/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util.interpolator;

import org.j3d.util.interpolator.Interpolator;

public class CoordinateInterpolator
extends Interpolator {
    private float[] sharedVector;
    private float[][] keyValues;
    private int valueLength;

    public CoordinateInterpolator() {
        this(20, 1);
    }

    public CoordinateInterpolator(int n) {
        this(n, 1);
    }

    public CoordinateInterpolator(int n, int n2) {
        super(n, n2);
        this.keys = new float[n];
        this.keyValues = new float[n][];
        this.valueLength = -1;
    }

    public void addKeyFrame(float f, float[] fArray) {
        int n = this.findKeyIndex(f);
        if (n < 0) {
            n = 0;
        }
        while (n < this.currentSize && this.keys[n] <= f) {
            ++n;
        }
        this.realloc();
        if (fArray == null) {
            throw new IllegalArgumentException("Coord array is null");
        }
        int n2 = fArray.length;
        if (n2 < 3 || n2 % 3 != 0) {
            throw new IllegalArgumentException("Coordinates length not x 3");
        }
        float[] fArray2 = new float[n2];
        System.arraycopy(fArray, 0, fArray2, 0, n2);
        if (this.valueLength > n2 || this.valueLength < 0) {
            this.valueLength = n2;
        }
        if (n >= this.currentSize) {
            this.keyValues[this.currentSize] = fArray2;
        } else {
            int n3 = this.currentSize - n;
            System.arraycopy(this.keyValues, n, this.keyValues, n + 1, n3);
            System.arraycopy(this.keys, n, this.keys, n + 1, n3);
            this.keyValues[n] = fArray2;
        }
        this.keys[n] = f;
        ++this.currentSize;
    }

    public float[] floatValue(float f) {
        int n;
        if (this.sharedVector == null || this.sharedVector.length != this.valueLength) {
            this.sharedVector = new float[this.valueLength];
        }
        if ((n = this.findKeyIndex(f)) < 0) {
            System.arraycopy(this.keyValues[0], 0, this.sharedVector, 0, this.valueLength);
        } else if (n >= this.currentSize - 1) {
            System.arraycopy(this.keyValues[this.currentSize - 1], 0, this.sharedVector, 0, this.valueLength);
        } else {
            switch (this.interpolationType) {
                case 1: {
                    float[] fArray = this.keyValues[n + 1];
                    float[] fArray2 = this.keyValues[n];
                    float f2 = 0.0f;
                    float f3 = this.keys[n];
                    float f4 = this.keys[n + 1];
                    if (f4 != f3) {
                        f2 = (f - f3) / (f4 - f3);
                    }
                    int n2 = this.valueLength;
                    while (--n2 > 1) {
                        float f5 = fArray[n2] - fArray2[n2];
                        this.sharedVector[n2] = fArray2[n2] + f2 * f5;
                        f5 = fArray[--n2] - fArray2[n2];
                        this.sharedVector[n2] = fArray2[n2] + f2 * f5;
                        f5 = fArray[--n2] - fArray2[n2];
                        this.sharedVector[n2] = fArray2[n2] + f2 * f5;
                    }
                    break;
                }
                case 2: {
                    System.arraycopy(this.keyValues[n], 0, this.sharedVector, 0, this.valueLength);
                }
            }
        }
        return this.sharedVector;
    }

    private final void realloc() {
        if (this.currentSize == this.allocatedSize) {
            int n = this.allocatedSize + 5;
            float[][] fArrayArray = new float[n][];
            System.arraycopy(this.keyValues, 0, fArrayArray, 0, this.allocatedSize);
            float[] fArray = new float[n];
            System.arraycopy(this.keys, 0, fArray, 0, this.allocatedSize);
            this.keys = fArray;
            this.keyValues = fArrayArray;
            this.allocatedSize = n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<Coordinate interpolator>\n");
        stringBuffer.append("First coord for each key\n");
        int n = 0;
        while (n < this.currentSize) {
            stringBuffer.append(n);
            stringBuffer.append(" key: ");
            stringBuffer.append(this.keys[n]);
            stringBuffer.append(" x: ");
            stringBuffer.append(this.keyValues[n][0]);
            stringBuffer.append(" y: ");
            stringBuffer.append(this.keyValues[n][1]);
            stringBuffer.append(" z: ");
            stringBuffer.append(this.keyValues[n][2]);
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append("</Coordinate interpolator>");
        return stringBuffer.toString();
    }
}

