/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util.interpolator;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.j3d.util.interpolator.ScalarInterpolator;

public class TestScalarInterpolator
extends TestCase {
    private static float[] keys = new float[]{0.1f, 0.4f, 5.0f};
    private static float[] values = new float[]{1.0f, 5.0f, 2.0f};
    private ScalarInterpolator interpolator;

    public TestScalarInterpolator(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new TestScalarInterpolator("testCreate"));
        testSuite.addTest((Test)new TestScalarInterpolator("testValueInsert"));
        testSuite.addTest((Test)new TestScalarInterpolator("testKeyGenLinear"));
        testSuite.addTest((Test)new TestScalarInterpolator("testKeyGenStep"));
        testSuite.addTest((Test)new TestScalarInterpolator("testClamping"));
        return testSuite;
    }

    public void setUp() {
        Assert.assertEquals((String)"Keys and values arrays are not the same size", (int)keys.length, (int)values.length);
        this.interpolator = new ScalarInterpolator();
    }

    public void testCreate() {
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            this.interpolator.addKeyFrame(keys[n2], values[n2]);
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            float f = this.interpolator.floatValue(keys[n2]);
            Assert.assertEquals((String)(n2 + " value not same"), (float)values[n2], (float)f, (float)0.0f);
            ++n2;
        }
    }

    public void testValueInsert() {
        int n = keys.length;
        Assert.assertTrue((String)"Not enough keys ( < 3) to do this test", (n > 2 ? 1 : 0) != 0);
        this.interpolator.addKeyFrame(keys[0], values[0]);
        this.interpolator.addKeyFrame(keys[2], values[2]);
        this.interpolator.addKeyFrame(keys[1], values[1]);
        int n2 = 0;
        while (n2 < n) {
            float f = this.interpolator.floatValue(keys[n2]);
            Assert.assertEquals((String)(n2 + " value not same"), (float)values[n2], (float)f, (float)0.0f);
            ++n2;
        }
    }

    public void testKeyGenLinear() {
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            this.interpolator.addKeyFrame(keys[n2], values[n2]);
            ++n2;
        }
        float f = keys[0] + (keys[1] - keys[0]) / 2.0f;
        float f2 = values[0] + (values[1] - values[0]) / 2.0f;
        float f3 = this.interpolator.floatValue(f);
        Assert.assertEquals((String)"1st value not same", (float)f2, (float)f3, (float)0.0f);
        f = keys[1] + (keys[2] - keys[1]) / 2.0f;
        f2 = values[1] + (values[2] - values[1]) / 2.0f;
        f3 = this.interpolator.floatValue(f);
        Assert.assertEquals((String)"2nd value not same", (float)f2, (float)f3, (float)0.0f);
    }

    public void testKeyGenStep() {
        this.interpolator = new ScalarInterpolator(3, 2);
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            this.interpolator.addKeyFrame(keys[n2], values[n2]);
            ++n2;
        }
        float f = keys[0] + (keys[1] - keys[0]) / 2.0f;
        float f2 = this.interpolator.floatValue(f);
        Assert.assertEquals((String)"1st value not same", (float)values[0], (float)f2, (float)0.0f);
        f = keys[1] + (keys[2] - keys[1]) / 2.0f;
        f2 = this.interpolator.floatValue(f);
        Assert.assertEquals((String)"2nd value not same", (float)values[1], (float)f2, (float)0.0f);
    }

    public void testClamping() {
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            this.interpolator.addKeyFrame(keys[n2], values[n2]);
            ++n2;
        }
        float f = keys[0] - 1.0f;
        float f2 = this.interpolator.floatValue(f);
        Assert.assertEquals((String)"Min value not same", (float)values[0], (float)f2, (float)0.0f);
        f = keys[--n] + 1.0f;
        f2 = this.interpolator.floatValue(f);
        Assert.assertEquals((String)"Max value not same", (float)values[n], (float)f2, (float)0.0f);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)TestScalarInterpolator.suite());
    }
}

