/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ndar.ws.accession;

import gov.nih.ndar.ws.accession.AccessionClient;
import java.io.FileNotFoundException;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;

public abstract class ValidationToolAbstractAccessionClient
implements AccessionClient {
    private static final OMNamespace omNs = OMAbstractFactory.getOMFactory().createOMNamespace("http://ndar.nih.gov/service/AccessionService", "ndar");
    private Logger logger = Logger.getLogger(this.getClass().getName());
    public static final String ACTION_TESTCONNECTION = "testConnection";
    public static final String ACTION_DOACCESSIONSEXIST = "doAccessionsExist";
    public static final String ACTION_DOESACCESSIONEXIST = "doesAccessionExist";
    public static final String ACTION_GETDATADICTIONARY = "getDataDictionary";
    public static final String ACTION_GETPUBLISHEDSTRUCTURES = "getPublishedStructures";
    public static final String EMPTY_SUBMITTED_ACCESSION_MSG = "The ACCESSION input that is submitted is empty; please resubmit.";
    public static final String INPUT_OUTPUT_MISMATCH_MSG = "There is an error in processing your request. Please resubmit.";
    private String axis2xmlPath;
    private ConfigurationContext configContext;
    private Options options;
    private String policyPath;
    private String reposPath;
    private ServiceClient serviceClient;
    private String sourceEpr;
    private EndpointReference targetEpr;

    public ValidationToolAbstractAccessionClient() {
    }

    public ValidationToolAbstractAccessionClient(String path, String axis2xml, String policyPath, String sourceEpr, String targetEpr) throws FileNotFoundException, XMLStreamException, AxisFault {
        this.sourceEpr = sourceEpr;
        this.targetEpr = new EndpointReference(targetEpr);
        this.reposPath = path;
        this.axis2xmlPath = axis2xml;
        this.policyPath = policyPath;
        this.init();
    }

    public void init() throws AxisFault, XMLStreamException, FileNotFoundException {
        this.options = new Options();
        this.options.setTo(this.targetEpr);
        this.options.setManageSession(true);
        this.options.setTransportInProtocol("http");
        this.configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)this.reposPath, (String)this.axis2xmlPath);
        StAXOMBuilder builder = new StAXOMBuilder(this.policyPath);
        Policy policy = PolicyEngine.getPolicy((OMElement)builder.getDocumentElement());
        this.options.setProperty("rampartPolicy", (Object)policy);
        this.serviceClient = new ServiceClient(this.configContext, null);
        this.serviceClient.setOptions(this.options);
        this.serviceClient.engageModule(new QName("addressing"));
        this.serviceClient.engageModule(new QName("rampart"));
    }

    public String testConnection() throws AxisFault {
        this.serviceClient.getOptions().setAction("ndar:testConnection");
        OMElement payLoad = this.createTestConnectionPayLoad();
        OMElement result = this.serviceClient.sendReceive(payLoad);
        this.serviceClient.cleanup();
        return result.getFirstElement().getText();
    }

    public synchronized String doesAccessionExist(String accession, String type) throws AxisFault {
        this.serviceClient.getOptions().setAction("ndar:doesAccessionExist");
        OMElement payLoad = this.createdoesAccessionExistPayLoad(accession, type);
        OMElement result = this.serviceClient.sendReceive(payLoad);
        this.serviceClient.cleanup();
        return result.getFirstElement().getText();
    }

    public OMElement getDataDictionary(String lis) throws AxisFault {
        this.serviceClient.getOptions().setAction("ndar:getDataDictionary");
        OMElement payLoad = this.createGetDataDictionaryPayLoad(lis);
        OMElement result = this.serviceClient.sendReceive(payLoad);
        this.serviceClient.cleanup();
        return result.getFirstElement();
    }

    public OMElement getPublishedStructures() throws AxisFault {
        this.serviceClient.getOptions().setAction("ndar:getPublishedStructures");
        OMElement payLoad = this.createGetPublishedStructuresPayLoad();
        OMElement result = this.serviceClient.sendReceive(payLoad);
        this.serviceClient.cleanup();
        return result.getFirstElement();
    }

    public String doAccessionsExist(String accessions, String type) throws AxisFault {
        String returnedValue = null;
        String[] accessionFields = accessions.split(",");
        if (accessionFields.length == 0 || accessionFields.length == 1 && accessionFields[0].trim().equals("")) {
            this.logger.info("***** the number of accessions submitted is: " + accessionFields.length);
            returnedValue = EMPTY_SUBMITTED_ACCESSION_MSG;
        } else {
            this.serviceClient.getOptions().setAction("ndar:doAccessionsExist");
            OMElement payLoad = this.createdoAccessionsExistPayLoad(accessions, type);
            this.logger.info("********* The ACCESSION(s) that are entered are: " + accessions);
            OMElement result = this.serviceClient.sendReceive(payLoad);
            this.serviceClient.cleanup();
            String[] booleanFields = result.getFirstElement().getText().split(",");
            returnedValue = accessionFields.length != booleanFields.length ? INPUT_OUTPUT_MISMATCH_MSG : result.getFirstElement().getText();
        }
        return returnedValue;
    }

    public void login(String username, String password) throws AxisFault {
        this.serviceClient.getOptions().setAction("ndar:login");
        OMElement payLoad = this.createLoginPayLoad(username, password);
        this.serviceClient.sendReceive(payLoad);
        this.serviceClient.cleanup();
    }

    public void logout() throws AxisFault {
        this.serviceClient.getOptions().setAction("urn:logout");
        OMElement payLoad = this.createLogoutPayLoad();
        this.serviceClient.fireAndForget(payLoad);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private OMElement createGetDataDictionaryPayLoad(String lis) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement method = factory.createOMElement(ACTION_GETDATADICTIONARY, omNs);
        OMElement value = factory.createOMElement("list", omNs);
        value.addChild((OMNode)factory.createOMText((OMContainer)value, lis));
        method.addChild((OMNode)value);
        return method;
    }

    private OMElement createGetPublishedStructuresPayLoad() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement method = fac.createOMElement(ACTION_GETPUBLISHEDSTRUCTURES, omNs);
        return method;
    }

    private OMElement createLoginPayLoad(String username, String password) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement method = fac.createOMElement("login", omNs);
        OMElement value = fac.createOMElement("username", omNs);
        value.addChild((OMNode)fac.createOMText((OMContainer)value, username));
        method.addChild((OMNode)value);
        value = fac.createOMElement("password", omNs);
        value.addChild((OMNode)fac.createOMText((OMContainer)value, password));
        method.addChild((OMNode)value);
        return method;
    }

    private OMElement createLogoutPayLoad() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement method = fac.createOMElement("logout", omNs);
        return method;
    }

    private OMElement createTestConnectionPayLoad() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement method = fac.createOMElement(ACTION_TESTCONNECTION, omNs);
        return method;
    }

    private OMElement createdoAccessionsExistPayLoad(String accessions, String type) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement method = fac.createOMElement(ACTION_DOACCESSIONSEXIST, omNs);
        OMElement value = fac.createOMElement("accession", omNs);
        value.addChild((OMNode)fac.createOMText((OMContainer)value, accessions));
        method.addChild((OMNode)value);
        value = fac.createOMElement("type", omNs);
        value.addChild((OMNode)fac.createOMText((OMContainer)value, type));
        method.addChild((OMNode)value);
        return method;
    }

    private OMElement createdoesAccessionExistPayLoad(String accessions, String type) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement method = fac.createOMElement(ACTION_DOESACCESSIONEXIST, omNs);
        OMElement value = fac.createOMElement("accession", omNs);
        value.addChild((OMNode)fac.createOMText((OMContainer)value, accessions));
        method.addChild((OMNode)value);
        value = fac.createOMElement("type", omNs);
        value.addChild((OMNode)fac.createOMText((OMContainer)value, type));
        method.addChild((OMNode)value);
        return method;
    }

    public String getAxis2xmlPath() {
        return this.axis2xmlPath;
    }

    public String getPolicyPath() {
        return this.policyPath;
    }

    public String getReposPath() {
        return this.reposPath;
    }

    public ServiceClient getServiceClient() {
        return this.serviceClient;
    }

    public String getSourceEpr() {
        return this.sourceEpr;
    }

    public EndpointReference getTargetEpr() {
        return this.targetEpr;
    }

    public void setAxis2xmlPath(String axis2xmlPath) {
        this.axis2xmlPath = axis2xmlPath;
    }

    public void setPolicyPath(String policyPath) {
        this.policyPath = policyPath;
    }

    public void setReposPath(String reposPath) {
        this.reposPath = reposPath;
    }

    public void setServiceClient(ServiceClient serviceClient) {
        this.serviceClient = serviceClient;
    }

    public void setSourceEpr(String sourceEpr) {
        this.sourceEpr = sourceEpr;
    }

    public void setTargetEpr(EndpointReference targetEpr) {
        this.targetEpr = targetEpr;
    }
}

