/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ndar.ws.accession.utils;

import gov.nih.ndar.ws.accession.utils.ISO3166Countries;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.ws.security.WSPasswordCallback;

public abstract class AbstractPWCBHandler
implements CallbackHandler {
    protected static ISO3166Countries isoCountries;
    private String name;

    public String getPasswordFile() {
        return String.valueOf(this.getPropertiesDirPath()) + File.separator + this.name + File.separator + "repository" + File.separator + "conf" + File.separator + "pwcbhandler.properties";
    }

    public String getISOPropertiesFile() {
        return String.valueOf(this.getPropertiesDirPath()) + File.separator + this.name + File.separator + "repository" + File.separator + "conf" + File.separator + "iso3166Countries.properties";
    }

    public abstract String getPropertiesDirPath();

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        int i = 0;
        while (i < callbacks.length) {
            WSPasswordCallback pwcb = (WSPasswordCallback)callbacks[i];
            String id = pwcb.getIdentifer();
            this.name = id.substring(id.lastIndexOf("_") + 1).toUpperCase();
            isoCountries = new ISO3166Countries(this.getISOPropertiesFile());
            Properties aliasPasswords = new Properties();
            FileInputStream in = new FileInputStream(this.getPasswordFile());
            aliasPasswords.load(in);
            in.close();
            String password = this.decrypt(aliasPasswords.getProperty(id));
            if (password != null) {
                pwcb.setPassword(password);
            }
            ++i;
        }
    }

    private String decrypt(String encryptedText) {
        byte[] backToString = this.convertToByteArray(encryptedText);
        String convertBackToString = new String(backToString);
        convertBackToString = convertBackToString.replaceAll("2", "C");
        convertBackToString = convertBackToString.replaceAll("6", "G");
        convertBackToString = convertBackToString.replaceAll("4", "S");
        convertBackToString = convertBackToString.replaceAll("9", "K");
        convertBackToString = convertBackToString.replaceAll("3", "N");
        convertBackToString = convertBackToString.replaceAll("8", "A");
        convertBackToString = convertBackToString.replaceAll("z", "1");
        convertBackToString = convertBackToString.replaceAll("u", "2");
        convertBackToString = convertBackToString.replaceAll("t", "3");
        convertBackToString = convertBackToString.replaceAll("s", "4");
        convertBackToString = convertBackToString.replaceAll("n", "5");
        convertBackToString = convertBackToString.replaceAll("m", "6");
        convertBackToString = convertBackToString.replaceAll("k", "7");
        convertBackToString = convertBackToString.replaceAll("e", "8");
        convertBackToString = convertBackToString.replaceAll("b", "9");
        convertBackToString = convertBackToString.replaceAll("a", "0");
        convertBackToString = convertBackToString.replaceAll("@", "a");
        convertBackToString = convertBackToString.replaceAll("#", "e");
        convertBackToString = convertBackToString.replaceAll("\\)", "t");
        convertBackToString = convertBackToString.replaceAll("!", "s");
        convertBackToString = convertBackToString.replaceAll("\\*", "m");
        convertBackToString = convertBackToString.replaceAll("\\+", "n");
        convertBackToString = convertBackToString.replaceAll("&", "z");
        convertBackToString = convertBackToString.replaceAll("=", "k");
        convertBackToString = convertBackToString.replaceAll("-", "b");
        convertBackToString = convertBackToString.replaceAll("%", "u");
        return convertBackToString.substring(6, convertBackToString.length() - 7);
    }

    private byte[] convertToByteArray(String info) {
        byte[] txtInByte = new byte[info.length() / 2];
        int j = 0;
        int i = 0;
        while (i < info.length()) {
            txtInByte[j++] = Byte.parseByte(info.substring(i, i + 2), 16);
            i += 2;
        }
        return txtInByte;
    }
}

