/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ndar.ws.accession.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TreeMap;

public class ISO3166Countries {
    private static ISO3166Countries INSTANCE;
    private TreeMap<String, String> iso3166TreeMap;
    private String filePath;

    public ISO3166Countries(String var) throws RuntimeException {
        Properties iso3166Props = new Properties();
        this.filePath = var;
        try {
            FileInputStream in = new FileInputStream(this.getFilePath());
            iso3166Props.load(in);
            in.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.iso3166TreeMap = new TreeMap();
        Enumeration<?> countryList = iso3166Props.propertyNames();
        while (countryList.hasMoreElements()) {
            String countryName = (String)countryList.nextElement();
            this.iso3166TreeMap.put(countryName, iso3166Props.getProperty(countryName));
        }
        INSTANCE = this;
    }

    public String[] getCountryArray() {
        return this.iso3166TreeMap.keySet().toArray(new String[this.iso3166TreeMap.size()]);
    }

    public String getAbbreviation(String countryName) {
        return this.iso3166TreeMap.get(countryName);
    }

    public boolean validAbbreviation(String countryAbbreviation) {
        return this.iso3166TreeMap.containsValue(countryAbbreviation);
    }

    public boolean validCountry(String countryName) {
        return this.iso3166TreeMap.containsKey(countryName);
    }

    public static ISO3166Countries getInstance() {
        return INSTANCE;
    }

    public String getFilePath() {
        return this.filePath;
    }
}

