/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ndar.ws.accession.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;

public class UnZip {
    public static final int LIST = 0;
    public static final int EXTRACT = 1;
    protected int mode = 0;
    protected ZipFile zippy;
    protected byte[] b = new byte[8092];
    protected SortedSet dirsMade;
    protected boolean warnedMkDir = false;

    public static void main(String[] argv) {
    }

    public static Exception extract(String zipPath) {
        return UnZip.extract(zipPath, ".");
    }

    public static Exception extract(String zipPath, String targetDir) {
        UnZip u;
        block7: {
            block6: {
                try {
                    u = new UnZip();
                    u.setMode(1);
                    if (zipPath != null && zipPath.length() != 0) break block6;
                    System.err.println("ERROR:  The path to the zip file cannot be null or empty string");
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return e;
                }
            }
            if (targetDir != null) break block7;
            System.err.println("ERROR:  The path to unzip contents");
            return null;
        }
        if (zipPath.endsWith(".zip") || zipPath.endsWith(".jar")) {
            u.unZip(zipPath, targetDir);
        } else {
            System.err.println("Not a zip file? " + zipPath);
        }
        System.err.println("All done!");
        return null;
    }

    UnZip() {
    }

    protected void setMode(int m) {
        if (m == 0 || m == 1) {
            this.mode = m;
        }
    }

    private void unZip(String fileName, String targetDir) {
        this.dirsMade = new TreeSet();
        try {
            this.zippy = new ZipFile(fileName);
            Enumeration<? extends ZipEntry> all = this.zippy.entries();
            while (all.hasMoreElements()) {
                this.getFile(all.nextElement(), targetDir);
            }
        }
        catch (IOException err) {
            System.err.println("IO Error: " + err);
            return;
        }
    }

    protected void getFile(ZipEntry e, String targetDir) throws IOException {
        String zipName = e.getName();
        if (targetDir == null || targetDir.trim().length() == 0) {
            targetDir = ".";
        }
        switch (this.mode) {
            case 1: {
                File d;
                String dirName;
                if (zipName.startsWith("/")) {
                    if (!this.warnedMkDir) {
                        System.out.println("Ignoring absolute paths");
                    }
                    this.warnedMkDir = true;
                    zipName = zipName.substring(1);
                }
                if (zipName.endsWith("/")) {
                    return;
                }
                int ix = zipName.lastIndexOf(47);
                if (!(ix <= 0 || this.dirsMade.contains(dirName = zipName.substring(0, ix)) || (d = new File(String.valueOf(targetDir) + File.separator + dirName)).exists() && d.isDirectory())) {
                    System.out.println("Creating Directory: " + dirName);
                    if (!d.mkdirs()) {
                        System.err.println("Warning: unable to mkdir " + dirName);
                        JOptionPane.showMessageDialog(null, "Warning: unable to mkdir " + dirName, "Extraction done", -1);
                    }
                    this.dirsMade.add(dirName);
                }
                zipName = String.valueOf(targetDir) + File.separator + zipName;
                System.err.println("Creating " + zipName);
                FileOutputStream os = new FileOutputStream(zipName);
                InputStream is = this.zippy.getInputStream(e);
                int n = 0;
                while ((n = is.read(this.b)) > 0) {
                    os.write(this.b, 0, n);
                }
                is.close();
                os.close();
                break;
            }
            case 0: {
                if (e.isDirectory()) {
                    System.out.println("Directory " + zipName);
                    break;
                }
                System.out.println("File " + zipName);
                break;
            }
            default: {
                throw new IllegalStateException("mode value (" + this.mode + ") bad");
            }
        }
    }
}

