/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ndar.ws.client;

import gov.nih.ndar.model.DataStructure;
import gov.nih.ndar.ws.accession.DataValidationProperties;
import gov.nih.ndar.ws.accession.VToolSimpleAccessionClient;
import gov.nih.ndar.ws.accession.utils.UnZip;
import gov.nih.ndar.ws.client.GlobalConstants;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Startup {
    public static final String DEV_NAME = "DEV";
    public static final String STAGE_NAME = "STAGE";
    public static final String DEMO_NAME = "DEMO";
    public static final String PROD_NAME = "PROD";
    private static VToolSimpleAccessionClient absGenoClient;
    private static DataValidationProperties connectionProps;

    public static void main(String[] argv) {
        try {
            VToolSimpleAccessionClient vt = Startup.getClient(PROD_NAME);
            if (vt != null) {
                OMElement e = vt.getPublishedStructures();
                Startup.printXML(e, "");
                String lis = Startup.parseStructures(e);
                System.out.println("### " + lis);
                String temp = "subject01, affection01, subject_treatment_info01, sub_2_prot01, experiment01, exp_2_prot01, biosample01, biosam_treatment_info01, biosam_2_prot01, expsam_2_prot01, expsample01, expsam_2_reagent01, expsam_2_biosam01, reagent01, protocol01, ng_subjects_human01, ng_biological_samples01, ng_reagents01, ng_experiments01, ng_protocols01, ng_experiment_samples01";
                Startup.buildObjects(vt.getDataDictionary(temp));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String parseStructures(OMElement e) {
        QName qName = new QName(e.getNamespace().getNamespaceURI(), "short_name");
        String lis = "";
        Iterator it = e.getChildren();
        while (it.hasNext()) {
            OMElement i = (OMElement)it.next();
            if (!i.getLocalName().equals("data_structure")) continue;
            String temp = i.getAttributeValue(qName);
            try {
                lis = String.valueOf(lis) + temp + ", ";
            }
            catch (Exception ex) {
                System.out.println(String.valueOf(temp) + " was improperly named.  Please check with NDAR Admins for ways to fix.");
                ex.printStackTrace();
            }
        }
        return lis.substring(0, lis.lastIndexOf(","));
    }

    public static void printXML(OMElement e, String tabs) {
        String text = "<" + e.getLocalName() + " ";
        Iterator i = e.getAllAttributes();
        while (i.hasNext()) {
            OMAttribute a = (OMAttribute)i.next();
            text = String.valueOf(text) + a.getLocalName() + "=\"" + a.getAttributeValue().trim() + "\" ";
        }
        boolean hasChildren = false;
        i = e.getChildElements();
        while (i.hasNext()) {
            if (!hasChildren) {
                hasChildren = true;
                text = String.valueOf(text) + ">";
                System.out.println(String.valueOf(tabs) + text);
            }
            Startup.printXML((OMElement)i.next(), String.valueOf(tabs) + "\t");
        }
        if (!hasChildren) {
            System.out.println(String.valueOf(tabs) + text + "/>");
        } else {
            System.out.println(String.valueOf(tabs) + "</" + e.getLocalName() + ">");
        }
    }

    public static List<DataStructure> buildObjects(OMElement e) {
        ArrayList<DataStructure> dsList = new ArrayList<DataStructure>();
        Iterator dsIt = e.getChildren();
        while (dsIt.hasNext()) {
            OMElement dsElement = (OMElement)dsIt.next();
            if (!dsElement.getLocalName().equals("data_structure")) continue;
            DataStructure ds = new DataStructure(dsElement);
            Iterator deIt = dsElement.getChildren();
            while (deIt.hasNext()) {
                OMElement oMElement = (OMElement)deIt.next();
            }
        }
        return dsList;
    }

    public static VToolSimpleAccessionClient getClient(String env) {
        return Startup.getClient(env, true);
    }

    public static VToolSimpleAccessionClient getClient(String env, boolean download) {
        try {
            System.setSecurityManager(null);
            String repoLoc = null;
            if (env.equalsIgnoreCase(DEV_NAME)) {
                repoLoc = "http://ndar-dev-apps.cit.nih.gov/val_rep/repository.jar";
            }
            if (env.equalsIgnoreCase(DEMO_NAME)) {
                repoLoc = "http://ndar-demo-apps.cit.nih.gov/val_rep/repository.jar";
            }
            if (env.equalsIgnoreCase(PROD_NAME)) {
                repoLoc = "http://ndarportal.nih.gov/val_rep/repository.jar";
            }
            if (download) {
                Startup.downloadRepo(repoLoc, env);
            }
            if (Startup.initGenoClient(env)) {
                return absGenoClient;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static boolean initGenoClient(String env) {
        String path = "datavalidation.properties";
        try {
            String msg;
            connectionProps = new DataValidationProperties(String.valueOf(File.separator) + env + File.separator);
            absGenoClient = new VToolSimpleAccessionClient(connectionProps.getPathToAxis(), null, String.valueOf(connectionProps.getPathToAxis()) + File.separator + "conf" + File.separator + "policy.xml", connectionProps.getGuidUrl(), connectionProps.getGuidUrl());
            absGenoClient.login(connectionProps.getGuidUser(), connectionProps.getGuidPassword());
            System.out.println(connectionProps.getPathToAxis());
            return absGenoClient == null || (msg = absGenoClient.testConnection()).contains("SUCCESS");
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (AxisFault afe) {
            StringWriter sWriter = new StringWriter();
            afe.printStackTrace(new PrintWriter(sWriter));
            afe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static String downloadRepo(String repoLocation, String env) {
        Exception result;
        String localRepoJarPath;
        block19: {
            OutputStream out = null;
            URLConnection conn = null;
            InputStream in = null;
            new File(String.valueOf(GlobalConstants.CODEBOOK_DIR) + env + File.separator).mkdirs();
            localRepoJarPath = String.valueOf(GlobalConstants.CODEBOOK_DIR) + env + File.separator + new File("repository.jar").getName();
            System.out.println(localRepoJarPath);
            try {
                try {
                    int numRead;
                    URL url = new URL(repoLocation);
                    out = new BufferedOutputStream(new FileOutputStream(localRepoJarPath));
                    conn = url.openConnection();
                    in = conn.getInputStream();
                    byte[] buffer = new byte[1024];
                    long numWritten = 0L;
                    while ((numRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, numRead);
                        numWritten += (long)numRead;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                        break block19;
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        if ((result = UnZip.extract(localRepoJarPath, String.valueOf(GlobalConstants.CODEBOOK_DIR) + env + File.separator)) != null) {
            result.printStackTrace();
        }
        Startup.modifyPolicy(env);
        return localRepoJarPath;
    }

    protected static void modifyPolicy(String env) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new File(String.valueOf(GlobalConstants.CODEBOOK_DIR) + env + File.separator + GlobalConstants.POLICY_DIR));
            doc.getDocumentElement().normalize();
            NodeList listOfNodes = doc.getElementsByTagName("ramp:crypto");
            int totalNodes = listOfNodes.getLength();
            int s = 0;
            while (s < listOfNodes.getLength()) {
                Node firstNode = listOfNodes.item(s);
                if (firstNode.getNodeType() == 1) {
                    Element firstNodeElement = (Element)firstNode;
                    NodeList firstPropertyList = firstNodeElement.getElementsByTagName("ramp:property");
                    Element firstNameElement = (Element)firstPropertyList.item(1);
                    NodeList textFNList = firstNameElement.getChildNodes();
                    String currentNodeValue = textFNList.item(0).getNodeValue().trim();
                    textFNList.item(0).setNodeValue(String.valueOf(GlobalConstants.CODEBOOK_DIR) + env + File.separator + currentNodeValue);
                }
                ++s;
            }
            OutputFormat format = new OutputFormat(doc);
            format.setIndenting(true);
            XMLSerializer serializer = new XMLSerializer((OutputStream)new FileOutputStream(new File(String.valueOf(GlobalConstants.CODEBOOK_DIR) + env + File.separator + GlobalConstants.POLICY_DIR)), format);
            serializer.serialize(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

