/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.ellipticFunctions;

import de.jtem.ellipticFunctions.Elliptic;
import de.jtem.mfc.field.Complex;

public class Jacobi
extends Elliptic {
    static final Complex z = new Complex();
    static final Complex u = new Complex();
    static final Complex Z = new Complex();
    static final Complex c = new Complex();
    static final Complex g = new Complex();
    static final Complex m = new Complex();
    static final Complex k = new Complex();
    static final Complex K = new Complex();
    static final Complex kPrime = new Complex();
    static final Complex KPrime = new Complex();
    static final Complex tau = new Complex();
    static final Complex an = new Complex();
    static final Complex bn = new Complex();
    static final Complex ONE = new Complex(1.0);
    static final Complex logOfC = new Complex();
    static final Complex theta1 = new Complex();
    static final Complex theta2 = new Complex();
    static final Complex theta3 = new Complex();
    static final Complex theta4 = new Complex();
    static final Complex snOfU = new Complex();
    static final Complex cnOfU = new Complex();
    static final Complex dnOfU = new Complex();
    static final Complex[] thetaConstants = new Complex[4];
    static final Complex logOfCForTheta1 = new Complex();
    static final Complex logOfCForTheta2 = new Complex();
    static final Complex logOfCForTheta3 = new Complex();
    static final Complex logOfCForTheta4 = new Complex();

    Jacobi() {
    }

    public static void sn(Complex u, Complex tau, Complex[] thetaConstants, Complex snOfU) {
        z.assignDivide(u, thetaConstants[3]);
        z.assignDivide(thetaConstants[3]);
        Jacobi.theta1(z, tau, 1.0E-12, Z, logOfCForTheta1, theta1);
        Jacobi.theta4(z, tau, 1.0E-12, Z, logOfCForTheta4, theta4);
        logOfC.assignMinus(logOfCForTheta1, logOfCForTheta4);
        snOfU.assignExp(logOfC);
        snOfU.assignDivide(thetaConstants[2]);
        snOfU.assignTimes(thetaConstants[3]);
        snOfU.assignTimes(theta1);
        snOfU.assignDivide(theta4);
    }

    public static Complex sn(Complex u, Complex k) {
        Jacobi.tau_from_k(k, tau);
        Jacobi.thetaConstants(tau, 1.0E-12, thetaConstants);
        Complex snOfU = new Complex();
        Jacobi.sn(u, tau, thetaConstants, snOfU);
        return snOfU;
    }

    public static double sn(double u, double k) {
        Jacobi.k.assign(k);
        Jacobi.u.assign(u);
        Jacobi.tau_from_k(Jacobi.k, tau);
        Jacobi.thetaConstants(tau, 1.0E-12, thetaConstants);
        Jacobi.sn(Jacobi.u, tau, thetaConstants, snOfU);
        return Jacobi.snOfU.re;
    }

    public static void cn(Complex u, Complex tau, Complex[] thetaConstants, Complex cnOfU) {
        z.assignDivide(u, thetaConstants[3]);
        z.assignDivide(thetaConstants[3]);
        Jacobi.theta2(z, tau, 1.0E-12, Z, logOfCForTheta2, theta2);
        Jacobi.theta4(z, tau, 1.0E-12, Z, logOfCForTheta4, theta4);
        logOfC.assignMinus(logOfCForTheta2, logOfCForTheta4);
        cnOfU.assignExp(logOfC);
        cnOfU.assignDivide(thetaConstants[2]);
        cnOfU.assignTimes(thetaConstants[0]);
        cnOfU.assignTimes(theta2);
        cnOfU.assignDivide(theta4);
    }

    public static Complex cn(Complex u, Complex k) {
        Jacobi.tau_from_k(k, tau);
        Jacobi.thetaConstants(tau, 1.0E-12, thetaConstants);
        Complex cnOfU = new Complex();
        Jacobi.cn(u, tau, thetaConstants, cnOfU);
        return cnOfU;
    }

    public static double cn(double u, double k) {
        Jacobi.k.assign(k);
        Jacobi.u.assign(u);
        Jacobi.tau_from_k(Jacobi.k, tau);
        Jacobi.thetaConstants(tau, 1.0E-12, thetaConstants);
        Jacobi.cn(Jacobi.u, tau, thetaConstants, cnOfU);
        return Jacobi.cnOfU.re;
    }

    public static void dn(Complex u, Complex tau, Complex[] thetaConstants, Complex dnOfU) {
        z.assignDivide(u, thetaConstants[3]);
        z.assignDivide(thetaConstants[3]);
        Jacobi.theta3(z, tau, 1.0E-12, Z, logOfCForTheta3, theta3);
        Jacobi.theta4(z, tau, 1.0E-12, Z, logOfCForTheta4, theta4);
        logOfC.assignMinus(logOfCForTheta3, logOfCForTheta4);
        dnOfU.assignExp(logOfC);
        dnOfU.assignDivide(thetaConstants[3]);
        dnOfU.assignTimes(thetaConstants[0]);
        dnOfU.assignTimes(theta3);
        dnOfU.assignDivide(theta4);
    }

    public static Complex dn(Complex u, Complex k) {
        Jacobi.tau_from_k(k, tau);
        Jacobi.thetaConstants(tau, 1.0E-12, thetaConstants);
        Complex dnOfU = new Complex();
        Jacobi.dn(u, tau, thetaConstants, dnOfU);
        return dnOfU;
    }

    public static double dn(double u, double k) {
        Jacobi.k.assign(k);
        Jacobi.u.assign(u);
        Jacobi.tau_from_k(Jacobi.k, tau);
        Jacobi.thetaConstants(tau, 1.0E-12, thetaConstants);
        Jacobi.dn(Jacobi.u, tau, thetaConstants, dnOfU);
        return Jacobi.dnOfU.re;
    }

    public static void kPrime_from_k(Complex k, Complex kPrime) {
        kPrime.assignSqr(k);
        kPrime.assignNeg();
        kPrime.assignPlus(ONE);
        kPrime.assignSqrt();
    }

    public static Complex kPrime_from_k(Complex k) {
        Complex kPrime = new Complex();
        Jacobi.kPrime_from_k(k, kPrime);
        return kPrime;
    }

    public static double kPrime_from_k(double k) {
        return Math.sqrt(1.0 - k * k);
    }

    static void arithmeticGeometricMeanAlgorigthm(Complex a, Complex b, double eps, Complex m) {
        an.assign(a);
        bn.assign(b);
        for (int i = 0; i < 100; ++i) {
            m.re = (Jacobi.an.re + Jacobi.bn.re) / 2.0;
            m.im = (Jacobi.an.im + Jacobi.bn.im) / 2.0;
            if (an.distSqr(bn) < an.absSqr() * eps * eps) {
                return;
            }
            g.assignTimes(an, bn);
            bn.assignSqrt(g);
            an.assign(m);
        }
        throw new RuntimeException("reached max count; algorithm failed");
    }

    public static void K_from_k(Complex k, Complex K) {
        Jacobi.kPrime_from_k(k, kPrime);
        Jacobi.arithmeticGeometricMeanAlgorigthm(ONE, kPrime, 1.0E-12, m);
        K.assign(1.5707963267948966);
        K.assignDivide(m);
    }

    public static Complex K_from_k(Complex k) {
        Complex K = new Complex();
        Jacobi.K_from_k(k, K);
        return K;
    }

    public static void KPrime_from_k(Complex k, Complex KPrime) {
        Jacobi.arithmeticGeometricMeanAlgorigthm(ONE, k, 1.0E-12, m);
        KPrime.assign(1.5707963267948966);
        KPrime.assignDivide(m);
    }

    public static Complex KPrime_from_k(Complex k) {
        Complex KPrime = new Complex();
        Jacobi.KPrime_from_k(k, KPrime);
        return KPrime;
    }

    public static void k_from_thetaConstants(Complex[] thetaConstants, Complex k) {
        k.assignDivide(thetaConstants[2], thetaConstants[3]);
        k.assignSqr();
    }

    public static Complex k_from_thetaConstants(Complex[] thetaConstants) {
        Complex k = new Complex();
        Jacobi.k_from_thetaConstants(thetaConstants, k);
        return k;
    }

    public static void kPrime_from_thetaConstants(Complex[] thetaConstants, Complex kPrime) {
        kPrime.assignDivide(thetaConstants[0], thetaConstants[3]);
        kPrime.assignSqr();
    }

    public static Complex kPrime_from_thetaConstants(Complex[] thetaConstants) {
        Complex kPrime = new Complex();
        Jacobi.kPrime_from_thetaConstants(thetaConstants, kPrime);
        return kPrime;
    }

    public static void K_from_thetaConstants(Complex[] thetaConstants, Complex K) {
        K.assignSqr(thetaConstants[3]);
        K.assignTimes(1.5707963267948966);
    }

    public static Complex K_from_thetaConstants(Complex[] thetaConstants) {
        Complex K = new Complex();
        Jacobi.K_from_thetaConstants(thetaConstants, K);
        return K;
    }

    public static void KPrime_from_K_and_tau(Complex K, Complex tau, Complex KPrime) {
        KPrime.assignTimes(tau, K);
        KPrime.assignDivideI();
    }

    public static Complex KPrime_from_K_and_tau(Complex K, Complex tau) {
        Complex KPrime = new Complex();
        Jacobi.KPrime_from_K_and_tau(K, tau, KPrime);
        return KPrime;
    }

    public static void K_from_KPrime_and_tau(Complex KPrime, Complex tau, Complex K) {
        K.assignDivide(KPrime, tau);
        K.assignTimesI();
    }

    public static Complex K_from_KPrime_and_tau(Complex KPrime, Complex tau) {
        Complex K = new Complex();
        Jacobi.K_from_KPrime_and_tau(KPrime, tau, K);
        return K;
    }

    public static void tauPrime_from_tau(Complex tau, Complex tauPrime) {
        tauPrime.assignInvert(tau);
        tauPrime.assignNeg();
    }

    public static Complex tauPrime_from_tau(Complex tau) {
        Complex tauPrime = new Complex();
        Jacobi.tauPrime_from_tau(tau, tauPrime);
        return tauPrime;
    }

    public static void tau_from_k(Complex k, Complex tau) {
        Jacobi.KPrime_from_k(k, KPrime);
        Jacobi.K_from_k(k, K);
        tau.assignDivide(KPrime, K);
        tau.assignTimesI();
    }

    public static Complex tau_from_k(Complex k) {
        Complex tau = new Complex();
        Jacobi.tau_from_k(k, tau);
        return tau;
    }
}

