/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.field;

import de.jtem.mfc.field.ComplexValue;
import de.jtem.mfc.field.Field;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.ListIterator;

public class ComplexConstant
extends ComplexValue
implements Field.Complex,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final ComplexConstant ZERO = new ComplexConstant(0.0, 0.0);
    public static final ComplexConstant ONE = new ComplexConstant(1.0, 0.0);
    public static final ComplexConstant I = new ComplexConstant(0.0, 1.0);
    public static final ComplexConstant NEG_ONE = new ComplexConstant(-1.0, 0.0);
    public static final ComplexConstant NEG_I = new ComplexConstant(0.0, -1.0);
    double re;
    double im;

    public ComplexConstant() {
        this.re = 0.0;
        this.im = 0.0;
    }

    public ComplexConstant(double aReal) {
        this.re = aReal;
        this.im = 0.0;
    }

    public ComplexConstant(ComplexConstant u) {
        this.re = u.re;
        this.im = u.im;
    }

    public ComplexConstant(Field.Complex u) {
        this.re = u.getRe();
        this.im = u.getIm();
    }

    public ComplexConstant(double aReal, double aImag) {
        this.re = aReal;
        this.im = aImag;
    }

    @Override
    public final double getRe() {
        return this.re;
    }

    @Override
    public final double getIm() {
        return this.im;
    }

    final void assign(double aReal, double aImag) {
        this.re = aReal;
        this.im = aImag;
    }

    final void assign(ComplexConstant v) {
        this.re = v.re;
        this.im = v.im;
    }

    final void assign(Field.Complex v) {
        this.re = v.getRe();
        this.im = v.getIm();
    }

    final void assign(double re) {
        this.re = re;
        this.im = 0.0;
    }

    public final ComplexConstant copy() {
        return new ComplexConstant(this.re, this.im);
    }

    public final Object clone() {
        return this.copy();
    }

    public final boolean isInfinite() {
        return Double.isInfinite(this.re) || Double.isInfinite(this.im);
    }

    public final boolean isNaN() {
        return Double.isNaN(this.re) || Double.isNaN(this.im);
    }

    public boolean isZero() {
        return this.equals(0.0, 0.0);
    }

    public final ComplexConstant plus(Field.Complex v) {
        return new ComplexConstant(this.re + v.getRe(), this.im + v.getIm());
    }

    public final ComplexConstant plus(double r) {
        return new ComplexConstant(this.re + r, this.im);
    }

    final void assignPlus(double x, double y) {
        this.re += x;
        this.im += y;
    }

    final void assignPlus(ComplexConstant v) {
        this.re += v.re;
        this.im += v.im;
    }

    final void assignPlus(Field.Complex v) {
        this.re += v.getRe();
        this.im += v.getIm();
    }

    final void assignPlus(ComplexConstant u, double r) {
        this.re = u.re + r;
        this.im = u.im;
    }

    final void assignPlus(Field.Complex u, double r) {
        this.re = u.getRe() + r;
        this.im = u.getIm();
    }

    final void assignPlus(double r) {
        this.re += r;
    }

    final void assignPlus(ComplexConstant u, ComplexConstant v) {
        this.re = u.re + v.re;
        this.im = u.im + v.im;
    }

    final void assignPlus(Field.Complex u, Field.Complex v) {
        this.re = u.getRe() + v.getRe();
        this.im = u.getIm() + v.getIm();
    }

    public final ComplexConstant minus(Field.Complex v) {
        return new ComplexConstant(this.re - v.getRe(), this.im - v.getIm());
    }

    public final ComplexConstant minus(double r) {
        return new ComplexConstant(this.re - r, this.im);
    }

    final void assignMinus(double x, double y) {
        this.re -= x;
        this.im -= y;
    }

    final void assignMinus(ComplexConstant v) {
        this.re -= v.re;
        this.im -= v.im;
    }

    final void assignMinus(Field.Complex v) {
        this.re -= v.getRe();
        this.im -= v.getIm();
    }

    final void assignMinus(double r) {
        this.re -= r;
    }

    final void assignMinus(ComplexConstant u, ComplexConstant v) {
        this.re = u.re - v.re;
        this.im = u.im - v.im;
    }

    final void assignMinus(Field.Complex u, Field.Complex v) {
        this.re = u.getRe() - v.getRe();
        this.im = u.getIm() - v.getIm();
    }

    final void assignMinus(ComplexConstant u, double r) {
        this.re = u.re - r;
        this.im = u.im;
    }

    final void assignMinus(Field.Complex u, double r) {
        this.re = u.getRe() - r;
        this.im = u.getIm();
    }

    final void assignMinus(double r, ComplexConstant u) {
        this.re = r - u.re;
        this.im = -u.im;
    }

    final void assignMinus(double r, Field.Complex u) {
        this.re = r - u.getRe();
        this.im = -u.getIm();
    }

    public final ComplexConstant times(Field.Complex v) {
        return new ComplexConstant(this.re * v.getRe() - this.im * v.getIm(), this.re * v.getIm() + this.im * v.getRe());
    }

    public final ComplexConstant times(double r) {
        return new ComplexConstant(this.re * r, this.im * r);
    }

    final void assignTimes(double x, double y) {
        double rr = this.re * x - this.im * y;
        double ii = this.re * y + this.im * x;
        this.re = rr;
        this.im = ii;
    }

    final void assignTimes(ComplexConstant v) {
        double rr = this.re * v.re - this.im * v.im;
        double ii = this.re * v.im + this.im * v.re;
        this.re = rr;
        this.im = ii;
    }

    final void assignTimes(Field.Complex v) {
        double rr = this.re * v.getRe() - this.im * v.getIm();
        double ii = this.re * v.getIm() + this.im * v.getRe();
        this.re = rr;
        this.im = ii;
    }

    final void assignTimes(double r) {
        this.re *= r;
        this.im *= r;
    }

    final void assignTimes(double x, double y, double u, double v) {
        this.re = x * u - y * v;
        this.im = x * v + y * u;
    }

    final void assignTimes(ComplexConstant u, ComplexConstant v) {
        double rr = u.re * v.re - u.im * v.im;
        double ii = u.re * v.im + u.im * v.re;
        this.re = rr;
        this.im = ii;
    }

    final void assignTimes(Field.Complex u, Field.Complex v) {
        this.assignTimes(u.getRe(), u.getIm(), v.getRe(), v.getIm());
    }

    final void assignTimes(ComplexConstant u, double r) {
        this.re = u.re * r;
        this.im = u.im * r;
    }

    final void assignTimes(Field.Complex u, double r) {
        this.re = u.getRe() * r;
        this.im = u.getIm() * r;
    }

    public final ComplexConstant timesI() {
        return new ComplexConstant(-this.im, this.re);
    }

    final void assignTimesI() {
        double rr = this.re;
        this.re = -this.im;
        this.im = rr;
    }

    final void assignTimesI(ComplexConstant v) {
        double rr = v.re;
        this.re = -v.im;
        this.im = rr;
    }

    final void assignTimesI(Field.Complex v) {
        double rr = v.getRe();
        this.re = -v.getIm();
        this.im = rr;
    }

    public final ComplexConstant divideI() {
        return new ComplexConstant(this.im, -this.re);
    }

    final void assignDivideI() {
        double rr = this.re;
        this.re = this.im;
        this.im = -rr;
    }

    final void assignDivideI(ComplexConstant v) {
        double rr = v.re;
        this.re = v.im;
        this.im = -rr;
    }

    final void assignDivideI(Field.Complex v) {
        double rr = v.getRe();
        this.re = v.getIm();
        this.im = -rr;
    }

    public final ComplexConstant divide(Field.Complex v) {
        double vIm;
        double vRe = v.getRe();
        double nn = vRe * vRe + (vIm = v.getIm()) * vIm;
        if (nn == 0.0) {
            return new ComplexConstant(this.re / nn, this.im / nn);
        }
        return new ComplexConstant((this.re * vRe + this.im * vIm) / nn, (this.im * vRe - this.re * vIm) / nn);
    }

    public final ComplexConstant divide(double r) {
        return new ComplexConstant(this.re / r, this.im / r);
    }

    final void assignDivide(double x, double y) {
        double nn = x * x + y * y;
        if (nn == 0.0) {
            this.re /= nn;
            this.im /= nn;
        } else {
            double rr = this.re;
            double ii = this.im;
            this.re = (rr * x + ii * y) / nn;
            this.im = (ii * x - rr * y) / nn;
        }
    }

    final void assignDivide(ComplexConstant v) {
        this.assignDivide(v.re, v.im);
    }

    final void assignDivide(Field.Complex v) {
        this.assignDivide(v.getRe(), v.getIm());
    }

    final void assignDivide(double r) {
        this.re /= r;
        this.im /= r;
    }

    final void assignDivide(double x, double y, double u, double v) {
        double nn = u * u + v * v;
        if (nn == 0.0) {
            this.re /= nn;
            this.im /= nn;
        } else {
            double rr = (x * u + y * v) / nn;
            double ii = (y * u - x * v) / nn;
            this.re = rr;
            this.im = ii;
        }
    }

    final void assignDivide(ComplexConstant u, ComplexConstant v) {
        double nn = v.re * v.re + v.im * v.im;
        if (nn == 0.0) {
            this.re /= nn;
            this.im /= nn;
        } else {
            double rr = (u.re * v.re + u.im * v.im) / nn;
            double ii = (u.im * v.re - u.re * v.im) / nn;
            this.re = rr;
            this.im = ii;
        }
    }

    final void assignDivide(Field.Complex u, Field.Complex v) {
        this.assignDivide(u.getRe(), u.getIm(), v.getRe(), v.getIm());
    }

    final void assignDivide(ComplexConstant u, double r) {
        this.re = u.re / r;
        this.im = u.im / r;
    }

    final void assignDivide(Field.Complex u, double r) {
        this.re = u.getRe() / r;
        this.im = u.getIm() / r;
    }

    final void assignDivide(double r, ComplexConstant z) {
        double nn = ComplexConstant.absSqr(z);
        if (nn == 0.0) {
            this.re = r / nn;
            this.im = 0.0;
        } else {
            this.re = r * z.re / nn;
            this.im = -r * z.im / nn;
        }
    }

    final void assignDivide(double r, Field.Complex z) {
        double v;
        double u = z.getRe();
        double nn = u * u + (v = z.getIm()) * v;
        if (nn == 0.0) {
            this.re = r / nn;
            this.im = 0.0;
        } else {
            this.re = r * u / nn;
            this.im = -r * v / nn;
        }
    }

    public final ComplexConstant invert() {
        double nn = this.re * this.re + this.im * this.im;
        if (nn == 0.0) {
            return new ComplexConstant(Double.POSITIVE_INFINITY, 0.0);
        }
        return new ComplexConstant(this.re / nn, -this.im / nn);
    }

    public static final ComplexConstant invert(Field.Complex u) {
        double uIm;
        double uRe = u.getRe();
        double nn = uRe * uRe + (uIm = u.getIm()) * uIm;
        if (nn == 0.0) {
            return new ComplexConstant(Double.POSITIVE_INFINITY, 0.0);
        }
        return new ComplexConstant(uRe / nn, -uIm / nn);
    }

    final void assignInvert() {
        double nn = this.re * this.re + this.im * this.im;
        if (nn == 0.0) {
            this.re = Double.POSITIVE_INFINITY;
            this.im = 0.0;
            return;
        }
        this.re /= nn;
        this.im /= -nn;
    }

    final void assignInvert(ComplexConstant u) {
        double nn = u.re * u.re + u.im * u.im;
        if (nn == 0.0) {
            this.re = Double.POSITIVE_INFINITY;
            this.im = 0.0;
        } else {
            this.re = u.re / nn;
            this.im = -u.im / nn;
        }
    }

    final void assignInvert(Field.Complex u) {
        double uIm;
        double uRe = u.getRe();
        double nn = uRe * uRe + (uIm = u.getIm()) * uIm;
        if (nn == 0.0) {
            this.re = Double.POSITIVE_INFINITY;
            this.im = 0.0;
        } else {
            this.re = uRe / nn;
            this.im = -uIm / nn;
        }
    }

    public static final ComplexConstant conjugate(Field.Complex u) {
        return new ComplexConstant(u.getRe(), -u.getIm());
    }

    public final ComplexConstant conjugate() {
        return new ComplexConstant(this.re, -this.im);
    }

    final void assignConjugate() {
        this.im = -this.im;
    }

    final void assignConjugate(ComplexConstant u) {
        this.re = u.re;
        this.im = -u.im;
    }

    final void assignConjugate(Field.Complex u) {
        this.re = u.getRe();
        this.im = -u.getIm();
    }

    public static final ComplexConstant neg(Field.Complex u) {
        return new ComplexConstant(-u.getRe(), -u.getIm());
    }

    public final ComplexConstant neg() {
        return new ComplexConstant(-this.re, -this.im);
    }

    final void assignNeg() {
        this.re = -this.re;
        this.im = -this.im;
    }

    final void assignNeg(ComplexConstant u) {
        this.re = -u.re;
        this.im = -u.im;
    }

    final void assignNeg(Field.Complex u) {
        this.re = -u.getRe();
        this.im = -u.getIm();
    }

    public static final ComplexConstant sqr(Field.Complex u) {
        double uRe = u.getRe();
        double uIm = u.getIm();
        ComplexConstant w = new ComplexConstant();
        w.re = uRe * uRe - uIm * uIm;
        w.im = 2.0 * uRe * uIm;
        return w;
    }

    public final ComplexConstant sqr() {
        return ComplexConstant.sqr(this);
    }

    final void assignSqr() {
        double rr = this.re;
        double ii = this.im;
        this.re = rr * rr - ii * ii;
        this.im = 2.0 * rr * ii;
    }

    final void assignSqr(ComplexConstant u) {
        if (this == u) {
            this.assignSqr();
        } else {
            this.re = u.re * u.re - u.im * u.im;
            this.im = 2.0 * u.re * u.im;
        }
    }

    final void assignSqr(Field.Complex u) {
        if (this == u) {
            this.assignSqr();
        } else {
            double uRe = u.getRe();
            double uIm = u.getIm();
            this.re = uRe * uRe - uIm * uIm;
            this.im = 2.0 * uRe * uIm;
        }
    }

    public static final ComplexConstant cube(Field.Complex u) {
        ComplexConstant w = new ComplexConstant();
        double uRe = u.getRe();
        double uIm = u.getIm();
        w.re = uRe * (uRe * uRe - 3.0 * uIm * uIm);
        w.im = uIm * (3.0 * uRe * uRe - uIm * uIm);
        return w;
    }

    public final ComplexConstant cube() {
        return ComplexConstant.cube(this);
    }

    final void assignCube() {
        double rr = this.re;
        double ii = this.im;
        this.re = rr * (rr * rr - 3.0 * ii * ii);
        this.im = ii * (3.0 * rr * rr - ii * ii);
    }

    final void assignCube(ComplexConstant u) {
        if (this == u) {
            this.assignCube();
        } else {
            this.re = u.re * (u.re * u.re - 3.0 * u.im * u.im);
            this.im = u.im * (3.0 * u.re * u.re - u.im * u.im);
        }
    }

    final void assignCube(Field.Complex u) {
        if (this == u) {
            this.assignCube();
        } else {
            double uRe = u.getRe();
            double uIm = u.getIm();
            this.re = uRe * (uRe * uRe - 3.0 * uIm * uIm);
            this.im = uIm * (3.0 * uRe * uRe - uIm * uIm);
        }
    }

    public static final double re(ComplexConstant u) {
        return u.re;
    }

    public static final double im(ComplexConstant u) {
        return u.im;
    }

    public static final ComplexConstant exp(Field.Complex u) {
        ComplexConstant w = new ComplexConstant();
        double r = Math.exp(u.getRe());
        w.re = r * Math.cos(u.getIm());
        w.im = r * Math.sin(u.getIm());
        return w;
    }

    public final ComplexConstant exp() {
        return ComplexConstant.exp(this);
    }

    final void assignExp() {
        double r = Math.exp(this.re);
        this.re = r * Math.cos(this.im);
        this.im = r * Math.sin(this.im);
    }

    final void assignExp(double x, double y) {
        double r = Math.exp(x);
        this.re = r * Math.cos(y);
        this.im = r * Math.sin(y);
    }

    final void assignExp(ComplexConstant u) {
        double r = Math.exp(u.re);
        this.re = r * Math.cos(u.im);
        this.im = r * Math.sin(u.im);
    }

    final void assignExp(Field.Complex u) {
        double r = Math.exp(u.getRe());
        this.re = r * Math.cos(u.getIm());
        this.im = r * Math.sin(u.getIm());
    }

    public static final ComplexConstant log(Field.Complex u) {
        ComplexConstant v = new ComplexConstant(u);
        v.assignLog();
        return v;
    }

    public final ComplexConstant log() {
        return ComplexConstant.log(this);
    }

    final void assignLog() {
        this.assignLog(this);
    }

    final void assignLog(ComplexConstant u) {
        double r = u.abs();
        if (r == 0.0) {
            this.re = Double.NEGATIVE_INFINITY;
            this.im = 0.0;
        } else {
            double arg = u.arg();
            this.re = Math.log(r);
            this.im = arg;
        }
    }

    final void assignLog(Field.Complex u) {
        double uIm;
        double uRe = u.getRe();
        double r = ComplexConstant.abs(uRe, uIm = u.getIm());
        if (r == 0.0) {
            this.re = Double.NEGATIVE_INFINITY;
            this.im = 0.0;
        } else {
            double arg = ComplexConstant.arg(uRe, uIm);
            this.re = Math.log(r);
            this.im = arg;
        }
    }

    public static final ComplexConstant sqrt(Field.Complex u) {
        double uRe = u.getRe();
        double uIm = u.getIm();
        double rr = Math.sqrt(ComplexConstant.abs(uRe, uIm));
        double ii = ComplexConstant.arg(uRe, uIm) / 2.0;
        return new ComplexConstant(rr * Math.cos(ii), rr * Math.sin(ii));
    }

    public final ComplexConstant sqrt() {
        return ComplexConstant.sqrt(this);
    }

    final void assignSqrt() {
        double rr = Math.sqrt(this.abs());
        double ii = this.arg() / 2.0;
        this.re = rr * Math.cos(ii);
        this.im = rr * Math.sin(ii);
    }

    final void assignSqrt(ComplexConstant u) {
        double rr = Math.sqrt(ComplexConstant.abs(u));
        double ii = ComplexConstant.arg(u) / 2.0;
        this.re = rr * Math.cos(ii);
        this.im = rr * Math.sin(ii);
    }

    final void assignSqrt(Field.Complex u) {
        double uRe = u.getRe();
        double uIm = u.getIm();
        double rr = Math.sqrt(ComplexConstant.abs(uRe, uIm));
        double ii = ComplexConstant.arg(uRe, uIm) / 2.0;
        this.re = rr * Math.cos(ii);
        this.im = rr * Math.sin(ii);
    }

    public static final ComplexConstant pow(Field.Complex u, Field.Complex v) {
        ComplexConstant w = new ComplexConstant(u);
        w.assignPow(v);
        return w;
    }

    public final ComplexConstant pow(Field.Complex v) {
        return ComplexConstant.pow((Field.Complex)this, v);
    }

    final void assignPow(ComplexConstant v) {
        this.assignPow(this, v);
    }

    final void assignPow(Field.Complex v) {
        this.assignPow((Field.Complex)this, v);
    }

    final void assignPow(double x, double y, double u, double v) {
        if (ComplexConstant.absSqr(u, v) == 0.0) {
            this.re = 1.0;
            this.im = 0.0;
            return;
        }
        double r = ComplexConstant.abs(x, y);
        if (r == 0.0) {
            this.re = 0.0;
            this.im = 0.0;
            return;
        }
        double arg = ComplexConstant.arg(x, y);
        double tmpRe = Math.log(r);
        double tmpIm = arg;
        double rr = tmpRe * u - tmpIm * v;
        double ii = tmpRe * v + tmpIm * u;
        r = Math.exp(rr);
        this.re = r * Math.cos(ii);
        this.im = r * Math.sin(ii);
    }

    final void assignPow(ComplexConstant u, ComplexConstant v) {
        this.assignPow(u.re, u.im, v.re, v.im);
    }

    final void assignPow(Field.Complex u, Field.Complex v) {
        this.assignPow(u.getRe(), u.getIm(), v.getRe(), v.getIm());
    }

    public static final ComplexConstant pow(Field.Complex u, double r) {
        ComplexConstant c = new ComplexConstant();
        c.assignPow(u, r);
        return c;
    }

    public final ComplexConstant pow(double r) {
        return ComplexConstant.pow((Field.Complex)this, r);
    }

    final void assignPow(double r) {
        this.assignPow(this, r);
    }

    final void assignPow(double x, double y, double r) {
        double tmpIm;
        double tmpRe;
        double rad = ComplexConstant.abs(x, y);
        if (rad == 0.0) {
            tmpRe = Double.NEGATIVE_INFINITY;
            tmpIm = 0.0;
        } else {
            double arg = ComplexConstant.arg(x, y);
            tmpRe = Math.log(rad);
            tmpIm = arg;
        }
        double rr = Math.exp(tmpRe *= r);
        this.re = rr * Math.cos(tmpIm *= r);
        this.im = rr * Math.sin(tmpIm);
    }

    final void assignPow(ComplexConstant u, double r) {
        this.assignPow(u.re, u.im, r);
    }

    final void assignPow(Field.Complex u, double r) {
        this.assignPow(u.getRe(), u.getIm(), r);
    }

    final void assignPow(double r, ComplexConstant u) {
        this.assignPow(r, 0.0, u.re, u.im);
    }

    final void assignPow(double r, Field.Complex u) {
        this.assignPow(r, 0.0, u.getRe(), u.getIm());
    }

    final void assignPow(double x, double y, int r) {
        ComplexConstant u2n = new ComplexConstant(x, y);
        if (r < 0) {
            r = -r;
            u2n.assignInvert();
        }
        this.assign(1.0, 0.0);
        while (r != 0) {
            if ((r & 1) == 1) {
                this.assignTimes(u2n);
            }
            u2n.assignSqr();
            r >>= 1;
        }
    }

    final void assignPow(ComplexConstant u, int r) {
        this.assignPow(u.re, u.im, r);
    }

    final void assignPow(Field.Complex u, int r) {
        this.assignPow(u.getRe(), u.getIm(), r);
    }

    public static final ComplexConstant pow(Field.Complex u, int r) {
        ComplexConstant c = new ComplexConstant();
        c.assignPow(u, r);
        return c;
    }

    public final ComplexConstant pow(int r) {
        ComplexConstant c = new ComplexConstant();
        c.assignPow(this.re, this.im, r);
        return c;
    }

    final void assignPow(int r) {
        this.assignPow(this, r);
    }

    public static final ComplexConstant sin(Field.Complex u) {
        ComplexConstant w = new ComplexConstant();
        w.assignSin(u.getRe(), u.getIm());
        return w;
    }

    public final ComplexConstant sin() {
        return ComplexConstant.sin(this);
    }

    final void assignSin() {
        this.assignSin(this.re, this.im);
    }

    final void assignSin(double x, double y) {
        double sinRe = Math.sin(x);
        double cosRe = Math.cos(x);
        double expIm = Math.exp(y);
        this.re = sinRe * (expIm + 1.0 / expIm) / 2.0;
        this.im = cosRe * (expIm - 1.0 / expIm) / 2.0;
    }

    final void assignSin(ComplexConstant u) {
        this.assignSin(u.re, u.im);
    }

    final void assignSin(Field.Complex u) {
        this.assignSin(u.getRe(), u.getIm());
    }

    public static final ComplexConstant cos(Field.Complex u) {
        ComplexConstant w = new ComplexConstant();
        w.assignCos(u.getRe(), u.getIm());
        return w;
    }

    public final ComplexConstant cos() {
        return ComplexConstant.cos(this);
    }

    final void assignCos() {
        this.assignCos(this.re, this.im);
    }

    final void assignCos(double x, double y) {
        double cosRe = Math.cos(x);
        double sinRe = Math.sin(x);
        double expIm = Math.exp(y);
        this.re = cosRe * (expIm + 1.0 / expIm) / 2.0;
        this.im = -sinRe * (expIm - 1.0 / expIm) / 2.0;
    }

    final void assignCos(ComplexConstant u) {
        this.assignCos(u.re, u.im);
    }

    final void assignCos(Field.Complex u) {
        this.assignCos(u.getRe(), u.getIm());
    }

    public static final ComplexConstant tan(Field.Complex u) {
        ComplexConstant w = new ComplexConstant();
        w.assignTan(u.getRe(), u.getIm());
        return w;
    }

    public final ComplexConstant tan() {
        return ComplexConstant.tan(this);
    }

    final void assignTan() {
        this.assignTan(this.re, this.im);
    }

    final void assignTan(double x, double y) {
        double cosRe = Math.cos(x);
        double sinRe = Math.sin(x);
        double expIm = Math.exp(y);
        double reCos = cosRe * (expIm + 1.0 / expIm) / 2.0;
        double imCos = -sinRe * (expIm - 1.0 / expIm) / 2.0;
        this.re = sinRe * (expIm + 1.0 / expIm) / 2.0;
        this.im = cosRe * (expIm - 1.0 / expIm) / 2.0;
        this.assignDivide(reCos, imCos);
    }

    final void assignTan(ComplexConstant u) {
        this.assignTan(u.re, u.im);
    }

    final void assignTan(Field.Complex u) {
        this.assignTan(u.getRe(), u.getIm());
    }

    public static final ComplexConstant sinh(Field.Complex u) {
        ComplexConstant w = new ComplexConstant();
        w.assignSinh(u.getRe(), u.getIm());
        return w;
    }

    public final ComplexConstant sinh() {
        return ComplexConstant.sinh(this);
    }

    final void assignSinh() {
        this.assignSinh(this.re, this.im);
    }

    final void assignSinh(double x, double y) {
        double sinIm = Math.sin(y);
        double cosIm = Math.cos(y);
        double expRe = Math.exp(x);
        this.re = cosIm * (expRe - 1.0 / expRe) / 2.0;
        this.im = sinIm * (expRe + 1.0 / expRe) / 2.0;
    }

    final void assignSinh(ComplexConstant u) {
        this.assignSinh(u.re, u.im);
    }

    final void assignSinh(Field.Complex u) {
        this.assignSinh(u.getRe(), u.getIm());
    }

    public static final ComplexConstant cosh(Field.Complex u) {
        ComplexConstant w = new ComplexConstant();
        w.assignCosh(u.getRe(), u.getIm());
        return w;
    }

    public final ComplexConstant cosh() {
        return ComplexConstant.cosh(this);
    }

    final void assignCosh() {
        this.assignCosh(this.re, this.im);
    }

    final void assignCosh(double x, double y) {
        double sinIm = Math.sin(y);
        double cosIm = Math.cos(y);
        double expRe = Math.exp(x);
        this.re = cosIm * (expRe + 1.0 / expRe) / 2.0;
        this.im = sinIm * (expRe - 1.0 / expRe) / 2.0;
    }

    final void assignCosh(ComplexConstant u) {
        this.assignCosh(u.re, u.im);
    }

    final void assignCosh(Field.Complex u) {
        this.assignCosh(u.getRe(), u.getIm());
    }

    public static final ComplexConstant fromPolar(double r, double f) {
        ComplexConstant w = new ComplexConstant();
        w.re = r * Math.cos(f);
        w.im = r * Math.sin(f);
        return w;
    }

    final void assignFromPolar(double r, double f) {
        this.re = r * Math.cos(f);
        this.im = r * Math.sin(f);
    }

    public final void assignCrossRatio(double aRe, double aIm, double bRe, double bIm, double cRe, double cIm, double dRe, double dIm) {
        this.assignDivide(cRe - bRe, cIm - bIm, bRe - aRe, bIm - aIm);
        this.assignTimes(aRe - dRe, aIm - dIm);
        this.assignDivide(dRe - cRe, dIm - cIm);
    }

    public static final ComplexConstant crossRatio(Field.Complex a, Field.Complex b, Field.Complex c, Field.Complex d) {
        ComplexConstant cr = new ComplexConstant();
        cr.assignCrossRatio(a, b, c, d);
        return cr;
    }

    public final void assignCrossRatio(ComplexConstant a, ComplexConstant b, ComplexConstant c, ComplexConstant d) {
        this.assignCrossRatio(a.re, a.im, b.re, b.im, c.re, c.im, d.re, d.im);
    }

    public final void assignCrossRatio(Field.Complex a, Field.Complex b, Field.Complex c, Field.Complex d) {
        this.assignCrossRatio(a.getRe(), a.getIm(), b.getRe(), b.getIm(), c.getRe(), c.getIm(), d.getRe(), d.getIm());
    }

    final void assignRandom() {
        this.re = Math.random();
        this.im = Math.random();
    }

    public static final double dot(ComplexConstant u, ComplexConstant v) {
        return u.re * v.re + u.im * v.im;
    }

    public final double dot(ComplexConstant v) {
        return this.re * v.re + this.im * v.im;
    }

    public final double dot(Field.Complex v) {
        return this.re * v.getRe() + this.im * v.getIm();
    }

    public static final double det(ComplexConstant u, ComplexConstant v) {
        return u.re * v.im - u.im * v.re;
    }

    public final double det(ComplexConstant v) {
        return this.re * v.im - this.im * v.re;
    }

    public final double det(Field.Complex v) {
        return this.re * v.getIm() - this.im * v.getRe();
    }

    public static final double distSqr(ComplexConstant u, ComplexConstant v) {
        double subRe = u.re - v.re;
        double subIm = u.im - v.im;
        return subRe * subRe + subIm * subIm;
    }

    public final double distSqr(ComplexConstant v) {
        double subRe = this.re - v.re;
        double subIm = this.im - v.im;
        return subRe * subRe + subIm * subIm;
    }

    public final double distSqr(Field.Complex v) {
        double subRe = this.re - v.getRe();
        double subIm = this.im - v.getIm();
        return subRe * subRe + subIm * subIm;
    }

    public static final double dist(ComplexConstant u, ComplexConstant v) {
        return Math.sqrt(ComplexConstant.distSqr(u, v));
    }

    public final double dist(ComplexConstant v) {
        return Math.sqrt(this.distSqr(v));
    }

    public final double dist(Field.Complex v) {
        return Math.sqrt(this.distSqr(v));
    }

    public static final double abs(ComplexConstant u) {
        return u.abs();
    }

    public final double abs() {
        return Math.sqrt(this.re * this.re + this.im * this.im);
    }

    public static final double absSqr(ComplexConstant u) {
        return u.re * u.re + u.im * u.im;
    }

    public final double absSqr() {
        return this.re * this.re + this.im * this.im;
    }

    public static final double arg(ComplexConstant u) {
        return ComplexConstant.arg(u.re, u.im);
    }

    public final double arg() {
        return ComplexConstant.arg(this.re, this.im);
    }

    public final boolean equals(Field.Complex c, double eps) {
        return Math.abs(this.re - c.getRe()) < eps && Math.abs(this.im - c.getIm()) < eps;
    }

    @Override
    public final boolean equals(Field.Complex c) {
        return this == c ? true : this.equals(c.getRe(), c.getIm());
    }

    public final boolean equals(ComplexConstant c) {
        return this == c ? true : this.equals(c.re, c.im);
    }

    public final boolean equals(double x, double y, double eps) {
        return Math.abs(this.re - x) < eps && Math.abs(this.im - y) < eps;
    }

    public final boolean equals(double x, double y) {
        return Math.abs(this.re - x) < 1.0E-14 && Math.abs(this.im - y) < 1.0E-14;
    }

    public final boolean equals(ComplexConstant c, double eps) {
        return Math.abs(this.re - c.re) < eps && Math.abs(this.im - c.im) < eps;
    }

    public static final boolean arraysCoincide(ComplexConstant[] c1, ComplexConstant[] c2, double eps) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null && c2 != null || c2 == null && c1 != null || c2.length != c1.length) {
            return false;
        }
        int l = c1.length;
        for (int i = 0; i < l; ++i) {
            if (c1[i].equals(c2[i], eps)) continue;
            return false;
        }
        return true;
    }

    public static final boolean arraysCoincide(ComplexConstant[] c1, ComplexConstant[] c2) {
        return ComplexConstant.arraysCoincide(c1, c2, 1.0E-14);
    }

    public static final boolean setsCoincide(ComplexConstant[] c1, ComplexConstant[] c2) {
        return ComplexConstant.setsCoincide(c1, c2, 1.0E-14);
    }

    public static final boolean setsCoincide(ComplexConstant[] c1, ComplexConstant[] c2, double eps) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null && c2 != null || c2 == null && c1 != null || c2.length != c1.length) {
            return false;
        }
        int l = c1.length;
        LinkedList<ComplexConstant> liste = new LinkedList<ComplexConstant>();
        for (int i = 0; i < l; ++i) {
            liste.add(c2[i]);
        }
        block1: for (int i = 0; i < l; ++i) {
            ListIterator it = liste.listIterator(0);
            while (it.hasNext()) {
                if (c1[i].equals((ComplexConstant)it.next(), eps)) {
                    it.remove();
                    continue block1;
                }
                if (it.hasNext()) continue;
                return false;
            }
        }
        return liste.size() == 0;
    }

    public static final void arraycopy(Field.Complex[] s, int is, ComplexConstant[] d, int id, int size) {
        if (is + size > s.length || id + size > d.length) {
            throw new IndexOutOfBoundsException();
        }
        if (s == d && id == is) {
            return;
        }
        if (id <= is) {
            int i = 0;
            while (i < size) {
                d[id] = s[is] == null ? null : new ComplexConstant(s[is]);
                ++i;
                ++is;
                ++id;
            }
        } else {
            is += size - 1;
            id += size - 1;
            int i = 0;
            while (i < size) {
                d[id] = s[is] == null ? null : new ComplexConstant(s[is]);
                ++i;
                --is;
                --id;
            }
        }
    }

    public static final ComplexConstant[] copy(Field.Complex[] s) {
        ComplexConstant[] d = new ComplexConstant[s.length];
        ComplexConstant.arraycopy(s, 0, d, 0, s.length);
        return d;
    }
}

