/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.field;

import de.jtem.mfc.field.Complex;
import de.jtem.mfc.field.Field;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.ListIterator;

public abstract class ComplexValue
implements Field.Complex {
    static final double EPS = 1.0E-14;
    static final double EPSSQR = 1.0E-28;

    public static final double re(Field.Complex u) {
        return u.getRe();
    }

    public static final double im(Field.Complex u) {
        return u.getIm();
    }

    public static final double dot(Field.Complex u, Field.Complex v) {
        return u.getRe() * v.getRe() + u.getIm() * v.getIm();
    }

    public static final double det(Field.Complex u, Field.Complex v) {
        return u.getRe() * v.getIm() - u.getIm() * v.getRe();
    }

    public static final double distSqr(Field.Complex u, Field.Complex v) {
        double subRe = u.getRe() - v.getRe();
        double subIm = u.getIm() - v.getIm();
        return subRe * subRe + subIm * subIm;
    }

    public static final double dist(Field.Complex u, Field.Complex v) {
        return Math.sqrt(ComplexValue.distSqr(u, v));
    }

    public static final double abs(double x, double y) {
        return Math.sqrt(x * x + y * y);
    }

    public static final double abs(Field.Complex u) {
        return ComplexValue.abs(u.getRe(), u.getIm());
    }

    public static final double absSqr(double x, double y) {
        return x * x + y * y;
    }

    public static final double absSqr(Field.Complex u) {
        return u.getRe() * u.getRe() + u.getIm() * u.getIm();
    }

    public static final double argPositive(double x, double y) {
        if (Math.abs(x) > Math.abs(y)) {
            if (x > 0.0) {
                return y >= 0.0 ? Math.atan(y / x) : Math.atan(y / x) + Math.PI * 2;
            }
            return Math.atan(y / x) + Math.PI;
        }
        if (y > 0.0) {
            return 1.5707963267948966 - Math.atan(x / y);
        }
        return y < 0.0 ? 4.71238898038469 - Math.atan(x / y) : 0.0;
    }

    public static final double argPositive(Field.Complex u) {
        return ComplexValue.argPositive(u.getRe(), u.getIm());
    }

    public static final double arg(double x, double y) {
        if (Math.abs(x) > Math.abs(y)) {
            if (x > 0.0) {
                return y >= 0.0 ? Math.atan(y / x) : Math.atan(y / x);
            }
            return y >= 0.0 ? Math.PI + Math.atan(y / x) : Math.atan(y / x) - Math.PI;
        }
        if (y > 0.0) {
            return 1.5707963267948966 - Math.atan(x / y);
        }
        return y < 0.0 ? -Math.atan(x / y) - 1.5707963267948966 : 0.0;
    }

    public static final double arg(Field.Complex u) {
        return ComplexValue.arg(u.getRe(), u.getIm());
    }

    public boolean equals(Field.Complex z) {
        return ComplexValue.equals(this.getRe(), this.getIm(), z.getRe(), z.getIm());
    }

    public final boolean equals(Object o) {
        try {
            if (o == this) {
                return true;
            }
            return this.equals((Field.Complex)o);
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    public static final boolean equals(double x1, double y1, double x2, double y2, double eps) {
        return Math.abs(x1 - x2) < 1.0E-14 && Math.abs(y1 - y2) < eps;
    }

    public static final boolean equals(double x1, double y1, double x2, double y2) {
        return Math.abs(x1 - x2) < 1.0E-14 && Math.abs(y1 - y2) < 1.0E-14;
    }

    public static final boolean arraysCoinside(Field.Complex[] c1, Field.Complex[] c2, double eps) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null && c2 != null || c2 == null && c1 != null || c2.length != c1.length) {
            return false;
        }
        int l = c1.length;
        for (int i = 0; i < l; ++i) {
            if (ComplexValue.equals(c1[i].getRe(), c1[i].getIm(), c2[i].getRe(), c2[i].getIm(), eps)) continue;
            return false;
        }
        return true;
    }

    public static final boolean arraysCoincide(Field.Complex[] c1, Field.Complex[] c2) {
        return ComplexValue.arraysCoinside(c1, c2, 1.0E-14);
    }

    public static final boolean setsCoincide(Field.Complex[] c1, Field.Complex[] c2, double eps) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null && c2 != null || c2 == null && c1 != null || c2.length != c1.length) {
            return false;
        }
        int l = c1.length;
        LinkedList<Field.Complex> liste = new LinkedList<Field.Complex>();
        for (int i = 0; i < l; ++i) {
            liste.add(c2[i]);
        }
        block1: for (int i = 0; i < l; ++i) {
            ListIterator it = liste.listIterator(0);
            while (it.hasNext()) {
                Field.Complex next = (Field.Complex)it.next();
                if (ComplexValue.equals(c1[i].getRe(), c1[i].getIm(), next.getRe(), next.getIm(), eps)) {
                    it.remove();
                    continue block1;
                }
                if (it.hasNext()) continue;
                return false;
            }
        }
        return liste.size() == 0;
    }

    public static final boolean setsCoincide(Field.Complex[] c1, Field.Complex[] c2) {
        return ComplexValue.setsCoincide(c1, c2, 1.0E-14);
    }

    public static String toString(Field.Complex complex, boolean withBrackets) {
        StringBuffer sb = new StringBuffer(20);
        if (withBrackets) {
            sb.append('(');
        }
        sb.append(complex.getRe());
        if (complex.getIm() >= 0.0) {
            sb.append("+");
        }
        sb.append(complex.getIm()).append('i');
        if (withBrackets) {
            sb.append(')');
        }
        return sb.toString();
    }

    public final String toString() {
        return ComplexValue.toString(this, true);
    }

    public static final Complex parseComplex(String s) {
        try {
            StreamTokenizer st = new StreamTokenizer(new StringReader(s));
            st.resetSyntax();
            st.wordChars(48, 57);
            st.wordChars(46, 46);
            st.whitespaceChars(0, 32);
            double cRe = 0.0;
            double cIm = 0.0;
            int t = st.nextToken();
            if (t == 105) {
                t = st.nextToken();
                if (t == -1) {
                    cIm = 1.0;
                    return new Complex(cRe, cIm);
                }
                throw new IllegalArgumentException("Syntax: [+|-] number [(+|- number i)|i]");
            }
            double num = ComplexValue.numerical(t, st);
            t = st.ttype;
            if (t == -1) {
                cRe = num;
                return new Complex(cRe, cIm);
            }
            if (t == 105) {
                t = st.nextToken();
                if (t == -1) {
                    cIm = num;
                    return new Complex(cRe, cIm);
                }
                throw new IllegalArgumentException("Syntax: [+|-] number [(+|- number i)|i]");
            }
            cRe = num;
            num = ComplexValue.numerical(t, st);
            t = st.ttype;
            if (t == 105) {
                t = st.nextToken();
                if (t == -1) {
                    cIm = num;
                    return new Complex(cRe, cIm);
                }
                throw new IllegalArgumentException("Syntax: [+|-] number [(+|- number i)|i]");
            }
            throw new IllegalArgumentException("missing i part");
        }
        catch (IOException ex) {
            throw new Error();
        }
    }

    private static double numerical(int t, StreamTokenizer st) throws IOException {
        double num;
        boolean minus;
        if (t == 43 || t == 45) {
            minus = t == 45;
            t = st.nextToken();
            if (t == 105) {
                double num2 = minus ? -1.0 : 1.0;
                return num2;
            }
        } else {
            minus = false;
        }
        if (t == -3) {
            num = Double.parseDouble(st.sval);
            if (minus) {
                num = -num;
            }
        } else {
            throw new IllegalArgumentException("Syntax: [+|-] number [(+|- number i)|i]");
        }
        t = st.nextToken();
        if (t == 69 || t == 101) {
            t = st.nextToken();
            if (t == 43 || t == 45) {
                minus = t == 45;
                t = st.nextToken();
            } else {
                minus = false;
            }
            if (t == -3) {
                double exp = Double.parseDouble(st.sval);
                if (minus) {
                    exp = -exp;
                }
                num *= Math.pow(10.0, exp);
                t = st.nextToken();
            } else {
                throw new IllegalArgumentException("Syntax: [+|-] number [(+|- number i)|i]");
            }
        }
        return num;
    }
}

