/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.field;

import javax.swing.BoundedRangeModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class DoubleBoundedRangeModel
implements BoundedRangeModel {
    private double min = -1.0;
    private double max = 1.0;
    private double value;
    private double divider;
    private boolean isAdjusting;
    EventListenerList listenerList = new EventListenerList();
    ChangeEvent changeEvent = null;

    public DoubleBoundedRangeModel() {
        this.updateRange();
    }

    public void setDoubleMinimum(double min) {
        if (this.min == min) {
            return;
        }
        if (min > this.min) {
            if (min > this.max) {
                this.max = min;
            }
            if (min > this.value) {
                this.value = min;
            }
        }
        this.min = min;
        this.updateRange();
        this.fireChangeEvent();
    }

    public double getDoubleMinimum() {
        return this.min;
    }

    public void setDoubleMaximum(double max) {
        if (this.max == max) {
            return;
        }
        if (max < this.max) {
            if (max < this.min) {
                this.min = max;
            }
            if (max < this.value) {
                this.value = max;
            }
        }
        this.max = max;
        this.updateRange();
        this.fireChangeEvent();
    }

    public double getDoubleMaximum() {
        return this.max;
    }

    public void setDoubleValue(double newValue) {
        if (this.value == newValue) {
            return;
        }
        this.value = newValue;
        boolean rangeChanged = false;
        if (this.value < this.min) {
            this.min = this.value;
            rangeChanged = true;
        } else if (this.value > this.max) {
            this.max = this.value;
            rangeChanged = true;
        } else if (!this.isAdjusting) {
            if (this.value == this.min) {
                this.min = DoubleBoundedRangeModel.relativeMin(this.value);
                rangeChanged = true;
            } else if (this.value == this.max) {
                this.max = DoubleBoundedRangeModel.relativeMax(this.value);
                rangeChanged = true;
            }
        }
        if (rangeChanged) {
            this.updateRange();
        }
        this.fireChangeEvent();
    }

    public double getDoubleValue() {
        return this.value;
    }

    private void updateRange() {
        this.divider = (this.max - this.min) / 2.147483647E9;
    }

    public static double relativeMin(double value) {
        if (value == 0.0) {
            return -1.0;
        }
        double digits = Math.ceil(Math.log(Math.abs(value)) / Math.log(10.0));
        if (value < 0.0) {
            if (value > -1.0) {
                return -1.0;
            }
            if (value == -Math.pow(10.0, digits)) {
                return -Math.pow(10.0, digits + 1.0);
            }
            return -Math.pow(10.0, digits);
        }
        if (value <= 1.0) {
            return 0.0;
        }
        return Math.pow(10.0, digits - 1.0);
    }

    public static double relativeMax(double value) {
        if (value == 0.0) {
            return 1.0;
        }
        double digits = Math.ceil(Math.log(Math.abs(value)) / Math.log(10.0));
        if (value < 0.0) {
            if (value >= -1.0) {
                return 0.0;
            }
            return -Math.pow(10.0, digits - 1.0);
        }
        if (value < 1.0) {
            return 1.0;
        }
        if (value == Math.pow(10.0, digits)) {
            return Math.pow(10.0, digits + 1.0);
        }
        return Math.pow(10.0, digits);
    }

    @Override
    public int getExtent() {
        return 1;
    }

    @Override
    public int getMaximum() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinimum() {
        return 0;
    }

    @Override
    public int getValue() {
        return (int)((this.value - this.min) / this.divider);
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    @Override
    public void setExtent(int newExtent) {
    }

    @Override
    public void setMaximum(int newMaximum) {
    }

    @Override
    public void setMinimum(int newMinimum) {
    }

    @Override
    public void setValue(int newValue) {
        this.setDoubleValue((double)newValue * this.divider + this.min);
    }

    @Override
    public void setValueIsAdjusting(boolean b) {
        boolean fireLater = false;
        if (b != this.isAdjusting) {
            this.isAdjusting = b;
            if (!this.isAdjusting) {
                if (this.value == this.min) {
                    this.min = DoubleBoundedRangeModel.relativeMin(this.value);
                    fireLater = true;
                } else if (this.value == this.max) {
                    fireLater = true;
                    this.max = DoubleBoundedRangeModel.relativeMax(this.value);
                }
                if (fireLater) {
                    this.updateRange();
                }
            }
        }
        if (fireLater) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DoubleBoundedRangeModel.this.fireChangeEvent();
                }
            });
        } else {
            this.fireChangeEvent();
        }
    }

    @Override
    public void setRangeProperties(int newValue, int extent, int min, int max, boolean adjusting) {
        boolean valueChanged = this.value != (double)newValue;
        boolean adjustingChanged = this.isAdjusting != adjusting;
        this.value = newValue;
        this.isAdjusting = adjusting;
        if (valueChanged || adjustingChanged) {
            this.fireChangeEvent();
        }
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public void fireChangeEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }
}

