/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.geometry;

import de.jtem.mfc.field.Complex;
import de.jtem.mfc.group.Moebius;
import de.jtem.mfc.vector.Complex2;
import de.jtem.mfc.vector.Real3;
import java.io.Serializable;

public class ComplexProjective1
extends Complex2
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;

    public ComplexProjective1() {
        super(1.0, 0.0, 0.0, 0.0);
    }

    public ComplexProjective1(Complex a, Complex b) {
        super(a, b);
    }

    public ComplexProjective1(ComplexProjective1 p) {
        super(p);
    }

    public ComplexProjective1(double theARe, double theAIm, double theBRe, double theBIm) {
        super(theARe, theAIm, theBRe, theBIm);
    }

    public void apply(Moebius m) {
        m.applyTo(this);
    }

    public final void projectTo(Complex z) {
        z.assign(this.aRe, this.aIm);
        z.assignDivide(this.bRe, this.bIm);
    }

    public final void projectTo(Real3 v) {
        double aNormSq = this.aRe * this.aRe + this.aIm * this.aIm;
        double bNormSq = this.bRe * this.bRe + this.bIm * this.bIm;
        double normSqSum = aNormSq + bNormSq;
        double twoAConjugateBRe = 2.0 * (this.aRe * this.bRe + this.aIm * this.bIm);
        double twoAConjugateBIm = 2.0 * (this.aIm * this.bRe - this.aRe * this.bIm);
        v.x = twoAConjugateBRe / normSqSum;
        v.y = twoAConjugateBIm / normSqSum;
        v.z = (aNormSq - bNormSq) / normSqSum;
    }

    public static final boolean equals(double aRe1, double aIm1, double bRe1, double bIm1, double aRe2, double aIm2, double bRe2, double bIm2) {
        return Math.abs(aRe1 * bRe2 - aIm1 * bIm2 - (aRe2 * bRe1 - aIm2 * bIm1)) < 1.0E-14 && Math.abs(aIm1 * bRe2 + aRe1 * bIm2 - (aIm2 * bRe1 + aRe2 * bIm1)) < 1.0E-14;
    }

    public static final boolean equals(double aRe1, double aIm1, double bRe1, double bIm1, double aRe2, double aIm2) {
        return ComplexProjective1.equals(aRe1, aIm1, bRe1, bIm1, aRe2, aIm2, 1.0, 0.0);
    }

    public final boolean equals(double aRe1, double aIm1, double bRe1, double bIm1) {
        return ComplexProjective1.equals(aRe1, aIm1, bRe1, bIm1, this.aRe, this.aIm, this.bRe, this.bIm);
    }

    public final boolean equals(Object o) {
        try {
            return this.equals((ComplexProjective1)o);
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    public final boolean equals(ComplexProjective1 c) {
        return this == c ? true : ComplexProjective1.equals(c.aRe, c.aIm, c.bRe, c.bIm, this.aRe, this.aIm, this.bRe, this.bIm);
    }
}

