/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.group;

import de.jtem.mfc.group.Permutation;
import de.jtem.mfc.group.PermutationEditorPanel;
import java.awt.Component;
import java.beans.PropertyEditorSupport;

public final class PermutationEditor
extends PropertyEditorSupport {
    private int[] value;
    private PermutationEditorPanel editor;
    private int[] basket = new int[20];

    public PermutationEditor() {
        this.value = new int[0];
    }

    public PermutationEditor(int[] v) {
        this.setValue(v);
    }

    public PermutationEditor(Permutation v) {
        this.setValue(v.getPermutation());
    }

    @Override
    public String getAsText() {
        return de.jtem.numericalMethods.algebra.group.Permutation.toString(this.value);
    }

    @Override
    public void setAsText(String s) throws IllegalArgumentException {
        int[] theIntArray = this.stringTo(s);
        if (!de.jtem.numericalMethods.algebra.group.Permutation.isPermutation(theIntArray)) {
            throw new IllegalArgumentException("Syntax: This is not a permutation of 0..n.");
        }
        this.setValue(theIntArray);
    }

    public int[] stringTo(String s) {
        try {
            return de.jtem.numericalMethods.algebra.group.Permutation.stringToIntArray(s, this.basket);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.enlarge();
            return this.stringTo(s);
        }
    }

    private void enlarge() {
        int[] larger = new int[this.basket.length << 1];
        System.arraycopy(this.basket, 0, larger, 0, this.basket.length);
        this.basket = larger;
    }

    @Override
    public Object getValue() {
        Permutation copy = new Permutation(this.value);
        return copy;
    }

    @Override
    public void setValue(Object o) {
        int[] newVal = ((Permutation)o).getPermutation();
        if (this.editor != null) {
            this.editor.setValue(newVal);
        }
        this.setValue(newVal);
        super.setValue(o);
    }

    public void setValue(int[] newVal) {
        boolean equal = true;
        if (this.value.length != newVal.length) {
            equal = false;
        } else {
            int i = this.value.length;
            while (--i >= 0) {
                if (this.value[i] == newVal[i]) continue;
                equal = false;
                break;
            }
        }
        if (!equal) {
            this.value = newVal;
            this.firePropertyChange();
        }
    }

    @Override
    public Component getCustomEditor() {
        if (this.editor != null) {
            return this.editor;
        }
        this.editor = new PermutationEditorPanel(this);
        this.editor.setValue(this.value);
        return this.editor;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }
}

