/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.group;

import de.jtem.mfc.group.Permutation;
import de.jtem.mfc.group.PermutationEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PermutationEditorPanel
extends JPanel
implements ActionListener,
Serializable {
    private JTextField permutation;
    private JTextField label;
    private JTextField cycle;
    private JButton next;
    private JButton nextD;
    private GridBagConstraints gbc = new GridBagConstraints();
    private int[] value;
    private PermutationEditor pE;

    public PermutationEditorPanel(PermutationEditor pE) {
        this.pE = pE;
        this.setLayout(new GridBagLayout());
        this.gbc.fill = 0;
        this.gbc.insets.bottom = 0;
        this.gbc.insets.top = 0;
        this.gbc.insets.left = 4;
        this.gbc.insets.right = 4;
        this.gbc.gridwidth = 1;
        this.gbc.weightx = 0.0;
        this.add((Component)new JLabel("", 4), this.gbc);
        this.gbc.fill = 2;
        this.gbc.gridwidth = 0;
        this.gbc.weightx = 1.0;
        this.label = new JTextField("( 0 1 2 3 4 )", 2);
        this.add((Component)this.label, this.gbc);
        this.label.setEditable(false);
        this.gbc.insets.bottom = 4;
        this.gbc.gridwidth = 1;
        this.gbc.weightx = 0.0;
        this.add((Component)new JLabel("permutation", 4), this.gbc);
        this.gbc.gridwidth = 0;
        this.gbc.weightx = 1.0;
        this.permutation = new JTextField();
        this.add((Component)this.permutation, this.gbc);
        this.permutation.addActionListener(this);
        this.gbc.insets.top = 10;
        this.gbc.gridwidth = 1;
        this.gbc.weightx = 0.0;
        this.add((Component)new JLabel("cycles", 4), this.gbc);
        this.gbc.gridwidth = 0;
        this.gbc.weightx = 1.0;
        this.cycle = new JTextField();
        this.add((Component)this.cycle, this.gbc);
        this.cycle.addActionListener(this);
        this.gbc.gridwidth = 1;
        this.gbc.weightx = 0.0;
        this.gbc.fill = 0;
        this.next = new JButton("next");
        this.add((Component)this.next, this.gbc);
        this.next.setActionCommand("next");
        this.next.setToolTipText("Click to jump to the next permutation.");
        this.next.addActionListener(this);
        this.gbc.gridwidth = 0;
        this.gbc.weightx = 1.0;
        this.nextD = new JButton("next Derangement");
        this.add((Component)this.nextD, this.gbc);
        this.nextD.setActionCommand("nextD");
        this.nextD.setToolTipText("Click to jump to the next derangement.");
        this.nextD.setEnabled(false);
        this.nextD.addActionListener(this);
        this.gbc.insets.top = 0;
    }

    public void setValue(Permutation v) {
        this.setValue(v.getPermutation());
    }

    public void setValue(int[] v) {
        this.value = v;
        this.pE.setValue(v);
        this.label.setText(de.jtem.numericalMethods.algebra.group.Permutation.toString(de.jtem.numericalMethods.algebra.group.Permutation.identity(v.length)));
        this.permutation.setText(de.jtem.numericalMethods.algebra.group.Permutation.toString(v));
        this.cycle.setText(de.jtem.numericalMethods.algebra.group.Permutation.cyclesToString(de.jtem.numericalMethods.algebra.group.Permutation.cycles(v)));
        this.nextD.setEnabled(de.jtem.numericalMethods.algebra.group.Permutation.isDerangement(v));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if ("next".equals(ev.getActionCommand())) {
            de.jtem.numericalMethods.algebra.group.Permutation.next(this.value);
            this.setValue(this.value);
            return;
        }
        if ("nextD".equals(ev.getActionCommand())) {
            de.jtem.numericalMethods.algebra.group.Permutation.nextDerangement(this.value);
            this.setValue(this.value);
            return;
        }
        JTextField source = (JTextField)ev.getSource();
        String s = source.getText();
        if (source == this.permutation) {
            this.setValue(de.jtem.numericalMethods.algebra.group.Permutation.stringToIntArray(s));
        }
        if (source == this.cycle) {
            this.setValue(de.jtem.numericalMethods.algebra.group.Permutation.fromCycles(de.jtem.numericalMethods.algebra.group.Permutation.stringToCycles(s)));
        }
    }
}

