/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.group;

import de.jtem.mfc.group.Permutation;
import java.beans.PropertyEditorSupport;

public final class SimplePermutationEditor
extends PropertyEditorSupport {
    private int[] value;
    private int[] basket = new int[20];

    public SimplePermutationEditor() {
        this.value = new int[0];
    }

    public SimplePermutationEditor(int[] v) {
        this.setValue(v);
    }

    public SimplePermutationEditor(Permutation v) {
        this.setValue(v.getPermutation());
    }

    @Override
    public String getAsText() {
        return de.jtem.numericalMethods.algebra.group.Permutation.toString(this.value);
    }

    @Override
    public void setAsText(String s) throws IllegalArgumentException {
        int[] theIntArray = this.stringTo(s);
        if (!de.jtem.numericalMethods.algebra.group.Permutation.isPermutation(theIntArray)) {
            throw new IllegalArgumentException("Syntax: This is not a permutation of 0..n.");
        }
        this.setValue(theIntArray);
    }

    public int[] stringTo(String s) {
        try {
            return de.jtem.numericalMethods.algebra.group.Permutation.stringToIntArray(s, this.basket);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.enlarge();
            return this.stringTo(s);
        }
    }

    private void enlarge() {
        int[] larger = new int[this.basket.length << 1];
        System.arraycopy(this.basket, 0, larger, 0, this.basket.length);
        this.basket = larger;
    }

    @Override
    public Object getValue() {
        int len = this.value.length;
        int[] copy = new int[len];
        System.arraycopy(this.value, 0, copy, 0, len);
        return copy;
    }

    @Override
    public void setValue(Object o) {
        int[] newVal = (int[])o;
        boolean equal = true;
        if (this.value.length != newVal.length) {
            equal = false;
        } else {
            int i = this.value.length;
            while (--i >= 0) {
                if (this.value[i] == newVal[i]) continue;
                equal = false;
                break;
            }
        }
        if (!equal) {
            this.value = newVal;
            this.firePropertyChange();
        }
    }
}

