/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.matrix;

import de.jtem.mfc.field.Complex;
import de.jtem.mfc.field.Field;
import de.jtem.mfc.matrix.Complex2By2;
import de.jtem.mfc.vector.Complex2;
import java.io.Serializable;

public abstract class AbstractComplex2By2
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final double EPSILON = 1.0E-14;
    public static final double EPS = 1.0E-14;
    public static final double EPSSQR = 1.0E-28;
    static final Complex dummyComplex = new Complex();
    static final Complex2By2 dummyComplex2By2 = new Complex2By2();
    protected double aRe;
    protected double aIm;
    protected double bRe;
    protected double bIm;
    protected double cRe;
    protected double cIm;
    protected double dRe;
    protected double dIm;

    protected AbstractComplex2By2() {
        this.assignIdentity();
    }

    protected AbstractComplex2By2(double aRe, double aIm, double bRe, double bIm, double cRe, double cIm, double dRe, double dIm) {
        this.assign(aRe, aIm, bRe, bIm, cRe, cIm, dRe, dIm);
    }

    protected AbstractComplex2By2(Complex a, Complex b, Complex c, Complex d) {
        this.assign(a.re, a.im, b.re, b.im, c.re, c.im, d.re, d.im);
    }

    protected AbstractComplex2By2(Field.Complex a, Field.Complex b, Field.Complex c, Field.Complex d) {
        this.assign(a.getRe(), a.getIm(), b.getRe(), b.getIm(), c.getRe(), c.getIm(), d.getRe(), d.getIm());
    }

    public AbstractComplex2By2(AbstractComplex2By2 m) {
        this.assign(m);
    }

    public Complex getA() {
        return new Complex(this.aRe, this.aIm);
    }

    public void getA(Complex a) {
        a.assign(this.aRe, this.aIm);
    }

    protected void setA(Complex a) {
        this.aRe = a.re;
        this.aIm = a.im;
    }

    public Complex getB() {
        return new Complex(this.bRe, this.bIm);
    }

    public void getB(Complex b) {
        b.assign(this.bRe, this.bIm);
    }

    protected void setB(Complex b) {
        this.bRe = b.re;
        this.bIm = b.im;
    }

    public Complex getC() {
        return new Complex(this.cRe, this.cIm);
    }

    public void getC(Complex c) {
        c.assign(this.cRe, this.cIm);
    }

    protected void setC(Complex c) {
        this.cRe = c.re;
        this.cIm = c.im;
    }

    public Complex getD() {
        return new Complex(this.dRe, this.dIm);
    }

    public void getD(Complex d) {
        d.assign(this.dRe, this.dIm);
    }

    protected void setD(Complex d) {
        this.dRe = d.re;
        this.dIm = d.im;
    }

    protected void assignZero() {
        this.assign(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    protected void assignIdentity() {
        this.assign(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    protected void assign(double aRe, double aIm, double bRe, double bIm, double cRe, double cIm, double dRe, double dIm) {
        this.aRe = aRe;
        this.aIm = aIm;
        this.bRe = bRe;
        this.bIm = bIm;
        this.cRe = cRe;
        this.cIm = cIm;
        this.dRe = dRe;
        this.dIm = dIm;
    }

    protected void assign(Complex a, Complex b, Complex c, Complex d) {
        this.assign(a.re, a.im, b.re, b.im, c.re, c.im, d.re, d.im);
    }

    protected void assign(AbstractComplex2By2 s) {
        this.assign(s.aRe, s.aIm, s.bRe, s.bIm, s.cRe, s.cIm, s.dRe, s.dIm);
    }

    protected void assignTimes(AbstractComplex2By2 a) {
        this.assignTimes(this, a);
    }

    public static void times(AbstractComplex2By2 a, AbstractComplex2By2 b, AbstractComplex2By2 c) {
        if (a == c || b == c) {
            double d1r = a.aRe * b.aRe - a.aIm * b.aIm + a.bRe * b.cRe - a.bIm * b.cIm;
            double d1i = a.aRe * b.aIm + a.aIm * b.aRe + a.bRe * b.cIm + a.bIm * b.cRe;
            double d2r = a.aRe * b.bRe - a.aIm * b.bIm + a.bRe * b.dRe - a.bIm * b.dIm;
            double d2i = a.aRe * b.bIm + a.aIm * b.bRe + a.bRe * b.dIm + a.bIm * b.dRe;
            double d3r = a.cRe * b.aRe - a.cIm * b.aIm + a.dRe * b.cRe - a.dIm * b.cIm;
            double d3i = a.cRe * b.aIm + a.cIm * b.aRe + a.dRe * b.cIm + a.dIm * b.cRe;
            double d4r = a.cRe * b.bRe - a.cIm * b.bIm + a.dRe * b.dRe - a.dIm * b.dIm;
            double d4i = a.cRe * b.bIm + a.cIm * b.bRe + a.dRe * b.dIm + a.dIm * b.dRe;
            c.aRe = d1r;
            c.aIm = d1i;
            c.bRe = d2r;
            c.bIm = d2i;
            c.cRe = d3r;
            c.cIm = d3i;
            c.dRe = d4r;
            c.dIm = d4i;
        } else {
            c.aRe = a.aRe * b.aRe - a.aIm * b.aIm + a.bRe * b.cRe - a.bIm * b.cIm;
            c.aIm = a.aRe * b.aIm + a.aIm * b.aRe + a.bRe * b.cIm + a.bIm * b.cRe;
            c.bRe = a.aRe * b.bRe - a.aIm * b.bIm + a.bRe * b.dRe - a.bIm * b.dIm;
            c.bIm = a.aRe * b.bIm + a.aIm * b.bRe + a.bRe * b.dIm + a.bIm * b.dRe;
            c.cRe = a.cRe * b.aRe - a.cIm * b.aIm + a.dRe * b.cRe - a.dIm * b.cIm;
            c.cIm = a.cRe * b.aIm + a.cIm * b.aRe + a.dRe * b.cIm + a.dIm * b.cRe;
            c.dRe = a.cRe * b.bRe - a.cIm * b.bIm + a.dRe * b.dRe - a.dIm * b.dIm;
            c.dIm = a.cRe * b.bIm + a.cIm * b.bRe + a.dRe * b.dIm + a.dIm * b.dRe;
        }
    }

    protected void assignTimes(AbstractComplex2By2 a, AbstractComplex2By2 b) {
        AbstractComplex2By2.times(a, b, this);
    }

    protected void assignTimes(double r) {
        this.assignTimes(this, r);
    }

    protected void assignTimes(AbstractComplex2By2 m, double r) {
        if (m == this) {
            this.aRe *= r;
            this.aIm *= r;
            this.bRe *= r;
            this.bIm *= r;
            this.cRe *= r;
            this.cIm *= r;
            this.dRe *= r;
            this.dIm *= r;
        } else {
            this.aRe = m.aRe * r;
            this.aIm = m.aIm * r;
            this.bRe = m.bRe * r;
            this.bIm = m.bIm * r;
            this.cRe = m.cRe * r;
            this.cIm = m.cIm * r;
            this.dRe = m.dRe * r;
            this.dIm = m.dIm * r;
        }
    }

    protected void assignTimes(double x, double y) {
        this.assignTimes(this, x, y);
    }

    protected void assignTimes(AbstractComplex2By2 m, double x, double y) {
        if (m == this) {
            double tmp = this.aRe * x - this.aIm * y;
            this.aIm = this.aIm * x + this.aRe * y;
            this.aRe = tmp;
            tmp = this.bRe * x - this.bIm * y;
            this.bIm = this.bIm * x + this.bRe * y;
            this.bRe = tmp;
            tmp = this.cRe * x - this.cIm * y;
            this.cIm = this.cIm * x + this.cRe * y;
            this.cRe = tmp;
            tmp = this.dRe * x - this.dIm * y;
            this.dIm = this.dIm * x + this.dRe * y;
            this.dRe = tmp;
        } else {
            this.aRe = m.aRe * x - m.aIm * y;
            this.aIm = m.aIm * x + m.aRe * y;
            this.bRe = m.bRe * x - m.bIm * y;
            this.bIm = m.bIm * x + m.bRe * y;
            this.cRe = m.cRe * x - m.cIm * y;
            this.cIm = m.cIm * x + m.cRe * y;
            this.dRe = m.dRe * x - m.dIm * y;
            this.dIm = m.dIm * x + m.dRe * y;
        }
    }

    protected void assignTimes(Complex z) {
        this.assignTimes(this, z.re, z.im);
    }

    protected void assignTimes(AbstractComplex2By2 m, Complex z) {
        this.assignTimes(m, z.re, z.im);
    }

    protected void assignDivide(AbstractComplex2By2 m) {
        this.assignDivide(this, m);
    }

    public static void divide(AbstractComplex2By2 a, AbstractComplex2By2 b, AbstractComplex2By2 c) {
        double detRe = b.aRe * b.dRe - b.aIm * b.dIm - (b.bRe * b.cRe - b.bIm * b.cIm);
        double detIm = b.aRe * b.dIm + b.aIm * b.dRe - (b.bRe * b.cIm + b.bIm * b.cRe);
        double nn = detRe * detRe + detIm * detIm;
        if (nn == 0.0) {
            throw new RuntimeException("Matrix is not invertible. ");
        }
        if (a == c || b == c) {
            double d1r = a.aRe * b.dRe - a.aIm * b.dIm - a.bRe * b.cRe + a.bIm * b.cIm;
            double d1i = a.aRe * b.dIm + a.aIm * b.dRe - a.bRe * b.cIm - a.bIm * b.cRe;
            double d2r = a.bRe * b.aRe - a.bIm * b.aIm - a.aRe * b.bRe + a.aIm * b.bIm;
            double d2i = a.bRe * b.aIm + a.bIm * b.aRe - a.aRe * b.bIm - a.aIm * b.bRe;
            double d3r = a.cRe * b.dRe - a.cIm * b.dIm - a.dRe * b.cRe + a.dIm * b.cIm;
            double d3i = a.cRe * b.dIm + a.cIm * b.dRe - a.dRe * b.cIm - a.dIm * b.cRe;
            double d4r = a.dRe * b.aRe - a.dIm * b.aIm - a.cRe * b.bRe + a.cIm * b.bIm;
            double d4i = a.dRe * b.aIm + a.dIm * b.aRe - a.cRe * b.bIm - a.cIm * b.bRe;
            c.aRe = d1r;
            c.aIm = d1i;
            c.bRe = d2r;
            c.bIm = d2i;
            c.cRe = d3r;
            c.cIm = d3i;
            c.dRe = d4r;
            c.dIm = d4i;
        } else {
            c.aRe = a.aRe * b.dRe - a.aIm * b.dIm - a.bRe * b.cRe + a.bIm * b.cIm;
            c.aIm = a.aRe * b.dIm + a.aIm * b.dRe - a.bRe * b.cIm - a.bIm * b.cRe;
            c.bRe = a.bRe * b.aRe - a.bIm * b.aIm - a.aRe * b.bRe + a.aIm * b.bIm;
            c.bIm = a.bRe * b.aIm + a.bIm * b.aRe - a.aRe * b.bIm - a.aIm * b.bRe;
            c.cRe = a.cRe * b.dRe - a.cIm * b.dIm - a.dRe * b.cRe + a.dIm * b.cIm;
            c.cIm = a.cRe * b.dIm + a.cIm * b.dRe - a.dRe * b.cIm - a.dIm * b.cRe;
            c.dRe = a.dRe * b.aRe - a.dIm * b.aIm - a.cRe * b.bRe + a.cIm * b.bIm;
            c.dIm = a.dRe * b.aIm + a.dIm * b.aRe - a.cRe * b.bIm - a.cIm * b.bRe;
        }
        c.assignDivide(nn);
    }

    protected void assignDivide(AbstractComplex2By2 a, AbstractComplex2By2 b) {
        AbstractComplex2By2.divide(a, b, this);
    }

    protected void assignDivide(double r) {
        this.assignDivide(this, r);
    }

    protected void assignDivide(AbstractComplex2By2 m, double r) {
        if (m == this) {
            this.aRe /= r;
            this.aIm /= r;
            this.bRe /= r;
            this.bIm /= r;
            this.cRe /= r;
            this.cIm /= r;
            this.dRe /= r;
            this.dIm /= r;
        } else {
            this.aRe = m.aRe / r;
            this.aIm = m.aIm / r;
            this.bRe = m.bRe / r;
            this.bIm = m.bIm / r;
            this.cRe = m.cRe / r;
            this.cIm = m.cIm / r;
            this.dRe = m.dRe / r;
            this.dIm = m.dIm / r;
        }
    }

    protected void assignDivide(double x, double y) {
        this.assignDivide(this, x, y);
    }

    protected void assignDivide(AbstractComplex2By2 m, double x, double y) {
        double nn = x * x + y * y;
        if (nn != 0.0) {
            this.assignTimes(m, x, -y);
        }
        this.assignDivide(nn);
    }

    protected void assignDivide(Complex z) {
        this.assignDivide(this, z.re, z.im);
    }

    protected void assignDivide(AbstractComplex2By2 m, Complex z) {
        double nn = z.re * z.re + z.im * z.im;
        if (nn != 0.0) {
            this.assignTimes(m, z.re, -z.im);
        }
        this.assignDivide(nn);
    }

    protected void assignPlus(AbstractComplex2By2 a) {
        this.assignPlus(this, a);
    }

    public static void plus(AbstractComplex2By2 a, AbstractComplex2By2 b, AbstractComplex2By2 c) {
        c.aRe = a.aRe + b.aRe;
        c.aIm = a.aIm + b.aIm;
        c.bRe = a.bRe + b.bRe;
        c.bIm = a.bIm + b.bIm;
        c.cRe = a.cRe + b.cRe;
        c.cIm = a.cIm + b.cIm;
        c.dRe = a.dRe + b.dRe;
        c.dIm = a.dIm + b.dIm;
    }

    protected void assignPlus(AbstractComplex2By2 a, AbstractComplex2By2 b) {
        AbstractComplex2By2.plus(a, b, this);
    }

    protected void assignPlus(double x) {
        this.assignPlus(this, x);
    }

    protected void assignPlus(AbstractComplex2By2 m, double x) {
        this.aRe = m.aRe + x;
        this.bRe = m.bRe + x;
        this.cRe = m.cRe + x;
        this.dRe = m.dRe + x;
    }

    protected void assignPlus(double x, double y) {
        this.assignPlus(this, x, y);
    }

    protected void assignPlus(AbstractComplex2By2 m, double x, double y) {
        this.aRe = m.aRe + x;
        this.aIm = m.aIm + y;
        this.bRe = m.bRe + x;
        this.bIm = m.bIm + y;
        this.cRe = m.cRe + x;
        this.cIm = m.cIm + y;
        this.dRe = m.dRe + x;
        this.dIm = m.dIm + y;
    }

    protected void assignPlus(Complex z) {
        this.assignPlus(this, z.re, z.im);
    }

    protected void assignPlus(AbstractComplex2By2 m, Complex z) {
        this.assignPlus(m, z.re, z.im);
    }

    protected void assignMinus(AbstractComplex2By2 a) {
        this.assignMinus(this, a);
    }

    public static void minus(AbstractComplex2By2 a, AbstractComplex2By2 b, AbstractComplex2By2 c) {
        c.aRe = a.aRe - b.aRe;
        c.aIm = a.aIm - b.aIm;
        c.bRe = a.bRe - b.bRe;
        c.bIm = a.bIm - b.bIm;
        c.cRe = a.cRe - b.cRe;
        c.cIm = a.cIm - b.cIm;
        c.dRe = a.dRe - b.dRe;
        c.dIm = a.dIm - b.dIm;
    }

    protected void assignMinus(AbstractComplex2By2 a, AbstractComplex2By2 b) {
        AbstractComplex2By2.minus(a, b, this);
    }

    protected void assignMinus(double x) {
        this.assignMinus(this, x);
    }

    protected void assignMinus(AbstractComplex2By2 m, double x) {
        this.aRe = m.aRe - x;
        this.bRe = m.bRe - x;
        this.cRe = m.cRe - x;
        this.dRe = m.dRe - x;
    }

    protected void assignMinus(double x, double y) {
        this.assignMinus(this, x, y);
    }

    protected void assignMinus(AbstractComplex2By2 m, double x, double y) {
        this.aRe = m.aRe - x;
        this.aIm = m.aIm - y;
        this.bRe = m.bRe - x;
        this.bIm = m.bIm - y;
        this.cRe = m.cRe - x;
        this.cIm = m.cIm - y;
        this.dRe = m.dRe - x;
        this.dIm = m.dIm - y;
    }

    protected void assignMinus(Complex z) {
        this.assignMinus(this, z.re, z.im);
    }

    protected void assignMinus(AbstractComplex2By2 m, Complex z) {
        this.assignMinus(m, z.re, z.im);
    }

    protected void assignNeg(AbstractComplex2By2 a) {
        this.aRe = -a.aRe;
        this.aIm = -a.aIm;
        this.bRe = -a.bRe;
        this.bIm = -a.bIm;
        this.cRe = -a.cRe;
        this.cIm = -a.cIm;
        this.dRe = -a.dRe;
        this.dIm = -a.dIm;
    }

    protected void assignNeg() {
        this.assignNeg(this);
    }

    protected void assignConjugate(AbstractComplex2By2 a) {
        if (a == this) {
            this.aIm = -a.aIm;
            this.bIm = -a.bIm;
            this.cIm = -a.cIm;
            this.dIm = -a.dIm;
        } else {
            this.aRe = a.aRe;
            this.aIm = -a.aIm;
            this.bRe = a.cRe;
            this.bIm = -a.cIm;
            this.cRe = a.bRe;
            this.cIm = -a.bIm;
            this.dRe = a.dRe;
            this.dIm = -a.dIm;
        }
    }

    protected void assignConjugate() {
        this.assignConjugate(this);
    }

    protected void assignTranspose(AbstractComplex2By2 a) {
        if (a == this) {
            double tmp = this.bRe;
            this.bRe = this.cRe;
            this.cRe = tmp;
            tmp = this.bIm;
            this.bIm = this.cIm;
            this.cIm = tmp;
        } else {
            this.aRe = a.aRe;
            this.aIm = a.aIm;
            this.bRe = a.cRe;
            this.bIm = a.cIm;
            this.cRe = a.bRe;
            this.cIm = a.bIm;
            this.dRe = a.dRe;
            this.dIm = a.dIm;
        }
    }

    protected void assignTranspose() {
        this.assignTranspose(this);
    }

    protected void assignStar(AbstractComplex2By2 a) {
        if (a == this) {
            double tmp = this.bRe;
            this.bRe = this.cRe;
            this.cRe = tmp;
            tmp = this.bIm;
            this.bIm = -this.cIm;
            this.cIm = -tmp;
            this.aIm = -this.aIm;
            this.dIm = -this.dIm;
        } else {
            this.aRe = a.aRe;
            this.aIm = -a.aIm;
            this.bRe = a.cRe;
            this.bIm = -a.cIm;
            this.cRe = a.bRe;
            this.cIm = -a.bIm;
            this.dRe = a.dRe;
            this.dIm = -a.dIm;
        }
    }

    protected void assignStar() {
        this.assignStar(this);
    }

    protected void assignAdjugate(AbstractComplex2By2 a) {
        double tmp = a.aRe;
        this.aRe = a.dRe;
        this.dRe = tmp;
        tmp = a.aIm;
        this.aIm = a.dIm;
        this.dIm = tmp;
        this.bRe = -a.bRe;
        this.bIm = -a.bIm;
        this.cRe = -a.cRe;
        this.cIm = -a.cIm;
    }

    protected void assignAdjugate() {
        this.assignAdjugate(this);
    }

    protected void assignInvert(AbstractComplex2By2 m) {
        double detRe = m.aRe * m.dRe - m.aIm * m.dIm - (m.bRe * m.cRe - m.bIm * m.cIm);
        double detIm = m.aRe * m.dIm + m.aIm * m.dRe - (m.bRe * m.cIm + m.bIm * m.cRe);
        double nn = detRe * detRe + detIm * detIm;
        if (nn == 0.0) {
            throw new RuntimeException(m + " matrix is not invertable");
        }
        this.assignAdjugate(m);
        this.assignTimes(detRe / nn, -detIm / nn);
    }

    protected void assignInvert() {
        this.assignInvert(this);
    }

    protected void assignAdjoined(AbstractComplex2By2 a) {
        double tmp = a.bRe;
        this.bRe = a.cRe;
        this.cRe = tmp;
        tmp = -a.bIm;
        this.bIm = -a.cIm;
        this.cIm = tmp;
        this.aRe = a.aRe;
        this.aIm = -a.aIm;
        this.dRe = a.dRe;
        this.dIm = -a.dIm;
    }

    protected void assignAdjoined() {
        this.assignAdjoined(this);
    }

    protected void assignNormalizeDeterminant(AbstractComplex2By2 m) {
        double detRe = m.aRe * m.dRe - m.aIm * m.dIm - (m.bRe * m.cRe - m.bIm * m.cIm);
        double detIm = m.aRe * m.dIm + m.aIm * m.dRe - (m.bRe * m.cIm + m.bIm * m.cRe);
        if (Math.abs(detIm) > 1.0E-14 || Math.abs(detRe - 1.0) > 1.0E-14) {
            double sqrtOfDetIm;
            double ii;
            double rr = Math.sqrt(Complex.abs(detRe, detIm));
            double sqrtOfDetRe = rr * Math.cos(ii = Complex.arg(detRe, detIm) / 2.0);
            double nn = sqrtOfDetRe * sqrtOfDetRe + (sqrtOfDetIm = rr * Math.sin(ii)) * sqrtOfDetIm;
            if (nn == 0.0) {
                throw new ArithmeticException("Matrix determinant is zero");
            }
            if (this != m) {
                this.assign(m);
            }
            this.assignTimes(sqrtOfDetRe, -sqrtOfDetIm);
            this.assignDivide(nn);
        }
    }

    protected void assignNormalizeDeterminant() {
        this.assignNormalizeDeterminant(this);
    }

    protected void assignByColumn(Complex2 column1, Complex2 column2) {
        this.assign(column1.aRe, column1.aIm, column2.aRe, column2.aIm, column1.bRe, column1.bIm, column2.bRe, column2.bIm);
    }

    protected void assignConjugateWith(AbstractComplex2By2 t) throws IllegalArgumentException {
        t.determinant(dummyComplex);
        if (AbstractComplex2By2.dummyComplex.re == 0.0 && AbstractComplex2By2.dummyComplex.im == 0.0) {
            throw new IllegalArgumentException("Det t == 0.0. ");
        }
        this.assignAdjugate();
        this.assignTimes(t, this);
        this.assignAdjugate();
        this.assignTimes(t, this);
        this.assignDivide(dummyComplex);
    }

    protected void assignAdjoinedWith(AbstractComplex2By2 t) {
        this.assignTimes(t, this);
        this.assignAdjoined();
        this.assignTimes(t, this);
        this.assignAdjoined();
    }

    protected void assignByEigenvectors(double eigenvalue1Re, double eigenvalue1Im, Complex2 eigenvector1, double eigenvalue2Re, double eigenvalue2Im, Complex2 eigenvector2) {
        this.assign(eigenvalue1Re, eigenvalue1Im, 0.0, 0.0, 0.0, 0.0, eigenvalue2Re, eigenvalue2Im);
        dummyComplex2By2.assignByColumn(eigenvector1, eigenvector2);
        this.assignConjugateWith(dummyComplex2By2);
    }

    protected void assignByEigenvectors(Complex eigenvalue1, Complex2 eigenvector1, Complex eigenvalue2, Complex2 eigenvector2) {
        this.assignByEigenvectors(eigenvalue1.re, eigenvalue1.im, eigenvector1, eigenvalue2.re, eigenvalue2.im, eigenvector2);
    }

    public final double absSqr() {
        return this.aRe * this.aRe + this.aIm * this.aIm + this.bRe * this.bRe + this.bIm * this.bIm + this.cRe * this.cRe + this.cIm * this.cIm + this.dRe * this.dRe + this.dIm * this.dIm;
    }

    public final double abs() {
        return Math.sqrt(this.absSqr());
    }

    public final double distSqr(AbstractComplex2By2 s) {
        return (s.aRe - this.aRe) * (s.aRe - this.aRe) + (s.aIm - this.aIm) * (s.aIm - this.aIm) + (s.bRe - this.bRe) * (s.bRe - this.bRe) + (s.bIm - this.bIm) * (s.bIm - this.bIm) + (s.cRe - this.cRe) * (s.cRe - this.cRe) + (s.cIm - this.cIm) * (s.cIm - this.cIm) + (s.dRe - this.dRe) * (s.dRe - this.dRe) + (s.dIm - this.dIm) * (s.dIm - this.dIm);
    }

    public final double dist(AbstractComplex2By2 s) {
        return Math.sqrt(this.distSqr(s));
    }

    public final Complex determinant() {
        Complex det = new Complex();
        this.determinant(det);
        return det;
    }

    public final void determinant(Complex det) {
        double detRe = this.aRe * this.dRe - this.aIm * this.dIm - this.bRe * this.cRe + this.bIm * this.cIm;
        double detIm = this.aRe * this.dIm + this.aIm * this.dRe - this.bRe * this.cIm - this.bIm * this.cRe;
        det.assign(detRe, detIm);
    }

    public final Complex trace() {
        Complex trace = new Complex();
        this.trace(trace);
        return trace;
    }

    public final void trace(Complex trace) {
        trace.assign(this.aRe + this.dRe, this.aIm + this.dIm);
    }

    public final double normSqr() {
        Complex bigEV = new Complex();
        this.getEigenValues(null, bigEV);
        return bigEV.absSqr();
    }

    public final double norm() {
        Complex bigEV = new Complex();
        this.getEigenValues(null, bigEV);
        return bigEV.abs();
    }

    public final void getEigenValues(Complex smallEV, Complex bigEV) {
        double sqrtOfDisIm;
        double ii;
        double aPlusDRe = this.aRe + this.dRe;
        double aPlusDIm = this.aIm + this.dIm;
        double detRe = this.aRe * this.dRe - this.aIm * this.dIm - this.bRe * this.cRe + this.bIm * this.cIm;
        double disRe = aPlusDRe * aPlusDRe - aPlusDIm * aPlusDIm - 4.0 * detRe;
        double detIm = this.aRe * this.dIm + this.aIm * this.dRe - this.bRe * this.cIm - this.bIm * this.cRe;
        double disIm = aPlusDRe * aPlusDIm + aPlusDIm * aPlusDRe - 4.0 * detIm;
        double rr = Math.sqrt(Complex.abs(disRe, disIm));
        double sqrtOfDisRe = rr * Math.cos(ii = Complex.arg(disRe, disIm) / 2.0);
        if (aPlusDRe * sqrtOfDisRe + aPlusDIm * (sqrtOfDisIm = rr * Math.sin(ii)) < 0.0) {
            sqrtOfDisRe = -sqrtOfDisRe;
            sqrtOfDisIm = -sqrtOfDisIm;
        }
        if (smallEV != null) {
            smallEV.assign((aPlusDRe - sqrtOfDisRe) / 2.0, (aPlusDIm - sqrtOfDisIm) / 2.0);
        }
        if (bigEV != null) {
            bigEV.assign((aPlusDRe + sqrtOfDisRe) / 2.0, (aPlusDIm + sqrtOfDisIm) / 2.0);
        }
    }

    public final void getEigenValues(Complex[] ev) {
        if (ev[0] == null) {
            ev[0] = new Complex();
        }
        if (ev[1] == null) {
            ev[1] = new Complex();
        }
        this.getEigenValues(ev[0], ev[1]);
    }

    public final Complex[] getEigenValues() {
        Complex[] ev = new Complex[2];
        this.getEigenValues(ev);
        return ev;
    }

    public boolean equals(Object o) {
        try {
            return this.distSqr((AbstractComplex2By2)o) < 1.0E-28;
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer().append('(').append('(').append('(').append(this.aRe);
        if (this.aIm >= 0.0) {
            sb.append('+');
        }
        sb.append(this.aIm).append('i').append(')').append(',').append('(').append(this.bRe);
        if (this.bIm >= 0.0) {
            sb.append('+');
        }
        sb.append(this.bIm).append('i').append(')').append(')').append(',');
        sb.append('(').append('(').append(this.cRe);
        if (this.cIm >= 0.0) {
            sb.append('+');
        }
        sb.append(this.cIm).append('i').append(')').append(',').append('(').append(this.dRe);
        if (this.dIm >= 0.0) {
            sb.append('+');
        }
        sb.append(this.dIm).append('i').append(')').append(')').append(')');
        return sb.toString();
    }

    public static void times(AbstractComplex2By2 m, Complex2 v, Complex2 w) {
        if (v == w) {
            double wARe = m.aRe * v.aRe - m.aIm * v.aIm + m.bRe * v.bRe - m.bIm * v.bIm;
            double wAIm = m.aRe * v.aIm + m.aIm * v.aRe + m.bRe * v.bIm + m.bIm * v.bRe;
            double wBRe = m.cRe * v.aRe - m.cIm * v.aIm + m.dRe * v.bRe - m.dIm * v.bIm;
            double wBIm = m.cRe * v.aIm + m.cIm * v.aRe + m.dRe * v.bIm + m.dIm * v.bRe;
            w.aRe = wARe;
            w.aIm = wAIm;
            w.bRe = wBRe;
            w.bIm = wBIm;
        } else {
            w.aRe = m.aRe * v.aRe - m.aIm * v.aIm + m.bRe * v.bRe - m.bIm * v.bIm;
            w.aIm = m.aRe * v.aIm + m.aIm * v.aRe + m.bRe * v.bIm + m.bIm * v.bRe;
            w.bRe = m.cRe * v.aRe - m.cIm * v.aIm + m.dRe * v.bRe - m.dIm * v.bIm;
            w.bIm = m.cRe * v.aIm + m.cIm * v.aRe + m.dRe * v.bIm + m.dIm * v.bRe;
        }
    }
}

