/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.matrix;

import de.jtem.mfc.field.Complex;
import de.jtem.mfc.field.Field;
import de.jtem.mfc.matrix.AbstractComplex2By2;
import de.jtem.mfc.matrix.Complex2By2;
import de.jtem.mfc.polynomial.ComplexLaurentPolynomial;
import de.jtem.numericalMethods.algebra.loopGroup.BirkhoffFactorization;
import de.jtem.numericalMethods.algebra.loopGroup.IwasawaFactorization;
import java.io.Serializable;

public class ComplexLaurentPolynomial2By2
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final double EPS = 1.0E-14;
    public ComplexLaurentPolynomial a;
    public ComplexLaurentPolynomial b;
    public ComplexLaurentPolynomial c;
    public ComplexLaurentPolynomial d;
    static ComplexLaurentPolynomial p11 = new ComplexLaurentPolynomial();
    static ComplexLaurentPolynomial p12 = new ComplexLaurentPolynomial();
    static ComplexLaurentPolynomial p21 = new ComplexLaurentPolynomial();
    static ComplexLaurentPolynomial p22 = new ComplexLaurentPolynomial();
    static ComplexLaurentPolynomial q11 = new ComplexLaurentPolynomial();
    static ComplexLaurentPolynomial q12 = new ComplexLaurentPolynomial();
    static ComplexLaurentPolynomial q21 = new ComplexLaurentPolynomial();
    static ComplexLaurentPolynomial q22 = new ComplexLaurentPolynomial();
    private static final Complex evalResult = new Complex();
    private static final Complex evalDerivativeResult = new Complex();

    public ComplexLaurentPolynomial2By2() {
        this.a = new ComplexLaurentPolynomial();
        this.b = new ComplexLaurentPolynomial();
        this.c = new ComplexLaurentPolynomial();
        this.d = new ComplexLaurentPolynomial();
    }

    public ComplexLaurentPolynomial2By2(ComplexLaurentPolynomial2By2 p) {
        this(p.a, p.b, p.c, p.d);
    }

    public ComplexLaurentPolynomial2By2(ComplexLaurentPolynomial a, ComplexLaurentPolynomial b, ComplexLaurentPolynomial c, ComplexLaurentPolynomial d) {
        this.a = new ComplexLaurentPolynomial(a);
        this.b = new ComplexLaurentPolynomial(b);
        this.c = new ComplexLaurentPolynomial(c);
        this.d = new ComplexLaurentPolynomial(d);
    }

    public ComplexLaurentPolynomial2By2(int lowerDegree, int degree) {
        this.a = new ComplexLaurentPolynomial(lowerDegree, degree);
        this.b = new ComplexLaurentPolynomial(lowerDegree, degree);
        this.c = new ComplexLaurentPolynomial(lowerDegree, degree);
        this.d = new ComplexLaurentPolynomial(lowerDegree, degree);
    }

    public ComplexLaurentPolynomial getA() {
        return this.a;
    }

    public void setA(ComplexLaurentPolynomial p) {
        this.a = p;
    }

    public ComplexLaurentPolynomial getB() {
        return this.b;
    }

    public void setB(ComplexLaurentPolynomial p) {
        this.b = p;
    }

    public ComplexLaurentPolynomial getC() {
        return this.c;
    }

    public void setC(ComplexLaurentPolynomial p) {
        this.c = p;
    }

    public ComplexLaurentPolynomial getD() {
        return this.d;
    }

    public void setD(ComplexLaurentPolynomial p) {
        this.d = p;
    }

    public void eval(Complex z, AbstractComplex2By2 m) {
        this.a.eval(z, evalResult);
        m.setA(evalResult);
        this.b.eval(z, evalResult);
        m.setB(evalResult);
        this.c.eval(z, evalResult);
        m.setC(evalResult);
        this.d.eval(z, evalResult);
        m.setD(evalResult);
    }

    public Complex2By2 eval(Complex z) {
        Complex2By2 m = new Complex2By2();
        this.eval(z, m);
        return m;
    }

    public void evalDerivative(Complex z, int n, AbstractComplex2By2 m) {
        this.a.evalDerivative(z, n, evalDerivativeResult);
        m.setA(evalDerivativeResult);
        this.b.evalDerivative(z, n, evalDerivativeResult);
        m.setB(evalDerivativeResult);
        this.c.evalDerivative(z, n, evalDerivativeResult);
        m.setC(evalDerivativeResult);
        this.d.evalDerivative(z, n, evalDerivativeResult);
        m.setD(evalDerivativeResult);
    }

    public Complex2By2 evalDerivative(Complex z, int n) {
        Complex2By2 m = new Complex2By2();
        this.evalDerivative(z, n, m);
        return m;
    }

    public void assign(ComplexLaurentPolynomial2By2 p) {
        this.a.assign(p.a);
        this.b.assign(p.b);
        this.c.assign(p.c);
        this.d.assign(p.d);
    }

    public static ComplexLaurentPolynomial2By2 identity() {
        return ComplexLaurentPolynomial2By2.constant(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    public void assignIdentity() {
        this.a.assignMonomial(0, 1.0, 0.0);
        this.b.assignMonomial(0, 0.0, 0.0);
        this.c.assignMonomial(0, 0.0, 0.0);
        this.d.assignMonomial(0, 1.0, 0.0);
    }

    public static ComplexLaurentPolynomial2By2 constant(double aRe, double aIm, double bRe, double bIm, double cRe, double cIm, double dRe, double dIm) {
        ComplexLaurentPolynomial2By2 result = new ComplexLaurentPolynomial2By2();
        result.getA().setCoefficient(0, aRe, aIm);
        result.getB().setCoefficient(0, bRe, bIm);
        result.getC().setCoefficient(0, cRe, cIm);
        result.getD().setCoefficient(0, dRe, dIm);
        return result;
    }

    public static ComplexLaurentPolynomial2By2 constant(Complex a, Complex b, Complex c, Complex d) {
        return ComplexLaurentPolynomial2By2.constant(a.re, a.im, b.re, b.im, c.re, c.im, d.re, d.im);
    }

    public static ComplexLaurentPolynomial2By2 constant(Field.Complex a, Field.Complex b, Field.Complex c, Field.Complex d) {
        return ComplexLaurentPolynomial2By2.constant(a.getRe(), a.getIm(), b.getRe(), b.getIm(), c.getRe(), c.getIm(), d.getRe(), d.getIm());
    }

    public void assignConstant(Complex a, Complex b, Complex c, Complex d) {
        this.a.assignMonomial(0, a);
        this.b.assignMonomial(0, b);
        this.c.assignMonomial(0, c);
        this.d.assignMonomial(0, d);
    }

    public void assignTimes(ComplexLaurentPolynomial2By2 l, ComplexLaurentPolynomial2By2 m) {
        p11.assignTimes(l.a, m.a);
        q11.assignTimes(l.b, m.c);
        p12.assignTimes(l.a, m.b);
        q12.assignTimes(l.b, m.d);
        p21.assignTimes(l.c, m.a);
        q21.assignTimes(l.d, m.c);
        p22.assignTimes(l.c, m.b);
        q22.assignTimes(l.d, m.d);
        this.a.assignPlus(p11, q11);
        this.b.assignPlus(p12, q12);
        this.c.assignPlus(p21, q21);
        this.d.assignPlus(p22, q22);
    }

    public void assignTimes(ComplexLaurentPolynomial2By2 m) {
        this.assignTimes(this, m);
    }

    public ComplexLaurentPolynomial2By2 times(ComplexLaurentPolynomial2By2 m) {
        ComplexLaurentPolynomial2By2 result = new ComplexLaurentPolynomial2By2();
        result.assignTimes(this, m);
        return result;
    }

    public void assignPlus(ComplexLaurentPolynomial2By2 l, ComplexLaurentPolynomial2By2 m) {
        this.a.assignPlus(l.a, m.a);
        this.b.assignPlus(l.b, m.b);
        this.c.assignPlus(l.c, m.c);
        this.d.assignPlus(l.d, m.d);
    }

    public void assignPlus(ComplexLaurentPolynomial2By2 m) {
        this.assignPlus(this, m);
    }

    public ComplexLaurentPolynomial2By2 plus(ComplexLaurentPolynomial2By2 m) {
        ComplexLaurentPolynomial2By2 result = new ComplexLaurentPolynomial2By2();
        result.assignPlus(this, m);
        return result;
    }

    public ComplexLaurentPolynomial2By2 neg() {
        ComplexLaurentPolynomial2By2 result = new ComplexLaurentPolynomial2By2();
        result.setA(this.a.neg());
        result.setB(this.b.neg());
        result.setC(this.c.neg());
        result.setD(this.d.neg());
        return result;
    }

    public ComplexLaurentPolynomial2By2 minus(ComplexLaurentPolynomial2By2 q) {
        ComplexLaurentPolynomial2By2 result = new ComplexLaurentPolynomial2By2();
        result.assignMinus(this, q);
        return result;
    }

    public void assignMinus(ComplexLaurentPolynomial2By2 q) {
        this.assignMinus(this, q);
    }

    public void assignMinus(ComplexLaurentPolynomial2By2 p, ComplexLaurentPolynomial2By2 q) {
        this.a.assignMinus(p.a, q.a);
        this.b.assignMinus(p.b, q.b);
        this.c.assignMinus(p.c, q.c);
        this.d.assignMinus(p.d, q.d);
    }

    public void determinant(ComplexLaurentPolynomial p) {
        p.assignMinus(this.a.times(this.d), this.b.times(this.c));
    }

    public ComplexLaurentPolynomial determinant() {
        ComplexLaurentPolynomial result = new ComplexLaurentPolynomial();
        this.determinant(result);
        return result;
    }

    public void trace(ComplexLaurentPolynomial p) {
        p.assignPlus(this.a, this.d);
    }

    public ComplexLaurentPolynomial trace() {
        ComplexLaurentPolynomial result = new ComplexLaurentPolynomial();
        this.trace(result);
        return result;
    }

    public int getDegree() {
        int deg = this.a.getDegree();
        int newDeg = this.b.getDegree();
        if (newDeg > deg) {
            deg = newDeg;
        }
        if ((newDeg = this.c.getDegree()) > deg) {
            deg = newDeg;
        }
        if ((newDeg = this.d.getDegree()) > deg) {
            deg = newDeg;
        }
        return deg;
    }

    public void setDegree(int deg) {
        this.a.setDegree(deg);
        this.b.setDegree(deg);
        this.c.setDegree(deg);
        this.d.setDegree(deg);
    }

    public void setDegrees(int lowDeg, int deg) {
        this.a.setDegrees(lowDeg, deg);
        this.b.setDegrees(lowDeg, deg);
        this.c.setDegrees(lowDeg, deg);
        this.d.setDegrees(lowDeg, deg);
    }

    public void truncate(int deg) {
        this.a.truncate(deg);
        this.b.truncate(deg);
        this.c.truncate(deg);
        this.d.truncate(deg);
    }

    public int getLowerDegree() {
        int deg = this.a.getLowerDegree();
        int newDeg = this.b.getLowerDegree();
        if (newDeg < deg) {
            deg = newDeg;
        }
        if ((newDeg = this.c.getLowerDegree()) < deg) {
            deg = newDeg;
        }
        if ((newDeg = this.d.getLowerDegree()) < deg) {
            deg = newDeg;
        }
        return deg;
    }

    public void setLowerDegree(int deg) {
        this.a.setLowerDegree(deg);
        this.b.setLowerDegree(deg);
        this.c.setLowerDegree(deg);
        this.d.setLowerDegree(deg);
    }

    public void truncateBelow(int deg) {
        this.a.truncateBelow(deg);
        this.b.truncateBelow(deg);
        this.c.truncateBelow(deg);
        this.d.truncateBelow(deg);
    }

    public void truncate(double eps) {
        this.a.truncate(eps);
        this.b.truncate(eps);
        this.c.truncate(eps);
        this.d.truncate(eps);
    }

    public void truncate() {
        this.truncate(1.0E-14);
    }

    public ComplexLaurentPolynomial2By2 star() {
        return new ComplexLaurentPolynomial2By2(this.a.star(), this.c.star().neg(), this.b.star().neg(), this.d.star());
    }

    public void assignStar(ComplexLaurentPolynomial2By2 p) {
        this.a.assignStar(p.a);
        this.b.assignStar(p.c);
        this.b.assignNeg();
        this.c.assignStar(p.b);
        this.c.assignNeg();
        this.d.assignStar(p.d);
    }

    public void assignStar() {
        this.a.assignStar();
        this.b.assignStar();
        this.b.assignNeg();
        this.c.assignStar();
        this.c.assignNeg();
        this.d.assignStar();
        ComplexLaurentPolynomial p = this.b;
        this.b = this.c;
        this.c = p;
    }

    public ComplexLaurentPolynomial2By2 adjugate() {
        return new ComplexLaurentPolynomial2By2(this.d, this.b.neg(), this.c.neg(), this.a);
    }

    public void assignAdjugate(ComplexLaurentPolynomial2By2 p) {
        this.a.assign(p.d);
        this.b.assignNeg(p.b);
        this.c.assignNeg(p.c);
        this.d.assign(p.a);
    }

    public void assignAdjugate() {
        this.b.assignNeg();
        this.c.assignNeg();
        ComplexLaurentPolynomial p = this.d;
        this.d = this.a;
        this.a = p;
    }

    public void assignDerivative(ComplexLaurentPolynomial2By2 p, int n) {
        this.a.assignDerivative(p.a, n);
        this.b.assignDerivative(p.b, n);
        this.c.assignDerivative(p.c, n);
        this.d.assignDerivative(p.d, n);
    }

    public void assignDerivative(int n) {
        this.assignDerivative(this, n);
    }

    public ComplexLaurentPolynomial2By2 derivative(int n) {
        ComplexLaurentPolynomial2By2 result = new ComplexLaurentPolynomial2By2(this.a.derivative(n), this.b.derivative(n), this.c.derivative(n), this.d.derivative(n));
        return result;
    }

    public void assignDerivative(ComplexLaurentPolynomial2By2 p) {
        this.assignDerivative(p, 1);
    }

    public void assignDerivative() {
        this.assignDerivative(this, 1);
    }

    public ComplexLaurentPolynomial2By2 derivative() {
        return this.derivative(1);
    }

    public void assignRandom() {
        this.a.assignRandom();
        this.b.assignRandom();
        this.c.assignRandom();
        this.d.assignRandom();
    }

    public void assignBirkhoffFactor(ComplexLaurentPolynomial2By2 A, int direction, int factor, int normalize) {
        int N = Math.max(A.getDegree(), -A.getLowerDegree());
        A.setDegrees(-N, N);
        if (BirkhoffFactorization.isNegative(direction, factor)) {
            this.setDegrees(-N, 0);
        } else {
            this.setDegrees(0, N);
        }
        double[][][] aRe = new double[2][2][];
        double[][][] aIm = new double[2][2][];
        double[][][] cRe = new double[2][2][];
        double[][][] cIm = new double[2][2][];
        aRe[0][0] = A.a.re();
        aIm[0][0] = A.a.im();
        aRe[0][1] = A.b.re();
        aIm[0][1] = A.b.im();
        aRe[1][0] = A.c.re();
        aIm[1][0] = A.c.im();
        aRe[1][1] = A.d.re();
        aIm[1][1] = A.d.im();
        cRe[0][0] = this.a.re();
        cIm[0][0] = this.a.im();
        cRe[0][1] = this.b.re();
        cIm[0][1] = this.b.im();
        cRe[1][0] = this.c.re();
        cIm[1][0] = this.c.im();
        cRe[1][1] = this.d.re();
        cIm[1][1] = this.d.im();
        BirkhoffFactorization.factor(aRe, aIm, cRe, cIm, direction, factor, normalize);
    }

    public void assignIwasawaFactor(ComplexLaurentPolynomial2By2 A) {
        int N = Math.max(A.getDegree(), -A.getLowerDegree());
        A.setDegrees(-N, N);
        this.setDegrees(-N, N);
        double[][][] aRe = new double[2][2][];
        double[][][] aIm = new double[2][2][];
        double[][][] bRe = new double[2][2][];
        double[][][] bIm = new double[2][2][];
        aRe[0][0] = A.a.re();
        aIm[0][0] = A.a.im();
        aRe[0][1] = A.b.re();
        aIm[0][1] = A.b.im();
        aRe[1][0] = A.c.re();
        aIm[1][0] = A.c.im();
        aRe[1][1] = A.d.re();
        aIm[1][1] = A.d.im();
        bRe[0][0] = this.a.re();
        bIm[0][0] = this.a.im();
        bRe[0][1] = this.b.re();
        bIm[0][1] = this.b.im();
        bRe[1][0] = this.c.re();
        bIm[1][0] = this.c.im();
        bRe[1][1] = this.d.re();
        bIm[1][1] = this.d.im();
        IwasawaFactorization.factor(aRe, aIm, bRe, bIm, N);
    }

    public boolean equals(ComplexLaurentPolynomial2By2 p) {
        return this.equals(p, 1.0E-14);
    }

    public boolean equals(ComplexLaurentPolynomial2By2 p, double eps) {
        return this.a.equals(p.a) && this.b.equals(p.b) && this.c.equals(p.c) && this.d.equals(p.d);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        try {
            return this.equals((ComplexLaurentPolynomial2By2)o);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(300);
        sb.append("a = " + this.a + "\n");
        sb.append("b = " + this.b + "\n");
        sb.append("c = " + this.c + "\n");
        sb.append("d = " + this.d + "\n");
        return sb.toString();
    }
}

