/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.matrix;

import de.jtem.mfc.field.Complex;
import de.jtem.mfc.matrix.AbstractComplex2By2;
import java.io.Serializable;

public class HermitianComplex2By2
extends AbstractComplex2By2
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;

    public HermitianComplex2By2() {
    }

    public HermitianComplex2By2(HermitianComplex2By2 m) {
        super(m);
    }

    public HermitianComplex2By2(double theA, double theBRe, double theBIm, double theD) {
        super(theA, 0.0, theBRe, theBIm, theBRe, -theBIm, theD, 0.0);
    }

    public HermitianComplex2By2(double a, Complex b, double d) {
        this(a, b.re, b.im, d);
    }

    public double getARe() {
        return this.aRe;
    }

    public void setARe(double v) {
        this.aRe = v;
    }

    @Override
    public void setB(Complex b) {
        this.bRe = b.re;
        this.bIm = b.im;
        this.cRe = b.re;
        this.cIm = -b.im;
    }

    @Override
    public void setC(Complex c) {
        this.cRe = c.re;
        this.cIm = c.im;
        this.bRe = c.re;
        this.bIm = -c.im;
    }

    public double getDRe() {
        return this.dRe;
    }

    public void setDRe(double v) {
        this.dRe = v;
    }

    public void assign(double newA, double newBRe, double newBIm, double newD) {
        this.aRe = newA;
        this.aIm = 0.0;
        this.bRe = newBRe;
        this.bIm = newBIm;
        this.cRe = newBRe;
        this.cIm = -newBIm;
        this.dRe = newD;
        this.dIm = 0.0;
    }

    public void assign(double a, Complex b, double d) {
        this.assign(a, b.re, b.im, d);
    }

    public void assign(HermitianComplex2By2 s) {
        this.assign(s.aRe, s.bRe, s.bIm, s.dRe);
    }

    @Override
    public void assignConjugateWith(AbstractComplex2By2 t) {
        super.assignConjugateWith(t);
    }

    @Override
    public void assignAdjoinedWith(AbstractComplex2By2 t) {
        super.assignAdjoinedWith(t);
    }

    public void assignLorentzVector(double x0, double x1, double x2, double x3) {
        this.assign(x0 - x3, -x1, -x2, x0 + x3);
    }

    public final double lorentzVectorX0() {
        return 0.5 * (this.aRe + this.dRe);
    }

    public final double lorentzVectorX1() {
        return -this.bRe;
    }

    public final double lorentzVectorX2() {
        return -this.bIm;
    }

    public final double lorentzVectorX3() {
        return 0.5 * (this.dRe - this.aRe);
    }

    public double realDeterminant() {
        return this.aRe * this.dRe - this.bRe * this.bRe - this.bIm * this.bIm;
    }
}

