/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.matrix;

import de.jtem.mfc.field.Complex;
import de.jtem.mfc.matrix.Complex2By2;
import de.jtem.mfc.vector.Complex2;

public class TestComplex2By2 {
    static final double EPS = 1.0E-14;

    private static double maxDiff(Complex2 v, Complex2 w) {
        double d1 = Math.abs(v.aRe - w.aRe);
        double d2 = Math.abs(v.aIm - w.aIm);
        double d3 = Math.abs(v.bRe - w.bRe);
        double d4 = Math.abs(v.bIm - w.bIm);
        double dd1 = d1 > d2 ? d1 : d2;
        double dd2 = d3 > d4 ? d3 : d4;
        return dd1 > dd2 ? dd1 : dd2;
    }

    private static double maxDiff(Complex z, Complex w) {
        double d2;
        double d1 = Math.abs(z.re - w.re);
        return d1 > (d2 = Math.abs(z.im - w.im)) ? d1 : d2;
    }

    public static void main(String[] args) {
        Complex2By2 m1 = new Complex2By2();
        Complex2 v1 = new Complex2();
        Complex2 v2 = new Complex2();
        Complex2 v3 = new Complex2();
        Complex2 v4 = new Complex2();
        Complex z1 = new Complex();
        Complex z2 = new Complex();
        Complex z3 = new Complex();
        Complex z4 = new Complex();
        z1.assign(2.5, -3.2);
        z2.assign(-1.2, 10.0);
        v1.assign(1.0, 2.0, 3.0, 4.0);
        v2.assign(-2.0, -1.0, 0.0, 1.0);
        m1.assignByEigenvectors(z1, v1, z2, v2);
        v3.assignTimes(m1, v1);
        v4.assignTimes(z1, v1);
        if (TestComplex2By2.maxDiff(v3, v4) > 1.0E-14) {
            throw new RuntimeException();
        }
        v3.assignTimes(m1, v2);
        v4.assignTimes(z2, v2);
        if (TestComplex2By2.maxDiff(v3, v4) > 1.0E-14) {
            throw new RuntimeException();
        }
        m1.getEigenValues(z3, z4);
        if (TestComplex2By2.maxDiff(z1, z3) > 1.0E-14) {
            throw new RuntimeException();
        }
        if (TestComplex2By2.maxDiff(z2, z4) > 1.0E-14) {
            throw new RuntimeException();
        }
    }
}

