/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.polynomial;

import de.jtem.mfc.field.Complex;
import de.jtem.mfc.field.Field;
import de.jtem.mfc.polynomial.ComplexPolynomial;
import java.io.Serializable;

public final class ComplexLaurentPolynomial
implements Complex.FunctionOnComplex,
Serializable {
    private static final long serialVersionUID = 1L;
    static final double EPS = 1.0E-14;
    double[] re;
    double[] im;
    int degree;
    int lowerDegree;
    private static double[] p = new double[2];

    public ComplexLaurentPolynomial(int n, double x, double y) {
        this.re = new double[]{x};
        this.im = new double[]{y};
        this.lowerDegree = this.degree = n;
    }

    public ComplexLaurentPolynomial(int n, Field.Complex a) {
        this(n, a.getRe(), a.getIm());
    }

    public ComplexLaurentPolynomial(int n) {
        this(n, 1.0, 0.0);
    }

    public ComplexLaurentPolynomial() {
        this(0, 0.0, 0.0);
    }

    public ComplexLaurentPolynomial(int lowerDegree, int degree) {
        this.degree = degree;
        this.lowerDegree = lowerDegree;
        this.re = new double[degree - lowerDegree + 1];
        this.im = new double[degree - lowerDegree + 1];
    }

    public ComplexLaurentPolynomial(ComplexPolynomial p) {
        this.re = (double[])p.re.clone();
        this.im = (double[])p.im.clone();
        this.degree = p.degree;
        this.lowerDegree = 0;
    }

    public ComplexLaurentPolynomial(ComplexLaurentPolynomial p) {
        this.re = (double[])p.re.clone();
        this.im = (double[])p.im.clone();
        this.degree = p.degree;
        this.lowerDegree = p.lowerDegree;
    }

    public ComplexLaurentPolynomial(Field.Complex a) {
        this(0, a.getRe(), a.getIm());
    }

    public ComplexLaurentPolynomial(int lowerDeg, Complex[] a) {
        this.assign(lowerDeg, a);
    }

    public ComplexLaurentPolynomial(Complex[] a) {
        this(0, a);
    }

    public ComplexLaurentPolynomial(int lowDeg, double[] aRe, double[] aIm) {
        if (aRe.length != aIm.length) {
            throw new IllegalArgumentException("array lengths do not coincide");
        }
        this.lowerDegree = lowDeg;
        this.degree = aRe.length + lowDeg - 1;
        this.re = aRe;
        this.im = aIm;
    }

    public double[] re() {
        return this.re;
    }

    public double[] im() {
        return this.im;
    }

    public int getLowerDegree() {
        return this.lowerDegree;
    }

    public void setLowerDegree(int lowDeg) {
        this.setDegrees(lowDeg, this.degree);
    }

    public void truncateBelow(int lowDeg) {
        if (lowDeg > this.lowerDegree) {
            this.setLowerDegree(lowDeg);
        }
    }

    public int getDegree() {
        return this.degree;
    }

    public void setDegree(int newDeg) {
        this.setDegrees(this.lowerDegree, newDeg);
    }

    public void setDegrees(int lowDeg, int newDeg) {
        if (newDeg != this.degree || lowDeg != this.lowerDegree) {
            int newLength = newDeg - lowDeg + 1;
            double[] newRe = new double[newLength];
            double[] newIm = new double[newLength];
            if (this.re != null) {
                int offset = lowDeg - this.lowerDegree;
                int polyStart = Math.max(0, offset);
                int newStart = Math.max(0, -offset);
                int len = Math.min(this.degree, newDeg) - this.lowerDegree + 1 - polyStart;
                if (len > 0) {
                    System.arraycopy(this.re, polyStart, newRe, newStart, len);
                    System.arraycopy(this.im, polyStart, newIm, newStart, len);
                }
            }
            this.re = newRe;
            this.im = newIm;
            this.lowerDegree = lowDeg;
            this.degree = newDeg;
        }
    }

    public void truncate(int deg) {
        if (deg < this.degree) {
            this.setDegree(deg);
        }
    }

    public void truncate(double eps) {
        double sqrEps = eps * eps;
        int i = this.degree;
        int k = this.re.length - 1;
        while (i >= this.lowerDegree && !(this.re[k] * this.re[k] + this.im[k] * this.im[k] > sqrEps)) {
            --i;
            --k;
        }
        if (i < this.lowerDegree) {
            this.assignMonomial(0, 0.0, 0.0);
            return;
        }
        int j = this.lowerDegree;
        k = 0;
        while (j <= i) {
            if (this.re[k] * this.re[k] + this.im[k] * this.im[k] > sqrEps) {
                this.setDegrees(j, i);
                return;
            }
            ++j;
            ++k;
        }
        this.setDegrees(i, i);
    }

    public void truncate() {
        this.truncate(1.0E-14);
    }

    public void assignZero() {
        this.assignMonomial(0, 0.0, 0.0);
    }

    public void assignMonomial(int n, double x, double y) {
        if (this.degree != this.lowerDegree) {
            this.re = new double[]{x};
            this.im = new double[]{y};
        } else {
            this.re[0] = x;
            this.im[0] = y;
        }
        this.lowerDegree = this.degree = n;
    }

    public void assignMonomial(int n, Field.Complex z) {
        this.assignMonomial(n, z.getRe(), z.getIm());
    }

    public void assignMonomial(int n) {
        this.assignMonomial(n, 1.0, 0.0);
    }

    public void assign(ComplexLaurentPolynomial p) {
        this.assign(p.lowerDegree, p.re, p.im);
    }

    public void assign(int lowDeg, Complex[] a) {
        if (a.length != this.degree - this.lowerDegree + 1) {
            this.re = new double[a.length];
            this.im = new double[a.length];
        }
        for (int i = 0; i < a.length; ++i) {
            this.re[i] = a[i].re;
            this.im[i] = a[i].im;
        }
        this.degree = lowDeg + a.length - 1;
        this.lowerDegree = lowDeg;
    }

    public void assign(int lowDeg, double[] aRe, double[] aIm) {
        if (aRe.length != this.degree - this.lowerDegree + 1) {
            this.re = (double[])aRe.clone();
            this.im = (double[])aIm.clone();
        } else {
            System.arraycopy(aRe, 0, this.re, 0, this.degree - this.lowerDegree + 1);
            System.arraycopy(aIm, 0, this.im, 0, this.degree - this.lowerDegree + 1);
        }
        this.degree = lowDeg + aRe.length - 1;
        this.lowerDegree = lowDeg;
    }

    public void coefficients(int startOrder, Complex[] a) {
        int minLength = Math.min(this.degree - startOrder + 1, a.length);
        for (int i = 0; i < minLength; ++i) {
            int j = i + startOrder - this.lowerDegree;
            if (a[i] == null) {
                a[i] = new Complex(this.re[j], this.im[j]);
                continue;
            }
            a[i].assign(this.re[j], this.im[j]);
        }
    }

    public Complex[] coefficients(int startOrder) {
        Complex[] c = new Complex[this.degree + 1 - startOrder];
        this.coefficients(startOrder, c);
        return c;
    }

    public Complex[] getCoefficients() {
        return this.coefficients(this.lowerDegree);
    }

    public Complex getCoefficient(int i) {
        Complex z = new Complex();
        this.getCoefficient(i, z);
        return z;
    }

    public void getCoefficient(int i, Complex z) {
        if (i >= this.lowerDegree && i <= this.degree) {
            z.assign(this.re[i - this.lowerDegree], this.im[i - this.lowerDegree]);
        } else {
            z.assign(0.0, 0.0);
        }
    }

    public void setCoefficient(int i, Field.Complex z) {
        this.setCoefficient(i, z.getRe(), z.getIm());
    }

    public void setCoefficient(int i, double x, double y) {
        if (i < this.lowerDegree) {
            this.setLowerDegree(i);
        }
        if (i > this.degree) {
            this.setDegree(i);
        }
        this.re[i - this.lowerDegree] = x;
        this.im[i - this.lowerDegree] = y;
    }

    public void assignCoefficients(ComplexLaurentPolynomial p) {
        int i;
        int minDegree = Math.min(this.degree, p.degree);
        int maxLowerDegree = Math.max(this.lowerDegree, p.lowerDegree);
        int length = minDegree - maxLowerDegree + 1;
        System.arraycopy(p.re, maxLowerDegree - p.lowerDegree, this.re, maxLowerDegree - this.lowerDegree, length);
        System.arraycopy(p.im, maxLowerDegree - p.lowerDegree, this.im, maxLowerDegree - this.lowerDegree, length);
        for (i = this.lowerDegree; i < maxLowerDegree; ++i) {
            this.re[i - this.lowerDegree] = 0.0;
            this.im[i - this.lowerDegree] = 0.0;
        }
        for (i = minDegree + 1; i <= this.degree; ++i) {
            this.re[i - this.lowerDegree] = 0.0;
            this.im[i - this.lowerDegree] = 0.0;
        }
    }

    public Complex eval(Complex z) {
        Complex w = new Complex();
        this.eval(z, w);
        return w;
    }

    @Override
    public void eval(Complex z, Complex w) {
        de.jtem.numericalMethods.algebra.polynomial.ComplexLaurentPolynomial.eval(this.re, this.im, this.lowerDegree, this.degree, z.re, z.im, p);
        w.assign(p[0], p[1]);
    }

    public Complex evalDerivative(Complex z, int n) {
        Complex w = new Complex();
        this.evalDerivative(z, n, w);
        return w;
    }

    public void evalDerivative(Complex z, int n, Complex w) {
        double[] p = new double[2];
        de.jtem.numericalMethods.algebra.polynomial.ComplexLaurentPolynomial.evalDerivative(this.re, this.im, this.lowerDegree, this.degree, n, z.re, z.im, p);
        w.assign(p[0], p[1]);
    }

    public ComplexLaurentPolynomial plus(ComplexLaurentPolynomial q) {
        ComplexLaurentPolynomial result = new ComplexLaurentPolynomial();
        result.assignPlus(this, q);
        return result;
    }

    public void assignPlus(ComplexLaurentPolynomial q) {
        this.assignPlus(this, q);
    }

    public void assignPlus(ComplexLaurentPolynomial p, ComplexLaurentPolynomial q) {
        int i;
        int newDegree = Math.max(p.degree, q.degree);
        int newLowerDegree = Math.min(p.lowerDegree, q.lowerDegree);
        double[] newRe = new double[newDegree - newLowerDegree + 1];
        double[] newIm = new double[newDegree - newLowerDegree + 1];
        for (i = p.lowerDegree; i <= p.degree; ++i) {
            newRe[i - newLowerDegree] = p.re[i - p.lowerDegree];
            newIm[i - newLowerDegree] = p.im[i - p.lowerDegree];
        }
        for (i = q.lowerDegree; i <= q.degree; ++i) {
            int n = i - newLowerDegree;
            newRe[n] = newRe[n] + q.re[i - q.lowerDegree];
            int n2 = i - newLowerDegree;
            newIm[n2] = newIm[n2] + q.im[i - q.lowerDegree];
        }
        this.re = newRe;
        this.im = newIm;
        this.degree = newDegree;
        this.lowerDegree = newLowerDegree;
    }

    public ComplexLaurentPolynomial minus(ComplexLaurentPolynomial q) {
        ComplexLaurentPolynomial result = new ComplexLaurentPolynomial();
        result.assignMinus(this, q);
        return result;
    }

    public void assignMinus(ComplexLaurentPolynomial q) {
        this.assignMinus(this, q);
    }

    public void assignMinus(ComplexLaurentPolynomial p, ComplexLaurentPolynomial q) {
        int i;
        int newDegree = Math.max(p.degree, q.degree);
        int newLowerDegree = Math.min(p.lowerDegree, q.lowerDegree);
        double[] newRe = new double[newDegree - newLowerDegree + 1];
        double[] newIm = new double[newDegree - newLowerDegree + 1];
        for (i = p.lowerDegree; i <= p.degree; ++i) {
            newRe[i - newLowerDegree] = p.re[i - p.lowerDegree];
            newIm[i - newLowerDegree] = p.im[i - p.lowerDegree];
        }
        for (i = q.lowerDegree; i <= q.degree; ++i) {
            int n = i - newLowerDegree;
            newRe[n] = newRe[n] - q.re[i - q.lowerDegree];
            int n2 = i - newLowerDegree;
            newIm[n2] = newIm[n2] - q.im[i - q.lowerDegree];
        }
        this.re = newRe;
        this.im = newIm;
        this.degree = newDegree;
        this.lowerDegree = newLowerDegree;
    }

    public ComplexLaurentPolynomial times(ComplexLaurentPolynomial q) {
        ComplexLaurentPolynomial result = new ComplexLaurentPolynomial();
        result.assignTimes(this, q);
        return result;
    }

    public void assignTimes(ComplexLaurentPolynomial q) {
        this.assignTimes(this, q);
    }

    public void assignTimes(ComplexLaurentPolynomial p, ComplexLaurentPolynomial q) {
        int newDegree = p.degree + q.degree;
        int newLowerDegree = p.lowerDegree + q.lowerDegree;
        double[] newRe = new double[newDegree - newLowerDegree + 1];
        double[] newIm = new double[newDegree - newLowerDegree + 1];
        de.jtem.numericalMethods.algebra.polynomial.ComplexPolynomial.times(p.re, p.im, p.degree - p.lowerDegree, q.re, q.im, q.degree - q.lowerDegree, newRe, newIm);
        this.re = newRe;
        this.im = newIm;
        this.degree = newDegree;
        this.lowerDegree = newLowerDegree;
    }

    public void assignTimes(ComplexLaurentPolynomial p, Complex z) {
        this.setNewDegrees(p);
        for (int i = 0; i < this.re.length; ++i) {
            double pRe = p.re[i];
            double pIm = p.im[i];
            this.re[i] = pRe * z.re - pIm * z.im;
            this.im[i] = pRe * z.im + pIm * z.re;
        }
    }

    public void assignTimes(Complex z, ComplexLaurentPolynomial p) {
        this.assignTimes(p, z);
    }

    public void assignTimes(Complex z) {
        this.assignTimes(this, z);
    }

    public ComplexLaurentPolynomial times(Complex z) {
        ComplexLaurentPolynomial result = new ComplexLaurentPolynomial();
        result.assignTimes(this, z);
        return result;
    }

    public void assignTimes(ComplexLaurentPolynomial p, double x) {
        this.setNewDegrees(p);
        for (int i = 0; i < this.re.length; ++i) {
            this.re[i] = p.re[i] * x;
            this.im[i] = p.im[i] * x;
        }
    }

    public void assignTimes(double x, ComplexLaurentPolynomial p) {
        this.assignTimes(p, x);
    }

    public void assignTimes(double x) {
        this.assignTimes(this, x);
    }

    public ComplexLaurentPolynomial times(double x) {
        ComplexLaurentPolynomial result = new ComplexLaurentPolynomial();
        result.assignTimes(this, x);
        return result;
    }

    void setNewDegrees(int lowerDegree, int degree) {
        this.degree = degree;
        this.lowerDegree = lowerDegree;
        if (this.re.length != degree - lowerDegree + 1) {
            this.re = new double[degree - lowerDegree + 1];
            this.im = new double[degree - lowerDegree + 1];
        }
    }

    void setNewDegrees(ComplexLaurentPolynomial p) {
        this.setNewDegrees(p.lowerDegree, p.degree);
    }

    public void assignNeg(ComplexLaurentPolynomial p) {
        this.setNewDegrees(p);
        for (int i = 0; i < this.re.length; ++i) {
            this.re[i] = -p.re[i];
            this.im[i] = -p.im[i];
        }
    }

    public void assignNeg() {
        this.assignNeg(this);
    }

    public ComplexLaurentPolynomial neg() {
        ComplexLaurentPolynomial result = new ComplexLaurentPolynomial(this.lowerDegree, this.degree);
        result.assignNeg(this);
        return result;
    }

    public void assignStar(ComplexLaurentPolynomial p) {
        if (p == this) {
            this.assignStar();
            return;
        }
        this.setNewDegrees(-p.degree, -p.lowerDegree);
        int i = 0;
        int j = this.re.length - 1;
        while (i < this.re.length) {
            this.re[i] = p.re[j];
            this.im[i] = -p.im[j];
            ++i;
            --j;
        }
    }

    public ComplexLaurentPolynomial star() {
        ComplexLaurentPolynomial result = new ComplexLaurentPolynomial(this);
        result.assignStar();
        return result;
    }

    public void assignStar() {
        int tmpDegree = this.degree;
        this.degree = -this.lowerDegree;
        this.lowerDegree = -tmpDegree;
        int i = 0;
        for (int j = this.re.length - 1; i < j; ++i, --j) {
            double tmpRe = this.re[i];
            this.re[i] = this.re[j];
            this.re[j] = tmpRe;
            double tmpIm = this.im[i];
            this.im[i] = -this.im[j];
            this.im[j] = -tmpIm;
        }
        if (this.re.length % 2 == 1) {
            this.im[this.re.length / 2] = -this.im[this.re.length / 2];
        }
    }

    public void assignDerivative(ComplexLaurentPolynomial p, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("order of derivative is negative");
        }
        double[] pRe = p.re;
        double[] pIm = p.im;
        if (pRe.length != this.re.length) {
            this.re = new double[this.degree - this.lowerDegree + 1];
            this.im = new double[this.degree - this.lowerDegree + 1];
        }
        de.jtem.numericalMethods.algebra.polynomial.ComplexLaurentPolynomial.derivative(pRe, pIm, p.lowerDegree, p.degree, n, this.re, this.im);
        this.degree = p.degree - n;
        this.lowerDegree = p.lowerDegree - n;
    }

    public void assignDerivative(int n) {
        this.assignDerivative(this, n);
    }

    public ComplexLaurentPolynomial derivative(int n) {
        ComplexLaurentPolynomial result = new ComplexLaurentPolynomial(this.lowerDegree - n, new double[this.degree - this.lowerDegree + 1], new double[this.degree - this.lowerDegree + 1]);
        result.assignDerivative(this, n);
        return result;
    }

    public void assignDerivative(ComplexLaurentPolynomial p) {
        this.assignDerivative(p, 1);
    }

    public void assignDerivative() {
        this.assignDerivative(this, 1);
    }

    public ComplexLaurentPolynomial derivative() {
        return this.derivative(1);
    }

    public void setRoots(Complex[] roots) {
        Complex aN = roots.length == this.degree ? new Complex(this.re[this.degree], this.im[this.degree]) : new Complex(1.0, 0.0);
        this.assignMonomial(0, aN);
        ComplexLaurentPolynomial q = new ComplexLaurentPolynomial(1, 1.0, 0.0);
        for (int i = 0; i < roots.length; ++i) {
            q.setCoefficient(0, roots[i].neg());
            this.assignTimes(q);
        }
    }

    public void assignRandom() {
        for (int i = this.lowerDegree; i <= this.degree; ++i) {
            this.setCoefficient(i, Math.random(), Math.random());
        }
    }

    private final boolean isZero(int index, double epsSqr) {
        return this.re[index -= this.lowerDegree] * this.re[index] + this.im[index] * this.im[index] < epsSqr;
    }

    private final boolean equals(int index, ComplexLaurentPolynomial p, double epsSqr) {
        double dy;
        int pIndex;
        double dx;
        return (dx = this.re[index -= this.lowerDegree] - p.re[pIndex = index - p.lowerDegree]) * dx + (dy = this.im[index] - p.im[pIndex]) * dy < epsSqr;
    }

    public boolean equals(ComplexLaurentPolynomial p) {
        return this.equals(p, 1.0E-14);
    }

    public boolean equals(ComplexLaurentPolynomial p, double eps) {
        int i;
        double epsSqr = eps * eps;
        if (p == this) {
            return true;
        }
        if (this.lowerDegree < p.lowerDegree) {
            for (i = this.lowerDegree; i < p.lowerDegree; ++i) {
                if (this.isZero(i, epsSqr)) continue;
                return false;
            }
        } else {
            for (i = p.lowerDegree; i < this.lowerDegree; ++i) {
                if (p.isZero(i, epsSqr)) continue;
                return false;
            }
        }
        if (this.degree > p.degree) {
            for (i = p.degree + 1; i <= this.degree; ++i) {
                if (this.isZero(i, epsSqr)) continue;
                return false;
            }
        } else {
            for (i = this.degree + 1; i <= p.degree; ++i) {
                if (p.isZero(i, epsSqr)) continue;
                return false;
            }
        }
        int min = Math.max(p.lowerDegree, this.lowerDegree);
        int max = Math.min(p.degree, this.degree);
        for (int i2 = min; i2 <= max; ++i2) {
            if (this.equals(i2, p, epsSqr)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        try {
            return this.equals((ComplexLaurentPolynomial)o);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toString() {
        return de.jtem.numericalMethods.algebra.polynomial.ComplexLaurentPolynomial.toString(this.re, this.im, this.lowerDegree, this.degree, 1.0E-14);
    }
}

