/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.polynomial;

import de.jtem.mfc.field.Complex;
import de.jtem.mfc.field.ComplexConstant;
import de.jtem.mfc.field.Field;
import java.io.Serializable;

public class ComplexPolynomial
implements Complex.FunctionOnComplex,
Serializable {
    private static final long serialVersionUID = 1L;
    static final double EPS = 1.0E-14;
    double[] re;
    double[] im;
    public int degree;
    private static double[] p = new double[2];

    public double[] re() {
        return this.re;
    }

    public double[] im() {
        return this.im;
    }

    public ComplexPolynomial() {
        this.re = new double[1];
        this.im = new double[1];
    }

    public ComplexPolynomial(ComplexPolynomial p) {
        this.re = (double[])p.re.clone();
        this.im = (double[])p.im.clone();
        this.degree = p.degree;
    }

    public ComplexPolynomial(Field.Complex a) {
        this(0, a);
    }

    public ComplexPolynomial(int deg, Field.Complex a) {
        this(deg, a.getRe(), a.getIm());
    }

    public ComplexPolynomial(int deg, double x, double y) {
        this.degree = deg;
        this.re = new double[this.degree + 1];
        this.im = new double[this.degree + 1];
        this.re[this.degree] = x;
        this.im[this.degree] = y;
    }

    public ComplexPolynomial(int deg) {
        this(deg, 1.0, 0.0);
    }

    public ComplexPolynomial(Complex[] a) {
        this.assign(a);
    }

    public ComplexPolynomial(double[] aRe, double[] aIm) {
        this.assign(aRe, aIm);
    }

    public int getDegree() {
        return this.degree;
    }

    public void setDegree(int newDeg) {
        if (newDeg != this.degree) {
            double[] newRe = new double[newDeg + 1];
            double[] newIm = new double[newDeg + 1];
            int minDeg = Math.min(this.degree, newDeg);
            System.arraycopy(this.re, 0, newRe, 0, minDeg + 1);
            System.arraycopy(this.im, 0, newIm, 0, minDeg + 1);
            this.degree = newDeg;
            this.re = newRe;
            this.im = newIm;
        }
    }

    public void truncate(int deg) {
        if (deg < this.degree) {
            this.setDegree(deg);
        }
    }

    public void truncate(double eps) {
        int i;
        double sqrEps = eps * eps;
        for (i = this.degree; i > 0 && !(this.re[i] * this.re[i] + this.im[i] * this.im[i] > sqrEps); --i) {
        }
        this.setDegree(i);
    }

    public void truncate() {
        this.truncate(1.0E-14);
    }

    public void assignZero() {
        this.assignMonomial(0, 0.0, 0.0);
    }

    public void assignMonomial(int deg, Field.Complex a) {
        this.assignMonomial(deg, a.getRe(), a.getIm());
    }

    public void assignMonomial(int deg, double x, double y) {
        if (this.degree != deg) {
            this.degree = deg;
            this.re = new double[this.degree + 1];
            this.im = new double[this.degree + 1];
        } else {
            for (int i = 0; i < this.degree; ++i) {
                this.im[i] = 0.0;
                this.re[i] = 0.0;
            }
        }
        this.re[this.degree] = x;
        this.im[this.degree] = y;
    }

    public void assignMonomial(int deg) {
        this.assignMonomial(deg, 1.0, 0.0);
    }

    public void assign(Complex[] a) {
        if (this.degree != a.length - 1 || this.re == null) {
            this.degree = a.length - 1;
            this.re = new double[this.degree + 1];
            this.im = new double[this.degree + 1];
        }
        for (int i = 0; i <= this.degree; ++i) {
            this.re[i] = a[i].re;
            this.im[i] = a[i].im;
        }
    }

    public void assign(ComplexConstant[] a) {
        if (this.degree != a.length - 1 || this.re == null) {
            this.degree = a.length - 1;
            this.re = new double[this.degree + 1];
            this.im = new double[this.degree + 1];
        }
        for (int i = 0; i <= this.degree; ++i) {
            this.re[i] = a[i].getRe();
            this.im[i] = a[i].getIm();
        }
    }

    public void assign(Field.Complex[] a) {
        if (this.degree != a.length - 1 || this.re == null) {
            this.degree = a.length - 1;
            this.re = new double[this.degree + 1];
            this.im = new double[this.degree + 1];
        }
        for (int i = 0; i <= this.degree; ++i) {
            this.re[i] = a[i].getRe();
            this.im[i] = a[i].getIm();
        }
    }

    public void assign(ComplexPolynomial p) {
        this.assign(p.re, p.im);
    }

    public void assign(double[] aRe, double[] aIm) {
        if (this.degree != aRe.length - 1 || this.re == null) {
            this.degree = aRe.length - 1;
            this.re = (double[])aRe.clone();
            this.im = (double[])aIm.clone();
        } else {
            System.arraycopy(aRe, 0, this.re, 0, this.degree + 1);
            System.arraycopy(aIm, 0, this.im, 0, this.degree + 1);
        }
    }

    public void getCoefficients(Complex[] a) {
        int minLength = Math.min(this.degree + 1, a.length);
        for (int i = 0; i < minLength; ++i) {
            if (a[i] == null) {
                a[i] = new Complex(this.re[i], this.im[i]);
                continue;
            }
            a[i].assign(this.re[i], this.im[i]);
        }
    }

    public Complex[] getCoefficients() {
        Complex[] c = new Complex[this.degree + 1];
        this.getCoefficients(c);
        return c;
    }

    public Complex getCoefficient(int i) {
        Complex z = new Complex();
        this.getCoefficient(i, z);
        return z;
    }

    public void getCoefficient(int i, Complex z) {
        if (i >= 0 && i <= this.degree) {
            z.assign(this.re[i], this.im[i]);
        } else {
            z.assign(0.0, 0.0);
        }
    }

    public void setCoefficient(int i, Field.Complex z) {
        this.re[i] = z.getRe();
        this.im[i] = z.getIm();
    }

    public void setCoefficient(int i, double x, double y) {
        this.re[i] = x;
        this.im[i] = y;
    }

    public void assignCoefficients(ComplexPolynomial p) {
        int minDegree = Math.min(this.degree, p.degree);
        System.arraycopy(p.re, 0, this.re, 0, minDegree + 1);
        System.arraycopy(p.im, 0, this.im, 0, minDegree + 1);
        for (int i = minDegree + 1; i <= this.degree; ++i) {
            this.re[i] = 0.0;
            this.im[i] = 0.0;
        }
    }

    public Complex eval(Complex z) {
        Complex w = new Complex();
        this.eval(z, w);
        return w;
    }

    @Override
    public void eval(Complex z, Complex w) {
        de.jtem.numericalMethods.algebra.polynomial.ComplexPolynomial.eval(this.re, this.im, this.degree, z.re, z.im, p);
        w.assign(p[0], p[1]);
    }

    public Complex evalDerivative(Complex z, int n) {
        Complex w = new Complex();
        this.evalDerivative(z, n, w);
        return w;
    }

    public void evalDerivative(Complex z, int n, Complex w) {
        double[] p = new double[2];
        de.jtem.numericalMethods.algebra.polynomial.ComplexPolynomial.evalDerivative(this.re, this.im, this.degree, n, z.re, z.im, p);
        w.assign(p[0], p[1]);
    }

    public ComplexPolynomial plus(ComplexPolynomial q) {
        ComplexPolynomial result = new ComplexPolynomial(Math.max(this.degree, q.degree));
        result.assignPlus(this, q);
        return result;
    }

    public void assignPlus(ComplexPolynomial q) {
        this.assignPlus(this, q);
    }

    public void assignPlus(ComplexPolynomial p, ComplexPolynomial q) {
        int i;
        int newDegree = Math.max(p.degree, q.degree);
        double[] newRe = new double[newDegree + 1];
        double[] newIm = new double[newDegree + 1];
        for (i = 0; i <= p.degree; ++i) {
            newRe[i] = p.re[i];
            newIm[i] = p.im[i];
        }
        for (i = 0; i <= q.degree; ++i) {
            int n = i;
            newRe[n] = newRe[n] + q.re[i];
            int n2 = i;
            newIm[n2] = newIm[n2] + q.im[i];
        }
        this.re = newRe;
        this.im = newIm;
        this.degree = newDegree;
    }

    public ComplexPolynomial neg() {
        double[] newRe = new double[this.degree + 1];
        double[] newIm = new double[this.degree + 1];
        for (int i = 0; i <= this.degree; ++i) {
            newRe[i] = -this.re[i];
            newIm[i] = -this.im[i];
        }
        return new ComplexPolynomial(newRe, newIm);
    }

    public ComplexPolynomial minus(ComplexPolynomial q) {
        ComplexPolynomial result = new ComplexPolynomial(Math.max(this.degree, q.degree));
        result.assignMinus(this, q);
        return result;
    }

    public void assignMinus(ComplexPolynomial q) {
        this.assignMinus(this, q);
    }

    public void assignMinus(ComplexPolynomial p, ComplexPolynomial q) {
        int i;
        int newDegree = Math.max(p.degree, q.degree);
        double[] newRe = new double[newDegree + 1];
        double[] newIm = new double[newDegree + 1];
        for (i = 0; i <= p.degree; ++i) {
            newRe[i] = p.re[i];
            newIm[i] = p.im[i];
        }
        for (i = 0; i <= q.degree; ++i) {
            int n = i;
            newRe[n] = newRe[n] - q.re[i];
            int n2 = i;
            newIm[n2] = newIm[n2] - q.im[i];
        }
        this.re = newRe;
        this.im = newIm;
        this.degree = newDegree;
    }

    public ComplexPolynomial times(ComplexPolynomial q) {
        ComplexPolynomial result = new ComplexPolynomial(this.degree + q.degree);
        result.assignTimes(this, q);
        return result;
    }

    public void assignTimes(ComplexPolynomial q) {
        this.assignTimes(this, q);
    }

    public void assignTimes(ComplexPolynomial p, ComplexPolynomial q) {
        int newDegree = p.degree + q.degree;
        double[] newRe = new double[newDegree + 1];
        double[] newIm = new double[newDegree + 1];
        de.jtem.numericalMethods.algebra.polynomial.ComplexPolynomial.times(p.re, p.im, p.degree, q.re, q.im, q.degree, newRe, newIm);
        this.re = newRe;
        this.im = newIm;
        this.degree = newDegree;
    }

    public void assignTimes(ComplexPolynomial p, Complex z) {
        this.setDegree(p.degree);
        for (int i = 0; i <= this.degree; ++i) {
            double pRe = p.re[i];
            double pIm = p.im[i];
            this.re[i] = pRe * z.re - pIm * z.im;
            this.im[i] = pRe * z.im + pIm * z.re;
        }
    }

    public void assignTimes(Complex z, ComplexPolynomial p) {
        this.assignTimes(p, z);
    }

    public void assignTimes(Complex z) {
        this.assignTimes(this, z);
    }

    public ComplexPolynomial times(Complex z) {
        ComplexPolynomial result = new ComplexPolynomial(this.degree);
        result.assignTimes(this, z);
        return result;
    }

    public void assignTimes(ComplexPolynomial p, double x) {
        this.setDegree(p.degree);
        for (int i = 0; i <= this.degree; ++i) {
            this.re[i] = p.re[i] * x;
            this.im[i] = p.im[i] * x;
        }
    }

    public ComplexPolynomial times(double x) {
        ComplexPolynomial result = new ComplexPolynomial(this.degree);
        result.assignTimes(this, x);
        return result;
    }

    public void assignTimes(double x, ComplexPolynomial p) {
        this.assignTimes(p, x);
    }

    public void assignTimes(double x) {
        this.assignTimes(this, x);
    }

    public void assignDivide(ComplexPolynomial p, ComplexPolynomial q) {
        double[] auxRe = new double[this.degree + 1];
        double[] auxIm = new double[this.degree + 1];
        double[] newRe = new double[p.degree - q.degree + 1];
        double[] newIm = new double[p.degree - q.degree + 1];
        de.jtem.numericalMethods.algebra.polynomial.ComplexPolynomial.divide(p.re, p.im, p.degree, q.re, q.im, q.degree, auxRe, auxIm, newRe, newIm);
        this.re = newRe;
        this.im = newIm;
        this.degree = p.degree - q.degree;
    }

    public void assignDerivative(ComplexPolynomial p, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("order of derivative is negative");
        }
        if (this.degree < n) {
            this.assignZero();
        }
        double[] pRe = p.re;
        double[] pIm = p.im;
        int degreeOfP = p.degree;
        if (this.degree != degreeOfP - n) {
            this.degree = degreeOfP - n;
            this.re = new double[this.degree + 1];
            this.im = new double[this.degree + 1];
        }
        de.jtem.numericalMethods.algebra.polynomial.ComplexPolynomial.derivative(pRe, pIm, degreeOfP, n, this.re, this.im);
    }

    public void assignDerivative(int n) {
        this.assignDerivative(this, n);
    }

    public ComplexPolynomial derivative(int n) {
        ComplexPolynomial result = new ComplexPolynomial(Math.max(this.degree - n, 0));
        result.assignDerivative(this, n);
        return result;
    }

    public void assignDerivative(ComplexPolynomial p) {
        this.assignDerivative(p, 1);
    }

    public void assignDerivative() {
        this.assignDerivative(this, 1);
    }

    public ComplexPolynomial derivative() {
        return this.derivative(1);
    }

    public Complex[] getRoots() {
        Complex[] roots = new Complex[this.degree];
        this.getRoots(roots);
        return roots;
    }

    public void getRoots(Complex[] roots) {
        double[] rootsRe = new double[this.degree];
        double[] rootsIm = new double[this.degree];
        if (roots == null || roots.length != this.degree) {
            throw new IllegalArgumentException("array has wrong size");
        }
        de.jtem.numericalMethods.algebra.polynomial.ComplexPolynomial.laguerAllRoots(this.re, this.im, this.degree, 1.0E-14, rootsRe, rootsIm);
        for (int i = 0; i < this.degree; ++i) {
            if (roots[i] == null) {
                roots[i] = new Complex(rootsRe[i], rootsIm[i]);
                continue;
            }
            roots[i].assign(rootsRe[i], rootsIm[i]);
        }
    }

    public void setRoots(Complex[] roots) {
        Complex aN = roots.length == this.degree ? new Complex(this.re[this.degree], this.im[this.degree]) : new Complex(1.0, 0.0);
        this.assignMonomial(0, aN);
        ComplexPolynomial q = new ComplexPolynomial(1);
        for (int i = 0; i < roots.length; ++i) {
            q.setCoefficient(0, roots[i].neg());
            this.assignTimes(q);
        }
    }

    public void assignRandom() {
        for (int i = 0; i <= this.degree; ++i) {
            this.re[i] = Math.random();
            this.im[i] = Math.random();
        }
    }

    private final boolean isZero(int index, double epsSqr) {
        return this.re[index] * this.re[index] + this.im[index] * this.im[index] < epsSqr;
    }

    private final boolean equals(int index, ComplexPolynomial p, double epsSqr) {
        double dx = this.re[index] - p.re[index];
        double dy = this.im[index] - p.im[index];
        return dx * dx + dy * dy < epsSqr;
    }

    public boolean equals(ComplexPolynomial p) {
        return this.equals(p, 1.0E-14);
    }

    public boolean equals(ComplexPolynomial p, double eps) {
        int i;
        double epsSqr = eps * eps;
        if (p == this) {
            return true;
        }
        if (this.degree > p.degree) {
            for (i = p.degree + 1; i <= this.degree; ++i) {
                if (this.isZero(i, epsSqr)) continue;
                return false;
            }
        } else {
            for (i = this.degree + 1; i <= p.degree; ++i) {
                if (p.isZero(i, epsSqr)) continue;
                return false;
            }
        }
        int max = Math.min(p.degree, this.degree);
        for (int i2 = 0; i2 <= max; ++i2) {
            if (this.equals(i2, p, epsSqr)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        try {
            return this.equals((ComplexPolynomial)o);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toString() {
        return de.jtem.numericalMethods.algebra.polynomial.ComplexPolynomial.toString(this.re, this.im, this.degree, 1.0E-14);
    }
}

