/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.set;

import de.jtem.mfc.set.Interval;
import java.io.Serializable;

public class DiscretizedInterval
implements Serializable,
Cloneable {
    public static final long serialVersionUID = 1L;
    final double[] min;
    final double[] max;
    final int[] discr;
    final int dim;
    final int numOfVertices;

    static double[] constant(double value, int dim) {
        double[] constant = new double[dim];
        for (int i = 0; i < dim; ++i) {
            constant[i] = value;
        }
        return constant;
    }

    static int[] constant(int value, int dim) {
        int[] constant = new int[dim];
        for (int i = 0; i < dim; ++i) {
            constant[i] = value;
        }
        return constant;
    }

    public DiscretizedInterval(Interval interval, int[] discr) {
        this(interval.min, interval.max, discr);
    }

    public DiscretizedInterval(Interval interval, int discr) {
        this(interval.min, interval.max, DiscretizedInterval.constant(discr, interval.getDim()));
    }

    public DiscretizedInterval(int[] discr) {
        this(DiscretizedInterval.constant(1.0, discr.length), discr);
    }

    public DiscretizedInterval() {
        this(1, 1);
    }

    public DiscretizedInterval(int dim, int discr) {
        this(DiscretizedInterval.constant(1.0, dim), DiscretizedInterval.constant(discr, dim));
    }

    public DiscretizedInterval(double[] max, int[] discr) {
        this(new double[max.length], max, discr);
    }

    public DiscretizedInterval(double[] min, double[] max, int[] discr) {
        if (min.length != max.length || min.length != discr.length) {
            throw new IllegalArgumentException("length of arrays do not coincide");
        }
        this.min = (double[])min.clone();
        this.max = (double[])max.clone();
        this.discr = (int[])discr.clone();
        this.dim = min.length;
        int vol = discr[0] + 1;
        for (int i = 1; i < this.dim; ++i) {
            vol *= discr[i] + 1;
        }
        this.numOfVertices = vol;
    }

    public Interval getInterval() {
        return new Interval(this.min, this.max);
    }

    public void setInterval(Interval interval) {
        if (interval.getDim() != this.dim) {
            throw new IllegalArgumentException("interval has wrong dimension");
        }
        System.arraycopy(interval.min, 0, this.min, 0, this.dim);
        System.arraycopy(interval.max, 0, this.max, 0, this.dim);
    }

    public void getValue(int[] index, double[] value) {
        for (int i = 0; i < this.dim; ++i) {
            int I = index[i];
            int D = this.discr[i];
            if (I > D || I < -1) {
                throw new IndexOutOfBoundsException("multi index out of bounds");
            }
            double t = (double)I / (double)D;
            value[i] = (1.0 - t) * this.min[i] + t * this.max[i];
        }
    }

    public double[] getValue(int[] index) {
        double[] value = new double[this.dim];
        this.getValue(index, value);
        return value;
    }

    public int getNumOfVertices() {
        return this.numOfVertices;
    }

    public int getDim() {
        return this.dim;
    }
}

