/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.set;

import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;

public class Interval
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final double EPS = 1.0E-12;
    double[] min;
    double[] max;

    private final void checkMinMax() {
        if (this.min.length != this.max.length) {
            throw new IllegalArgumentException("length of min and max do not coincide");
        }
        for (int i = 0; i < this.max.length; ++i) {
            if (!(this.min[i] > this.max[i])) continue;
            throw new IllegalArgumentException("min is bigger max");
        }
    }

    public Interval() {
        this(1);
    }

    public Interval(double a, double b) {
        this(1);
        this.min[0] = a;
        this.max[0] = b;
        this.checkMinMax();
    }

    public Interval(int dim) {
        this.min = new double[dim];
        this.max = new double[dim];
        int i = 0;
        while (i < this.max.length) {
            this.max[i++] = 1.0;
        }
    }

    public Interval(Interval interval) {
        this.min = (double[])interval.min.clone();
        this.max = (double[])interval.max.clone();
    }

    public Interval(String s) {
        this.assign(s);
    }

    public Interval(double[] min, double[] max) {
        this.min = (double[])min.clone();
        this.max = (double[])max.clone();
        this.checkMinMax();
    }

    public int getDim() {
        return this.min.length;
    }

    public double getMin(int index) {
        return this.min[index];
    }

    public void setMin(int index, double min) {
        this.min[index] = min;
    }

    public double getMax(int index) {
        return this.max[index];
    }

    public void setMax(int index, double max) {
        this.max[index] = max;
    }

    public double getSize(int index) {
        return this.max[index] - this.min[index];
    }

    public double getVolume() {
        double volume = this.max[0] - this.min[0];
        for (int i = 1; i < this.min.length; ++i) {
            volume *= this.max[i] - this.min[i];
        }
        return volume;
    }

    public double getDiameter() {
        double lengthSqr = (this.max[0] - this.min[0]) * (this.max[0] - this.min[0]);
        for (int i = 1; i < this.min.length; ++i) {
            lengthSqr += (this.max[i] - this.min[i]) * (this.max[i] - this.min[i]);
        }
        return Math.sqrt(lengthSqr);
    }

    public void assignTensor(Interval interval1, Interval interval2) {
        if (this.min.length != interval1.min.length + interval2.min.length) {
            this.min = new double[interval1.min.length + interval2.min.length];
            this.max = new double[interval1.min.length + interval2.min.length];
        }
        System.arraycopy(interval1.min, 0, this.min, 0, interval1.min.length);
        System.arraycopy(interval2.min, 0, this.min, interval1.min.length, interval2.min.length);
        System.arraycopy(interval1.max, 0, this.max, 0, interval1.max.length);
        System.arraycopy(interval2.max, 0, this.max, interval1.max.length, interval2.max.length);
    }

    public Interval tensor(Interval interval) {
        Interval tensor = new Interval(this.min.length + interval.min.length);
        tensor.assignTensor(this, interval);
        return tensor;
    }

    public void assignBound(Interval interval1, Interval interval2) {
        if (interval1.min.length != interval2.min.length) {
            throw new IllegalArgumentException("dimensions of intervals do not coincide");
        }
        if (this.min.length != interval1.min.length) {
            this.min = new double[interval1.min.length];
            this.max = new double[interval1.min.length];
        }
        for (int i = 0; i < this.min.length; ++i) {
            this.min[i] = Math.min(interval1.min[i], interval2.min[i]);
            this.max[i] = Math.max(interval1.max[i], interval2.max[i]);
        }
    }

    public void assignBound(Interval interval) {
        this.assignBound(this, interval);
    }

    public Interval bound(Interval interval) {
        Interval bound = new Interval(this.min.length + interval.min.length);
        bound.assignBound(this, interval);
        return bound;
    }

    public void assignJoin(Interval interval1, Interval interval2) {
        if (!interval1.joinable(interval2)) {
            throw new ArithmeticException("intervals are not joinable in a single interval");
        }
        this.assignBound(interval1, interval2);
    }

    public void assignJoin(Interval interval) {
        this.assignJoin(this, interval);
    }

    public Interval join(Interval interval) {
        Interval join = new Interval(this.min.length + interval.min.length);
        join.assignJoin(this, interval);
        return join;
    }

    public boolean joinable(Interval interval) {
        return this.joinable(interval, 1.0E-12);
    }

    public boolean joinable(Interval interval, double eps) {
        if (this.min.length != interval.min.length) {
            return false;
        }
        boolean wasAlreadyDifferent = false;
        for (int i = 0; i < this.min.length; ++i) {
            if (!(Math.abs(this.min[i] - interval.min[i]) > eps) && !(Math.abs(this.max[i] - interval.max[i]) > eps)) continue;
            if (wasAlreadyDifferent) {
                return false;
            }
            if (!(this.min[i] - 1.0E-12 < interval.min[i] && interval.min[i] < this.max[i] + 1.0E-12 || this.min[i] - 1.0E-12 < interval.max[i] && interval.max[i] < this.max[i] + 1.0E-12)) {
                return false;
            }
            wasAlreadyDifferent = true;
        }
        return true;
    }

    public boolean intersect(Interval interval) {
        return this.intersect(interval, 1.0E-12);
    }

    public boolean intersect(Interval interval, double eps) {
        if (this.min.length != interval.min.length) {
            return false;
        }
        for (int i = 0; i < this.min.length; ++i) {
            if (!(this.min[i] - 1.0E-12 > interval.max[i]) && !(this.max[i] + 1.0E-12 < interval.min[i])) continue;
            return false;
        }
        return true;
    }

    public void assign(String s) {
        double[] array = Interval.stringToArray(s, null);
        if (array.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        if (this.min == null || this.min.length != array.length / 2) {
            this.min = new double[array.length / 2];
            this.max = new double[array.length / 2];
        }
        int k = 0;
        for (int i = 0; i < this.min.length; ++i) {
            this.min[i] = array[k++];
            this.max[i] = array[k++];
        }
    }

    public void assign(Interval interval) {
        this.assign(interval.min, interval.max);
    }

    public void assign(double[] min, double[] max) {
        if (min.length != max.length) {
            throw new IllegalArgumentException("length of min and max do not coincide");
        }
        if (min.length != this.min.length) {
            this.min = (double[])min.clone();
            this.max = (double[])max.clone();
        } else {
            System.arraycopy(min, 0, this.min, 0, min.length);
            System.arraycopy(max, 0, this.max, 0, max.length);
        }
    }

    public void assignByCenter(double[] center, double[] delta) {
        if (center.length != delta.length) {
            throw new IllegalArgumentException("length of arrays do not coincide");
        }
        this.assign(center, center);
        for (int i = 0; i < center.length; ++i) {
            int n = i;
            this.min[n] = this.min[n] - Math.abs(delta[i]);
            int n2 = i;
            this.max[n2] = this.max[n2] + Math.abs(delta[i]);
        }
    }

    public void assignByCenter(double[] center, double relDelta) {
        this.assign(center, center);
        for (int i = 0; i < center.length; ++i) {
            int n = i;
            this.min[n] = this.min[n] - Math.abs(center[i] * relDelta);
            int n2 = i;
            this.max[n2] = this.max[n2] + Math.abs(center[i] * relDelta);
        }
    }

    public void getCenter(double[] center, int offset) {
        for (int i = 0; i < this.min.length; ++i) {
            center[offset++] = (this.min[i] + this.max[i]) / 2.0;
        }
    }

    public double[] getCenter() {
        double[] center = new double[this.min.length];
        this.getCenter(center, 0);
        return center;
    }

    public boolean equals(Interval interval, double eps) {
        if (this == interval) {
            return true;
        }
        if (this.min.length != interval.min.length) {
            return false;
        }
        for (int i = 0; i < this.min.length; ++i) {
            if (Math.abs(this.min[i] - interval.min[i]) > eps) {
                return false;
            }
            if (!(Math.abs(this.max[i] - interval.max[i]) > eps)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Interval interval) {
        return this.equals(interval, 1.0E-12);
    }

    public boolean equals(Object object) {
        try {
            return this.equals((Interval)object, 1.0E-12);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("[");
        sb.append(this.min[0]);
        sb.append(",");
        sb.append(this.max[0]);
        for (int i = 1; i < this.min.length; ++i) {
            sb.append("]x[");
            sb.append(this.min[i]);
            sb.append(",");
            sb.append(this.max[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    static double[] stringToArray(String s, double[] basket) {
        if (basket == null || basket.length < s.length() / 2 + 1) {
            basket = new double[s.length() / 2 + 1];
        }
        try {
            StreamTokenizer st = new StreamTokenizer(new StringReader(s));
            st.resetSyntax();
            st.whitespaceChars(0, 44);
            st.whitespaceChars(91, 93);
            st.whitespaceChars(120, 120);
            st.parseNumbers();
            int num = 0;
            while (st.nextToken() != -1) {
                basket[num++] = st.nval;
            }
            double[] array = new double[num];
            System.arraycopy(basket, 0, array, 0, num);
            return array;
        }
        catch (IOException ex) {
            throw new Error();
        }
    }
}

