/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.set;

import java.io.Serializable;

public abstract class MultiIndexedDataSet
implements Serializable,
Cloneable {
    public static final long serialVersionUID = 1L;
    final int[] min;
    final int[] max;
    final int[] size;
    final int dim;
    final int numOfVertices;

    public MultiIndexedDataSet(int[] max) {
        this(new int[max.length], max);
    }

    public MultiIndexedDataSet(int[] min, int[] max) {
        if (min.length != max.length) {
            throw new IllegalArgumentException("length of min and max do not coincide");
        }
        this.min = (int[])min.clone();
        this.max = (int[])max.clone();
        this.dim = min.length;
        this.size = new int[this.dim];
        this.size[0] = 1;
        for (int i = 1; i < this.dim; ++i) {
            this.size[i] = (max[i - 1] - min[i - 1] + 1) * this.size[i - 1];
        }
        int vol = max[0] - min[0] + 1;
        for (int i = 1; i < this.dim; ++i) {
            vol *= max[i] - min[i] + 1;
        }
        this.numOfVertices = vol;
    }

    public int getNumOfVertices() {
        return this.numOfVertices;
    }

    public int getDim() {
        return this.dim;
    }

    public boolean isOutOfBounds(int[] index) {
        if (index.length != this.dim) {
            return true;
        }
        for (int i = 0; i < this.dim; ++i) {
            if (index[i] >= this.min[i] && index[i] <= this.max[i]) continue;
            return true;
        }
        return false;
    }

    public int getLinearIndexOf(int[] index) {
        return this.getLinearIndexOf(index, true);
    }

    public int getLinearIndexOf(int[] index, boolean checkBounds) {
        if (checkBounds && this.isOutOfBounds(index)) {
            throw new IndexOutOfBoundsException("multi index is out of bounts");
        }
        int linearIndex = index[this.dim - 1];
        for (int i = this.dim - 2; i >= 0; --i) {
            linearIndex += this.size[i] * index[i];
        }
        return linearIndex;
    }
}

