/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.set;

import de.jtem.mfc.set.MultiIndexedSet;

public class MultiIndexedDoubleSet
extends MultiIndexedSet {
    public static final long serialVersionUID = 1L;
    final double[] set;

    public MultiIndexedDoubleSet(int[] max) {
        this(new int[max.length], max);
    }

    public MultiIndexedDoubleSet(MultiIndexedSet multiIndexedSet) {
        this(multiIndexedSet.min, multiIndexedSet.max);
    }

    public MultiIndexedDoubleSet(MultiIndexedDoubleSet multiIndexedDoubleSet) {
        super(multiIndexedDoubleSet.min, multiIndexedDoubleSet.max);
        this.set = (double[])multiIndexedDoubleSet.set.clone();
    }

    public MultiIndexedDoubleSet(int[] min, int[] max) {
        super(min, max);
        this.set = new double[this.numOfVertices];
    }

    public double getValue(int[] index) {
        return this.getValue(index, true);
    }

    public double getValue(int[] index, boolean checkBounds) {
        return this.set[this.getLinearIndexOf(index, checkBounds)];
    }

    public double getValue(int linearIndex) {
        return this.set[linearIndex];
    }

    public void setValue(int[] index, double value) {
        this.setValue(index, value, true);
    }

    public void setValue(int[] index, double value, boolean checkBounds) {
        this.set[this.getLinearIndexOf((int[])index, (boolean)checkBounds)] = value;
    }

    public void setValue(int linearIndex, double value) {
        this.set[linearIndex] = value;
    }

    public Object toArray() {
        return this.toArray((Object)null);
    }

    public Object toArray(Object array) {
        switch (this.dim) {
            case 1: {
                return this.toArray((double[])array);
            }
            case 2: {
                return this.toArray((double[][])array);
            }
            case 3: {
                return this.toArray((double[][][])array);
            }
            case 4: {
                return this.toArray((double[][][][])array);
            }
        }
        throw new UnsupportedOperationException("dimension bigger then 4 are not supported");
    }

    public double[] toArray(double[] array) {
        if (this.dim != 1) {
            throw new IllegalArgumentException("array has wrong dimension");
        }
        if (array == null || array.length != this.max[0] - this.min[0] + 1) {
            array = new double[this.max[0] - this.min[0] + 1];
        }
        System.arraycopy(this.set, 0, array, 0, array.length);
        return array;
    }

    public double[][] toArray(double[][] array) {
        if (this.dim != 2) {
            throw new IllegalArgumentException("array has wrong dimension");
        }
        int xSize = this.max[0] - this.min[0] + 1;
        int ySize = this.max[1] - this.min[1] + 1;
        if (array == null || array.length != xSize || array[0].length != ySize) {
            array = new double[xSize][ySize];
        }
        int i = 0;
        int j = 0;
        while (i < xSize) {
            System.arraycopy(this.set, j, array[i], 0, ySize);
            ++i;
            j += ySize;
        }
        return array;
    }

    public double[][][] toArray(double[][][] array) {
        if (this.dim != 3) {
            throw new IllegalArgumentException("array has wrong dimension");
        }
        int xSize = this.max[0] - this.min[0] + 1;
        int ySize = this.max[1] - this.min[1] + 1;
        int vSize = this.max[2] - this.min[2] + 1;
        if (array == null || array.length != xSize || array[0].length != ySize || array[0][0].length != vSize) {
            array = new double[xSize][ySize][vSize];
        }
        int k = 0;
        for (int i = 0; i < xSize; ++i) {
            int j = 0;
            while (j < ySize) {
                System.arraycopy(this.set, k, array[i][j], 0, vSize);
                ++j;
                k += vSize;
            }
        }
        return array;
    }

    public double[][][][] toArray(double[][][][] array) {
        if (this.dim != 4) {
            throw new IllegalArgumentException("array has wrong dimension");
        }
        int xSize = this.max[0] - this.min[0] + 1;
        int ySize = this.max[1] - this.min[1] + 1;
        int vSize = this.max[2] - this.min[2] + 1;
        int wSize = this.max[3] - this.min[3] + 1;
        if (array == null || array.length != xSize || array[0].length != ySize || array[0][0].length != vSize || array[0][0][0].length != wSize) {
            array = new double[xSize][ySize][vSize][wSize];
        }
        int l = 0;
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                int k = 0;
                while (k < vSize) {
                    System.arraycopy(this.set, l, array[i][j][k], 0, wSize);
                    ++k;
                    l += wSize;
                }
            }
        }
        return array;
    }
}

