/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.mfc.vector;

import de.jtem.mfc.field.Complex;
import de.jtem.mfc.matrix.AbstractComplex2By2;
import java.io.Serializable;

public class Complex2
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected static final double EPS = 1.0E-14;
    public double aRe;
    public double aIm;
    public double bRe;
    public double bIm;

    public Complex2() {
    }

    public Complex2(double aRe, double aIm, double bRe, double bIm) {
        this.assign(aRe, aIm, bRe, bIm);
    }

    protected Complex2(Complex a, Complex b) {
        this.assign(a.re, a.im, b.re, b.im);
    }

    public Complex2(Complex2 v) {
        this.assign(v);
    }

    public void assignZero() {
        this.assign(0.0, 0.0, 0.0, 0.0);
    }

    public void assign(double aRe, double aIm, double bRe, double bIm) {
        this.aRe = aRe;
        this.aIm = aIm;
        this.bRe = bRe;
        this.bIm = bIm;
    }

    public final Complex getA() {
        return new Complex(this.aRe, this.aIm);
    }

    public final void getA(Complex a) {
        a.assign(this.aRe, this.aIm);
    }

    public final void setA(Complex a) {
        this.aRe = a.re;
        this.aIm = a.im;
    }

    public final Complex getB() {
        return new Complex(this.bRe, this.bIm);
    }

    public final void getB(Complex b) {
        b.assign(this.bRe, this.bIm);
    }

    public final void setB(Complex b) {
        this.bRe = b.re;
        this.bIm = b.im;
    }

    public final Complex2 copy() {
        return new Complex2(this);
    }

    public final void assign(Complex a, Complex b) {
        this.assign(a.re, a.im, b.re, b.im);
    }

    public final void assign(Complex2 s) {
        this.assign(s.aRe, s.aIm, s.bRe, s.bIm);
    }

    public final void assignTimes(AbstractComplex2By2 m, Complex2 v) {
        AbstractComplex2By2.times(m, v, this);
    }

    public final void assignTimes(Complex z, Complex2 v) {
        double dummyARe = z.re * v.aRe - z.im * v.aIm;
        double dummyAIm = z.re * v.aIm + z.im * v.aRe;
        double dummyBRe = z.re * v.bRe - z.im * v.bIm;
        double dummyBIm = z.re * v.bIm + z.im * v.bRe;
        this.aRe = dummyARe;
        this.aIm = dummyAIm;
        this.bRe = dummyBRe;
        this.bIm = dummyBIm;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer().append('(').append('(').append('(').append(this.aRe);
        if (this.aIm >= 0.0) {
            sb.append('+');
        }
        sb.append(this.aIm).append('i').append(')').append(',').append('(').append(this.bRe);
        if (this.bIm >= 0.0) {
            sb.append('+');
        }
        sb.append(this.bIm).append('i').append(')').append(')').append(')');
        return sb.toString();
    }
}

