/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear;

import de.jtem.numericalMethods.algebra.linear.VectorOperations;

public final class MatrixOperations {
    private MatrixOperations() {
    }

    public static final void times(double[][] ARe, double[][] AIm, double[][] BRe, double[][] BIm, double[][] CRe, double[][] CIm) {
        double[][] tmpARe = ARe == CRe || ARe == CIm ? MatrixOperations.copy(ARe) : ARe;
        double[][] tmpAIm = AIm == CRe || AIm == CIm ? MatrixOperations.copy(AIm) : AIm;
        double[][] tmpBRe = BRe == CRe || BRe == CIm ? MatrixOperations.copy(BRe) : BRe;
        double[][] tmpBIm = BIm == CRe || BIm == CIm ? MatrixOperations.copy(BIm) : BIm;
        int n = tmpBRe.length;
        int numRows = CRe.length;
        int numCols = CRe[0].length;
        for (int i = 0; i < numRows; ++i) {
            double[] rowARe = tmpARe[i];
            double[] rowAIm = tmpAIm[i];
            double[] rowRe = CRe[i];
            double[] rowIm = CIm[i];
            for (int j = 0; j < numCols; ++j) {
                double wRe = 0.0;
                double wIm = 0.0;
                for (int k = 0; k < n; ++k) {
                    wRe += rowARe[k] * tmpBRe[k][j] - rowAIm[k] * tmpBIm[k][j];
                    wIm += rowARe[k] * tmpBIm[k][j] + rowAIm[k] * tmpBRe[k][j];
                }
                rowRe[j] = wRe;
                rowIm[j] = wIm;
            }
        }
    }

    public static final void times(int[][] A, int[][] B, int[][] C) {
        int[][] tmpB;
        int[][] tmpA;
        if (A == C) {
            tmpA = MatrixOperations.copy(C);
            tmpB = B != C ? B : tmpA;
        } else {
            tmpA = A;
            tmpB = B != C ? B : MatrixOperations.copy(C);
        }
        int n = tmpB.length;
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            int[] rowA = tmpA[i];
            int[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                int sum = 0;
                for (int k = 0; k < n; ++k) {
                    sum += rowA[k] * tmpB[k][j];
                }
                rowC[j] = sum;
            }
        }
    }

    public static final void times(double[][] A, double[][] B, double[][] C) {
        double[][] tmpB;
        double[][] tmpA;
        if (A == C) {
            tmpA = MatrixOperations.copy(C);
            tmpB = B != C ? B : tmpA;
        } else {
            tmpA = A;
            tmpB = B != C ? B : MatrixOperations.copy(C);
        }
        int n = tmpB.length;
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            double[] rowA = tmpA[i];
            double[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                double sum = 0.0;
                for (int k = 0; k < n; ++k) {
                    sum += rowA[k] * tmpB[k][j];
                }
                rowC[j] = sum;
            }
        }
    }

    public static final void times(int[][] A, double[][] B, double[][] C) {
        double[][] tmpB = B != C ? B : MatrixOperations.copy(C);
        int n = tmpB.length;
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            int[] rowA = A[i];
            double[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                double sum = 0.0;
                for (int k = 0; k < n; ++k) {
                    sum += (double)rowA[k] * tmpB[k][j];
                }
                rowC[j] = sum;
            }
        }
    }

    public static final void times(double[][] A, int[][] B, double[][] C) {
        double[][] tmpA = A != C ? A : MatrixOperations.copy(C);
        int n = B.length;
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            double[] rowA = tmpA[i];
            double[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                double sum = 0.0;
                for (int k = 0; k < n; ++k) {
                    sum += rowA[k] * (double)B[k][j];
                }
                rowC[j] = sum;
            }
        }
    }

    public static final void times(int[][] A, int[][] B, double[][] C) {
        int n = B.length;
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            int[] rowA = A[i];
            double[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                double sum = 0.0;
                for (int k = 0; k < n; ++k) {
                    sum += (double)(rowA[k] * B[k][j]);
                }
                rowC[j] = sum;
            }
        }
    }

    public static final void divide(double[][] ARe, double[][] AIm, double bRe, double bIm, double[][] CRe, double[][] CIm) {
        double nn = bRe * bRe + bIm * bIm;
        int numRows = CRe.length;
        int numCols = CRe[0].length;
        for (int i = 0; i < numRows; ++i) {
            double[] rowMRe = ARe[i];
            double[] rowRe = CRe[i];
            double[] rowMIm = AIm[i];
            double[] rowIm = CIm[i];
            for (int j = 0; j < numCols; ++j) {
                double rr = rowMRe[j];
                double ii = rowMIm[j];
                rowRe[j] = (rr * bRe + ii * bIm) / nn;
                rowIm[j] = (ii * bRe - rr * bIm) / nn;
            }
        }
    }

    public static final void times(double[][] ARe, double[][] AIm, double bRe, double bIm, double[][] CRe, double[][] CIm) {
        int numRows = ARe.length;
        int numCols = ARe[0].length;
        for (int i = 0; i < numRows; ++i) {
            double[] rowRe = CRe[i];
            double[] rowIm = CIm[i];
            double[] rowReA = ARe[i];
            double[] rowImA = AIm[i];
            for (int j = 0; j < numCols; ++j) {
                double rr = rowReA[j];
                double ii = rowImA[j];
                rowRe[j] = rr * bRe - ii * bIm;
                rowIm[j] = rr * bIm + ii * bRe;
            }
        }
    }

    public static final void times(int[][] A, int b, int[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            int[] rowA = A[i];
            int[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = rowA[j] * b;
            }
        }
    }

    public static final void divide(int[][] A, int b, int[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            int[] rowA = A[i];
            int[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = rowA[j] / b;
            }
        }
    }

    public static final void divide(int[][] A, double b, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            int[] rowA = A[i];
            double[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = (double)rowA[j] / b;
            }
        }
    }

    public static final void divide(int b, int[][] A, int[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            int[] rowA = A[i];
            int[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = b / rowA[j];
            }
        }
    }

    public static final void divide(double b, double[][] A, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            double[] rowA = A[i];
            double[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = b / rowA[j];
            }
        }
    }

    public static final void divide(double b, double[][] Are, double[][] Aim, double[][] Cre, double[][] Cim) {
        int numRows = Cre.length;
        int numCols = Cre[0].length;
        for (int i = 0; i < numRows; ++i) {
            double[] rowAre = Are[i];
            double[] rowCre = Cre[i];
            double[] rowAim = Aim[i];
            double[] rowCim = Cim[i];
            for (int j = 0; j < numCols; ++j) {
                double Re = rowAre[j];
                double Im = rowAim[j];
                double nn = Re * Re + Im * Im;
                if (nn == 0.0) {
                    rowCre[j] = b / nn;
                    rowCim[j] = 0.0;
                    continue;
                }
                rowCre[j] = b * Re / nn;
                rowCim[j] = -b * Im / nn;
            }
        }
    }

    public static final void divide(double b, int[][] A, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            int[] rowA = A[i];
            double[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = b / (double)rowA[j];
            }
        }
    }

    public static final void divide(double[][] A, double b, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            double[] rowA = A[i];
            double[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = rowA[j] / b;
            }
        }
    }

    public static final void times(double[][] A, double b, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            double[] rowA = A[i];
            double[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = rowA[j] * b;
            }
        }
    }

    public static final void times(int[][] A, double b, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            int[] rowA = A[i];
            double[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = (double)rowA[j] * b;
            }
        }
    }

    public static final void times(double[][] MRe, double[][] MIm, double[] VRe, double[] VIm, double[] WRe, double[] WIm) {
        double[] tmpVRe = VRe == WRe || VRe == WIm ? (double[])VRe.clone() : VRe;
        double[] tmpVIm = VIm == WRe || VIm == WIm ? (double[])VIm.clone() : VIm;
        int numOfRows = MRe.length;
        int numOfCols = MRe[0].length;
        for (int i = 0; i < numOfRows; ++i) {
            double re = 0.0;
            double im = 0.0;
            double[] rowRe = MRe[i];
            double[] rowIm = MIm[i];
            for (int j = 0; j < numOfCols; ++j) {
                re += rowRe[j] * tmpVRe[j] - rowIm[j] * tmpVIm[j];
                im += rowRe[j] * tmpVIm[j] + rowIm[j] * tmpVRe[j];
            }
            WRe[i] = re;
            WIm[i] = im;
        }
    }

    public static final void times(double[] VRe, double[] VIm, double[][] MRe, double[][] MIm, double[] WRe, double[] WIm) {
        int numOfRows = MRe.length;
        int numOfCols = MRe[0].length;
        for (int i = 0; i < numOfCols; ++i) {
            double thisRe = 0.0;
            double thisIm = 0.0;
            for (int j = 0; j < numOfRows; ++j) {
                thisRe += MRe[j][i] * VRe[j] - MIm[j][i] * VIm[j];
                thisIm += MRe[j][i] * VIm[j] + MIm[j][i] * VRe[j];
            }
            WRe[i] = thisRe;
            WIm[i] = thisIm;
        }
    }

    public static final void times(int[][] A, int[] b, int[] c) {
        int[] tmpB = b != c ? b : VectorOperations.copy(c);
        int n = b.length;
        for (int[] rowA : A) {
            int sum = 0;
            for (int j = 0; j < n; ++j) {
                sum += rowA[j] * tmpB[j];
            }
            c[i] = sum;
        }
    }

    public static final void times(int[][] A, int[] b, double[] c) {
        int n = b.length;
        for (int[] rowA : A) {
            int sum = 0;
            for (int j = 0; j < n; ++j) {
                sum += rowA[j] * b[j];
            }
            c[i] = sum;
        }
    }

    public static final void times(double[][] A, double[] b, double[] c) {
        double[] tmpB = b != c ? b : VectorOperations.copy(c);
        int n = b.length;
        for (double[] rowA : A) {
            double sum = 0.0;
            for (int j = 0; j < n; ++j) {
                sum += rowA[j] * tmpB[j];
            }
            c[i] = sum;
        }
    }

    public static final void times(int[][] A, double[] b, double[] c) {
        double[] tmpB = b != c ? b : VectorOperations.copy(c);
        int n = b.length;
        for (int[] rowA : A) {
            double sum = 0.0;
            for (int j = 0; j < n; ++j) {
                sum += (double)rowA[j] * tmpB[j];
            }
            c[i] = sum;
        }
    }

    public static final void times(double[][] A, int[] b, double[] c) {
        int n = b.length;
        for (double[] rowA : A) {
            double sum = 0.0;
            for (int j = 0; j < n; ++j) {
                sum += rowA[j] * (double)b[j];
            }
            c[i] = sum;
        }
    }

    public static final void times(int[] a, int[][] B, int[] c) {
        int[] tmpA = a != c ? a : VectorOperations.copy(c);
        int n = a.length;
        int numCols = c.length;
        for (int i = 0; i < numCols; ++i) {
            int sum = 0;
            for (int j = 0; j < n; ++j) {
                sum += tmpA[j] * B[j][i];
            }
            c[i] = sum;
        }
    }

    public static final void times(int[] a, int[][] B, double[] c) {
        int n = a.length;
        int numCols = c.length;
        for (int i = 0; i < numCols; ++i) {
            int sum = 0;
            for (int j = 0; j < n; ++j) {
                sum += a[j] * B[j][i];
            }
            c[i] = sum;
        }
    }

    public static final void times(double[] a, double[][] B, double[] c) {
        double[] tmpA = a != c ? a : VectorOperations.copy(c);
        int n = a.length;
        int numCols = c.length;
        for (int i = 0; i < numCols; ++i) {
            double sum = 0.0;
            for (int j = 0; j < n; ++j) {
                sum += tmpA[j] * B[j][i];
            }
            c[i] = sum;
        }
    }

    public static final void times(int[] a, double[][] B, double[] c) {
        int n = a.length;
        int numCols = c.length;
        for (int i = 0; i < numCols; ++i) {
            double sum = 0.0;
            for (int j = 0; j < n; ++j) {
                sum += (double)a[j] * B[j][i];
            }
            c[i] = sum;
        }
    }

    public static final void times(double[] a, int[][] B, double[] c) {
        double[] tmpA = a != c ? a : VectorOperations.copy(c);
        int n = a.length;
        int numCols = c.length;
        for (int i = 0; i < numCols; ++i) {
            double sum = 0.0;
            for (int j = 0; j < n; ++j) {
                sum += tmpA[j] * (double)B[j][i];
            }
            c[i] = sum;
        }
    }

    public static final void times(int[] a, int[] b, int[][] C) {
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                C[i][j] = a[i] * b[j];
            }
        }
    }

    public static final void times(double[] a, double[] b, double[][] C) {
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                C[i][j] = a[i] * b[j];
            }
        }
    }

    public static final void times(int[] a, double[] b, double[][] C) {
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                C[i][j] = (double)a[i] * b[j];
            }
        }
    }

    public static final void times(double[] a, int[] b, double[][] C) {
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                C[i][j] = a[i] * (double)b[j];
            }
        }
    }

    public static final void plus(int[][] A, int[][] B, int[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            int[] rowA = A[i];
            int[] rowB = B[i];
            int[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = rowA[j] + rowB[j];
            }
        }
    }

    public static final void plus(double[][] A, double[][] B, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            double[] rowA = A[i];
            double[] rowB = B[i];
            double[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = rowA[j] + rowB[j];
            }
        }
    }

    public static final void plus(double[][] A, int[][] B, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            double[] rowA = A[i];
            int[] rowB = B[i];
            double[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = rowA[j] + (double)rowB[j];
            }
        }
    }

    public static final void plus(int[][] A, double[][] B, double[][] C) {
        MatrixOperations.plus(B, A, C);
    }

    public static final void plus(int[][] A, int b, int[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            int[] rowA = A[i];
            int[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = rowA[j] + b;
            }
        }
    }

    public static final void plus(double[][] A, double b, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            double[] rowA = A[i];
            double[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = rowA[j] + b;
            }
        }
    }

    public static final void plus(int[][] A, double b, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            int[] rowA = A[i];
            double[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = (double)rowA[j] + b;
            }
        }
    }

    public static final void minus(int[][] A, int[][] B, int[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            int[] rowA = A[i];
            int[] rowB = B[i];
            int[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = rowA[j] - rowB[j];
            }
        }
    }

    public static final void minus(double[][] A, double[][] B, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            double[] rowA = A[i];
            double[] rowB = B[i];
            double[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = rowA[j] - rowB[j];
            }
        }
    }

    public static final void minus(double[][] A, int[][] B, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            double[] rowA = A[i];
            int[] rowB = B[i];
            double[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = rowA[j] - (double)rowB[j];
            }
        }
    }

    public static final void minus(int[][] A, double[][] B, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            int[] rowA = A[i];
            double[] rowB = B[i];
            double[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = (double)rowA[j] - rowB[j];
            }
        }
    }

    public static final void minus(int[][] A, int b, int[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            int[] rowA = A[i];
            int[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = rowA[j] - b;
            }
        }
    }

    public static final void minus(int a, int[][] B, int[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            int[] rowB = B[i];
            int[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = a - rowB[j];
            }
        }
    }

    public static final void minus(double[][] A, double b, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            double[] rowA = A[i];
            double[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = rowA[j] - b;
            }
        }
    }

    public static final void minus(double a, double[][] B, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            double[] rowB = B[i];
            double[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = a - rowB[j];
            }
        }
    }

    public static final void minus(int[][] A, double b, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            int[] rowA = A[i];
            double[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = (double)rowA[j] - b;
            }
        }
    }

    public static final void minus(int a, double[][] B, double[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            double[] rowB = B[i];
            double[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = (double)a - rowB[j];
            }
        }
    }

    public static final void assign(double[][] A, double[][] B) {
        int numRows = A.length;
        int numCols = A[0].length;
        for (int i = 0; i < numRows; ++i) {
            System.arraycopy(A[i], 0, B[i], 0, numCols);
        }
    }

    public static final void assign(int[][] A, int[][] B) {
        int numRows = A.length;
        int numCols = A[0].length;
        for (int i = 0; i < numRows; ++i) {
            System.arraycopy(A[i], 0, B[i], 0, numCols);
        }
    }

    public static final void assign(int[][] A, double[][] B) {
        int numRows = A.length;
        int numCols = A[0].length;
        for (int i = 0; i < numRows; ++i) {
            int[] rowA = A[i];
            double[] rowB = B[i];
            for (int j = 0; j < numCols; ++j) {
                rowB[j] = rowA[j];
            }
        }
    }

    public static final int[][] copy(int[][] A) {
        int[][] cloneOfA = new int[A.length][A[0].length];
        MatrixOperations.assign(A, cloneOfA);
        return cloneOfA;
    }

    public static final double[][] copy(double[][] A) {
        double[][] cloneOfA = new double[A.length][A[0].length];
        MatrixOperations.assign(A, cloneOfA);
        return cloneOfA;
    }

    public static final void assign(double[][] A, double value) {
        int numRows = A.length;
        int numCols = A[0].length;
        double[] tmp = A[0];
        for (int j = 0; j < numCols; ++j) {
            tmp[j] = value;
        }
        for (int i = 1; i < numRows; ++i) {
            System.arraycopy(tmp, 0, A[i], 0, numCols);
        }
    }

    public static final void assign(int[][] A, int value) {
        int numRows = A.length;
        int numCols = A[0].length;
        int[] tmp = A[0];
        for (int j = 0; j < numCols; ++j) {
            tmp[j] = value;
        }
        for (int i = 1; i < numRows; ++i) {
            System.arraycopy(tmp, 0, A[i], 0, numCols);
        }
    }

    public static final void assignId(int[][] A) {
        int length = A.length;
        int[] tmp = new int[length];
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < length; ++j) {
                tmp = A[i];
                tmp[j] = i == j ? 1 : 0;
            }
        }
    }

    public static final void assignId(double[][] A) {
        int length = A.length;
        double[] tmp = new double[length];
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < length; ++j) {
                tmp = A[i];
                tmp[j] = i == j ? 1.0 : 0.0;
            }
        }
    }

    public static final void assignZero(int[][] A) {
        int numRows = A.length;
        int numCols = A[0].length;
        int[] tmp = A[0];
        for (int j = 0; j < numCols; ++j) {
            tmp[j] = 0;
        }
        for (int i = 1; i < numRows; ++i) {
            System.arraycopy(tmp, 0, A[i], 0, numCols);
        }
    }

    public static final void assignZero(double[][] A) {
        int numRows = A.length;
        int numCols = A[0].length;
        double[] tmp = A[0];
        for (int j = 0; j < numCols; ++j) {
            tmp[j] = 0.0;
        }
        for (int i = 1; i < numRows; ++i) {
            System.arraycopy(tmp, 0, A[i], 0, numCols);
        }
    }

    public static final void getDiagonal(int[][] A, int[] v) {
        int length = v.length;
        for (int i = 0; i < length; ++i) {
            v[i] = A[i][i];
        }
    }

    public static final void assignDiagonal(int[][] A, int[] v) {
        for (int A[i][i] : v) {
        }
    }

    public static final void assignDiagonal(int[][] A, int v) {
        int length = Math.min(A.length, A[0].length);
        for (int i = 0; i < length; ++i) {
            A[i][i] = v;
        }
    }

    public static final void assignDiagonal(double[][] A, double v) {
        int length = Math.min(A.length, A[0].length);
        for (int i = 0; i < length; ++i) {
            A[i][i] = v;
        }
    }

    public static final void assignDiagonal(double[][] A, double[] v) {
        for (double A[i][i] : v) {
        }
    }

    public static final void getDiagonal(double[][] A, double[] v) {
        int length = v.length;
        for (int i = 0; i < length; ++i) {
            v[i] = A[i][i];
        }
    }

    public static final void assignDiagonal(double[][] A, int[] v) {
        int length = v.length;
        for (int i = 0; i < length; ++i) {
            A[i][i] = v[i];
        }
    }

    public static final void assignRow(int[][] A, int[] v, int rowNum) {
        System.arraycopy(v, 0, A[rowNum], 0, v.length);
    }

    public static final void getRow(int[][] A, int[] v, int rowNum) {
        System.arraycopy(A[rowNum], 0, v, 0, v.length);
    }

    public static final void getRow(double[][] A, double[] v, int rowNum) {
        System.arraycopy(A[rowNum], 0, v, 0, v.length);
    }

    public static final void assignRow(double[][] A, double[] v, int rowNum) {
        System.arraycopy(v, 0, A[rowNum], 0, v.length);
    }

    public static final void assignRow(double[][] A, int[] v, int rowNum) {
        int l = v.length;
        double[] row = A[rowNum];
        for (int i = 0; i < l; ++i) {
            row[i] = v[i];
        }
    }

    public static final void assignCol(int[][] A, int[] v, int colNum) {
        for (int A[i][colNum] : v) {
        }
    }

    public static final void getCol(int[][] A, int[] v, int colNum) {
        int l = v.length;
        for (int i = 0; i < l; ++i) {
            v[i] = A[i][colNum];
        }
    }

    public static final void getCol(double[][] A, double[] v, int colNum) {
        int l = v.length;
        for (int i = 0; i < l; ++i) {
            v[i] = A[i][colNum];
        }
    }

    public static final void assignCol(double[][] A, double[] v, int colNum) {
        for (double A[i][colNum] : v) {
        }
    }

    public static final void assignCol(double[][] A, int[] v, int colNum) {
        int l = v.length;
        for (int i = 0; i < l; ++i) {
            A[i][colNum] = v[i];
        }
    }

    public static final void round(double[][] A, double[][] B) {
        int numRows = A.length;
        int numCols = A[0].length;
        for (int i = 0; i < numRows; ++i) {
            double[] rowA = A[i];
            double[] rowB = B[i];
            for (int j = 0; j < numCols; ++j) {
                rowB[j] = Math.floor(rowA[j] + 0.5);
            }
        }
    }

    public static final void round(double[][] A, int[][] B) {
        int numRows = A.length;
        int numCols = A[0].length;
        for (int i = 0; i < numRows; ++i) {
            double[] rowA = A[i];
            int[] rowB = B[i];
            for (int j = 0; j < numCols; ++j) {
                rowB[j] = (int)Math.floor(rowA[j] + 0.5);
            }
        }
    }

    public static final void floor(double[][] A, double[][] B) {
        int numRows = A.length;
        int numCols = A[0].length;
        for (int i = 0; i < numRows; ++i) {
            double[] rowA = A[i];
            double[] rowB = B[i];
            for (int j = 0; j < numCols; ++j) {
                rowB[j] = Math.floor(rowA[j]);
            }
        }
    }

    public static final void floor(double[][] A, int[][] B) {
        int numRows = A.length;
        int numCols = A[0].length;
        for (int i = 0; i < numRows; ++i) {
            double[] rowA = A[i];
            int[] rowB = B[i];
            for (int j = 0; j < numCols; ++j) {
                rowB[j] = (int)Math.floor(rowA[j]);
            }
        }
    }

    public static final void neg(int[][] A, int[][] B) {
        int numRows = A.length;
        int numCols = A[0].length;
        for (int i = 0; i < numRows; ++i) {
            int[] rowA = A[i];
            int[] rowB = B[i];
            for (int j = 0; j < numCols; ++j) {
                rowB[j] = -rowA[j];
            }
        }
    }

    public static final void neg(double[][] A, double[][] B) {
        int numRows = A.length;
        int numCols = A[0].length;
        for (int i = 0; i < numRows; ++i) {
            double[] rowA = A[i];
            double[] rowB = B[i];
            for (int j = 0; j < numCols; ++j) {
                rowB[j] = -rowA[j];
            }
        }
    }

    public static final void neg(int[][] A, double[][] B) {
        int numRows = A.length;
        int numCols = A[0].length;
        for (int i = 0; i < numRows; ++i) {
            int[] rowA = A[i];
            double[] rowB = B[i];
            for (int j = 0; j < numCols; ++j) {
                rowB[j] = -rowA[j];
            }
        }
    }

    public static final void mod(int[][] A, int b, int[][] C) {
        int numRows = C.length;
        int numCols = C[0].length;
        for (int i = 0; i < numRows; ++i) {
            int[] rowA = A[i];
            int[] rowC = C[i];
            for (int j = 0; j < numCols; ++j) {
                rowC[j] = rowA[j] % b;
            }
        }
    }

    public static final double normSqr(int[][] re) {
        int res = 0;
        int numRows = re.length;
        int numCols = re[0].length;
        for (int i = 0; i < numRows; ++i) {
            int[] rowRe = re[i];
            for (int j = 0; j < numCols; ++j) {
                res += rowRe[j] * rowRe[j];
            }
        }
        return res;
    }

    public static final double normSqr(double[][] re) {
        double res = 0.0;
        int numRows = re.length;
        int numCols = re[0].length;
        for (int i = 0; i < numRows; ++i) {
            double[] rowRe = re[i];
            for (int j = 0; j < numCols; ++j) {
                res += rowRe[j] * rowRe[j];
            }
        }
        return res;
    }

    public static final int[] maxAbs(double[][] re) {
        int r = re.length;
        int c = re[0].length;
        int[] pos = new int[]{0, 0};
        double max = 0.0;
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                double abs = re[i][j] * re[i][j];
                if (!(abs > max)) continue;
                max = abs;
                pos[0] = i;
                pos[1] = j;
            }
        }
        return pos;
    }

    public static final int[] maxAbs(double[][] re, double[][] im) {
        int r = re.length;
        int c = re[0].length;
        int[] pos = new int[]{0, 0};
        double max = 0.0;
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                double abs = re[i][j] * re[i][j] + im[i][j] * im[i][j];
                if (!(abs > max)) continue;
                max = abs;
                pos[0] = i;
                pos[1] = j;
            }
        }
        return pos;
    }

    public static final void transpose(int[][] m, int[][] trans) {
        int numRows = trans.length;
        if (m == trans) {
            for (int i = 0; i < numRows; ++i) {
                for (int j = 0; j < i; ++j) {
                    int tmp = m[i][j];
                    m[i][j] = m[j][i];
                    m[j][i] = tmp;
                }
            }
        } else {
            int numCols = trans[0].length;
            for (int i = 0; i < numRows; ++i) {
                int[] rowRe = trans[i];
                for (int j = 0; j < numCols; ++j) {
                    rowRe[j] = m[j][i];
                }
            }
        }
    }

    public static final void transpose(double[][] m, double[][] trans) {
        int numRows = trans.length;
        if (m == trans) {
            for (int i = 0; i < numRows; ++i) {
                for (int j = 0; j < i; ++j) {
                    double tmp = m[i][j];
                    m[i][j] = m[j][i];
                    m[j][i] = tmp;
                }
            }
        } else {
            int numCols = trans[0].length;
            for (int i = 0; i < numRows; ++i) {
                double[] rowRe = trans[i];
                for (int j = 0; j < numCols; ++j) {
                    rowRe[j] = m[j][i];
                }
            }
        }
    }

    public static final void random(double[][] m) {
        int numRows = m.length;
        int numCols = m[0].length;
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                m[i][j] = 2.0 * Math.random() - 1.0;
            }
        }
    }

    public static final void random(int[][] m, int range) {
        int numRows = m.length;
        int numCols = m[0].length;
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                m[i][j] = (int)Math.random() * range;
            }
        }
    }

    public static boolean isRectangular(int[][] m) {
        if (m.length == 0) {
            return true;
        }
        int numCols = m[0].length;
        int numRows = m.length;
        for (int i = 1; i < numRows; ++i) {
            if (m[i] != null && m[i].length == numCols) continue;
            return false;
        }
        return true;
    }

    public static boolean isRectangular(double[][] m) {
        if (m.length == 0) {
            return true;
        }
        int numCols = m[0].length;
        int numRows = m.length;
        for (int i = 1; i < numRows; ++i) {
            if (m[i] != null && m[i].length == numCols) continue;
            return false;
        }
        return true;
    }
}

