/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear.decompose;

public class Eigenvalue {
    private Eigenvalue() {
    }

    public static void decompose(double[][] A, double[][] V, double[] d) {
        double[] e = new double[d.length];
        Eigenvalue.decompose(A, V, d, e);
    }

    public static void decompose(double[][] A, double[][] V, double[] d, double[] e) {
        int j;
        int n = A[0].length;
        boolean issymmetric = true;
        int i = 0;
        while (i < n & issymmetric) {
            j = 0;
            while (j < n & issymmetric) {
                issymmetric = A[i][j] == A[j][i];
                ++j;
            }
            ++i;
        }
        if (issymmetric) {
            for (i = 0; i < n; ++i) {
                for (j = 0; j < n; ++j) {
                    V[i][j] = A[i][j];
                }
            }
            Eigenvalue.tridiagonalize(V, d, e);
            Eigenvalue.diagonalize(V, d, e);
        } else {
            double[][] H = new double[n][n];
            double[] ort = new double[n];
            for (int j2 = 0; j2 < n; ++j2) {
                for (int i2 = 0; i2 < n; ++i2) {
                    H[i2][j2] = A[i2][j2];
                }
            }
            Eigenvalue.hessenberg(H, ort, V);
            Eigenvalue.schur(H, V, d, e);
        }
    }

    private static void tridiagonalize(double[][] V, double[] d, double[] e) {
        int i;
        int j;
        int n = V[0].length;
        for (j = 0; j < n; ++j) {
            d[j] = V[n - 1][j];
        }
        for (i = n - 1; i > 0; --i) {
            int k;
            double scale = 0.0;
            double h = 0.0;
            for (k = 0; k < i; ++k) {
                scale += Math.abs(d[k]);
            }
            if (scale == 0.0) {
                e[i] = d[i - 1];
                for (int j2 = 0; j2 < i; ++j2) {
                    d[j2] = V[i - 1][j2];
                    V[i][j2] = 0.0;
                    V[j2][i] = 0.0;
                }
            } else {
                int j3;
                int j4;
                for (k = 0; k < i; ++k) {
                    int n2 = k;
                    d[n2] = d[n2] / scale;
                    h += d[k] * d[k];
                }
                double f = d[i - 1];
                double g = Math.sqrt(h);
                if (f > 0.0) {
                    g = -g;
                }
                e[i] = scale * g;
                h -= f * g;
                d[i - 1] = f - g;
                for (j4 = 0; j4 < i; ++j4) {
                    e[j4] = 0.0;
                }
                for (j4 = 0; j4 < i; ++j4) {
                    V[j4][i] = f = d[j4];
                    g = e[j4] + V[j4][j4] * f;
                    for (int k2 = j4 + 1; k2 <= i - 1; ++k2) {
                        g += V[k2][j4] * d[k2];
                        int n3 = k2;
                        e[n3] = e[n3] + V[k2][j4] * f;
                    }
                    e[j4] = g;
                }
                f = 0.0;
                for (j4 = 0; j4 < i; ++j4) {
                    int n4 = j4;
                    e[n4] = e[n4] / h;
                    f += e[j4] * d[j4];
                }
                double hh = f / (h + h);
                for (j3 = 0; j3 < i; ++j3) {
                    int n5 = j3;
                    e[n5] = e[n5] - hh * d[j3];
                }
                for (j3 = 0; j3 < i; ++j3) {
                    f = d[j3];
                    g = e[j3];
                    for (int k3 = j3; k3 <= i - 1; ++k3) {
                        double[] dArray = V[k3];
                        int n6 = j3;
                        dArray[n6] = dArray[n6] - (f * e[k3] + g * d[k3]);
                    }
                    d[j3] = V[i - 1][j3];
                    V[i][j3] = 0.0;
                }
            }
            d[i] = h;
        }
        for (i = 0; i < n - 1; ++i) {
            int k;
            V[n - 1][i] = V[i][i];
            V[i][i] = 1.0;
            double h = d[i + 1];
            if (h != 0.0) {
                for (k = 0; k <= i; ++k) {
                    d[k] = V[k][i + 1] / h;
                }
                for (int j5 = 0; j5 <= i; ++j5) {
                    int k4;
                    double g = 0.0;
                    for (k4 = 0; k4 <= i; ++k4) {
                        g += V[k4][i + 1] * V[k4][j5];
                    }
                    for (k4 = 0; k4 <= i; ++k4) {
                        double[] dArray = V[k4];
                        int n7 = j5;
                        dArray[n7] = dArray[n7] - g * d[k4];
                    }
                }
            }
            for (k = 0; k <= i; ++k) {
                V[k][i + 1] = 0.0;
            }
        }
        for (j = 0; j < n; ++j) {
            d[j] = V[n - 1][j];
            V[n - 1][j] = 0.0;
        }
        V[n - 1][n - 1] = 1.0;
        e[0] = 0.0;
    }

    private static void diagonalize(double[][] V, double[] d, double[] e) {
        int n = V[0].length;
        for (int i = 1; i < n; ++i) {
            e[i - 1] = e[i];
        }
        e[n - 1] = 0.0;
        double f = 0.0;
        double tst1 = 0.0;
        double eps = Math.pow(2.0, -52.0);
        for (int l = 0; l < n; ++l) {
            int m;
            tst1 = Math.max(tst1, Math.abs(d[l]) + Math.abs(e[l]));
            for (m = l; m < n && !(Math.abs(e[m]) <= eps * tst1); ++m) {
            }
            if (m > l) {
                int iter = 0;
                do {
                    double c;
                    ++iter;
                    double g = d[l];
                    double p = (d[l + 1] - g) / (2.0 * e[l]);
                    double r = Eigenvalue.hypot(p, 1.0);
                    if (p < 0.0) {
                        r = -r;
                    }
                    d[l] = e[l] / (p + r);
                    d[l + 1] = e[l] * (p + r);
                    double dl1 = d[l + 1];
                    double h = g - d[l];
                    int i = l + 2;
                    while (i < n) {
                        int n2 = i++;
                        d[n2] = d[n2] - h;
                    }
                    f += h;
                    p = d[m];
                    double c2 = c = 1.0;
                    double c3 = c;
                    double el1 = e[l + 1];
                    double s = 0.0;
                    double s2 = 0.0;
                    for (int i2 = m - 1; i2 >= l; --i2) {
                        c3 = c2;
                        c2 = c;
                        s2 = s;
                        g = c * e[i2];
                        h = c * p;
                        r = Eigenvalue.hypot(p, e[i2]);
                        e[i2 + 1] = s * r;
                        s = e[i2] / r;
                        c = p / r;
                        p = c * d[i2] - s * g;
                        d[i2 + 1] = h + s * (c * g + s * d[i2]);
                        for (int k = 0; k < n; ++k) {
                            h = V[k][i2 + 1];
                            V[k][i2 + 1] = s * V[k][i2] + c * h;
                            V[k][i2] = c * V[k][i2] - s * h;
                        }
                    }
                    p = -s * s2 * c3 * el1 * e[l] / dl1;
                    e[l] = s * p;
                    d[l] = c * p;
                } while (Math.abs(e[l]) > eps * tst1);
            }
            d[l] = d[l] + f;
            e[l] = 0.0;
        }
        for (int i = 0; i < n - 1; ++i) {
            int j;
            int k = i;
            double p = d[i];
            for (j = i + 1; j < n; ++j) {
                if (!(d[j] < p)) continue;
                k = j;
                p = d[j];
            }
            if (k == i) continue;
            d[k] = d[i];
            d[i] = p;
            for (j = 0; j < n; ++j) {
                p = V[j][i];
                V[j][i] = V[j][k];
                V[j][k] = p;
            }
        }
    }

    private static double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }

    private static void hessenberg(double[][] H, double[] ort, double[][] V) {
        int m;
        int n = H.length;
        int low = 0;
        int high = n - 1;
        for (m = low + 1; m <= high - 1; ++m) {
            double f;
            double scale = 0.0;
            for (int i = m; i <= high; ++i) {
                scale += Math.abs(H[i][m - 1]);
            }
            if (scale == 0.0) continue;
            double h = 0.0;
            for (int i = high; i >= m; --i) {
                ort[i] = H[i][m - 1] / scale;
                h += ort[i] * ort[i];
            }
            double g = Math.sqrt(h);
            if (ort[m] > 0.0) {
                g = -g;
            }
            h -= ort[m] * g;
            ort[m] = ort[m] - g;
            for (int j = m; j < n; ++j) {
                int i;
                f = 0.0;
                for (i = high; i >= m; --i) {
                    f += ort[i] * H[i][j];
                }
                f /= h;
                for (i = m; i <= high; ++i) {
                    double[] dArray = H[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] - f * ort[i];
                }
            }
            for (int i = 0; i <= high; ++i) {
                int j;
                f = 0.0;
                for (j = high; j >= m; --j) {
                    f += ort[j] * H[i][j];
                }
                f /= h;
                for (j = m; j <= high; ++j) {
                    double[] dArray = H[i];
                    int n3 = j;
                    dArray[n3] = dArray[n3] - f * ort[j];
                }
            }
            ort[m] = scale * ort[m];
            H[m][m - 1] = scale * g;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                V[i][j] = i == j ? 1.0 : 0.0;
            }
        }
        for (m = high - 1; m >= low + 1; --m) {
            if (H[m][m - 1] == 0.0) continue;
            for (int i = m + 1; i <= high; ++i) {
                ort[i] = H[i][m - 1];
            }
            for (int j = m; j <= high; ++j) {
                int i;
                double g = 0.0;
                for (i = m; i <= high; ++i) {
                    g += ort[i] * V[i][j];
                }
                g = g / ort[m] / H[m][m - 1];
                for (i = m; i <= high; ++i) {
                    double[] dArray = V[i];
                    int n4 = j;
                    dArray[n4] = dArray[n4] + g * ort[i];
                }
            }
        }
    }

    private static void cdiv(double xr, double xi, double yr, double yi, double[] cdivr, double[] cdivi) {
        if (Math.abs(yr) > Math.abs(yi)) {
            double r = yi / yr;
            double d = yr + r * yi;
            cdivr[0] = (xr + r * xi) / d;
            cdivi[0] = (xi - r * xr) / d;
        } else {
            double r = yr / yi;
            double d = yi + r * yr;
            cdivr[0] = (r * xr + xi) / d;
            cdivi[0] = (r * xi - xr) / d;
        }
    }

    private static void schur(double[][] H, double[][] V, double[] d, double[] e) {
        double y;
        int i;
        int j;
        double x;
        double w;
        int l;
        int j2;
        int n;
        double[] cdivr = new double[1];
        double[] cdivi = new double[1];
        int nn = n = H.length;
        n = nn - 1;
        int low = 0;
        int high = nn - 1;
        double eps = Math.pow(2.0, -52.0);
        double exshift = 0.0;
        double p = 0.0;
        double q = 0.0;
        double r = 0.0;
        double s = 0.0;
        double z = 0.0;
        double norm = 0.0;
        for (int i2 = 0; i2 < nn; ++i2) {
            if (i2 < low | i2 > high) {
                d[i2] = H[i2][i2];
                e[i2] = 0.0;
            }
            for (j2 = Math.max(i2 - 1, 0); j2 < nn; ++j2) {
                norm += Math.abs(H[i2][j2]);
            }
        }
        int iter = 0;
        block2: while (n >= low) {
            int m;
            for (l = n; l > low; --l) {
                s = Math.abs(H[l - 1][l - 1]) + Math.abs(H[l][l]);
                if (s == 0.0) {
                    s = norm;
                }
                if (Math.abs(H[l][l - 1]) < eps * s) break;
            }
            if (l == n) {
                H[n][n] = H[n][n] + exshift;
                d[n] = H[n][n];
                e[n] = 0.0;
                --n;
                iter = 0;
                continue;
            }
            if (l == n - 1) {
                w = H[n][n - 1] * H[n - 1][n];
                p = (H[n - 1][n - 1] - H[n][n]) / 2.0;
                q = p * p + w;
                z = Math.sqrt(Math.abs(q));
                H[n][n] = H[n][n] + exshift;
                H[n - 1][n - 1] = H[n - 1][n - 1] + exshift;
                x = H[n][n];
                if (q >= 0.0) {
                    z = p >= 0.0 ? p + z : p - z;
                    d[n - 1] = x + z;
                    d[n] = d[n - 1];
                    if (z != 0.0) {
                        d[n] = x - w / z;
                    }
                    e[n - 1] = 0.0;
                    e[n] = 0.0;
                    x = H[n][n - 1];
                    s = Math.abs(x) + Math.abs(z);
                    p = x / s;
                    q = z / s;
                    r = Math.sqrt(p * p + q * q);
                    p /= r;
                    q /= r;
                    for (j = n - 1; j < nn; ++j) {
                        z = H[n - 1][j];
                        H[n - 1][j] = q * z + p * H[n][j];
                        H[n][j] = q * H[n][j] - p * z;
                    }
                    for (i = 0; i <= n; ++i) {
                        z = H[i][n - 1];
                        H[i][n - 1] = q * z + p * H[i][n];
                        H[i][n] = q * H[i][n] - p * z;
                    }
                    for (i = low; i <= high; ++i) {
                        z = V[i][n - 1];
                        V[i][n - 1] = q * z + p * V[i][n];
                        V[i][n] = q * V[i][n] - p * z;
                    }
                } else {
                    d[n - 1] = x + p;
                    d[n] = x + p;
                    e[n - 1] = z;
                    e[n] = -z;
                }
                n -= 2;
                iter = 0;
                continue;
            }
            x = H[n][n];
            y = 0.0;
            w = 0.0;
            if (l < n) {
                y = H[n - 1][n - 1];
                w = H[n][n - 1] * H[n - 1][n];
            }
            if (iter == 10) {
                exshift += x;
                i = low;
                while (i <= n) {
                    double[] dArray = H[i];
                    int n2 = i++;
                    dArray[n2] = dArray[n2] - x;
                }
                s = Math.abs(H[n][n - 1]) + Math.abs(H[n - 1][n - 2]);
                x = y = 0.75 * s;
                w = -0.4375 * s * s;
            }
            if (iter == 30) {
                s = (y - x) / 2.0;
                if ((s = s * s + w) > 0.0) {
                    s = Math.sqrt(s);
                    if (y < x) {
                        s = -s;
                    }
                    s = x - w / ((y - x) / 2.0 + s);
                    i = low;
                    while (i <= n) {
                        double[] dArray = H[i];
                        int n3 = i++;
                        dArray[n3] = dArray[n3] - s;
                    }
                    exshift += s;
                    w = 0.964;
                    y = 0.964;
                    x = 0.964;
                }
            }
            ++iter;
            for (m = n - 2; m >= l; --m) {
                z = H[m][m];
                r = x - z;
                s = y - z;
                p = (r * s - w) / H[m + 1][m] + H[m][m + 1];
                q = H[m + 1][m + 1] - z - r - s;
                r = H[m + 2][m + 1];
                s = Math.abs(p) + Math.abs(q) + Math.abs(r);
                if (m == l || Math.abs(H[m][m - 1]) * (Math.abs(q /= s) + Math.abs(r /= s)) < eps * (Math.abs(p /= s) * (Math.abs(H[m - 1][m - 1]) + Math.abs(z) + Math.abs(H[m + 1][m + 1])))) break;
            }
            for (int i3 = m + 2; i3 <= n; ++i3) {
                H[i3][i3 - 2] = 0.0;
                if (i3 <= m + 2) continue;
                H[i3][i3 - 3] = 0.0;
            }
            for (int k = m; k <= n - 1; ++k) {
                int i4;
                boolean notlast;
                boolean bl = notlast = k != n - 1;
                if (k != m) {
                    p = H[k][k - 1];
                    q = H[k + 1][k - 1];
                    r = notlast ? H[k + 2][k - 1] : 0.0;
                    x = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (x != 0.0) {
                        p /= x;
                        q /= x;
                        r /= x;
                    }
                }
                if (x == 0.0) continue block2;
                s = Math.sqrt(p * p + q * q + r * r);
                if (p < 0.0) {
                    s = -s;
                }
                if (s == 0.0) continue;
                if (k != m) {
                    H[k][k - 1] = -s * x;
                } else if (l != m) {
                    H[k][k - 1] = -H[k][k - 1];
                }
                x = (p += s) / s;
                y = q / s;
                z = r / s;
                q /= p;
                r /= p;
                for (int j3 = k; j3 < nn; ++j3) {
                    p = H[k][j3] + q * H[k + 1][j3];
                    if (notlast) {
                        H[k + 2][j3] = H[k + 2][j3] - (p += r * H[k + 2][j3]) * z;
                    }
                    H[k][j3] = H[k][j3] - p * x;
                    H[k + 1][j3] = H[k + 1][j3] - p * y;
                }
                for (i4 = 0; i4 <= Math.min(n, k + 3); ++i4) {
                    p = x * H[i4][k] + y * H[i4][k + 1];
                    if (notlast) {
                        H[i4][k + 2] = H[i4][k + 2] - (p += z * H[i4][k + 2]) * r;
                    }
                    H[i4][k] = H[i4][k] - p;
                    H[i4][k + 1] = H[i4][k + 1] - p * q;
                }
                for (i4 = low; i4 <= high; ++i4) {
                    p = x * V[i4][k] + y * V[i4][k + 1];
                    if (notlast) {
                        V[i4][k + 2] = V[i4][k + 2] - (p += z * V[i4][k + 2]) * r;
                    }
                    V[i4][k] = V[i4][k] - p;
                    V[i4][k + 1] = V[i4][k + 1] - p * q;
                }
            }
        }
        if (norm == 0.0) {
            return;
        }
        for (n = nn - 1; n >= 0; --n) {
            double t;
            p = d[n];
            q = e[n];
            if (q == 0.0) {
                l = n;
                H[n][n] = 1.0;
                for (i = n - 1; i >= 0; --i) {
                    int j4;
                    w = H[i][i] - p;
                    r = 0.0;
                    for (j4 = l; j4 <= n; ++j4) {
                        r += H[i][j4] * H[j4][n];
                    }
                    if (e[i] < 0.0) {
                        z = w;
                        s = r;
                        continue;
                    }
                    l = i;
                    if (e[i] == 0.0) {
                        H[i][n] = w != 0.0 ? -r / w : -r / (eps * norm);
                    } else {
                        x = H[i][i + 1];
                        y = H[i + 1][i];
                        q = (d[i] - p) * (d[i] - p) + e[i] * e[i];
                        H[i][n] = t = (x * s - z * r) / q;
                        H[i + 1][n] = Math.abs(x) > Math.abs(z) ? (-r - w * t) / x : (-s - y * t) / z;
                    }
                    t = Math.abs(H[i][n]);
                    if (!(eps * t * t > 1.0)) continue;
                    for (j4 = i; j4 <= n; ++j4) {
                        H[j4][n] = H[j4][n] / t;
                    }
                }
                continue;
            }
            if (!(q < 0.0)) continue;
            l = n - 1;
            if (Math.abs(H[n][n - 1]) > Math.abs(H[n - 1][n])) {
                H[n - 1][n - 1] = q / H[n][n - 1];
                H[n - 1][n] = -(H[n][n] - p) / H[n][n - 1];
            } else {
                Eigenvalue.cdiv(0.0, -H[n - 1][n], H[n - 1][n - 1] - p, q, cdivr, cdivi);
                H[n - 1][n - 1] = cdivr[0];
                H[n - 1][n] = cdivi[0];
            }
            H[n][n - 1] = 0.0;
            H[n][n] = 1.0;
            for (i = n - 2; i >= 0; --i) {
                int j5;
                double ra = 0.0;
                double sa = 0.0;
                for (j5 = l; j5 <= n; ++j5) {
                    ra += H[i][j5] * H[j5][n - 1];
                    sa += H[i][j5] * H[j5][n];
                }
                w = H[i][i] - p;
                if (e[i] < 0.0) {
                    z = w;
                    r = ra;
                    s = sa;
                    continue;
                }
                l = i;
                if (e[i] == 0.0) {
                    Eigenvalue.cdiv(-ra, -sa, w, q, cdivr, cdivi);
                    H[i][n - 1] = cdivr[0];
                    H[i][n] = cdivi[0];
                } else {
                    double vi;
                    x = H[i][i + 1];
                    y = H[i + 1][i];
                    double vr = (d[i] - p) * (d[i] - p) + e[i] * e[i] - q * q;
                    if (vr == 0.0 & (vi = (d[i] - p) * 2.0 * q) == 0.0) {
                        vr = eps * norm * (Math.abs(w) + Math.abs(q) + Math.abs(x) + Math.abs(y) + Math.abs(z));
                    }
                    Eigenvalue.cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi, cdivr, cdivi);
                    H[i][n - 1] = cdivr[0];
                    H[i][n] = cdivi[0];
                    if (Math.abs(x) > Math.abs(z) + Math.abs(q)) {
                        H[i + 1][n - 1] = (-ra - w * H[i][n - 1] + q * H[i][n]) / x;
                        H[i + 1][n] = (-sa - w * H[i][n] - q * H[i][n - 1]) / x;
                    } else {
                        Eigenvalue.cdiv(-r - y * H[i][n - 1], -s - y * H[i][n], z, q, cdivr, cdivi);
                        H[i + 1][n - 1] = cdivr[0];
                        H[i + 1][n] = cdivi[0];
                    }
                }
                t = Math.max(Math.abs(H[i][n - 1]), Math.abs(H[i][n]));
                if (!(eps * t * t > 1.0)) continue;
                for (j5 = i; j5 <= n; ++j5) {
                    H[j5][n - 1] = H[j5][n - 1] / t;
                    H[j5][n] = H[j5][n] / t;
                }
            }
        }
        for (int i5 = 0; i5 < nn; ++i5) {
            if (!(i5 < low | i5 > high)) continue;
            for (j = i5; j < nn; ++j) {
                V[i5][j] = H[i5][j];
            }
        }
        for (j2 = nn - 1; j2 >= low; --j2) {
            for (i = low; i <= high; ++i) {
                z = 0.0;
                for (int k = low; k <= Math.min(j2, high); ++k) {
                    z += V[i][k] * H[k][j2];
                }
                V[i][j2] = z;
            }
        }
    }
}

