/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.loopGroup;

import de.jtem.numericalMethods.algebra.linear.Inversion;
import de.jtem.numericalMethods.algebra.linear.VectorOperations;
import de.jtem.numericalMethods.algebra.linear.decompose.Householder;
import de.jtem.numericalMethods.algebra.linear.solve.RXB;
import de.jtem.numericalMethods.algebra.polynomial.ComplexPolynomial;

public class BirkhoffFactorization {
    public static final int NEG_POS = 0;
    public static final int POS_NEG = 1;
    public static final int FIRST = 0;
    public static final int SECOND = 1;

    public static void factor(double[][][] xRe, double[][][] xIm, double[][][] yRe, double[][][] yIm, int direction, int factor, int normalize) {
        int n = xRe.length;
        int N = (xRe[0][0].length - 1) / 2;
        int blockSize = N + 1;
        int m = blockSize * n;
        double[][][] tRe = new double[n][n][N + 1];
        double[][][] tIm = new double[n][n][N + 1];
        double[][] qRe = new double[m][m];
        double[][] qIm = new double[m][m];
        double[] dRe = new double[m];
        double[] dIm = new double[m];
        double[] kRe = new double[m];
        double[] kIm = new double[m];
        double[][] yyyRe = new double[n][m];
        double[][] yyyIm = new double[n][m];
        double[][] q0Re = new double[n][n];
        double[][] q0Im = new double[n][n];
        double[][] t0Re = new double[n][n];
        double[][] t0Im = new double[n][n];
        double[][][] uRe = new double[n][n][N + 1];
        double[][][] uIm = new double[n][n][N + 1];
        double[] tmpmRe = new double[2 * N + 1];
        double[] tmpmIm = new double[2 * N + 1];
        BirkhoffFactorization.factor(xRe, xIm, yRe, yIm, tRe, tIm, qRe, qIm, dRe, dIm, kRe, kIm, yyyRe, yyyIm, q0Re, q0Im, t0Re, t0Im, uRe, uIm, tmpmRe, tmpmIm, direction, factor, normalize);
    }

    public static void factor(double[][][] xRe, double[][][] xIm, double[][][] yRe, double[][][] yIm, double[][][] tRe, double[][][] tIm, double[][] qRe, double[][] qIm, double[] dRe, double[] dIm, double[] kRe, double[] kIm, double[][] yyyRe, double[][] yyyIm, double[][] q0Re, double[][] q0Im, double[][] t0Re, double[][] t0Im, double[][][] uRe, double[][][] uIm, double[] tmpmRe, double[] tmpmIm, int direction, int factor, int normalize) {
        int i;
        int n = xRe.length;
        int N = (xRe[0][0].length - 1) / 2;
        int blockSize = N + 1;
        if (blockSize <= N) {
            throw new IllegalArgumentException("blockSize must be at least degree+1");
        }
        boolean negFlag = BirkhoffFactorization.isNegative(direction, factor);
        boolean transposeFlag = factor == 1;
        for (int i2 = 0; i2 < n; ++i2) {
            for (int j = 0; j < n; ++j) {
                if (!transposeFlag) {
                    BirkhoffFactorization.setBlock(xRe[i2][j], qRe, i2, j, N, blockSize);
                    BirkhoffFactorization.setBlock(xIm[i2][j], qIm, i2, j, N, blockSize);
                    continue;
                }
                BirkhoffFactorization.setBlock(xRe[i2][j], qRe, j, i2, N, blockSize);
                BirkhoffFactorization.setBlock(xIm[i2][j], qIm, j, i2, N, blockSize);
            }
        }
        double[] t = Householder.decompose(qRe, qIm, dRe, dIm, kRe, kIm);
        if (t[0] == 0.0 && t[1] == 0.0) {
            throw new RuntimeException("not solvable");
        }
        for (i = 0; i < n; ++i) {
            BirkhoffFactorization.assignZero(yyyRe[i]);
            BirkhoffFactorization.assignZero(yyyIm[i]);
            if (negFlag) {
                yyyRe[i][i * blockSize] = 1.0;
            } else {
                yyyRe[i][i * blockSize + blockSize - 1] = 1.0;
            }
            Householder.qTimes(qRe, qIm, yyyRe[i], yyyIm[i], true);
        }
        for (i = 0; i < dRe.length; ++i) {
            qRe[i][i] = dRe[i];
            qIm[i][i] = dIm[i];
        }
        for (i = 0; i < n; ++i) {
            int j;
            int offset;
            RXB.solve(qRe, qIm, kRe, kIm, yyyRe[i], yyyIm[i]);
            int n2 = offset = negFlag ? 0 : blockSize - (N + 1);
            if (!transposeFlag) {
                for (j = 0; j < n; ++j) {
                    BirkhoffFactorization.getBlock(tRe[j][i], kRe, j * blockSize + offset, N);
                    BirkhoffFactorization.getBlock(tIm[j][i], kIm, j * blockSize + offset, N);
                }
                continue;
            }
            for (j = 0; j < n; ++j) {
                BirkhoffFactorization.getBlock(tRe[i][j], kRe, j * blockSize + offset, N);
                BirkhoffFactorization.getBlock(tIm[i][j], kIm, j * blockSize + offset, N);
            }
        }
        double[][][] inRe = tRe;
        double[][][] inIm = tIm;
        double[][][] outRe = yRe;
        double[][][] outIm = yIm;
        if (factor == 0 && normalize == 1 || factor == 1 && normalize == 0) {
            BirkhoffFactorization.normalize(tRe, tIm, uRe, uIm, t0Re, t0Im, q0Re, q0Im, dRe, dIm, yyyRe[0], yyyIm[0], factor == 1, !negFlag);
            inRe = uRe;
            inIm = uIm;
            outRe = yRe;
            outIm = yIm;
        }
        if (negFlag) {
            if (!transposeFlag) {
                BirkhoffFactorization.blockMultiplyPosNeg(xRe, xIm, inRe, inIm, outRe, outIm, tmpmRe, tmpmIm);
            } else {
                BirkhoffFactorization.blockMultiplyPosNegReverse(xRe, xIm, inRe, inIm, outRe, outIm, tmpmRe, tmpmIm);
            }
        } else if (!transposeFlag) {
            BirkhoffFactorization.blockMultiplyNegPos(xRe, xIm, inRe, inIm, outRe, outIm, tmpmRe, tmpmIm);
        } else {
            BirkhoffFactorization.blockMultiplyNegPosReverse(xRe, xIm, inRe, inIm, outRe, outIm, tmpmRe, tmpmIm);
        }
    }

    public static boolean isNegative(int direction, int factor) {
        return direction == 0 && factor == 0 || direction == 1 && factor == 1;
    }

    private static void blockMultiplyPosNeg(double[][][] aRe, double[][][] aIm, double[][][] bRe, double[][][] bIm, double[][][] cRe, double[][][] cIm, double[] tmpRe, double[] tmpIm) {
        if (aRe == cRe || bRe == cRe) {
            throw new IllegalArgumentException();
        }
        int n = aRe.length;
        int degOfA = aRe[0][0].length - 1;
        int degOfB = bRe[0][0].length - 1;
        int degOfC = cRe[0][0].length - 1;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                ComplexPolynomial.times(aRe[i][0], aIm[i][0], degOfA, bRe[0][j], bIm[0][j], degOfB, cRe[i][j], cIm[i][j], degOfC);
                for (int k = 1; k < n; ++k) {
                    ComplexPolynomial.times(aRe[i][k], aIm[i][k], degOfA, bRe[k][j], bIm[k][j], degOfB, tmpRe, tmpIm, degOfC);
                    VectorOperations.plus(cRe[i][j], tmpRe, cRe[i][j]);
                    VectorOperations.plus(cIm[i][j], tmpIm, cIm[i][j]);
                }
            }
        }
    }

    private static void blockMultiplyPosNegReverse(double[][][] aRe, double[][][] aIm, double[][][] bRe, double[][][] bIm, double[][][] cRe, double[][][] cIm, double[] tmpRe, double[] tmpIm) {
        if (aRe == cRe || bRe == cRe) {
            throw new IllegalArgumentException();
        }
        int n = aRe.length;
        int degOfA = aRe[0][0].length - 1;
        int degOfB = bRe[0][0].length - 1;
        int degOfC = cRe[0][0].length - 1;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                ComplexPolynomial.times(aRe[0][j], aIm[0][j], degOfA, bRe[i][0], bIm[i][0], degOfB, cRe[i][j], cIm[i][j], degOfC);
                for (int k = 1; k < n; ++k) {
                    ComplexPolynomial.times(aRe[k][j], aIm[k][j], degOfA, bRe[i][k], bIm[i][k], degOfB, tmpRe, tmpIm, degOfC);
                    VectorOperations.plus(cRe[i][j], tmpRe, cRe[i][j]);
                    VectorOperations.plus(cIm[i][j], tmpIm, cIm[i][j]);
                }
            }
        }
    }

    private static void blockMultiplyNegPos(double[][][] aRe, double[][][] aIm, double[][][] bRe, double[][][] bIm, double[][][] cRe, double[][][] cIm, double[] tmpRe, double[] tmpIm) {
        if (aRe == cRe || bRe == cRe) {
            throw new IllegalArgumentException();
        }
        int n = aRe.length;
        int N = bRe[0][0].length - 1;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                BirkhoffFactorization.polynomialTimes(aRe[i][0], aIm[i][0], bRe[0][j], bIm[0][j], cRe[i][j], cIm[i][j], N);
                for (int k = 1; k < n; ++k) {
                    BirkhoffFactorization.polynomialTimes(aRe[i][k], aIm[i][k], bRe[k][j], bIm[k][j], tmpRe, tmpIm, N);
                    VectorOperations.plus(cRe[i][j], tmpRe, cRe[i][j]);
                    VectorOperations.plus(cIm[i][j], tmpIm, cIm[i][j]);
                }
            }
        }
    }

    private static void blockMultiplyNegPosReverse(double[][][] aRe, double[][][] aIm, double[][][] bRe, double[][][] bIm, double[][][] cRe, double[][][] cIm, double[] tmpRe, double[] tmpIm) {
        if (aRe == cRe || bRe == cRe) {
            throw new IllegalArgumentException();
        }
        int n = aRe.length;
        int N = bRe[0][0].length - 1;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                BirkhoffFactorization.polynomialTimes(aRe[0][j], aIm[0][j], bRe[i][0], bIm[i][0], cRe[i][j], cIm[i][j], N);
                for (int k = 1; k < n; ++k) {
                    BirkhoffFactorization.polynomialTimes(aRe[k][j], aIm[k][j], bRe[i][k], bIm[i][k], tmpRe, tmpIm, N);
                    VectorOperations.plus(cRe[i][j], tmpRe, cRe[i][j]);
                    VectorOperations.plus(cIm[i][j], tmpIm, cIm[i][j]);
                }
            }
        }
    }

    private static void polynomialTimes(double[] aRe, double[] aIm, double[] bRe, double[] bIm, double[] cRe, double[] cIm, int N) {
        if (aRe == cRe || bRe == cRe) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i <= N; ++i) {
            double cr = 0.0;
            double ci = 0.0;
            for (int j = i; j <= N; ++j) {
                cr += aRe[N + j] * bRe[N + i - j] - aIm[N + j] * bIm[N + i - j];
                ci += aRe[N + j] * bIm[N + i - j] + aIm[N + j] * bRe[N + i - j];
            }
            cRe[i] = cr;
            cIm[i] = ci;
        }
    }

    private static void setBlock(double[] coeff, double[][] m, int row, int col, int N, int blockSize) {
        int rowOffset = row * blockSize;
        int colOffset = col * blockSize;
        int R = blockSize;
        for (int j = 0; j < blockSize; ++j) {
            int i;
            int p0 = Math.max(0, j - N);
            int p1 = Math.min(R, N + 1 + j);
            for (i = 0; i < p0; ++i) {
                m[i + rowOffset][j + colOffset] = 0.0;
            }
            for (i = p0; i < p1; ++i) {
                m[i + rowOffset][j + colOffset] = coeff[N + i - j];
            }
            for (i = p1; i < R; ++i) {
                m[i + rowOffset][j + colOffset] = 0.0;
            }
        }
    }

    private static void getBlock(double[] coeff, double[] x, int offset, int N) {
        System.arraycopy(x, offset, coeff, 0, N + 1);
    }

    private static void assignZero(double[] x) {
        for (int i = 0; i < x.length; ++i) {
            x[i] = 0.0;
        }
    }

    public static void normalize(double[][][] tRe, double[][][] tIm, double[][][] uRe, double[][][] uIm, double[][] t0Re, double[][] t0Im, double[][] q0Re, double[][] q0Im, double[] dRe, double[] dIm, double[] pRe, double[] pIm, boolean reverse, boolean neg) {
        if (tRe == uRe) {
            throw new IllegalArgumentException();
        }
        int n = tRe.length;
        int N = tRe[0][0].length - 1;
        int c = !neg ? 0 : N;
        BirkhoffFactorization.extractCoefficient(tRe, tIm, c, t0Re, t0Im);
        Inversion.compute(t0Re, t0Im, q0Re, q0Im, dRe, dIm, pRe, pIm);
        if (!reverse) {
            BirkhoffFactorization.times1(tRe, tIm, q0Re, q0Im, uRe, uIm, pRe, pIm);
        } else {
            BirkhoffFactorization.times1(q0Re, q0Im, tRe, tIm, uRe, uIm, pRe, pIm);
        }
    }

    private static void extractCoefficient(double[][][] bRe, double[][][] bIm, int k, double[][] bkRe, double[][] bkIm) {
        int n = bRe.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                bkRe[i][j] = bRe[i][j][k];
                bkIm[i][j] = bIm[i][j][k];
            }
        }
    }

    private static void times1(double[][][] aRe, double[][][] aIm, double[][] bRe, double[][] bIm, double[][][] cRe, double[][][] cIm, double[] tmpRe, double[] tmpIm) {
        if (aRe == cRe) {
            throw new IllegalArgumentException("a==c");
        }
        int n = aRe.length;
        int deg = aRe[0][0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                VectorOperations.times(aRe[i][0], aIm[i][0], bRe[0][j], bIm[0][j], cRe[i][j], cIm[i][j]);
                for (int k = 1; k < n; ++k) {
                    VectorOperations.times(aRe[i][k], aIm[i][k], bRe[k][j], bIm[k][j], tmpRe, tmpIm);
                    VectorOperations.plus(cRe[i][j], tmpRe, cRe[i][j]);
                    VectorOperations.plus(cIm[i][j], tmpIm, cIm[i][j]);
                }
            }
        }
    }

    private static void times1(double[][] bRe, double[][] bIm, double[][][] aRe, double[][][] aIm, double[][][] cRe, double[][][] cIm, double[] tmpRe, double[] tmpIm) {
        if (aRe == cRe) {
            throw new IllegalArgumentException("a==c");
        }
        int n = aRe.length;
        int deg = aRe[0][0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                VectorOperations.times(aRe[0][j], aIm[0][j], bRe[i][0], bIm[i][0], cRe[i][j], cIm[i][j]);
                for (int k = 1; k < n; ++k) {
                    VectorOperations.times(aRe[k][j], aIm[k][j], bRe[i][k], bIm[i][k], tmpRe, tmpIm);
                    VectorOperations.plus(cRe[i][j], tmpRe, cRe[i][j]);
                    VectorOperations.plus(cIm[i][j], tmpIm, cIm[i][j]);
                }
            }
        }
    }
}

