/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.differentiation;

import de.jtem.numericalMethods.calculus.differentiation.Ridders;
import de.jtem.numericalMethods.calculus.function.RealFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariables;
import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariablesWithGradient;
import de.jtem.numericalMethods.calculus.function.RealVectorValuedFunctionOfSeveralVariables;
import de.jtem.numericalMethods.calculus.function.RealVectorValuedFunctionOfSeveralVariablesWithJacobien;
import java.util.HashMap;

public class NumericalDerivative {
    static final int DEFALUT_MAX_TABLE_LENGTH = 10;

    NumericalDerivative() {
    }

    public static RealVectorValuedFunctionOfSeveralVariablesWithJacobien createDerivativeNumerically(RealVectorValuedFunctionOfSeveralVariables F, double h) {
        return NumericalDerivative.createDerivativeNumerically(F, h, 10, false);
    }

    public static RealVectorValuedFunctionOfSeveralVariablesWithJacobien createDerivativeNumerically(final RealVectorValuedFunctionOfSeveralVariables F, final double h, final int maxTableLength, final boolean hashValues) {
        return new RealVectorValuedFunctionOfSeveralVariablesWithJacobien(){

            @Override
            public void eval(double[] x, double[] values, int offset, double[][] jacobien) {
                F.eval(x, values, offset);
                NumericalDerivative.computeJacobienByRidders(F, x, jacobien, null, h, maxTableLength, hashValues);
            }

            @Override
            public int getDimensionOfTargetSpace() {
                return F.getDimensionOfTargetSpace();
            }

            @Override
            public int getNumberOfVariables() {
                return F.getNumberOfVariables();
            }

            @Override
            public void eval(double[] x, double[] values, int offset) {
                F.eval(x, values, offset);
            }
        };
    }

    public static void computeJacobienByRidders(RealVectorValuedFunctionOfSeveralVariables F, double[] x, double[][] jacobien, double[][] error, double h) {
        NumericalDerivative.computeJacobienByRidders(F, x, jacobien, error, h, 10, false);
    }

    public static void computeJacobienByRidders(RealVectorValuedFunctionOfSeveralVariables F, double[] x, double[][] jacobien, double[][] error, double h, int maxTableLength, boolean hashValues) {
        CoordinateVariableProjection cvp = new CoordinateVariableProjection(F, x, hashValues);
        double[] err = new double[1];
        cvp.variable = 0;
        while (cvp.variable < cvp.numberOfVariables) {
            if (hashValues) {
                cvp.hashMap.clear();
            }
            cvp.coordinate = 0;
            while (cvp.coordinate < cvp.dimensionOfTargetSpace) {
                jacobien[cvp.coordinate][cvp.variable] = Ridders.compute(cvp, 0.0, h, err);
                if (error != null) {
                    error[cvp.coordinate][cvp.variable] = err[0];
                }
                ++cvp.coordinate;
            }
            ++cvp.variable;
        }
    }

    public static RealFunctionOfSeveralVariablesWithGradient createDerivativeNumerically(RealFunctionOfSeveralVariables F, double h) {
        return NumericalDerivative.createDerivativeNumerically(F, h, 10);
    }

    public static RealFunctionOfSeveralVariablesWithGradient createDerivativeNumerically(final RealFunctionOfSeveralVariables F, final double h, final int maxTableLength) {
        return new RealFunctionOfSeveralVariablesWithGradient(){

            @Override
            public double eval(double[] x, double[] grad) {
                NumericalDerivative.computeGradientByRidders(F, x, grad, null, h, maxTableLength);
                return F.eval(x);
            }

            @Override
            public int getNumberOfVariables() {
                return F.getNumberOfVariables();
            }

            @Override
            public double eval(double[] x) {
                return F.eval(x);
            }
        };
    }

    public static void computeGradientByRidders(RealFunctionOfSeveralVariables F, double[] x, double[] grad, double[] error, double h) {
        NumericalDerivative.computeGradientByRidders(F, x, grad, error, h, 10);
    }

    public static void computeGradientByRidders(RealFunctionOfSeveralVariables F, double[] x, double[] grad, double[] error, double h, int maxTableLength) {
        VariableProjection cvp = new VariableProjection(F, x);
        double[] err = new double[1];
        cvp.variable = 0;
        while (cvp.variable < cvp.numberOfVariables) {
            grad[cvp.variable] = Ridders.compute(cvp, 0.0, h, err);
            if (error != null) {
                error[cvp.variable] = err[0];
            }
            ++cvp.variable;
        }
    }

    static class VariableProjection
    implements RealFunctionOfOneVariable {
        final RealFunctionOfSeveralVariables F;
        final int numberOfVariables;
        int variable = 0;
        final double[] x;

        VariableProjection(RealFunctionOfSeveralVariables F, double[] x) {
            this.F = F;
            this.x = x;
            this.numberOfVariables = F.getNumberOfVariables();
        }

        @Override
        public double eval(double t) {
            double xOfVariable = this.x[this.variable];
            int n = this.variable;
            this.x[n] = this.x[n] + t;
            double value = this.F.eval(this.x);
            this.x[this.variable] = xOfVariable;
            return value;
        }
    }

    static class CoordinateVariableProjection
    implements RealFunctionOfOneVariable {
        final RealVectorValuedFunctionOfSeveralVariables F;
        final int numberOfVariables;
        final int dimensionOfTargetSpace;
        int coordinate = 0;
        int variable = 0;
        final double[] x;
        final double[] values;
        final HashMap hashMap;

        CoordinateVariableProjection(RealVectorValuedFunctionOfSeveralVariables F, double[] x, boolean hashValues) {
            this.F = F;
            this.x = x;
            this.hashMap = hashValues ? new HashMap() : null;
            this.numberOfVariables = F.getNumberOfVariables();
            this.dimensionOfTargetSpace = F.getDimensionOfTargetSpace();
            this.values = new double[this.dimensionOfTargetSpace];
        }

        @Override
        public double eval(double t) {
            double[] hashedValues;
            Double T = null;
            if (this.hashMap != null && (hashedValues = (double[])this.hashMap.get(T = new Double(t))) != null) {
                return hashedValues[this.coordinate];
            }
            double xOfVariable = this.x[this.variable];
            int n = this.variable;
            this.x[n] = this.x[n] + t;
            this.F.eval(this.x, this.values, 0);
            this.x[this.variable] = xOfVariable;
            if (this.hashMap != null) {
                this.hashMap.put(T, this.values.clone());
            }
            return this.values[this.coordinate];
        }
    }
}

