/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.differentiation;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfOneVariable;

public class Ridders {
    static final double CON = 1.4;
    static final double CON2 = 1.9599999999999997;
    static final double SAFE = 2.0;

    Ridders() {
    }

    public static double compute(RealFunctionOfOneVariable f, double x, double h, double[] error) {
        return Ridders.compute(f, x, h, 10, error, 0);
    }

    public static double compute(RealFunctionOfOneVariable f, double x, double h, int maxTableLength, double[] error, int errorOffset) {
        double[][] table = new double[maxTableLength][maxTableLength];
        if (h == 0.0) {
            throw new IllegalArgumentException("h must be nonzero.");
        }
        double df = Double.NaN;
        double hh = h;
        table[0][0] = (f.eval(x + hh) - f.eval(x - hh)) / (2.0 * hh);
        double err = Double.MAX_VALUE;
        for (int i = 1; i < maxTableLength; ++i) {
            table[0][i] = (f.eval(x + (hh /= 1.4)) - f.eval(x - hh)) / (2.0 * hh);
            double fac = 1.9599999999999997;
            for (int j = 1; j < i; ++j) {
                table[j][i] = (table[j - 1][i] * fac - table[j - 1][i - 1]) / (fac - 1.0);
                fac = 1.9599999999999997 * fac;
                double errt = Math.max(Math.abs(table[j][i] - table[j - 1][i]), Math.abs(table[j][i] - table[j - 1][i - 1]));
                if (!(errt <= err)) continue;
                err = errt;
                df = table[j][i];
            }
            if (!(Math.abs(table[i][i] - table[i - 1][i - 1]) >= 2.0 * err)) continue;
            if (error != null) {
                error[0] = err;
            }
            return df;
        }
        if (error != null) {
            error[errorOffset] = err;
        }
        return df;
    }
}

