/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.functionApproximation;

import de.jtem.numericalMethods.calculus.functionApproximation.RealFunction;

public class ChebyshevApproximation {
    private ChebyshevApproximation() {
    }

    public static void fit(double[] c, RealFunction f) {
        int n = c.length;
        double twoOverN = 2.0 / (double)n;
        double piOverN = Math.PI / (double)n;
        double[] valueTable = new double[n];
        for (int i = 0; i < n; ++i) {
            valueTable[i] = f.valueAt(Math.cos(piOverN * ((double)i + 0.5)));
        }
        for (int j = 0; j < n; ++j) {
            double sum = 0.0;
            for (int i = 0; i < n; ++i) {
                sum += valueTable[i] * Math.cos(piOverN * (double)j * ((double)i + 0.5));
            }
            c[j] = twoOverN * sum;
        }
    }

    public static double evaluate(double[] c, double x) throws IllegalArgumentException {
        if (x < -1.0 || x > 1.0) {
            throw new IllegalArgumentException("Argument x = " + x + " not in range: " + "-1.0 <= x <= 1.0 expected.");
        }
        double a = 0.0;
        double b = 0.0;
        for (int i = c.length - 1; i >= 0; --i) {
            double bNew = c[i] - a;
            a = 2.0 * x * a + b;
            b = bNew;
        }
        return a * x + b - c[0] / 2.0;
    }

    public static void integrate(double[] c, double[] cInt) {
        ChebyshevApproximation.integrate(c, cInt, 1.0);
    }

    public static void integrate(double[] c, double[] cInt, double factor) throws IllegalArgumentException {
        int n = c.length;
        if (cInt.length != n) {
            throw new IllegalArgumentException("Incompatible Arguments: c.length == cInt.length expected.");
        }
        double factorHalf = 0.5 * factor;
        for (int i = 1; i < n - 1; ++i) {
            cInt[i] = factorHalf * (c[i - 1] - c[i + 1]) / (double)i;
        }
        cInt[n - 1] = factorHalf * c[n - 2] / (double)(n - 1);
        cInt[0] = cInt[0] - 2.0 * ChebyshevApproximation.evaluate(cInt, 0.0);
    }

    public static void divideByX(double[] c) {
        int i;
        double cIPlusTwo = 0.0;
        double cIPlusOne = 0.0;
        for (i = c.length - 1; i > 0; --i) {
            c[i] = 2.0 * c[i] - cIPlusTwo;
            cIPlusTwo = cIPlusOne;
            cIPlusOne = c[i];
        }
        for (i = 0; i < c.length - 1; ++i) {
            c[i] = c[i + 1];
        }
        c[c.length - 1] = 0.0;
    }
}

