/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.functionApproximation.bestFitting;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariablesWithGradient;
import de.jtem.numericalMethods.calculus.functionApproximation.bestFitting.BasisFunction;
import de.jtem.numericalMethods.calculus.functionApproximation.bestFitting.LinearFunctionSpaceElement;
import de.jtem.numericalMethods.calculus.functionApproximation.bestFitting.Sample;
import de.jtem.numericalMethods.calculus.minimizing.ConjugateGradient;

public class LinearFunctionSpace {
    BasisFunction[][] f;
    public final int n;
    public final int m;
    public final int dim;
    double[][] c;

    LinearFunctionSpace(BasisFunction[][] f) {
        this.f = f;
        this.n = f[0][0].getNumberOfVariables();
        this.m = f[0].length;
        this.dim = f.length;
        this.c = new double[this.dim][this.m];
    }

    public int getDimension() {
        return this.m * this.dim;
    }

    void eval(double[] x, double[] parameter, double[] u) {
        this.eval(x, parameter, u, this.c);
    }

    void eval(double[] x, double[] parameter, double[] u, double[][] c) {
        for (int j = 0; j < this.m; ++j) {
            u[j] = 0.0;
        }
        int k = 0;
        for (int i = 0; i < this.dim; ++i) {
            int j = 0;
            while (j < this.m) {
                double f_ij;
                c[i][j] = f_ij = this.f[i][j].eval(x);
                int n = j++;
                u[n] = u[n] + parameter[k] * f_ij;
                ++k;
            }
        }
    }

    public LinearFunctionSpaceElement searchForBestFit(double[] startParameter, Sample[] samples, double tol, int maxNumberOfSteps) {
        LinearFunctionSpaceElement best = new LinearFunctionSpaceElement(this);
        Energy energy = new Energy(samples);
        ConjugateGradient.search(best.coefficient, tol, energy, maxNumberOfSteps, false, null);
        return best;
    }

    public LinearFunctionSpaceElement searchForBestFit(LinearFunctionSpaceElement start, Sample[] samples, double tol, int maxNumberOfSteps) {
        return this.searchForBestFit(start, samples, tol, maxNumberOfSteps, 0);
    }

    public LinearFunctionSpaceElement searchForBestFit(LinearFunctionSpaceElement start, Sample[] samples, double tol, int maxNumberOfSteps, int numberOfDimensionsBeingFixed) {
        LinearFunctionSpaceElement best = new LinearFunctionSpaceElement(this, start.getCoefficients());
        Energy energy = new Energy(samples, numberOfDimensionsBeingFixed);
        ConjugateGradient.search(best.coefficient, tol, energy, maxNumberOfSteps, false, null);
        return best;
    }

    public LinearFunctionSpaceElement searchForBestFit(Sample[] samples, double tol, int maxNumberOfSteps) {
        return this.searchForBestFit(new LinearFunctionSpaceElement(this), samples, tol, maxNumberOfSteps);
    }

    class Energy
    implements RealFunctionOfSeveralVariablesWithGradient {
        final Sample[] samples;
        final double[] y;
        final int numberOfDimensionBeingFixed;

        Energy(Sample[] samples, int numberOfDimensionBeingFixed) {
            this.samples = samples;
            this.numberOfDimensionBeingFixed = numberOfDimensionBeingFixed;
            this.y = new double[LinearFunctionSpace.this.m];
        }

        Energy(Sample[] samples) {
            this(samples, 0);
        }

        final double absSqr(double[] u) {
            double uu = 0.0;
            for (int i = 0; i < LinearFunctionSpace.this.m; ++i) {
                uu += u[i] * u[i];
            }
            return uu;
        }

        @Override
        public double eval(double[] parameter, double[] gradient) {
            double energy = 0.0;
            if (gradient != null) {
                for (int j = 0; j < LinearFunctionSpace.this.m * LinearFunctionSpace.this.dim; ++j) {
                    gradient[j] = 0.0;
                }
            }
            for (int i = 0; i < this.samples.length; ++i) {
                int j;
                Sample sample = this.samples[i];
                LinearFunctionSpace.this.eval(sample.x, parameter, this.y, LinearFunctionSpace.this.c);
                for (j = 0; j < LinearFunctionSpace.this.m; ++j) {
                    int n = j;
                    this.y[n] = this.y[n] - sample.y[j];
                }
                if (gradient != null) {
                    int l = LinearFunctionSpace.this.m * this.numberOfDimensionBeingFixed;
                    for (j = this.numberOfDimensionBeingFixed; j < LinearFunctionSpace.this.dim; ++j) {
                        for (int k = 0; k < LinearFunctionSpace.this.m; ++k) {
                            int n = l++;
                            gradient[n] = gradient[n] + LinearFunctionSpace.this.c[j][k] * this.y[k] * sample.weight;
                        }
                    }
                }
                energy += this.absSqr(this.y) * sample.weight;
            }
            return energy / 2.0;
        }

        @Override
        public double eval(double[] parameter) {
            return this.eval(parameter, null);
        }

        @Override
        public int getNumberOfVariables() {
            return LinearFunctionSpace.this.getDimension();
        }
    }
}

