/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.functionApproximation.bestFitting;

import de.jtem.numericalMethods.calculus.functionApproximation.bestFitting.BasisFunction;
import java.util.Arrays;

public class Monomial
implements BasisFunction {
    final int[] index;
    final int order;
    final int numberOfVariables;
    final double coeff;

    Monomial(int[] index, int numberOfVariables) {
        this(index, numberOfVariables, 1.0);
    }

    Monomial(int[] index, int numberOfVariables, double coeff) {
        this.index = (int[])index.clone();
        Arrays.sort(this.index);
        this.order = index.length;
        this.numberOfVariables = numberOfVariables;
        this.coeff = coeff;
    }

    private static int[] index(int[] k) {
        int order = 0;
        for (int i = 0; i < k.length; ++i) {
            order += k[i];
        }
        int[] index = new int[order];
        int l = 0;
        for (int i = 0; i < k.length; ++i) {
            int j = 0;
            while (j < k[i]) {
                index[l] = i;
                ++j;
                ++l;
            }
        }
        return index;
    }

    private static int order(int[] k) {
        int order = 0;
        for (int i = 0; i < k.length; ++i) {
            order += k[i];
        }
        return order;
    }

    public int order(int k) {
        int order = 0;
        for (int i = 0; i < this.index.length; ++i) {
            if (this.index[i] != k) continue;
            ++order;
        }
        return order;
    }

    @Override
    public BasisFunction getPartialDerivative(int k) {
        int parcialOrder = this.order(k);
        if (parcialOrder == 0) {
            return new Monomial(new int[0], this.numberOfVariables, 0.0);
        }
        int[] indexOfDerivative = new int[this.index.length - 1];
        int i = 0;
        while (this.index[i] != k) {
            indexOfDerivative[i] = this.index[i];
            ++i;
        }
        ++i;
        while (i < this.index.length) {
            indexOfDerivative[i - 1] = this.index[i];
            ++i;
        }
        return new Monomial(indexOfDerivative, this.numberOfVariables, this.coeff * (double)parcialOrder);
    }

    public String toString() {
        if (this.order == 0) {
            return new Double(this.coeff).toString();
        }
        StringBuffer sb = new StringBuffer(300);
        if (this.coeff != 1.0) {
            sb.append(" " + this.coeff + " *");
        }
        sb.append(" x[" + this.index[0] + "]");
        for (int i = 1; i < this.index.length; ++i) {
            sb.append(" * x[" + this.index[i] + "]");
        }
        return sb.toString();
    }

    @Override
    public double eval(double[] x) {
        double result = this.coeff;
        for (int i = 0; i < this.order; ++i) {
            result *= x[i];
        }
        return result;
    }

    @Override
    public int getNumberOfVariables() {
        return this.numberOfVariables;
    }

    public boolean equals(Monomial other) {
        if (this.numberOfVariables != other.numberOfVariables || this.order != other.order) {
            return false;
        }
        for (int i = 0; i < this.order; ++i) {
            if (this.index[i] == other.index[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        try {
            return this.equals((Monomial)other);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public static Monomial create(int[] k) {
        return new Monomial(Monomial.index(k), k.length);
    }

    @Override
    public boolean isZero() {
        return this.coeff == 0.0;
    }

    public static class Cubic
    extends Monomial {
        final int i0;
        final int i1;
        final int i2;

        public Cubic(int i0, int i1, int i2, int numberOfVariables) {
            super(new int[]{i0, i1, i2}, numberOfVariables);
            this.i0 = i0;
            this.i1 = i1;
            this.i2 = i2;
        }

        @Override
        public double eval(double[] x) {
            return x[this.i0] * x[this.i1] * x[this.i2];
        }
    }

    public static class Quadratic
    extends Monomial {
        final int i0;
        final int i1;

        public Quadratic(int i0, int i1, int numberOfVariables) {
            super(new int[]{i0, i1}, numberOfVariables);
            this.i0 = i0;
            this.i1 = i1;
        }

        @Override
        public double eval(double[] x) {
            return x[this.i0] * x[this.i1];
        }
    }

    public static class Linear
    extends Monomial {
        final int i0;

        public Linear(int i0, int numberOfVariables) {
            super(new int[]{i0}, numberOfVariables);
            this.i0 = i0;
        }

        @Override
        public double eval(double[] x) {
            return x[this.i0];
        }
    }

    public static class Constant
    extends Monomial {
        public Constant(int numberOfVariables) {
            super(new int[0], numberOfVariables);
        }

        @Override
        public double eval(double[] x) {
            return 1.0;
        }
    }
}

