/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.interpolation;

import de.jtem.numericalMethods.algebra.linear.VectorOperations;
import de.jtem.numericalMethods.util.ArrayUtilities;
import java.io.Serializable;

public class CubicBSpline
implements Serializable {
    double[] x;
    double[] y;
    double[] ddy;
    double[] a;
    double[] b;
    double[] c;
    double[] r;
    int n;
    int N;
    int klo;
    int khi;
    double[] tmp1;
    double[] tmp2;
    double[] tmp3;
    double[] tmp4;
    double[] tmp5;

    private CubicBSpline() {
    }

    private CubicBSpline(double[] x, double[] y) {
        if (y.length != x.length) {
            throw new IllegalArgumentException("length of arrays must coinside");
        }
        if (y.length < 2) {
            throw new IllegalArgumentException("length of arrays must be bigger then 1");
        }
        this.x = ArrayUtilities.copy(x, null);
        this.y = ArrayUtilities.copy(y, null);
    }

    void compute() {
        int i;
        if (this.ddy == null || this.ddy.length != this.y.length) {
            this.ddy = new double[this.y.length];
        }
        if (this.a == null || this.a.length != this.N) {
            this.a = new double[this.N];
            this.b = new double[this.N];
            this.c = new double[this.N];
            this.r = new double[this.N];
            VectorOperations.assign(this.b, 2.0);
        }
        for (i = 1; i < this.n - 1; ++i) {
            this.a[i] = this.mu(i);
        }
        for (i = 1; i < this.N - 1; ++i) {
            this.c[i] = this.lambda(i);
        }
        for (i = 1; i < this.n - 1; ++i) {
            this.r[i] = this.d(i);
        }
    }

    final double h(int j) {
        return this.x[j] - this.x[j - 1];
    }

    final double d(int j) {
        int k = j + 1;
        double h_j = this.h(j);
        double h_k = this.h(k);
        return 6.0 / (h_j + h_k) * ((this.y[k] - this.y[j]) / h_k - (this.y[j] - this.y[j - 1]) / h_j);
    }

    final double lambda(int j) {
        int k = j + 1;
        double h_j = this.h(j);
        double h_k = this.h(k);
        return h_k / (h_j + h_k);
    }

    final double mu(int j) {
        int k = j + 1;
        double h_j = this.h(j);
        double h_k = this.h(k);
        return h_j / (h_j + h_k);
    }

    private final void searchInterval(double X) {
        this.klo = 0;
        this.khi = this.n - 1;
        while (this.khi - this.klo > 1) {
            int k = this.khi + this.klo >> 1;
            if (this.x[k] > X) {
                this.khi = k;
                continue;
            }
            this.klo = k;
        }
    }

    public double valueAt(double x) {
        return this.valueAt(x, 0);
    }

    public double valueAt(double X, int derivative) {
        this.searchInterval(X);
        double h = this.x[this.khi] - this.x[this.klo];
        if (h == 0.0) {
            throw new RuntimeException();
        }
        double a = (this.x[this.khi] - X) / h;
        double b = (X - this.x[this.klo]) / h;
        switch (derivative) {
            case 0: {
                return a * this.y[this.klo] + b * this.y[this.khi] + ((a * a * a - a) * this.ddy[this.klo] + (b * b * b - b) * this.ddy[this.khi]) * (h * h) / 6.0;
            }
            case 1: {
                return (this.y[this.khi] - this.y[this.klo]) / h - ((3.0 * a * a - 1.0) * this.ddy[this.klo] - (3.0 * b * b - 1.0) * this.ddy[this.khi]) * h / 6.0;
            }
            case 2: {
                return a * this.ddy[this.klo] + b * this.ddy[this.khi];
            }
        }
        return 0.0;
    }

    public int getLengthOfTable() {
        return this.n;
    }

    public double[] getX() {
        return (double[])this.x.clone();
    }

    public double getX(int index) {
        return this.x[index];
    }

    public double getY(int index) {
        return this.y[index];
    }

    public double[] getY() {
        return (double[])this.y.clone();
    }

    public double[] getDDY() {
        return (double[])this.ddy.clone();
    }

    public void setX(double[] x) {
        if (x.length != this.n) {
            throw new IllegalArgumentException("x array has wrong size");
        }
        if (ArrayUtilities.equal(this.x, x)) {
            return;
        }
        this.x = ArrayUtilities.copy(x, this.x);
        this.compute();
    }

    public void setY(double[] y) {
        if (y.length != this.n) {
            throw new IllegalArgumentException("y array has wrong size");
        }
        if (ArrayUtilities.equal(this.y, y)) {
            return;
        }
        this.y = ArrayUtilities.copy(y, this.y);
        this.compute();
    }

    public void setXY(int index, double X, double Y) {
        if (index != 0 && this.x[index - 1] >= X) {
            throw new IllegalArgumentException("x value in wrong range. It must hold: x[index-1] < x < x[index+1]");
        }
        if (index != this.n - 1 && X >= this.x[index + 1]) {
            throw new IllegalArgumentException("x value in wrong range. It must hold: x[index-1] < x < x[index+1]");
        }
        if (this.x[index] == X && this.y[index] == Y) {
            return;
        }
        this.x[index] = X;
        this.y[index] = Y;
        this.compute();
    }

    public int getIndexOfClosestXValue(double X) {
        if (X <= this.x[0]) {
            return 0;
        }
        if (X >= this.x[this.n - 1]) {
            return this.n - 1;
        }
        int klo = 0;
        int khi = this.n - 1;
        while (khi - klo > 1) {
            int k = khi + klo >> 1;
            if (this.x[k] > X) {
                khi = k;
                continue;
            }
            klo = k;
        }
        return X - this.x[klo] < this.x[khi] - X ? klo : khi;
    }

    public void setXY(double[] x, double[] y) {
        if (y.length != x.length) {
            throw new IllegalArgumentException("length of arrays must coinside");
        }
        if (y.length < 2) {
            throw new IllegalArgumentException("length of arrays must be bigger then 1");
        }
        if (ArrayUtilities.equal(this.y, y)) {
            if (ArrayUtilities.equal(this.x, x)) {
                return;
            }
            this.x = ArrayUtilities.copy(x, this.x);
        } else {
            this.x = ArrayUtilities.copy(x, this.x);
            this.y = ArrayUtilities.copy(y, this.y);
        }
        this.compute();
    }

    void tridag(double[] a, double[] b, double[] c, double[] r, double[] x) {
        if (this.tmp5 == null || this.tmp5.length != a.length) {
            this.tmp5 = new double[a.length];
        }
        this.tridag(a, b, c, r, x, this.tmp5);
    }

    void tridag(double[] a, double[] b, double[] c, double[] r, double[] x, double[] tmp) {
        int j;
        int n = a.length;
        double[] gam = tmp;
        if (b[0] == 0.0) {
            throw new RuntimeException("tridiag not diagonal dominant");
        }
        double bet = b[0];
        x[0] = r[0] / bet;
        for (j = 1; j < n; ++j) {
            gam[j] = c[j - 1] / bet;
            bet = b[j] - a[j] * gam[j];
            if (bet == 0.0) {
                throw new RuntimeException("tridiag not diagonal dominant");
            }
            x[j] = (r[j] - a[j] * x[j - 1]) / bet;
        }
        for (j = n - 2; j >= 0; --j) {
            int n2 = j;
            x[n2] = x[n2] - gam[j + 1] * x[j + 1];
        }
    }

    void cyclic(double[] a, double[] b, double[] c, double alpha, double beta, double[] r, double[] x) {
        if (this.tmp1 == null || this.tmp1.length != a.length) {
            this.tmp1 = new double[a.length];
            this.tmp2 = new double[a.length];
            this.tmp3 = new double[a.length];
            this.tmp4 = new double[a.length];
        }
        this.cyclic(a, b, c, alpha, beta, r, x, this.tmp1, this.tmp2, this.tmp3, this.tmp4);
    }

    void cyclic(double[] a, double[] b, double[] c, double alpha, double beta, double[] r, double[] x, double[] tmp1, double[] tmp2, double[] tmp3, double[] tmp4) {
        int i;
        int n = a.length;
        double[] bb = tmp1;
        double[] u = tmp2;
        double[] z = tmp3;
        if (n <= 2) {
            new IllegalArgumentException("n too small in cyclic");
        }
        double gamma = -b[0];
        bb[0] = b[0] - gamma;
        bb[n - 1] = b[n - 1] - alpha * beta / gamma;
        for (i = 1; i < n - 1; ++i) {
            bb[i] = b[i];
        }
        this.tridag(a, bb, c, r, x, tmp4);
        u[0] = gamma;
        u[n - 1] = alpha;
        for (i = 1; i < n - 1; ++i) {
            u[i] = 0.0;
        }
        this.tridag(a, bb, c, u, z, tmp4);
        double fact = (x[0] + beta * x[n - 1] / gamma) / (1.0 + z[0] + beta * z[n - 1] / gamma);
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = i2;
            x[n2] = x[n2] - fact * z[i2];
        }
    }

    public static class Periodic
    extends CubicBSpline {
        public Periodic(double[] x, double[] y) {
            super(x, y);
            this.compute();
        }

        @Override
        public void compute() {
            double mu0;
            this.n = this.y.length;
            this.N = this.n - 1;
            super.compute();
            double lambda0 = this.h(1) / (this.h(1) + this.h(this.N));
            double beta = mu0 = 1.0 - lambda0;
            double alpha = this.lambda(this.N - 1);
            this.c[0] = lambda0;
            this.r[0] = 6.0 / (this.h(1) + this.h(this.N)) * ((this.y[1] - this.y[0]) / this.h(1) - (this.y[this.N] - this.y[this.N - 1]) / this.h(this.N));
            this.cyclic(this.a, this.b, this.c, alpha, beta, this.r, this.ddy);
            this.ddy[this.N] = this.ddy[0];
        }
    }

    public static class Natural
    extends CubicBSpline {
        public Natural(double[] x, double[] y) {
            super(x, y);
            this.compute();
        }

        @Override
        public void compute() {
            this.n = this.N = this.y.length;
            super.compute();
            this.a[this.n - 1] = 0.0;
            this.c[0] = 0.0;
            this.r[this.n - 1] = 0.0;
            this.r[0] = 0.0;
            this.tridag(this.a, this.b, this.c, this.r, this.ddy);
        }
    }

    public static class Default
    extends CubicBSpline {
        double dYInFirstX = 0.0;
        double dYInLastX = 0.0;

        public Default(double[] x, double[] y, double dYInFirstX, double dYInLastX) {
            super(x, y);
            this.dYInFirstX = dYInFirstX;
            this.dYInLastX = dYInLastX;
            this.compute();
        }

        public Default(double[] x, double[] y) {
            this(x, y, 0.0, 0.0);
        }

        public double getDYInFirstX() {
            return this.dYInFirstX;
        }

        public void setDYInFirstX(double derivative) {
            if (this.dYInFirstX == derivative) {
                return;
            }
            this.dYInFirstX = derivative;
            this.compute();
        }

        public double getDYInLastX() {
            return this.dYInLastX;
        }

        public void setDYInLastX(double derivative) {
            if (this.dYInLastX == derivative) {
                return;
            }
            this.dYInLastX = derivative;
            this.compute();
        }

        @Override
        void compute() {
            this.n = this.N = this.y.length;
            super.compute();
            this.a[this.n - 1] = 1.0;
            this.c[0] = 1.0;
            this.r[0] = 6.0 / this.h(1) * ((this.y[1] - this.y[0]) / this.h(1) - this.dYInFirstX);
            this.r[this.n - 1] = -6.0 / this.h(this.n - 1) * ((this.y[this.n - 1] - this.y[this.n - 2]) / this.h(this.n - 1) - this.dYInLastX);
            this.tridag(this.a, this.b, this.c, this.r, this.ddy);
        }
    }
}

