/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.minimizing;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariablesWithGradient;
import de.jtem.numericalMethods.calculus.minimizing.Braket;
import de.jtem.numericalMethods.calculus.minimizing.DBrent;
import de.jtem.numericalMethods.calculus.minimizing.Line;
import de.jtem.numericalMethods.calculus.minimizing.MinimizingOnLine;
import de.jtem.numericalMethods.calculus.minimizing.RealDerivativeOnLine;
import java.io.Serializable;

public class DBrentOnLine
extends MinimizingOnLine
implements Serializable {
    private static final long serialVersionUID = 1L;
    final RealDerivativeOnLine dg;

    public DBrentOnLine(Line line, RealFunctionOfSeveralVariablesWithGradient f) {
        super(line, f);
        this.dg = new RealDerivativeOnLine(line, f);
    }

    public DBrentOnLine(double[] point, double[] direction, RealFunctionOfSeveralVariablesWithGradient f) {
        this(new Line(point, direction), f);
    }

    @Override
    public final double search(double tol) {
        this.abc[0] = -1.0;
        this.abc[1] = 0.0;
        this.abc[2] = 1.0;
        Braket.search(this.abc, this.valuesAtABC, this.g);
        DBrent.search(this.abc, this.result, this.g, this.dg, tol);
        double xmin = this.result[0];
        int j = 0;
        while (j < this.line.n) {
            int n = j;
            int n2 = j++;
            double d = this.line.direction[n2] * xmin;
            this.line.direction[n2] = d;
            this.line.point[n] = this.line.point[n] + d;
        }
        return this.result[1];
    }
}

