/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.minimizing;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariables;
import de.jtem.numericalMethods.calculus.minimizing.Info;

public final class NelderMead {
    private static final long serialVersionUID = 1L;
    static int ITMAX = 200;
    static double rho = 1.0;
    static double chi = 2.0;
    static double gamma = 0.5;
    static double sigma = 0.5;

    public static int getITMAX() {
        return ITMAX;
    }

    public static void setITMAX(int v) {
        ITMAX = v;
    }

    public static double[][] getStandardBasis(int dim) {
        double[][] basis = new double[dim][dim];
        for (int i = 0; i < dim; ++i) {
            basis[i][i] = 1.0;
        }
        return basis;
    }

    public static final double search(double[] p, double ftol, RealFunctionOfSeveralVariables f) {
        return NelderMead.search(p, NelderMead.getStandardBasis(p.length), ftol, f, ITMAX, null);
    }

    public static final double search(double[] p, double ftol, int maxIteration, RealFunctionOfSeveralVariables f) {
        return NelderMead.search(p, NelderMead.getStandardBasis(p.length), ftol, f, maxIteration, null);
    }

    public static final double search(double[] p, double ftol, int maxIteration, RealFunctionOfSeveralVariables f, Info info) {
        return NelderMead.search(p, NelderMead.getStandardBasis(p.length), ftol, f, maxIteration, info);
    }

    public static double search(double[] p, double[][] xi, double ftol, RealFunctionOfSeveralVariables f, int itMax, Info info) {
        String action = "";
        int numberOfVariables = f.getNumberOfVariables();
        if (p.length == numberOfVariables) {
            int i;
            int i2;
            int iteration = 0;
            double[][] vertices = new double[numberOfVariables + 1][numberOfVariables];
            double[] evaluation = new double[numberOfVariables + 1];
            double[] meanVertex = new double[numberOfVariables];
            double[] reflected = new double[numberOfVariables];
            double[] expanded = new double[numberOfVariables];
            double[] contracted = new double[numberOfVariables];
            double evReflected = 0.0;
            double evExpanded = 0.0;
            double evContracted = 0.0;
            for (int j = 0; j < numberOfVariables; ++j) {
                vertices[0][j] = p[j];
            }
            for (i2 = 0; i2 < numberOfVariables; ++i2) {
                for (int j = 0; j < numberOfVariables; ++j) {
                    vertices[i2 + 1][j] = p[j];
                }
                if (vertices[i2 + 1][i2] == 0.0) {
                    double[] dArray = vertices[i2 + 1];
                    int n = i2;
                    dArray[n] = dArray[n] + 2.5E-4 * xi[i2][i2];
                    continue;
                }
                double[] dArray = vertices[i2 + 1];
                int n = i2;
                dArray[n] = dArray[n] * (1.0 + 0.05 * xi[i2][i2]);
            }
            for (i2 = 0; i2 < numberOfVariables + 1; ++i2) {
                evaluation[i2] = f.eval(vertices[i2]);
            }
            if (info != null) {
                String s = new String(" f(p) = " + evaluation[0] + " , p = ");
                for (i = 0; i < vertices[0].length; ++i) {
                    s = s + vertices[0][i] + " ";
                }
                info.setMessage(s);
                info.setMaxIter(itMax);
            }
            NelderMead.order(vertices, evaluation);
            while (Math.abs(evaluation[numberOfVariables] - evaluation[0]) > ftol && iteration++ < itMax && NelderMead.sizeMax(vertices) > ftol * ftol) {
                int i3;
                NelderMead.updateMeanVertex(meanVertex, vertices, numberOfVariables);
                for (i3 = 0; i3 < numberOfVariables; ++i3) {
                    reflected[i3] = (1.0 + rho) * meanVertex[i3] - rho * vertices[numberOfVariables][i3];
                }
                evReflected = f.eval(reflected);
                if (evReflected < evaluation[0]) {
                    for (i3 = 0; i3 < numberOfVariables; ++i3) {
                        expanded[i3] = (1.0 + rho * chi) * meanVertex[i3] - rho * chi * vertices[numberOfVariables][i3];
                    }
                    evExpanded = f.eval(expanded);
                    if (evExpanded < evReflected) {
                        for (i3 = 0; i3 < numberOfVariables; ++i3) {
                            vertices[numberOfVariables][i3] = expanded[i3];
                        }
                        evaluation[numberOfVariables] = evExpanded;
                        action = "Expand";
                    } else {
                        for (i3 = 0; i3 < numberOfVariables; ++i3) {
                            vertices[numberOfVariables][i3] = reflected[i3];
                        }
                        evaluation[numberOfVariables] = evReflected;
                        action = "Reflection";
                    }
                } else if (evReflected >= evaluation[numberOfVariables - 1]) {
                    if (evReflected < evaluation[numberOfVariables]) {
                        for (i3 = 0; i3 < numberOfVariables; ++i3) {
                            contracted[i3] = (1.0 + rho * gamma) * meanVertex[i3] - rho * gamma * vertices[numberOfVariables][i3];
                        }
                        evContracted = f.eval(contracted);
                        if (evContracted <= evReflected) {
                            for (i3 = 0; i3 < numberOfVariables; ++i3) {
                                vertices[numberOfVariables][i3] = contracted[i3];
                            }
                            evaluation[numberOfVariables] = evContracted;
                            action = "Outside Contraction";
                        } else {
                            NelderMead.shrink(vertices, evaluation, f);
                            action = "Shrink";
                        }
                    } else {
                        for (i3 = 0; i3 < numberOfVariables; ++i3) {
                            contracted[i3] = (1.0 - gamma) * meanVertex[i3] + gamma * vertices[numberOfVariables][i3];
                        }
                        evContracted = f.eval(contracted);
                        if (evContracted < evReflected) {
                            for (i3 = 0; i3 < numberOfVariables; ++i3) {
                                vertices[numberOfVariables][i3] = contracted[i3];
                            }
                            evaluation[numberOfVariables] = evContracted;
                            action = "Inside contraction";
                        } else {
                            NelderMead.shrink(vertices, evaluation, f);
                            action = "Shrink";
                        }
                    }
                } else {
                    for (i3 = 0; i3 < numberOfVariables; ++i3) {
                        vertices[numberOfVariables][i3] = reflected[i3];
                    }
                    evaluation[numberOfVariables] = evReflected;
                    action = "Reflection";
                }
                if (info != null) {
                    String s = new String("iter = " + iteration + ", action = " + action + ", fp = " + evaluation[0] + ", p = ");
                    for (i = 0; i < vertices[0].length; ++i) {
                        s = s + vertices[0][i] + " ";
                    }
                    info.addMessage(s);
                }
                NelderMead.order(vertices, evaluation);
            }
            if (Math.abs(evaluation[numberOfVariables] - evaluation[0]) <= ftol && info != null) {
                info.setCurrentIter(iteration);
                info.printDebug();
            }
            if (info != null && iteration >= itMax) {
                info.setCurrentIter(iteration);
                info.setMessage("Too many iterations in routine Nelder-Mead simplex");
                info.printDebug();
            }
            for (int i4 = 0; i4 < p.length; ++i4) {
                p[i4] = vertices[0][i4];
            }
            return evaluation[0];
        }
        System.out.println("Uncompatible number of parameters and initial point");
        return Double.NaN;
    }

    private static void order(double[][] x, double[] y) {
        double tmp = 0.0;
        for (int i = 1; i < y.length; ++i) {
            int j = i;
            while (j > 0) {
                if (y[j] < y[j - 1]) {
                    tmp = y[j];
                    y[j] = y[j - 1];
                    y[j - 1] = tmp;
                    for (int k = 0; k < x[0].length; ++k) {
                        tmp = x[j][k];
                        x[j][k] = x[j - 1][k];
                        x[j - 1][k] = tmp;
                    }
                    --j;
                    continue;
                }
                j = 0;
            }
        }
    }

    private static void updateMeanVertex(double[] mean, double[][] samples, int variables) {
        int i = 0;
        while (i < variables) {
            mean[i] = 0.0;
            for (int j = 0; j < variables; ++j) {
                int n = i;
                mean[n] = mean[n] + samples[j][i];
            }
            int n = i++;
            mean[n] = mean[n] / (double)variables;
        }
    }

    private static void shrink(double[][] samples, double[] functions, RealFunctionOfSeveralVariables f) {
        NelderMead.order(samples, functions);
        for (int i = 1; i < samples.length; ++i) {
            for (int j = 0; j < samples[0].length; ++j) {
                samples[i][j] = (1.0 - sigma) * samples[0][j] + sigma * samples[i][j];
            }
            functions[i] = f.eval(samples[i]);
        }
        NelderMead.order(samples, functions);
    }

    private static double sizeMax(double[][] vertices) {
        double size = 0.0;
        for (int i = 0; i < vertices[0].length; ++i) {
            size += (vertices[0][i] - vertices[vertices.length - 1][i]) * (vertices[0][i] - vertices[vertices.length - 1][i]);
        }
        return size;
    }

    private static double norm2(double[] vector) {
        double norm = 0.0;
        for (int i = 0; i < vector.length; ++i) {
            norm += vector[i] * vector[i];
        }
        return norm;
    }
}

