/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.minimizing;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariablesWithGradient;
import de.jtem.numericalMethods.calculus.minimizing.BrentOnLine;
import de.jtem.numericalMethods.calculus.minimizing.DBrentOnLine;
import de.jtem.numericalMethods.calculus.minimizing.Info;
import de.jtem.numericalMethods.calculus.minimizing.MinimizingOnLine;
import java.io.Serializable;

public final class SteepestDescent
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final double CGOLD = 0.381966;
    static int ITMAX = 100;
    static final double EPS = 1.0E-10;
    static int iter;
    private static boolean useDBrent;

    public static int getITMAX() {
        return ITMAX;
    }

    public static void setITMAX(int v) {
        ITMAX = v;
    }

    public static int getIter() {
        return iter;
    }

    public static boolean getUseDBrent() {
        return useDBrent;
    }

    public static void setUseDBrent(boolean v) {
        useDBrent = v;
    }

    public static double search(double[] p, double ftol, RealFunctionOfSeveralVariablesWithGradient f) {
        return SteepestDescent.search(p, ftol, f, ITMAX, null);
    }

    public static double search(double[] p, double ftol, RealFunctionOfSeveralVariablesWithGradient f, int itMax, Info info) {
        if (itMax < 1) {
            throw new IllegalArgumentException("itMax must be positive!");
        }
        int n = p.length;
        double[] g = new double[n];
        double[] xi = new double[n];
        MinimizingOnLine minimizingOnLine = useDBrent ? new DBrentOnLine(p, xi, f) : new BrentOnLine(p, xi, f);
        if (info != null) {
            info.setMaxIter(itMax);
        }
        double fret = -1.0;
        for (int its = 0; its < itMax; ++its) {
            double fp;
            iter = its;
            fret = fp = f.eval(p, g);
            double gg = 0.0;
            for (int j = 0; j < n; ++j) {
                gg += g[j] * g[j];
            }
            if (gg == 0.0) {
                if (info != null) {
                    info.setCurrentIter(iter);
                }
                return fret;
            }
            double absOfG = Math.sqrt(gg);
            for (int j = 0; j < n; ++j) {
                xi[j] = -g[j] / absOfG;
            }
            fret = minimizingOnLine.search(2.0E-8);
            if (!(2.0 * Math.abs(fret - fp) <= ftol * (Math.abs(fret) + Math.abs(fp) + 1.0E-10))) continue;
            if (info != null) {
                String s = new String("iter = " + iter + ", fret = " + fret + ", fp = " + fp + ", p = ");
                for (int i = 0; i < n; ++i) {
                    s = s + p[i] + " ";
                }
                info.addMessage(s);
                info.setCurrentIter(iter);
                info.printDebug();
            }
            return fret;
        }
        if (info != null) {
            info.setMessage("Too many iterations in FRPRMN\n");
            info.setCurrentIter(itMax);
            info.printDebug();
        }
        return fret;
    }

    static {
        useDBrent = false;
    }
}

