/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.odeSolving;

import de.jtem.numericalMethods.calculus.odeSolving.ODE;
import de.jtem.numericalMethods.calculus.odeSolving.ODEIntermediateResultListener;
import de.jtem.numericalMethods.calculus.odeSolving.OdeSolver;
import java.io.Serializable;

public final class Extrap
implements OdeSolver,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private int KM;
    private int numOfEquations;
    private double absTol = 1.0E-7;
    private double relTol = 1.0E-7;
    private double[] WORK;
    private int[] IWORK;
    private double[] DY;
    private double[] YH1;
    private double[] YH2;
    private double[] DZ;
    private double[] SCAL;
    private double[] HH;
    private double[] W;
    private double[] A;
    private double[] ERRFAC;
    private double[][] T;
    private int[] NJ;
    private int[] IPOINT;
    private double SAFE1;
    private double SAFE2;
    private double SAFE3;
    private double FAC1;
    private double FAC2;
    private double FAC3;
    private double FAC4;
    private double UROUND;
    private double HMAX;
    private double ERR;
    private double FAC;
    private double ERROLD;
    private int NFCN;
    private int NSTEP;
    private int NACCPT;
    private int NREJCT;
    private int NMAX;
    private int MUDIF;
    private int NSEQU;
    private int MSTAB;
    private int JSTAB;
    private int IDERR;
    private boolean ATOV;
    private boolean REJECT;
    private double[] H = new double[]{0.1};
    private final double[] rTol = new double[1];
    private final double[] aTol = new double[1];

    public Extrap(int numOfEquations, int maxTableSize) {
        this.WORK = new double[21];
        this.IWORK = new int[22];
        this.setNumOfEquations(numOfEquations);
        this.setMaxTableSize(maxTableSize);
    }

    public Extrap(int numOfEquations) {
        this(numOfEquations, 9);
    }

    public Extrap() {
        this(1, 9);
    }

    @Override
    public int getNumOfEquations() {
        return this.numOfEquations;
    }

    @Override
    public void setNumOfEquations(int numOfEquations) {
        if (this.numOfEquations == numOfEquations) {
            return;
        }
        this.numOfEquations = numOfEquations;
        this.DY = new double[numOfEquations];
        this.YH1 = new double[numOfEquations];
        this.YH2 = new double[numOfEquations];
        this.DZ = new double[numOfEquations];
        this.SCAL = new double[numOfEquations];
        this.T = new double[this.KM][numOfEquations];
    }

    public int getMaxTableSize() {
        return this.KM;
    }

    public void setMaxTableSize(int KM) {
        if (this.KM == KM) {
            return;
        }
        if (KM < 3) {
            throw new IllegalArgumentException("KM must be bigger then 2");
        }
        this.KM = KM;
        this.HH = new double[KM + 1];
        this.W = new double[KM + 1];
        this.A = new double[KM + 1];
        this.ERRFAC = new double[2 * KM + 1];
        this.T = new double[KM][this.numOfEquations + 1];
        this.NJ = new int[KM + 1];
        this.IPOINT = new int[KM + 2];
    }

    public double getAbsTol() {
        return this.absTol;
    }

    public void setAbsTol(double absTol) {
        if (this.absTol == absTol) {
            return;
        }
        this.absTol = absTol;
    }

    public double getRelTol() {
        return this.relTol;
    }

    public void setRelTol(double relTol) {
        if (this.relTol == relTol) {
            return;
        }
        this.relTol = relTol;
    }

    public void printStatistics() {
        System.out.println(" fcn= " + this.NFCN + " step= " + this.NSTEP + " accpt= " + this.NACCPT + " rejct= " + this.NREJCT);
    }

    public void setIntParameter(int index, int parameter) {
        this.IWORK[index] = parameter;
    }

    public void setDoubleParameter(int index, double parameter) {
        this.WORK[index] = parameter;
    }

    public double getCurrentStepSize() {
        return this.H[0];
    }

    public void setCurrentStepSize(double currentStepSize) {
        this.H[0] = currentStepSize;
    }

    @Override
    public void odex(ODE f, double[] Y, double xStart, double xEnd) {
        this.odex(f, Y, xStart, xEnd, this.H, this.relTol, this.absTol, null);
    }

    public void odex(ODE f, double[] Y, double tol, double xStart, double xEnd) {
        this.odex(f, Y, xStart, xEnd, this.H, tol, tol, null);
    }

    public void odex(ODE f, double[] Y, double xStart, double xEnd, ODEIntermediateResultListener solout) {
        this.odex(f, Y, xStart, xEnd, this.H, this.relTol, this.absTol, solout);
    }

    public void odex(ODE f, double[] Y, double xStart, double xEnd, double tol, ODEIntermediateResultListener solout) {
        this.odex(f, Y, xStart, xEnd, this.H, tol, tol, solout);
    }

    public static void solve(ODE f, double[] x, double t0, double t1, double tol) {
        int n = f.getNumberOfEquations();
        new Extrap(n).odex(f, x, t0, t1, tol, null);
    }

    public static void solve(ODE f, double[] x, double t0, double t1, double tol, ODEIntermediateResultListener intermediate) {
        int n = f.getNumberOfEquations();
        new Extrap(n).odex(f, x, t0, t1, tol, intermediate);
    }

    public void odex(ODE f, double[] Y, double xEnd) {
        this.odex(f, Y, xEnd, new double[]{0.1}, this.rTol[0], this.aTol[0], null);
    }

    public void odex(ODE f, double[] Y, double xEnd, double[] H, double rtol, double atol, ODEIntermediateResultListener solout) {
        int n = f.getNumberOfEquations();
        double[] y = new double[n];
        System.arraycopy(Y, 1, y, 0, n);
        new Extrap(n).odex(f, y, Y[0], xEnd, H, rtol, atol, solout);
        System.arraycopy(y, 0, Y, 1, n);
    }

    public void odex(ODE f, double[] Y, double xStart, double xEnd, double[] H, double rtol, double atol) {
        this.odex(f, Y, xStart, xEnd, H, rtol, atol, null);
    }

    public void odex(ODE f, double[] Y, double xStart, double xEnd, double[] H, double rtol, double atol, ODEIntermediateResultListener solout) {
        this.rTol[0] = rtol;
        this.aTol[0] = atol;
        this.odex(f, Y, xStart, xEnd, H, this.rTol, this.aTol, 0, solout);
    }

    public void odex(ODE f, double[] Y, double xStart, double xEnd, double[] H, double[] RTOL, double[] ATOL, int ITOL, ODEIntermediateResultListener solout) {
        this.NFCN = 0;
        this.NSTEP = 0;
        this.NACCPT = 0;
        this.NREJCT = 0;
        if (this.IWORK[1] == 0) {
            this.NMAX = 10000;
        } else {
            this.NMAX = this.IWORK[1];
            if (this.NMAX < 0) {
                throw new IllegalArgumentException(" WRONG INPUT IWORK[ 1 ]= " + this.IWORK[1]);
            }
        }
        this.NSEQU = this.IWORK[3];
        if (this.NSEQU == 0) {
            this.NSEQU = 1;
        }
        if (this.NSEQU < 0 || this.NSEQU >= 6) {
            throw new IllegalArgumentException(" CURIOUS INPUT IWORK[ 3 ]= " + this.IWORK[3]);
        }
        this.MSTAB = this.IWORK[4] == 0 ? 1 : this.IWORK[4];
        this.JSTAB = this.IWORK[5] == 0 ? 2 : this.IWORK[5];
        if (this.IWORK[7] == 0) {
            this.MUDIF = 4;
        } else {
            this.MUDIF = this.IWORK[7];
            if (this.MUDIF <= 0 || this.MUDIF >= 7) {
                throw new IllegalArgumentException(" WRONG INPUT IWORK[ 7 ]  " + this.IWORK[7]);
            }
        }
        if (this.WORK[1] == 0.0) {
            this.UROUND = 2.3E-16;
        } else {
            this.UROUND = this.WORK[1];
            if (this.UROUND <= 1.0E-35 || this.UROUND >= 1.0) {
                throw new IllegalArgumentException(" WHICH MACHINE DO YOU HAVE? YOUR UROUND WAS:  " + this.WORK[1]);
            }
        }
        this.HMAX = this.WORK[2] == 0.0 ? xEnd - xStart : Math.abs(this.WORK[2]);
        if (this.WORK[3] == 0.0) {
            this.SAFE3 = 0.5;
        } else {
            this.SAFE3 = this.WORK[3];
            if (this.SAFE3 <= this.UROUND || this.SAFE3 >= 1.0) {
                throw new IllegalArgumentException(" CURIOUS INPUT WORK[ 3 ]= " + this.WORK[3]);
            }
        }
        this.FAC1 = this.WORK[4] == 0.0 ? 0.02 : this.WORK[4];
        this.FAC2 = this.WORK[5] == 0.0 ? 4.0 : this.WORK[5];
        this.FAC3 = this.WORK[6] == 0.0 ? 0.8 : this.WORK[6];
        this.FAC4 = this.WORK[7] == 0.0 ? 0.9 : this.WORK[7];
        this.SAFE1 = this.WORK[8] == 0.0 ? 0.65 : this.WORK[8];
        this.SAFE2 = this.WORK[9] == 0.0 ? 0.94 : this.WORK[9];
        this.odxcore(f, Y, xStart, xEnd, H, RTOL, ATOL, ITOL, solout);
        this.IWORK[17] = this.NFCN;
        this.IWORK[18] = this.NSTEP;
        this.IWORK[19] = this.NACCPT;
        this.IWORK[20] = this.NREJCT;
    }

    private void odxcore(ODE f, double[] Y, double xStart, double xEnd, double[] H, double[] RTOL, double[] ATOL, int ITOL, ODEIntermediateResultListener solout) {
        int i;
        switch (this.NSEQU) {
            case 1: {
                int i2;
                for (i2 = 1; i2 <= this.KM; ++i2) {
                    this.NJ[i2] = 2 * i2;
                }
                break;
            }
            case 2: {
                int i2;
                this.NJ[1] = 2;
                for (i2 = 2; i2 <= this.KM; ++i2) {
                    this.NJ[i2] = 4 * i2 - 4;
                }
                break;
            }
            case 3: {
                int i2;
                this.NJ[1] = 2;
                this.NJ[2] = 4;
                this.NJ[3] = 6;
                for (i2 = 4; i2 <= this.KM; ++i2) {
                    this.NJ[i2] = 2 * this.NJ[i2 - 2];
                }
                break;
            }
            case 4: {
                int i2;
                for (i2 = 1; i2 <= this.KM; ++i2) {
                    this.NJ[i2] = 4 * i2 - 2;
                }
                break;
            }
            case 5: {
                int i2;
                for (i2 = 1; i2 <= this.KM; ++i2) {
                    this.NJ[i2] = 4 * i2;
                }
                break;
            }
        }
        double X0 = xStart;
        this.A[1] = 1.0 + (double)this.NJ[1];
        for (i = 2; i <= this.KM; ++i) {
            this.A[i] = this.A[i - 1] + (double)this.NJ[i];
        }
        for (i = 0; i < this.numOfEquations; ++i) {
            this.SCAL[i] = ITOL == 0 ? ATOL[0] + RTOL[0] * Math.abs(Y[i]) : ATOL[i] + RTOL[i] * Math.abs(Y[i]);
        }
        double POSNEG = xEnd - xStart >= 0.0 ? 1.0 : -1.0;
        int K = Math.max(2, Math.min(this.KM - 1, (int)(-Math.log(RTOL[0]) / Math.log(10.0) * 0.6 + 1.5)));
        this.HMAX = Math.abs(this.HMAX);
        H[0] = Math.max(Math.abs(H[0]), 1.0E-4);
        H[0] = POSNEG * Math.min(H[0], Math.min(this.HMAX, Math.abs(xEnd - xStart) / 2.0));
        if (solout != null) {
            solout.intermediateResult(xStart, Y, 0);
        }
        this.ERR = 0.0;
        this.ERROLD = 1.0E10;
        double HOPTDE = POSNEG * this.HMAX;
        this.W[1] = 0.0;
        this.REJECT = false;
        boolean LAST = false;
        int KC = 0;
        block14: while (true) {
            int J;
            boolean goto55 = false;
            boolean goto60 = false;
            boolean goto100 = false;
            this.ATOV = false;
            if (0.1 * Math.abs(xEnd - xStart) <= Math.abs(xStart) * this.UROUND) {
                return;
            }
            H[0] = POSNEG * Math.min(Math.min(Math.abs(H[0]), Math.abs(xEnd - xStart)), Math.min(this.HMAX, Math.abs(HOPTDE)));
            if ((xStart + 1.01 * H[0] - xEnd) * POSNEG > 0.0) {
                H[0] = xEnd - xStart;
                LAST = true;
            }
            f.eval(xStart, Y, this.DZ);
            ++this.NFCN;
            if (this.NSTEP == 0 || LAST) {
                ++this.NSTEP;
                for (J = 1; J <= K; ++J) {
                    KC = J;
                    this.midex(f, J, xStart, Y, H, RTOL, ATOL, ITOL);
                    if (this.ATOV) continue block14;
                    if (J <= 1 || !(this.ERR <= 1.0)) continue;
                    goto60 = true;
                    break;
                }
                goto55 = true;
            }
            while (true) {
                if (!(goto55 || goto60 || goto100)) {
                    goto55 = false;
                    ++this.NSTEP;
                    if (this.NSTEP >= this.NMAX) {
                        throw new IllegalArgumentException(" EXIT OF ODEX AT X= " + xStart + " H = " + H[0] + " NUMBER OF STEPS > " + this.NSTEP);
                    }
                    KC = K - 1;
                    for (J = 1; J <= KC; ++J) {
                        this.midex(f, J, xStart, Y, H, RTOL, ATOL, ITOL);
                        if (this.ATOV) continue block14;
                    }
                    if (K == 2 || this.REJECT) {
                        goto60 = false;
                        goto100 = false;
                    } else if (this.ERR <= 1.0) {
                        goto60 = true;
                        goto100 = false;
                    } else if (this.ERR > (double)(this.NJ[K + 1] * this.NJ[K]) / 4.0 * ((double)(this.NJ[K + 1] * this.NJ[K]) / 4.0)) {
                        goto60 = false;
                        goto100 = true;
                    } else {
                        goto60 = false;
                        goto100 = false;
                    }
                    if (!goto60 && !goto100) {
                        this.midex(f, K, xStart, Y, H, RTOL, ATOL, ITOL);
                        if (this.ATOV) continue block14;
                        KC = K;
                        if (this.ERR <= 1.0) {
                            goto60 = true;
                            goto100 = false;
                        }
                    }
                } else {
                    goto55 = false;
                }
                if (!goto60 && !goto100) {
                    goto60 = false;
                    if (this.ERR > (double)this.NJ[K + 1] / 2.0 * ((double)this.NJ[K + 1] / 2.0)) {
                        goto100 = true;
                    } else {
                        KC = K + 1;
                        this.midex(f, KC, xStart, Y, H, RTOL, ATOL, ITOL);
                        if (this.ATOV) continue block14;
                        if (this.ERR > 1.0) {
                            goto100 = true;
                        }
                    }
                } else {
                    goto60 = false;
                }
                if (!goto100) {
                    int KOPT;
                    xStart += H[0];
                    for (int I = 0; I < this.numOfEquations; ++I) {
                        Y[I] = this.T[0][I];
                    }
                    ++this.NACCPT;
                    if (solout != null) {
                        solout.intermediateResult(xStart, Y, 0);
                    }
                    if (KC == 2) {
                        KOPT = Math.min(3, this.KM - 1);
                        if (this.REJECT) {
                            KOPT = 2;
                        }
                    } else if (KC <= K) {
                        KOPT = KC;
                        if (this.W[KC - 1] < this.W[KC] * this.FAC3) {
                            KOPT = KC - 1;
                        }
                        if (this.W[KC] < this.W[KC - 1] * this.FAC4) {
                            KOPT = Math.min(KC + 1, this.KM - 1);
                        }
                    } else {
                        KOPT = KC - 1;
                        if (KC > 3 && this.W[KC - 2] < this.W[KC - 1] * this.FAC3) {
                            KOPT = KC - 2;
                        }
                        if (this.W[KC] < this.W[KOPT] * this.FAC4) {
                            KOPT = Math.min(KC, this.KM - 1);
                        }
                    }
                    if (this.REJECT) {
                        K = Math.min(KOPT, KC);
                        H[0] = POSNEG * Math.min(Math.abs(H[0]), Math.abs(this.HH[K]));
                        this.REJECT = false;
                        continue block14;
                    }
                    H[0] = KOPT <= KC ? this.HH[KOPT] : (KC < K && this.W[KC] < this.W[KC - 1] * this.FAC4 ? this.HH[KC] * this.A[KOPT + 1] / this.A[KC] : this.HH[KC] * this.A[KOPT] / this.A[KC]);
                    K = KOPT;
                    H[0] = POSNEG * Math.abs(H[0]);
                    continue block14;
                }
                goto100 = false;
                if ((K = Math.min(K, Math.min(KC, this.KM - 1))) > 2 && this.W[K - 1] < this.W[K] * this.FAC3) {
                    --K;
                }
                ++this.NREJCT;
                H[0] = POSNEG * this.HH[K];
                this.REJECT = true;
            }
            break;
        }
    }

    private void midex(ODE f, int J, double xStart, double[] Y, double[] H, double[] RTOL, double[] ATOL, int ITOL) {
        double HJ = H[0] / (double)this.NJ[J];
        for (int I = 0; I < this.numOfEquations; ++I) {
            this.YH1[I] = Y[I];
            this.YH2[I] = Y[I] + HJ * this.DZ[I];
        }
        int M = this.NJ[J] - 1;
        for (int MM = 1; MM <= M; ++MM) {
            f.eval(xStart + HJ * (double)MM, this.YH2, this.DY);
            for (int I = 0; I < this.numOfEquations; ++I) {
                double YS = this.YH1[I];
                this.YH1[I] = this.YH2[I];
                this.YH2[I] = YS + 2.0 * HJ * this.DY[I];
            }
            if (MM > this.MSTAB || J > this.JSTAB) continue;
            double DEL1 = 0.0;
            for (int I = 0; I < this.numOfEquations; ++I) {
                DEL1 += this.DZ[I] / this.SCAL[I] * (this.DZ[I] / this.SCAL[I]);
            }
            double DEL2 = 0.0;
            for (int I = 0; I < this.numOfEquations; ++I) {
                DEL2 += (this.DY[I] - this.DZ[I]) / this.SCAL[I] * ((this.DY[I] - this.DZ[I]) / this.SCAL[I]);
            }
            double QUOT = DEL2 / Math.max(this.UROUND, DEL1);
            if (!(QUOT > 4.0)) continue;
            ++this.NFCN;
            this.ATOV = true;
            H[0] = H[0] * this.SAFE3;
            this.REJECT = true;
            return;
        }
        f.eval(xStart + H[0], this.YH2, this.DY);
        for (int I = 0; I < this.numOfEquations; ++I) {
            this.T[J - 1][I] = (this.YH1[I] + this.YH2[I] + HJ * this.DY[I]) / 2.0;
        }
        this.NFCN += this.NJ[J];
        if (J == 1) {
            return;
        }
        double DBLENJ = this.NJ[J];
        for (int L = J; L >= 2; --L) {
            this.FAC = DBLENJ / (double)this.NJ[L - 1] * (DBLENJ / (double)this.NJ[L - 1]) - 1.0;
            for (int I = 0; I < this.numOfEquations; ++I) {
                this.T[L - 2][I] = this.T[L - 1][I] + (this.T[L - 1][I] - this.T[L - 2][I]) / this.FAC;
            }
        }
        this.ERR = 0.0;
        for (int I = 0; I < this.numOfEquations; ++I) {
            double T1I = Math.max(Math.abs(Y[I]), Math.abs(this.T[0][I]));
            this.SCAL[I] = ITOL == 0 ? ATOL[0] + RTOL[0] * T1I : ATOL[I] + RTOL[I] * T1I;
            this.ERR += (this.T[0][I] - this.T[1][I]) / this.SCAL[I] * ((this.T[0][I] - this.T[1][I]) / this.SCAL[I]);
        }
        this.ERR = Math.sqrt(this.ERR / (double)this.numOfEquations);
        if (this.ERR * this.UROUND >= 1.0) {
            this.ATOV = true;
            H[0] = H[0] * this.SAFE3;
            this.REJECT = true;
            return;
        }
        if (J > 2 && this.ERR >= this.ERROLD) {
            this.ATOV = true;
            H[0] = H[0] * this.SAFE3;
            this.REJECT = true;
            return;
        }
        this.ERROLD = Math.max(4.0 * this.ERR, 1.0);
        double EXPO = 1.0 / (double)(2 * J - 1);
        double FACMIN = Math.pow(this.FAC1, EXPO);
        this.FAC = Math.min(this.FAC2 / FACMIN, Math.max(FACMIN, Math.pow(this.ERR / this.SAFE1, EXPO) / this.SAFE2));
        this.FAC = 1.0 / this.FAC;
        this.HH[J] = Math.min(Math.abs(H[0]) * this.FAC, this.HMAX);
        this.W[J] = this.A[J] / this.HH[J];
    }
}

