/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.odeSolving;

import de.jtem.numericalMethods.calculus.odeSolving.ODE;
import de.jtem.numericalMethods.calculus.odeSolving.OdeSolver;
import java.io.Serializable;

public class RungeKutta
implements OdeSolver,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    int numOfEquations;
    int numberOfSteps = 1;
    double[][] tempData;

    public RungeKutta(int numOfEquations) {
        this.setNumOfEquations(numOfEquations);
    }

    public RungeKutta() {
        this(1);
    }

    public int getNumberOfSteps() {
        return this.numberOfSteps;
    }

    public void setNumberOfSteps(int numberOfSteps) {
        if (numberOfSteps < 1) {
            throw new IllegalArgumentException(" number of steps must be positive");
        }
        this.numberOfSteps = numberOfSteps;
    }

    @Override
    public int getNumOfEquations() {
        return this.numOfEquations;
    }

    @Override
    public void setNumOfEquations(int numOfEquations) {
        if (this.numOfEquations == numOfEquations) {
            return;
        }
        this.numOfEquations = numOfEquations;
        this.tempData = new double[5][numOfEquations];
    }

    @Override
    public void odex(ODE ode, double[] x, double tStart, double tEnd) {
        if (this.numOfEquations < ode.getNumberOfEquations()) {
            this.setNumOfEquations(ode.getNumberOfEquations());
        }
        RungeKutta.odex(ode, x, tStart, tEnd, this.numberOfSteps, this.tempData);
    }

    public static void step(ODE ode, double t, double[] x, double[] r, double h, double[][] temp) {
        int k;
        double[] y_ = temp[0];
        double[] k1 = temp[1];
        double[] k2 = temp[2];
        double[] k3 = temp[3];
        double[] k4 = temp[4];
        int n = ode.getNumberOfEquations();
        double hOver2 = h / 2.0;
        double hOver6 = h / 6.0;
        ode.eval(t, x, k1);
        double x_ = t + hOver2;
        for (k = 0; k < n; ++k) {
            y_[k] = x[k] + hOver2 * k1[k];
        }
        ode.eval(x_, y_, k2);
        for (k = 0; k < n; ++k) {
            y_[k] = x[k] + hOver2 * k2[k];
        }
        ode.eval(x_, y_, k3);
        x_ = t + h;
        for (k = 0; k < n; ++k) {
            y_[k] = x[k] + h * k3[k];
        }
        ode.eval(x_, y_, k4);
        for (k = 0; k < n; ++k) {
            r[k] = x[k] + hOver6 * (k1[k] + 2.0 * (k2[k] + k3[k]) + k4[k]);
        }
    }

    public static void step(ODE ode, double t, double[] x, double[] r, double h, double[][] tempData, int intermediateSteps) {
        double hh = h / (double)(intermediateSteps + 1);
        RungeKutta.step(ode, t, x, r, hh, tempData);
        for (int i = 0; i < intermediateSteps; ++i) {
            RungeKutta.step(ode, t += hh, r, r, hh, tempData);
        }
    }

    public static void odex(ODE ode, double[] x, double tStart, double tEnd, int numOfSteps, double[][] tempData) {
        double h = (tEnd - tStart) / (double)numOfSteps;
        double t = tStart;
        for (int i = 0; i < numOfSteps; ++i) {
            RungeKutta.step(ode, t, x, x, h, tempData);
            t += h;
        }
    }

    public static void table(ODE ode, double[] init, double tStart, double tEnd, double[][] table) {
        RungeKutta.table(ode, init, tStart, tEnd, table, 0);
    }

    public static void table(ODE ode, double[] init, double tStart, double tEnd, double[][] table, int intermediateSteps) {
        int numOfSteps = table.length - 1;
        double h = (tEnd - tStart) / (double)numOfSteps;
        int noe = ode.getNumberOfEquations();
        double[][] tempData = new double[5][noe];
        System.arraycopy(init, 0, table[0], 0, noe);
        double t = tStart;
        if (intermediateSteps == 0) {
            for (int i = 0; i < numOfSteps; ++i) {
                RungeKutta.step(ode, t, table[i], table[i + 1], h, tempData);
                t += h;
            }
        } else {
            for (int i = 0; i < numOfSteps; ++i) {
                RungeKutta.step(ode, t, table[i], table[i + 1], h, tempData, intermediateSteps);
                t += h;
            }
        }
    }

    public static double rungeKuttaStep(ODE f, double x, double[] y, double H, double[] y_, double[] k1, double[] k2, double[] k3, double[] k4) {
        int k;
        int n = f.getNumberOfEquations();
        double hOver2 = H / 2.0;
        double hOver6 = H / 6.0;
        f.eval(x, y, k1);
        double x_ = x + hOver2;
        for (k = 0; k < n; ++k) {
            y_[k] = y[k] + hOver2 * k1[k];
        }
        f.eval(x_, y_, k2);
        for (k = 0; k < n; ++k) {
            y_[k] = y[k] + hOver2 * k2[k];
        }
        f.eval(x_, y_, k3);
        x_ = x + H;
        for (k = 0; k < n; ++k) {
            y_[k] = y[k] + H * k3[k];
        }
        f.eval(x_, y_, k4);
        for (k = 0; k < n; ++k) {
            int n2 = k;
            y[n2] = y[n2] + hOver6 * (k1[k] + 2.0 * (k2[k] + k3[k]) + k4[k]);
        }
        return x_;
    }
}

