/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.odeSolving;

import de.jtem.numericalMethods.calculus.odeSolving.ODE;
import de.jtem.numericalMethods.calculus.odeSolving.ODEIntermediateResultListener;
import de.jtem.numericalMethods.calculus.odeSolving.OdeSolver;
import java.io.Serializable;

public class RungeKuttaFehlberg
implements OdeSolver,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    int numOfEquations;
    double eps = 1.0E-7;
    double stepSize = 0.1;
    private double[][] temp;
    private int[] stepInfo = new int[2];
    private double[] h = new double[1];
    static final double SAFETY = 0.9;
    static final double PGROW = -0.2;
    static final double PSHRNK = -0.25;
    static final double ERRCON = 1.89E-4;
    static final double b21 = 0.2;
    static final double b31 = 0.075;
    static final double b32 = 0.225;
    static final double b41 = 0.3;
    static final double b42 = -0.9;
    static final double b43 = 1.2;
    static final double b51 = -0.2037037037037037;
    static final double b52 = 2.5;
    static final double b53 = -2.5925925925925926;
    static final double b54 = 1.2962962962962963;
    static final double b61 = 0.029495804398148147;
    static final double b62 = 0.341796875;
    static final double b63 = 0.041594328703703706;
    static final double b64 = 0.40034541377314814;
    static final double b65 = 0.061767578125;
    static final double a2 = 0.2;
    static final double a3 = 0.3;
    static final double a4 = 0.6;
    static final double a5 = 1.0;
    static final double a6 = 0.875;
    static final double c1 = 0.09788359788359788;
    static final double c3 = 0.4025764895330113;
    static final double c4 = 0.21043771043771045;
    static final double c6 = 0.2891022021456804;
    static final double dc5 = -0.019321986607142856;
    static final double dc1 = -0.004293774801587311;
    static final double dc3 = 0.018668586093857853;
    static final double dc4 = -0.034155026830808066;
    static final double dc6 = 0.03910220214568039;
    static final int MAX_NUM_OF_STEPS = 10000;
    static final double TINY = 1.0E-30;
    static final double EPS = 1.0E-15;

    public RungeKuttaFehlberg(int numOfEquations) {
        this.setNumOfEquations(numOfEquations);
    }

    public RungeKuttaFehlberg() {
        this(1);
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(double stepSize) {
        if (this.stepSize == stepSize) {
            return;
        }
        this.stepSize = stepSize;
    }

    public double getEps() {
        return this.eps;
    }

    public void setEps(double eps) {
        if (this.eps == eps) {
            return;
        }
        this.eps = eps;
    }

    @Override
    public int getNumOfEquations() {
        return this.numOfEquations;
    }

    @Override
    public void setNumOfEquations(int numOfEquations) {
        if (this.numOfEquations == numOfEquations) {
            return;
        }
        this.numOfEquations = numOfEquations;
        this.temp = new double[10][numOfEquations + 1];
    }

    @Override
    public void odex(ODE f, double[] y, double xStart, double xEnd) {
        this.h[0] = this.stepSize;
        RungeKuttaFehlberg.odex(f, y, xStart, xEnd, this.eps, this.h, 0.0, this.stepInfo, null, this.temp);
    }

    public void odex(ODE f, double[] y, double xStart, double xEnd, ODEIntermediateResultListener intermediate) {
        this.h[0] = this.stepSize;
        RungeKuttaFehlberg.odex(f, y, xStart, xEnd, this.eps, this.h, 0.0, this.stepInfo, intermediate, this.temp);
    }

    public void odex(ODE f, double[] y, double xStart, double xEnd, double tol, ODEIntermediateResultListener intermediate) {
        this.h[0] = this.stepSize;
        RungeKuttaFehlberg.odex(f, y, xStart, xEnd, tol, this.h, 0.0, this.stepInfo, intermediate, this.temp);
    }

    public static void solve(ODE f, double[] x, double t0, double t1, double tol) {
        RungeKuttaFehlberg.solve(f, x, t0, t1, tol, null);
    }

    public static void solve(ODE f, double[] x, double t0, double t1, double tol, ODEIntermediateResultListener intermediate) {
        int n = f.getNumberOfEquations();
        new RungeKuttaFehlberg(n).odex(f, x, t0, t1, tol, intermediate);
    }

    static double step(ODE f, double x, double[] y, double[] yPrime, double[] h, double eps, double[] yScale, double[] performedH, double[][] temp) {
        double maxError;
        int n;
        double[] y_;
        block2: {
            double xnew;
            y_ = temp[6];
            double[] yError = temp[7];
            n = f.getNumberOfEquations();
            do {
                RungeKuttaFehlberg.cashKarpErrorExtimate(f, x, y, yPrime, h[0], y_, yError, temp);
                maxError = 0.0;
                for (int i = 0; i < n; ++i) {
                    maxError = Math.max(maxError, Math.abs(yError[i] / yScale[i]));
                }
                if (!((maxError /= eps) > 1.0)) break block2;
                h[0] = 0.9 * h[0] * Math.pow(maxError, -0.25);
                if (!(h[0] < 0.1 * h[0])) continue;
                h[0] = h[0] * 0.1;
            } while ((xnew = x + h[0]) != x);
            throw new IllegalArgumentException("stepsize underflow in rkqs");
        }
        System.arraycopy(y_, 0, y, 0, n);
        performedH[0] = h[0];
        h[0] = maxError > 1.89E-4 ? 0.9 * h[0] * Math.pow(maxError, -0.2) : 5.0 * h[0];
        return x += h[0];
    }

    static void cashKarpErrorExtimate(ODE f, double x, double[] y, double[] yPrime, double h, double[] yout, double[] yError, double[][] temp) {
        int i;
        double[] y_ = temp[0];
        double[] ak2 = temp[1];
        double[] ak3 = temp[2];
        double[] ak4 = temp[3];
        double[] ak5 = temp[4];
        double[] ak6 = temp[5];
        int n = f.getNumberOfEquations();
        double x_ = x + 0.2 * h;
        for (i = 0; i < n; ++i) {
            y_[i] = y[i] + 0.2 * h * yPrime[i];
        }
        f.eval(x_, y_, ak2);
        x_ = x + 0.3 * h;
        for (i = 0; i < n; ++i) {
            y_[i] = y[i] + h * (0.075 * yPrime[i] + 0.225 * ak2[i]);
        }
        f.eval(x_, y_, ak3);
        x_ = x + 0.6 * h;
        for (i = 0; i < n; ++i) {
            y_[i] = y[i] + h * (0.3 * yPrime[i] + -0.9 * ak2[i] + 1.2 * ak3[i]);
        }
        f.eval(x_, y_, ak4);
        x_ = x + 1.0 * h;
        for (i = 0; i < n; ++i) {
            y_[i] = y[i] + h * (-0.2037037037037037 * yPrime[i] + 2.5 * ak2[i] + -2.5925925925925926 * ak3[i] + 1.2962962962962963 * ak4[i]);
        }
        f.eval(x_, y_, ak5);
        x_ = x + 0.875 * h;
        for (i = 0; i < n; ++i) {
            y_[i] = y[i] + h * (0.029495804398148147 * yPrime[i] + 0.341796875 * ak2[i] + 0.041594328703703706 * ak3[i] + 0.40034541377314814 * ak4[i] + 0.061767578125 * ak5[i]);
        }
        f.eval(x_, y_, ak6);
        for (i = 0; i < n; ++i) {
            yout[i] = y[i] + h * (0.09788359788359788 * yPrime[i] + 0.4025764895330113 * ak3[i] + 0.21043771043771045 * ak4[i] + 0.2891022021456804 * ak6[i]);
            yError[i] = h * (-0.004293774801587311 * yPrime[i] + 0.018668586093857853 * ak3[i] + -0.034155026830808066 * ak4[i] + -0.019321986607142856 * ak5[i] + 0.03910220214568039 * ak6[i]);
        }
    }

    static void odex(ODE f, double[] y, double xStart, double xEnd, double eps, double[] h, double minH, int[] stepInfo, ODEIntermediateResultListener intermediate) {
        int n = f.getNumberOfEquations();
        RungeKuttaFehlberg.odex(f, y, xStart, xEnd, eps, h, minH, stepInfo, intermediate, new double[10][n]);
    }

    static void odex(ODE f, double[] y, double xStart, double xEnd, double eps, double[] h, double minH, int[] stepInfo, ODEIntermediateResultListener intermediate, double[][] temp) {
        int n = f.getNumberOfEquations();
        double[] yScale = temp[8];
        double[] yPrime = temp[9];
        double[] performedH = new double[1];
        double x = xStart;
        h[0] = xStart < xEnd ? Math.abs(h[0]) : -Math.abs(h[0]);
        int numOfGoodSteps = 0;
        int numOfBadSteps = 0;
        for (int k = 0; k < 10000; ++k) {
            f.eval(x, y, yPrime);
            for (int i = 0; i < n; ++i) {
                yScale[i] = Math.abs(y[i]) + Math.abs(yPrime[i] * h[0]) + 1.0E-30;
            }
            if (Math.abs(xEnd - x) < Math.abs(h[0]) * 1.2) {
                h[0] = xEnd - x;
            }
            double triedH = h[0];
            x = RungeKuttaFehlberg.step(f, x, y, yPrime, h, eps, yScale, performedH, temp);
            if (intermediate != null) {
                intermediate.intermediateResult(x, y, 0);
            }
            if (h[0] == triedH) {
                ++numOfGoodSteps;
            } else {
                ++numOfBadSteps;
            }
            if (Math.abs((x - xEnd) / xEnd) < 1.0E-15) {
                stepInfo[0] = numOfGoodSteps;
                stepInfo[1] = numOfBadSteps;
                return;
            }
            if (!(Math.abs(performedH[0]) <= minH)) continue;
            throw new RuntimeException("too small step in odex");
        }
        throw new RuntimeException("too many steps in odex");
    }
}

