/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.rootFinding;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfOneVariable;

public class Brent {
    static final int ITMAX = 100;
    static final double EPS = 1.0E-15;

    public static double search(RealFunctionOfOneVariable f, double left, double right, double precision) {
        double a = left;
        double b = right;
        double c = right;
        double fa = f.eval(a);
        double fb = f.eval(b);
        if (fa > 0.0 && fb > 0.0 || fa < 0.0 && fb < 0.0) {
            throw new IllegalArgumentException("root is not bracketed");
        }
        double fc = fb;
        double d = 0.0;
        double e = 0.0;
        for (int iter = 1; iter <= 100; ++iter) {
            if (fb > 0.0 && fc > 0.0 || fb < 0.0 && fc < 0.0) {
                c = a;
                fc = fa;
                e = d = b - a;
            }
            if (Math.abs(fc) < Math.abs(fb)) {
                a = b;
                b = c;
                c = a;
                fa = fb;
                fb = fc;
                fc = fa;
            }
            double tol1 = 2.0E-15 * Math.abs(b) + 0.5 * precision;
            double xm = 0.5 * (c - b);
            if (Math.abs(xm) <= tol1 || fb == 0.0) {
                return b;
            }
            if (Math.abs(e) >= tol1 && Math.abs(fa) > Math.abs(fb)) {
                double min2;
                double q;
                double p;
                double s = fb / fa;
                if (a == c) {
                    p = 2.0 * xm * s;
                    q = 1.0 - s;
                } else {
                    q = fa / fc;
                    double r = fb / fc;
                    p = s * (2.0 * xm * q * (q - r) - (b - a) * (r - 1.0));
                    q = (q - 1.0) * (r - 1.0) * (s - 1.0);
                }
                if (p > 0.0) {
                    q = -q;
                }
                p = Math.abs(p);
                double min1 = 3.0 * xm * q - Math.abs(tol1 * q);
                double d2 = min1 < (min2 = Math.abs(e * q)) ? min1 : min2;
                if (2.0 * p < d2) {
                    e = d;
                    d = p / q;
                } else {
                    e = d = xm;
                }
            } else {
                e = d = xm;
            }
            a = b;
            fa = fb;
            b = Math.abs(d) > tol1 ? (b += d) : (b += xm >= 0.0 ? Math.abs(tol1) : -Math.abs(tol1));
            fb = f.eval(b);
        }
        throw new RuntimeException("exceeded maximal number of iterations");
    }
}

