/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.rootFinding;

import de.jtem.numericalMethods.algebra.linear.MatrixOperations;
import de.jtem.numericalMethods.algebra.linear.VectorOperations;
import de.jtem.numericalMethods.algebra.linear.decompose.Householder;
import de.jtem.numericalMethods.algebra.linear.solve.RXB;
import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariables;
import de.jtem.numericalMethods.calculus.function.RealVectorValuedFunctionOfSeveralVariablesWithJacobien;
import de.jtem.numericalMethods.calculus.rootFinding.Newton;

public class Broyden {
    static final double DEFAULT_MAX_STEPSIZE = 1.0;
    static final double EPS = 1.0E-15;

    Broyden() {
    }

    public static void search(RealVectorValuedFunctionOfSeveralVariablesWithJacobien func, double[] x) {
        Broyden.search(func, x, 200, 1.0E-8, 1.0E-10, 1.0E-15, 1.0);
    }

    public static void search(RealVectorValuedFunctionOfSeveralVariablesWithJacobien func, double[] x, int maxNumberOfIterations, double acc, double precision) {
        Broyden.search(func, x, maxNumberOfIterations, acc, acc / 100.0, precision, 1.0);
    }

    public static void search(RealVectorValuedFunctionOfSeveralVariablesWithJacobien func, double[] x, int maxNumberOfIterations, double acc, double accOfMin, double precision, double maxStepSize) {
        int n = func.getDimensionOfTargetSpace();
        double[] c = new double[n];
        double[] fvcold = new double[n];
        double[] g = new double[n];
        double[] p = new double[n];
        double[][] ts = new double[n][n];
        double[][] r = new double[n][n];
        double[][] r_ = new double[n][n];
        double[][] q = new double[n][n];
        double[] s = new double[n];
        double[] t = new double[n];
        double[] w = new double[n];
        double[] xold = new double[n];
        double[] fvec = new double[n];
        double[] tmp1 = new double[n];
        double[] tmp2 = new double[n];
        boolean[] check = new boolean[1];
        RealFunctionOfSeveralVariables fmin = Newton.normSqr(func, fvec);
        double f = fmin.eval(x);
        double test = 0.0;
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs(fvec[i]) > test)) continue;
            test = Math.abs(fvec[i]);
        }
        if (test < 0.01 * acc) {
            return;
        }
        double stpmax = maxStepSize * Math.max(Math.sqrt(VectorOperations.normSqr(x)), (double)n);
        boolean restrt = true;
        for (int its = 1; its <= maxNumberOfIterations; ++its) {
            int i;
            if (restrt) {
                func.eval(x, fvec, 0, r);
                double det = Householder.decompose(r, q, tmp1, tmp2);
                if (det == 0.0) {
                    new RuntimeException("singular Jacobian in broydn");
                }
            } else {
                VectorOperations.minus(x, xold, s);
                MatrixOperations.times(r, s, t);
                boolean skip = true;
                for (int i2 = 0; i2 < n; ++i2) {
                    double sum = 0.0;
                    for (int j = 0; j < n; ++j) {
                        sum += q[i2][j] * t[j];
                    }
                    w[i2] = fvec[i2] - fvcold[i2] - sum;
                    if (Math.abs(w[i2]) >= 1.0E-15 * (Math.abs(fvec[i2]) + Math.abs(fvcold[i2]))) {
                        skip = false;
                        continue;
                    }
                    w[i2] = 0.0;
                }
                if (!skip) {
                    MatrixOperations.times(w, q, t);
                    VectorOperations.divide(s, VectorOperations.normSqr(s), s);
                    MatrixOperations.times(t, s, ts);
                    MatrixOperations.plus(r, ts, r_);
                    MatrixOperations.times(q, r_, r);
                    double det = Householder.decompose(r, q, tmp1, tmp2);
                    if (det == 0.0) {
                        throw new RuntimeException("r singular");
                    }
                }
            }
            MatrixOperations.times(fvec, q, tmp1);
            MatrixOperations.times(tmp1, r, g);
            VectorOperations.assign(x, xold);
            VectorOperations.assign(fvec, fvcold);
            MatrixOperations.times(fvec, q, p);
            VectorOperations.neg(p, p);
            RXB.solve(r, p);
            f = Newton.lnsrch(xold, f, g, p, x, precision, stpmax, check, fmin);
            test = 0.0;
            for (i = 0; i < n; ++i) {
                if (!(Math.abs(fvec[i]) > test)) continue;
                test = Math.abs(fvec[i]);
            }
            if (test < acc) {
                return;
            }
            if (check[0]) {
                if (restrt) {
                    throw new HitLocalMinimumException();
                }
                test = 0.0;
                double den = Math.max(f, 0.5 * (double)n);
                for (int i3 = 0; i3 < n; ++i3) {
                    double temp = Math.abs(g[i3]) * Math.max(Math.abs(x[i3]), 1.0) / den;
                    if (!(temp > test)) continue;
                    test = temp;
                }
                if (test < accOfMin) {
                    return;
                }
                restrt = true;
                continue;
            }
            restrt = false;
            test = 0.0;
            for (i = 0; i < n; ++i) {
                double temp = Math.abs(x[i] - xold[i]) / Math.max(Math.abs(x[i]), 1.0);
                if (!(temp > test)) continue;
                test = temp;
            }
            if (!(test < precision)) continue;
            return;
        }
        throw new RuntimeException("exeeded maximal number of iterations");
    }

    public static class HitLocalMinimumException
    extends RuntimeException {
        public HitLocalMinimumException() {
        }

        public HitLocalMinimumException(String msg) {
        }
    }
}

