/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.rootFinding;

public class NewtonRaphson {
    public static double ACC = 1.0E-12;
    public static int MAX_NUM_OF_STEPS = 50;
    public static boolean DEBUG = false;

    private NewtonRaphson() {
    }

    public static void search(RealFunctionWithDerivative f, double x, double[] rootValues) {
        NewtonRaphson.search(f, x, rootValues, ACC, ACC, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, MAX_NUM_OF_STEPS, true);
    }

    public static void search(RealFunctionWithDerivative f, double x, double[] rootValues, double acc) {
        NewtonRaphson.search(f, x, rootValues, acc, acc, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, MAX_NUM_OF_STEPS, true);
    }

    public static void search(RealFunctionWithDerivative f, double x, double[] rootValues, double acc, double accX, double xMin, double xMax, int maxNumOfSteps, boolean panicIfMaxNumOfStepsAreExeeded) {
        if (DEBUG) {
            System.out.println("NewtonRaphson DEBUG: " + x);
        }
        for (int i = 0; i < maxNumOfSteps; ++i) {
            f.eval(x, rootValues, 1, rootValues, 2);
            if (DEBUG) {
                System.out.println("NewtonRaphson :  x  = " + x);
                System.out.println("               f(x) = " + rootValues[1]);
                System.out.println("              f'(x) = " + rootValues[2]);
            }
            double dx = rootValues[1] / rootValues[2];
            rootValues[0] = x -= dx;
            if (x < xMin || x > xMax) {
                throw new RuntimeException(" left initial brackets ");
            }
            if (Math.abs(dx / x) < accX || Math.abs(rootValues[1]) < acc) {
                return;
            }
            if (!(Math.abs(dx) < acc)) continue;
            return;
        }
        if (panicIfMaxNumOfStepsAreExeeded) {
            throw new RuntimeException(" exeed max number of steps !!! ");
        }
    }

    public static void search(ComplexFunctionWithDerivative f, double x, double y, double[] rootValues) {
        NewtonRaphson.search(f, x, y, rootValues, ACC, ACC, ACC, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, MAX_NUM_OF_STEPS, true);
    }

    public static void search(ComplexFunctionWithDerivative f, double x, double y, double[] rootValues, double acc) {
        NewtonRaphson.search(f, x, y, rootValues, acc, acc, acc, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, MAX_NUM_OF_STEPS, true);
    }

    public static void search(ComplexFunctionWithDerivative f, double x, double y, double[] rootValues, double acc, double accX, double accY, double xMin, double xMax, double yMin, double yMax, int maxNumOfSteps, boolean panicIfMaxNumOfStepsAreExeeded) {
        if (DEBUG) {
            System.out.println("NewtonRaphson DEBUG: " + x + " + i " + y);
        }
        for (int i = 0; i < maxNumOfSteps; ++i) {
            rootValues[0] = x;
            rootValues[1] = y;
            f.eval(x, y, rootValues, 2, rootValues, 4);
            double denom = rootValues[4] * rootValues[4] + rootValues[5] * rootValues[5];
            double dx = (rootValues[2] * rootValues[4] + rootValues[3] * rootValues[5]) / denom;
            double dy = (rootValues[3] * rootValues[4] - rootValues[2] * rootValues[5]) / denom;
            if (DEBUG) {
                System.out.println("NewtonRaphson :  x  = " + x + " + i " + y);
                System.out.println("               f(x) = " + rootValues[2] + " + i " + rootValues[3]);
                System.out.println("              f'(x) = " + rootValues[4] + " + i " + rootValues[5]);
                System.out.println("              dx = " + dx + " + i " + dy);
            }
            y -= dy;
            if ((x -= dx) < xMin || x > xMax || y < yMin || y > yMax) {
                throw new RuntimeException(" left initial brackets ");
            }
            double absZ = Math.abs(x) + Math.abs(y);
            if (!(Math.abs(dx / absZ) < accX && Math.abs(dy / absZ) < accY) && (!(Math.abs(rootValues[2]) < acc) || !(Math.abs(rootValues[3]) < acc))) continue;
            return;
        }
        if (panicIfMaxNumOfStepsAreExeeded) {
            throw new RuntimeException(" exeed max number of steps !!! ");
        }
    }

    public static interface ComplexFunctionWithDerivative {
        public void eval(double var1, double var3, double[] var5, int var6, double[] var7, int var8);
    }

    public static interface RealFunctionWithDerivative {
        public void eval(double var1, double[] var3, int var4, double[] var5, int var6);
    }
}

