/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.specialFunctions;

import de.jtem.numericalMethods.calculus.functionApproximation.ChebyshevApproximation;
import de.jtem.numericalMethods.calculus.functionApproximation.RealFunction;

public class Clausen {
    private static final double[] coeffs = new double[]{0.4482875649180977, 0.22723902480478247, 0.003193192528191099, 1.0195254591199122E-4, 4.188220138620993E-6, 1.951947102494479E-7, 9.833314612744994E-9, 5.226269539038555E-10, 2.889166021995073E-11, 1.6465290606931503E-12, 9.57374364530389E-14};
    public static final double CATALAN = Clausen.cl2(1.5707963267948966);

    private Clausen() {
    }

    public static double cl2(double x) {
        if ((x = Math.IEEEremainder(x, Math.PI * 2)) == 0.0) {
            return 0.0;
        }
        double xOverPi = x / Math.PI;
        double y = xOverPi * ChebyshevApproximation.evaluate(coeffs, 2.0 * xOverPi * xOverPi - 1.0);
        return y - x * (Math.log(Math.abs(x)) - 1.0);
    }

    private static void printChebychevCoeffificients(int n) {
        class MinusLogSinOverX
        implements RealFunction {
            MinusLogSinOverX() {
            }

            @Override
            public double valueAt(double x) {
                if (x == 0.0) {
                    return 0.0;
                }
                double xx = 1.5707963267948966 * x;
                return -Math.log(Math.sin(xx) / xx);
            }
        }
        MinusLogSinOverX function = new MinusLogSinOverX();
        double[] c1 = new double[2 * n];
        ChebyshevApproximation.fit(c1, function);
        for (int i = 1; i < c1.length; i += 2) {
            c1[i] = 0.0;
        }
        double[] c2 = new double[2 * n];
        ChebyshevApproximation.integrate(c1, c2, Math.PI);
        ChebyshevApproximation.divideByX(c2);
        System.out.println("Paste these coefficients into the code.");
        System.out.println("{");
        for (int i = 0; i < c2.length - 2; i += 2) {
            System.out.println(c2[i] + ",");
        }
        System.out.println(c2[c2.length - 2]);
        System.out.println("}");
    }

    public static void main(String[] args) {
        int n = args.length == 0 ? 25 : Integer.valueOf(args[0]);
        Clausen.printChebychevCoeffificients(n);
    }
}

