/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.geodesic;

import de.jtem.numericalMethods.geometry.geodesic.IntTriple;

public class TriangleStrip {
    TriangleStrip() {
    }

    public static int[] getStripBetweenElements(int[][] elementData, int[][] neighbourData, int e1, int e2) {
        int noe = elementData.length;
        int nextElement = -1;
        int frontCounter = 0;
        int pFsize = 0;
        if (e1 >= 0 && e1 < noe && e2 >= 0 && e2 < noe) {
            throw new IllegalArgumentException("elements are not part of triangulations");
        }
        int[] pFront = new int[noe];
        int[] nFront = new int[noe];
        int[] prev = new int[noe];
        int i = 0;
        while (i < noe) {
            prev[i++] = -1;
        }
        pFront[pFsize++] = e1;
        while (nextElement != e2 && pFsize > 0) {
            ++frontCounter;
            int nFsize = 0;
            for (int j = 0; j < pFsize; ++j) {
                int prevElement = pFront[j];
                for (i = 0; i < 3; ++i) {
                    nextElement = neighbourData[prevElement][i];
                    if (nextElement != -1 && prev[nextElement] == -1) {
                        nFront[nFsize++] = nextElement;
                        prev[nextElement] = prevElement;
                    }
                    if (nextElement == e2) break;
                }
                if (nextElement == e2) break;
            }
            int[] dummy = pFront;
            pFront = nFront;
            pFsize = nFsize;
            nFront = dummy;
        }
        if (nextElement != e2) {
            return null;
        }
        int[] strip = new int[frontCounter + 1];
        i = frontCounter;
        strip[i] = e2;
        int e = strip[i];
        while (i > 0) {
            e = strip[--i] = prev[e];
        }
        return strip;
    }

    public static int[] getOptimizedStrip(int[][] elementData, int[] stripData) {
        int noe = TriangleStrip.optimizeStrip(elementData, stripData, 2);
        if (noe == stripData.length) {
            return stripData;
        }
        int[] optimizedStrip = new int[noe];
        System.arraycopy(stripData, 0, optimizedStrip, 0, noe);
        return optimizedStrip;
    }

    public static int[] getComplexOptimizedStrip(int[][] elementData, int[] stripData) {
        int noe = TriangleStrip.optimizeStrip(elementData, stripData, 1);
        if (noe == stripData.length) {
            return stripData;
        }
        int[] optimizedStrip = new int[noe];
        System.arraycopy(stripData, 0, optimizedStrip, 0, noe);
        return optimizedStrip;
    }

    static int optimizeStrip(int[][] elementData, int[] stripData, int threshType) {
        int noe = stripData.length;
        int[] map = new int[3];
        while (noe > 1) {
            int This = 0;
            int thisElement = stripData[This];
            for (int next = 1; next < noe; ++next) {
                int nextElement = stripData[next];
                int type = IntTriple.getMap(map, elementData[thisElement], elementData[nextElement]);
                if (type == 0) {
                    throw new RuntimeException("strip is not connected");
                }
                if (next + 1 < noe) {
                    int testElement;
                    int testType;
                    int nextType = IntTriple.getMap(map, elementData[nextElement], elementData[stripData[next + 1]]);
                    for (int test = next + 1; test < noe && (testType = IntTriple.getMap(map, elementData[thisElement], elementData[testElement = stripData[test]])) != 0; ++test) {
                        if (testType <= threshType && testType < type && (test != next + 1 || testType < nextType)) continue;
                        next = test;
                        nextElement = testElement;
                        type = testType;
                    }
                }
                stripData[++This] = thisElement = nextElement;
            }
            if (noe == This + 1) break;
            noe = This + 1;
        }
        return noe;
    }

    public static int[] getSimpleOptimizedStrip(int[][] elementData, int[] stripData) {
        int noe = stripData.length;
        while (noe > 1) {
            int This = 0;
            int thisElement = stripData[This];
            int next = 1;
            while (next < noe) {
                int nextElement = stripData[next];
                if (nextElement == thisElement) {
                    ++next;
                    continue;
                }
                int test = next + 1;
                if (test < noe) {
                    int testElement = stripData[test];
                    if (testElement != thisElement) {
                        stripData[++This] = thisElement = nextElement;
                        next = test;
                        continue;
                    }
                    if (This > 0) {
                        thisElement = stripData[--This];
                        next = test;
                        continue;
                    }
                    next = test + 1;
                    continue;
                }
                stripData[++This] = nextElement;
                break;
            }
            if (noe == This + 1) break;
            noe = This + 1;
        }
        if (noe == stripData.length) {
            return stripData;
        }
        int[] optimizedStrip = new int[noe];
        System.arraycopy(stripData, 0, optimizedStrip, 0, noe);
        return optimizedStrip;
    }
}

