/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.hyperSurface;

import java.io.Serializable;

public class MarchingCubes
implements Serializable {
    private static final long serialVersionUID = 1L;
    double[] point;
    int[] index;
    double[] min;
    double[] max;
    static int[][] triTable = new int[][]{new int[0], {0, 8, 3}, {0, 1, 9}, {1, 8, 3, 9, 8, 1}, {1, 2, 10}, {0, 8, 3, 1, 2, 10}, {9, 2, 10, 0, 2, 9}, {2, 8, 3, 2, 10, 8, 10, 9, 8}, {3, 11, 2}, {0, 11, 2, 8, 11, 0}, {1, 9, 0, 2, 3, 11}, {1, 11, 2, 1, 9, 11, 9, 8, 11}, {3, 10, 1, 11, 10, 3}, {0, 10, 1, 0, 8, 10, 8, 11, 10}, {3, 9, 0, 3, 11, 9, 11, 10, 9}, {9, 8, 10, 10, 8, 11}, {4, 7, 8}, {4, 3, 0, 7, 3, 4}, {0, 1, 9, 8, 4, 7}, {4, 1, 9, 4, 7, 1, 7, 3, 1}, {1, 2, 10, 8, 4, 7}, {3, 4, 7, 3, 0, 4, 1, 2, 10}, {9, 2, 10, 9, 0, 2, 8, 4, 7}, {2, 10, 9, 2, 9, 7, 2, 7, 3, 7, 9, 4}, {8, 4, 7, 3, 11, 2}, {11, 4, 7, 11, 2, 4, 2, 0, 4}, {9, 0, 1, 8, 4, 7, 2, 3, 11}, {4, 7, 11, 9, 4, 11, 9, 11, 2, 9, 2, 1}, {3, 10, 1, 3, 11, 10, 7, 8, 4}, {1, 11, 10, 1, 4, 11, 1, 0, 4, 7, 11, 4}, {4, 7, 8, 9, 0, 11, 9, 11, 10, 11, 0, 3}, {4, 7, 11, 4, 11, 9, 9, 11, 10}, {9, 5, 4}, {9, 5, 4, 0, 8, 3}, {0, 5, 4, 1, 5, 0}, {8, 5, 4, 8, 3, 5, 3, 1, 5}, {1, 2, 10, 9, 5, 4}, {3, 0, 8, 1, 2, 10, 4, 9, 5}, {5, 2, 10, 5, 4, 2, 4, 0, 2}, {2, 10, 5, 3, 2, 5, 3, 5, 4, 3, 4, 8}, {9, 5, 4, 2, 3, 11}, {0, 11, 2, 0, 8, 11, 4, 9, 5}, {0, 5, 4, 0, 1, 5, 2, 3, 11}, {2, 1, 5, 2, 5, 8, 2, 8, 11, 4, 8, 5}, {10, 3, 11, 10, 1, 3, 9, 5, 4}, {4, 9, 5, 0, 8, 1, 8, 10, 1, 8, 11, 10}, {5, 4, 0, 5, 0, 11, 5, 11, 10, 11, 0, 3}, {5, 4, 8, 5, 8, 10, 10, 8, 11}, {9, 7, 8, 5, 7, 9}, {9, 3, 0, 9, 5, 3, 5, 7, 3}, {0, 7, 8, 0, 1, 7, 1, 5, 7}, {1, 5, 3, 3, 5, 7}, {9, 7, 8, 9, 5, 7, 10, 1, 2}, {10, 1, 2, 9, 5, 0, 5, 3, 0, 5, 7, 3}, {8, 0, 2, 8, 2, 5, 8, 5, 7, 10, 5, 2}, {2, 10, 5, 2, 5, 3, 3, 5, 7}, {7, 9, 5, 7, 8, 9, 3, 11, 2}, {9, 5, 7, 9, 7, 2, 9, 2, 0, 2, 7, 11}, {2, 3, 11, 0, 1, 8, 1, 7, 8, 1, 5, 7}, {11, 2, 1, 11, 1, 7, 7, 1, 5}, {9, 5, 8, 8, 5, 7, 10, 1, 3, 10, 3, 11}, {5, 7, 0, 5, 0, 9, 7, 11, 0, 1, 0, 10, 11, 10, 0}, {11, 10, 0, 11, 0, 3, 10, 5, 0, 8, 0, 7, 5, 7, 0}, {11, 10, 5, 7, 11, 5}, {10, 6, 5}, {0, 8, 3, 5, 10, 6}, {9, 0, 1, 5, 10, 6}, {1, 8, 3, 1, 9, 8, 5, 10, 6}, {1, 6, 5, 2, 6, 1}, {1, 6, 5, 1, 2, 6, 3, 0, 8}, {9, 6, 5, 9, 0, 6, 0, 2, 6}, {5, 9, 8, 5, 8, 2, 5, 2, 6, 3, 2, 8}, {2, 3, 11, 10, 6, 5}, {11, 0, 8, 11, 2, 0, 10, 6, 5}, {0, 1, 9, 2, 3, 11, 5, 10, 6}, {5, 10, 6, 1, 9, 2, 9, 11, 2, 9, 8, 11}, {6, 3, 11, 6, 5, 3, 5, 1, 3}, {0, 8, 11, 0, 11, 5, 0, 5, 1, 5, 11, 6}, {3, 11, 6, 0, 3, 6, 0, 6, 5, 0, 5, 9}, {6, 5, 9, 6, 9, 11, 11, 9, 8}, {5, 10, 6, 4, 7, 8}, {4, 3, 0, 4, 7, 3, 6, 5, 10}, {1, 9, 0, 5, 10, 6, 8, 4, 7}, {10, 6, 5, 1, 9, 7, 1, 7, 3, 7, 9, 4}, {6, 1, 2, 6, 5, 1, 4, 7, 8}, {1, 2, 5, 5, 2, 6, 3, 0, 4, 3, 4, 7}, {8, 4, 7, 9, 0, 5, 0, 6, 5, 0, 2, 6}, {7, 3, 9, 7, 9, 4, 3, 2, 9, 5, 9, 6, 2, 6, 9}, {3, 11, 2, 7, 8, 4, 10, 6, 5}, {5, 10, 6, 4, 7, 2, 4, 2, 0, 2, 7, 11}, {0, 1, 9, 4, 7, 8, 2, 3, 11, 5, 10, 6}, {9, 2, 1, 9, 11, 2, 9, 4, 11, 7, 11, 4, 5, 10, 6}, {8, 4, 7, 3, 11, 5, 3, 5, 1, 5, 11, 6}, {5, 1, 11, 5, 11, 6, 1, 0, 11, 7, 11, 4, 0, 4, 11}, {0, 5, 9, 0, 6, 5, 0, 3, 6, 11, 6, 3, 8, 4, 7}, {6, 5, 9, 6, 9, 11, 4, 7, 9, 7, 11, 9}, {10, 4, 9, 6, 4, 10}, {4, 10, 6, 4, 9, 10, 0, 8, 3}, {10, 0, 1, 10, 6, 0, 6, 4, 0}, {8, 3, 1, 8, 1, 6, 8, 6, 4, 6, 1, 10}, {1, 4, 9, 1, 2, 4, 2, 6, 4}, {3, 0, 8, 1, 2, 9, 2, 4, 9, 2, 6, 4}, {0, 2, 4, 4, 2, 6}, {8, 3, 2, 8, 2, 4, 4, 2, 6}, {10, 4, 9, 10, 6, 4, 11, 2, 3}, {0, 8, 2, 2, 8, 11, 4, 9, 10, 4, 10, 6}, {3, 11, 2, 0, 1, 6, 0, 6, 4, 6, 1, 10}, {6, 4, 1, 6, 1, 10, 4, 8, 1, 2, 1, 11, 8, 11, 1}, {9, 6, 4, 9, 3, 6, 9, 1, 3, 11, 6, 3}, {8, 11, 1, 8, 1, 0, 11, 6, 1, 9, 1, 4, 6, 4, 1}, {3, 11, 6, 3, 6, 0, 0, 6, 4}, {6, 4, 8, 11, 6, 8}, {7, 10, 6, 7, 8, 10, 8, 9, 10}, {0, 7, 3, 0, 10, 7, 0, 9, 10, 6, 7, 10}, {10, 6, 7, 1, 10, 7, 1, 7, 8, 1, 8, 0}, {10, 6, 7, 10, 7, 1, 1, 7, 3}, {1, 2, 6, 1, 6, 8, 1, 8, 9, 8, 6, 7}, {2, 6, 9, 2, 9, 1, 6, 7, 9, 0, 9, 3, 7, 3, 9}, {7, 8, 0, 7, 0, 6, 6, 0, 2}, {7, 3, 2, 6, 7, 2}, {2, 3, 11, 10, 6, 8, 10, 8, 9, 8, 6, 7}, {2, 0, 7, 2, 7, 11, 0, 9, 7, 6, 7, 10, 9, 10, 7}, {1, 8, 0, 1, 7, 8, 1, 10, 7, 6, 7, 10, 2, 3, 11}, {11, 2, 1, 11, 1, 7, 10, 6, 1, 6, 7, 1}, {8, 9, 6, 8, 6, 7, 9, 1, 6, 11, 6, 3, 1, 3, 6}, {0, 9, 1, 11, 6, 7}, {7, 8, 0, 7, 0, 6, 3, 11, 0, 11, 6, 0}, {7, 11, 6}, {7, 6, 11}, {3, 0, 8, 11, 7, 6}, {0, 1, 9, 11, 7, 6}, {8, 1, 9, 8, 3, 1, 11, 7, 6}, {10, 1, 2, 6, 11, 7}, {1, 2, 10, 3, 0, 8, 6, 11, 7}, {2, 9, 0, 2, 10, 9, 6, 11, 7}, {6, 11, 7, 2, 10, 3, 10, 8, 3, 10, 9, 8}, {7, 2, 3, 6, 2, 7}, {7, 0, 8, 7, 6, 0, 6, 2, 0}, {2, 7, 6, 2, 3, 7, 0, 1, 9}, {1, 6, 2, 1, 8, 6, 1, 9, 8, 8, 7, 6}, {10, 7, 6, 10, 1, 7, 1, 3, 7}, {10, 7, 6, 1, 7, 10, 1, 8, 7, 1, 0, 8}, {0, 3, 7, 0, 7, 10, 0, 10, 9, 6, 10, 7}, {7, 6, 10, 7, 10, 8, 8, 10, 9}, {6, 8, 4, 11, 8, 6}, {3, 6, 11, 3, 0, 6, 0, 4, 6}, {8, 6, 11, 8, 4, 6, 9, 0, 1}, {9, 4, 6, 9, 6, 3, 9, 3, 1, 11, 3, 6}, {6, 8, 4, 6, 11, 8, 2, 10, 1}, {1, 2, 10, 3, 0, 11, 0, 6, 11, 0, 4, 6}, {4, 11, 8, 4, 6, 11, 0, 2, 9, 2, 10, 9}, {10, 9, 3, 10, 3, 2, 9, 4, 3, 11, 3, 6, 4, 6, 3}, {8, 2, 3, 8, 4, 2, 4, 6, 2}, {0, 4, 2, 4, 6, 2}, {1, 9, 0, 2, 3, 4, 2, 4, 6, 4, 3, 8}, {1, 9, 4, 1, 4, 2, 2, 4, 6}, {8, 1, 3, 8, 6, 1, 8, 4, 6, 6, 10, 1}, {10, 1, 0, 10, 0, 6, 6, 0, 4}, {4, 6, 3, 4, 3, 8, 6, 10, 3, 0, 3, 9, 10, 9, 3}, {10, 9, 4, 6, 10, 4}, {4, 9, 5, 7, 6, 11}, {0, 8, 3, 4, 9, 5, 11, 7, 6}, {5, 0, 1, 5, 4, 0, 7, 6, 11}, {11, 7, 6, 8, 3, 4, 3, 5, 4, 3, 1, 5}, {9, 5, 4, 10, 1, 2, 7, 6, 11}, {6, 11, 7, 1, 2, 10, 0, 8, 3, 4, 9, 5}, {7, 6, 11, 5, 4, 10, 4, 2, 10, 4, 0, 2}, {3, 4, 8, 3, 5, 4, 3, 2, 5, 10, 5, 2, 11, 7, 6}, {7, 2, 3, 7, 6, 2, 5, 4, 9}, {9, 5, 4, 0, 8, 6, 0, 6, 2, 6, 8, 7}, {3, 6, 2, 3, 7, 6, 1, 5, 0, 5, 4, 0}, {6, 2, 8, 6, 8, 7, 2, 1, 8, 4, 8, 5, 1, 5, 8}, {9, 5, 4, 10, 1, 6, 1, 7, 6, 1, 3, 7}, {1, 6, 10, 1, 7, 6, 1, 0, 7, 8, 7, 0, 9, 5, 4}, {4, 0, 10, 4, 10, 5, 0, 3, 10, 6, 10, 7, 3, 7, 10}, {7, 6, 10, 7, 10, 8, 5, 4, 10, 4, 8, 10}, {6, 9, 5, 6, 11, 9, 11, 8, 9}, {3, 6, 11, 0, 6, 3, 0, 5, 6, 0, 9, 5}, {0, 11, 8, 0, 5, 11, 0, 1, 5, 5, 6, 11}, {6, 11, 3, 6, 3, 5, 5, 3, 1}, {1, 2, 10, 9, 5, 11, 9, 11, 8, 11, 5, 6}, {0, 11, 3, 0, 6, 11, 0, 9, 6, 5, 6, 9, 1, 2, 10}, {11, 8, 5, 11, 5, 6, 8, 0, 5, 10, 5, 2, 0, 2, 5}, {6, 11, 3, 6, 3, 5, 2, 10, 3, 10, 5, 3}, {5, 8, 9, 5, 2, 8, 5, 6, 2, 3, 8, 2}, {9, 5, 6, 9, 6, 0, 0, 6, 2}, {1, 5, 8, 1, 8, 0, 5, 6, 8, 3, 8, 2, 6, 2, 8}, {1, 5, 6, 2, 1, 6}, {1, 3, 6, 1, 6, 10, 3, 8, 6, 5, 6, 9, 8, 9, 6}, {10, 1, 0, 10, 0, 6, 9, 5, 0, 5, 6, 0}, {0, 3, 8, 5, 6, 10}, {10, 5, 6}, {11, 5, 10, 7, 5, 11}, {11, 5, 10, 11, 7, 5, 8, 3, 0}, {5, 11, 7, 5, 10, 11, 1, 9, 0}, {10, 7, 5, 10, 11, 7, 9, 8, 1, 8, 3, 1}, {11, 1, 2, 11, 7, 1, 7, 5, 1}, {0, 8, 3, 1, 2, 7, 1, 7, 5, 7, 2, 11}, {9, 7, 5, 9, 2, 7, 9, 0, 2, 2, 11, 7}, {7, 5, 2, 7, 2, 11, 5, 9, 2, 3, 2, 8, 9, 8, 2}, {2, 5, 10, 2, 3, 5, 3, 7, 5}, {8, 2, 0, 8, 5, 2, 8, 7, 5, 10, 2, 5}, {9, 0, 1, 5, 10, 3, 5, 3, 7, 3, 10, 2}, {9, 8, 2, 9, 2, 1, 8, 7, 2, 10, 2, 5, 7, 5, 2}, {1, 3, 5, 3, 7, 5}, {0, 8, 7, 0, 7, 1, 1, 7, 5}, {9, 0, 3, 9, 3, 5, 5, 3, 7}, {9, 8, 7, 5, 9, 7}, {5, 8, 4, 5, 10, 8, 10, 11, 8}, {5, 0, 4, 5, 11, 0, 5, 10, 11, 11, 3, 0}, {0, 1, 9, 8, 4, 10, 8, 10, 11, 10, 4, 5}, {10, 11, 4, 10, 4, 5, 11, 3, 4, 9, 4, 1, 3, 1, 4}, {2, 5, 1, 2, 8, 5, 2, 11, 8, 4, 5, 8}, {0, 4, 11, 0, 11, 3, 4, 5, 11, 2, 11, 1, 5, 1, 11}, {0, 2, 5, 0, 5, 9, 2, 11, 5, 4, 5, 8, 11, 8, 5}, {9, 4, 5, 2, 11, 3}, {2, 5, 10, 3, 5, 2, 3, 4, 5, 3, 8, 4}, {5, 10, 2, 5, 2, 4, 4, 2, 0}, {3, 10, 2, 3, 5, 10, 3, 8, 5, 4, 5, 8, 0, 1, 9}, {5, 10, 2, 5, 2, 4, 1, 9, 2, 9, 4, 2}, {8, 4, 5, 8, 5, 3, 3, 5, 1}, {0, 4, 5, 1, 0, 5}, {8, 4, 5, 8, 5, 3, 9, 0, 5, 0, 3, 5}, {9, 4, 5}, {4, 11, 7, 4, 9, 11, 9, 10, 11}, {0, 8, 3, 4, 9, 7, 9, 11, 7, 9, 10, 11}, {1, 10, 11, 1, 11, 4, 1, 4, 0, 7, 4, 11}, {3, 1, 4, 3, 4, 8, 1, 10, 4, 7, 4, 11, 10, 11, 4}, {4, 11, 7, 9, 11, 4, 9, 2, 11, 9, 1, 2}, {9, 7, 4, 9, 11, 7, 9, 1, 11, 2, 11, 1, 0, 8, 3}, {11, 7, 4, 11, 4, 2, 2, 4, 0}, {11, 7, 4, 11, 4, 2, 8, 3, 4, 3, 2, 4}, {2, 9, 10, 2, 7, 9, 2, 3, 7, 7, 4, 9}, {9, 10, 7, 9, 7, 4, 10, 2, 7, 8, 7, 0, 2, 0, 7}, {3, 7, 10, 3, 10, 2, 7, 4, 10, 1, 10, 0, 4, 0, 10}, {1, 10, 2, 8, 7, 4}, {4, 9, 1, 4, 1, 7, 7, 1, 3}, {4, 9, 1, 4, 1, 7, 0, 8, 1, 8, 7, 1}, {4, 0, 3, 7, 4, 3}, {4, 8, 7}, {9, 10, 8, 10, 11, 8}, {3, 0, 9, 3, 9, 11, 11, 9, 10}, {0, 1, 10, 0, 10, 8, 8, 10, 11}, {3, 1, 10, 11, 3, 10}, {1, 2, 11, 1, 11, 9, 9, 11, 8}, {3, 0, 9, 3, 9, 11, 1, 2, 9, 2, 11, 9}, {0, 2, 11, 8, 0, 11}, {3, 2, 11}, {2, 3, 8, 2, 8, 10, 10, 8, 9}, {9, 10, 2, 0, 9, 2}, {2, 3, 8, 2, 8, 10, 0, 1, 8, 1, 10, 8}, {1, 10, 2}, {1, 3, 8, 9, 1, 8}, {0, 9, 1}, {0, 3, 8}, new int[0]};

    public MarchingCubes() {
        this.min = new double[]{-0.5, -0.5, -0.5};
        this.max = new double[]{0.5, 0.5, 0.5};
    }

    public MarchingCubes(double[][][] field, double level, double[] min, double[] max) {
        this.min = min;
        this.max = max;
        this.triangulate(field, level);
    }

    public double getMin(int index) {
        return this.min[index];
    }

    public void setMin(int index, double min) {
        if (this.min[index] == min) {
            return;
        }
        if (this.max[index] <= min) {
            throw new IllegalArgumentException(" max must be bigger then min");
        }
        this.rescale(index, min, this.min[index], this.max[index], this.max[index]);
        this.min[index] = min;
    }

    public double getMax(int index) {
        return this.max[index];
    }

    public void setMax(int index, double max) {
        if (this.max[index] == max) {
            return;
        }
        if (this.min[index] >= max) {
            throw new IllegalArgumentException(" max must be bigger then min");
        }
        this.rescale(index, this.min[index], this.min[index], max, this.max[index]);
        this.max[index] = max;
    }

    private void rescale(int index, double newMin, double oldMin, double newMax, double oldMax) {
        if (this.point == null) {
            return;
        }
        double factor = (newMax - newMin) / (oldMax - oldMin);
        double offset = newMin - oldMin * factor;
        for (int i = index; i < this.point.length; i += 3) {
            this.point[i] = offset + this.point[i] * factor;
        }
    }

    public double[] getPoints() {
        return this.point;
    }

    public int[] getIndices() {
        return this.index;
    }

    public void triangulate(final double[][][] field, double level) {
        RealFunctionOnTripleIndex function = new RealFunctionOnTripleIndex(){
            {
                this.xSize = field.length;
                this.ySize = field[0].length;
                this.zSize = field[0][0].length;
            }

            @Override
            double valueAt(int i, int j, int k) {
                return field[i][j][k];
            }
        };
        this.triangulate(function, level);
    }

    public void triangulate(final RealFunctionOnReal3 f, final int[] sizes, double level) {
        RealFunctionOnTripleIndex function = new RealFunctionOnTripleIndex(){
            final double xs;
            final double ys;
            final double zs;
            final double xMin;
            final double yMin;
            final double zMin;
            final double xMax;
            final double yMax;
            final double zMax;
            {
                this.xSize = sizes[0];
                this.ySize = sizes[1];
                this.zSize = sizes[2];
                this.xs = 1.0 / (double)(this.xSize - 1);
                this.ys = 1.0 / (double)(this.ySize - 1);
                this.zs = 1.0 / (double)(this.zSize - 1);
                this.xMin = MarchingCubes.this.min[0];
                this.yMin = MarchingCubes.this.min[1];
                this.zMin = MarchingCubes.this.min[2];
                this.xMax = MarchingCubes.this.max[0];
                this.yMax = MarchingCubes.this.max[1];
                this.zMax = MarchingCubes.this.max[2];
            }

            @Override
            double valueAt(int i, int j, int k) {
                double x = this.xMin * (1.0 - (double)i * this.xs) + this.xMax * (double)i * this.xs;
                double y = this.yMin * (1.0 - (double)j * this.ys) + this.yMax * (double)j * this.ys;
                double z = this.zMin * (1.0 - (double)k * this.zs) + this.zMax * (double)k * this.zs;
                return f.valueAt(x, y, z);
            }
        };
        this.triangulate(function, level);
    }

    void triangulate(RealFunctionOnTripleIndex field, double level) {
        int k;
        double t;
        double q;
        int k2;
        double p;
        int i;
        int xSize = field.xSize;
        int ySize = field.ySize;
        int zSize = field.zSize;
        int[][][] xIndex = new int[xSize - 1][ySize][zSize];
        int[][][] yIndex = new int[xSize][ySize - 1][zSize];
        int[][][] zIndex = new int[xSize][ySize][zSize - 1];
        int numOfPoints = 0;
        for (i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                p = field.valueAt(i, j, 0);
                for (k2 = 1; k2 < zSize; ++k2) {
                    q = field.valueAt(i, j, k2);
                    if (q < level && p >= level || p < level && q >= level) {
                        t = (level - p) / (q - p);
                        double z = (double)(k2 - 1) + t;
                        this.setPoint(numOfPoints, i, j, z);
                        zIndex[i][j][k2 - 1] = numOfPoints++;
                    } else {
                        zIndex[i][j][k2 - 1] = -1;
                    }
                    p = q;
                }
            }
        }
        for (int j = 0; j < ySize; ++j) {
            for (k = 0; k < zSize; ++k) {
                p = field.valueAt(0, j, k);
                for (int i2 = 1; i2 < xSize; ++i2) {
                    q = field.valueAt(i2, j, k);
                    if (q < level && p >= level || p < level && q >= level) {
                        t = (level - p) / (q - p);
                        double x = (double)(i2 - 1) + t;
                        this.setPoint(numOfPoints, x, j, k);
                        xIndex[i2 - 1][j][k] = numOfPoints++;
                    } else {
                        xIndex[i2 - 1][j][k] = -1;
                    }
                    p = q;
                }
            }
        }
        for (i = 0; i < xSize; ++i) {
            for (k = 0; k < zSize; ++k) {
                p = field.valueAt(i, 0, k);
                for (int j = 1; j < ySize; ++j) {
                    q = field.valueAt(i, j, k);
                    if (q < level && p >= level || p < level && q >= level) {
                        t = (level - p) / (q - p);
                        double y = (double)(j - 1) + t;
                        this.setPoint(numOfPoints, i, y, k);
                        yIndex[i][j - 1][k] = numOfPoints++;
                    } else {
                        yIndex[i][j - 1][k] = -1;
                    }
                    p = q;
                }
            }
        }
        this.setNumOfPoints(numOfPoints);
        int numOfTriangles = 0;
        int[] vertexOnEdge = new int[12];
        for (int i3 = 0; i3 < xSize - 1; ++i3) {
            for (int j = 0; j < ySize - 1; ++j) {
                for (k2 = 0; k2 < zSize - 1; ++k2) {
                    int cubeindex = 0;
                    if (field.valueAt(i3, j, k2) < level) {
                        cubeindex |= 1;
                    }
                    if (field.valueAt(i3 + 1, j, k2) < level) {
                        cubeindex |= 2;
                    }
                    if (field.valueAt(i3 + 1, j, k2 + 1) < level) {
                        cubeindex |= 4;
                    }
                    if (field.valueAt(i3, j, k2 + 1) < level) {
                        cubeindex |= 8;
                    }
                    if (field.valueAt(i3, j + 1, k2) < level) {
                        cubeindex |= 0x10;
                    }
                    if (field.valueAt(i3 + 1, j + 1, k2) < level) {
                        cubeindex |= 0x20;
                    }
                    if (field.valueAt(i3 + 1, j + 1, k2 + 1) < level) {
                        cubeindex |= 0x40;
                    }
                    if (field.valueAt(i3, j + 1, k2 + 1) < level) {
                        cubeindex |= 0x80;
                    }
                    if (cubeindex == 0 || cubeindex == 255) continue;
                    vertexOnEdge[0] = xIndex[i3][j][k2];
                    vertexOnEdge[2] = xIndex[i3][j][k2 + 1];
                    vertexOnEdge[4] = xIndex[i3][j + 1][k2];
                    vertexOnEdge[6] = xIndex[i3][j + 1][k2 + 1];
                    vertexOnEdge[8] = yIndex[i3][j][k2];
                    vertexOnEdge[9] = yIndex[i3 + 1][j][k2];
                    vertexOnEdge[10] = yIndex[i3 + 1][j][k2 + 1];
                    vertexOnEdge[11] = yIndex[i3][j][k2 + 1];
                    vertexOnEdge[1] = zIndex[i3 + 1][j][k2];
                    vertexOnEdge[3] = zIndex[i3][j][k2];
                    vertexOnEdge[5] = zIndex[i3 + 1][j + 1][k2];
                    vertexOnEdge[7] = zIndex[i3][j + 1][k2];
                    int s = 0;
                    while (s < triTable[cubeindex].length) {
                        this.setTriangle(numOfTriangles, vertexOnEdge[triTable[cubeindex][s]], vertexOnEdge[triTable[cubeindex][s + 1]], vertexOnEdge[triTable[cubeindex][s + 2]]);
                        s += 3;
                        ++numOfTriangles;
                    }
                }
            }
        }
        this.setNumOfTriangles(numOfTriangles);
        this.rescale(0, this.min[0], 0.0, this.max[0], xSize - 1);
        this.rescale(1, this.min[1], 0.0, this.max[1], ySize - 1);
        this.rescale(2, this.min[2], 0.0, this.max[2], zSize - 1);
    }

    private void setPoint(int pos, double x, double y, double z) {
        if (this.point == null || this.point.length <= 3 * pos) {
            double[] newPoint = new double[3 * pos + 300];
            if (this.point != null) {
                System.arraycopy(this.point, 0, newPoint, 0, this.point.length);
            }
            this.point = newPoint;
        }
        this.point[3 * pos] = x;
        this.point[3 * pos + 1] = y;
        this.point[3 * pos + 2] = z;
    }

    private void setNumOfPoints(int nop) {
        if (this.point != null && this.point.length == 3 * nop) {
            return;
        }
        double[] newPoint = new double[3 * nop];
        if (this.point != null) {
            System.arraycopy(this.point, 0, newPoint, 0, Math.min(3 * nop, this.point.length));
        }
        this.point = newPoint;
    }

    private void setTriangle(int pos, int p, int q, int r) {
        if (this.index == null || this.index.length <= 3 * pos) {
            int[] newIndex = new int[3 * pos + 300];
            if (this.index != null) {
                System.arraycopy(this.index, 0, newIndex, 0, this.index.length);
            }
            this.index = newIndex;
        }
        this.index[3 * pos] = p;
        this.index[3 * pos + 1] = q;
        this.index[3 * pos + 2] = r;
    }

    private void setNumOfTriangles(int not) {
        if (this.index != null && this.index.length == 3 * not) {
            return;
        }
        int[] newIndex = new int[3 * not];
        if (this.index != null) {
            System.arraycopy(this.index, 0, newIndex, 0, Math.min(3 * not, this.index.length));
        }
        this.index = newIndex;
    }

    public static interface RealFunctionOnReal3 {
        public double valueAt(double var1, double var3, double var5);
    }

    static abstract class RealFunctionOnTripleIndex {
        int xSize;
        int ySize;
        int zSize;

        RealFunctionOnTripleIndex() {
        }

        abstract double valueAt(int var1, int var2, int var3);
    }
}

