/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.hyperSurface;

public class MarchingSquares {
    public static RealFunctionOnTupleIndex scanner(final RealFunctionOnReal2 f, final double xMin, final double xMax, final int xDiscr, final double yMin, final double yMax, final int yDiscr) {
        return new RealFunctionOnTupleIndex(){
            final double xs;
            final double ys;
            {
                this.xSize = xDiscr;
                this.ySize = yDiscr;
                this.xs = 1.0 / (double)(this.xSize - 1);
                this.ys = 1.0 / (double)(this.ySize - 1);
            }

            @Override
            double valueAt(int i, int j) {
                double x = xMin * (1.0 - (double)i * this.xs) + xMax * (double)i * this.xs;
                double y = yMin * (1.0 - (double)j * this.ys) + yMax * (double)j * this.ys;
                return f.valueAt(x, y);
            }
        };
    }

    public static double[][] scan(RealFunctionOnReal2 f, double xMin, double xMax, int xDiscr, double yMin, double yMax, int yDiscr) {
        double[][] scan = new double[xDiscr][yDiscr];
        MarchingSquares.scan(scan, f, xMin, xMax, yMin, yMax);
        return scan;
    }

    public static void scan(double[][] scan, RealFunctionOnReal2 f, double xMin, double xMax, double yMin, double yMax) {
        int xDiscr = scan.length;
        int yDiscr = scan[0].length;
        RealFunctionOnTupleIndex scanner = MarchingSquares.scanner(f, xMin, xMax, xDiscr, yMin, yMax, yDiscr);
        for (int i = 0; i < xDiscr; ++i) {
            for (int j = 0; j < yDiscr; ++j) {
                scan[i][j] = scanner.valueAt(i, j);
            }
        }
    }

    public static IndexedLineSet compute(RealFunctionOnReal2 f, double level, double xMin, double xMax, int xDiscr, double yMin, double yMax, int yDiscr) {
        RealFunctionOnTupleIndex scanner = MarchingSquares.scanner(f, xMin, xMax, xDiscr, yMin, yMax, yDiscr);
        return MarchingSquares.compute(scanner, level, xMin, xMax, yMin, yMax);
    }

    public static IndexedLineSet compute(RealFunctionOnTupleIndex f, double level, double xMin, double xMax, double yMin, double yMax) {
        int i;
        double t;
        double q;
        double p;
        int i2;
        int xSize = f.xSize;
        int ySize = f.ySize;
        int[][] xIndex = new int[xSize][ySize - 1];
        int[][] yIndex = new int[xSize - 1][ySize];
        int numOfPoints = 0;
        double[] point = new double[100];
        for (i2 = 0; i2 < xSize; ++i2) {
            p = f.valueAt(i2, 0) - level;
            for (int j = 1; j < ySize; ++j) {
                q = f.valueAt(i2, j) - level;
                if (p * q < 0.0) {
                    t = Math.abs(p) / (Math.abs(p) + Math.abs(q));
                    double y = (1.0 - t) * (double)(j - 1) + t * (double)j;
                    point = MarchingSquares.setPoint(point, numOfPoints, i2, y);
                    xIndex[i2][j - 1] = numOfPoints++;
                } else {
                    xIndex[i2][j - 1] = -1;
                }
                p = q;
            }
        }
        for (int j = 0; j < ySize; ++j) {
            p = f.valueAt(0, j) - level;
            for (i = 1; i < xSize; ++i) {
                q = f.valueAt(i, j) - level;
                if (p * q < 0.0) {
                    t = Math.abs(p) / (Math.abs(p) + Math.abs(q));
                    double x = (1.0 - t) * (double)(i - 1) + t * (double)i;
                    point = MarchingSquares.setPoint(point, numOfPoints, x, j);
                    yIndex[i - 1][j] = numOfPoints++;
                } else {
                    yIndex[i - 1][j] = -1;
                }
                p = q;
            }
        }
        point = MarchingSquares.resize(point, 2 * numOfPoints);
        int j = 0;
        for (i2 = 0; i2 < numOfPoints; ++i2) {
            point[j] = xMin * (1.0 - point[j] / (double)(xSize - 1)) + xMax * (point[j] / (double)(xSize - 1));
            point[++j] = yMin * (1.0 - point[j] / (double)(ySize - 1)) + yMax * (point[j] / (double)(ySize - 1));
            ++j;
        }
        int[] index = new int[100];
        int[] intersection = new int[4];
        int numOfEdges = 0;
        for (i = 0; i < xSize - 1; ++i) {
            for (int j2 = 0; j2 < ySize - 1; ++j2) {
                intersection[0] = xIndex[i][j2];
                intersection[1] = xIndex[i + 1][j2];
                intersection[2] = yIndex[i][j2];
                intersection[3] = yIndex[i][j2 + 1];
                for (int ii = 0; ii < 4; ++ii) {
                    if (intersection[ii] == -1) continue;
                    for (int jj = ii + 1; jj < 4; ++jj) {
                        if (intersection[jj] == -1) continue;
                        index = MarchingSquares.setEdge(index, numOfEdges++, intersection[ii], intersection[jj]);
                    }
                }
            }
        }
        index = MarchingSquares.resize(index, 2 * numOfEdges);
        int[] count = new int[numOfEdges];
        for (int i3 = 0; i3 < numOfEdges; ++i3) {
            count[i3] = 2;
        }
        return new IndexedLineSet(point, index, count);
    }

    public static IndexedLineSet compute(final double[][] field, double level, double xMin, double xMax, double yMin, double yMax) {
        RealFunctionOnTupleIndex f = new RealFunctionOnTupleIndex(){
            {
                this.xSize = field.length;
                this.ySize = field[0].length;
            }

            @Override
            double valueAt(int i, int j) {
                return field[i][j];
            }
        };
        return MarchingSquares.compute(f, level, xMin, xMax, yMin, yMax);
    }

    private static double[] setPoint(double[] point, int pos, double x, double y) {
        if (point.length <= 2 * pos) {
            double[] newPoint = new double[2 * point.length + 10];
            System.arraycopy(point, 0, newPoint, 0, point.length);
            point = newPoint;
        }
        point[2 * pos] = x;
        point[2 * pos + 1] = y;
        return point;
    }

    private static double[] resize(double[] point, int size) {
        if (point.length == size) {
            return point;
        }
        double[] newPoint = new double[size];
        System.arraycopy(point, 0, newPoint, 0, Math.min(size, point.length));
        return newPoint;
    }

    private static int[] setEdge(int[] index, int pos, int p, int q) {
        if (index.length <= 2 * pos + 2) {
            int[] newIndex = new int[2 * index.length + 10];
            System.arraycopy(index, 0, newIndex, 0, index.length);
            index = newIndex;
        }
        index[2 * pos] = p;
        index[2 * pos + 1] = q;
        return index;
    }

    private static int[] resize(int[] index, int size) {
        if (index.length == size) {
            return index;
        }
        int[] newIndex = new int[size];
        System.arraycopy(index, 0, newIndex, 0, Math.min(size, index.length));
        return newIndex;
    }

    public static double[][] removeDirt(double[][] field, int x, int y, double min, double max, double ratio, double value) {
        int xSize = field.length;
        int ySize = field[0].length;
        double[][] out = (double[][])field.clone();
        int xSizeMinusX = xSize - x;
        int ySizeMinusY = ySize - y;
        int count = (int)((double)(x * y) * ratio);
        for (int i = 0; i < xSizeMinusX; ++i) {
            for (int j = 0; j < ySizeMinusY; ++j) {
                if (MarchingSquares.getNumOfDirtyValues(field, i, j, x, y, min, max) <= count) continue;
                MarchingSquares.removeDirt(out, i, j, x, y, value);
            }
        }
        return out;
    }

    public static int getNumOfDirtyValues(double[][] field, int i, int j, int x, int y, double min, double max) {
        int numOfDirtyValues = 0;
        int I = 0;
        int ii = i;
        while (I < x) {
            int J = 0;
            int jj = j;
            while (J < y) {
                double v = field[ii][jj];
                if (v < min || v > max) {
                    ++numOfDirtyValues;
                }
                ++J;
                ++jj;
            }
            ++I;
            ++ii;
        }
        return numOfDirtyValues;
    }

    public static void removeDirt(double[][] field, int i, int j, int x, int y, double value) {
        int I = 0;
        int ii = i;
        while (I < x) {
            int J = 0;
            int jj = j;
            while (J < y) {
                field[ii][jj] = value;
                ++J;
                ++jj;
            }
            ++I;
            ++ii;
        }
    }

    public static double[][] removeDirt(double[][] field, int l, int maxNumOfSignChanges, double value) {
        double[][] out = (double[][])field.clone();
        MarchingSquares.removeDirt(field, out, l, maxNumOfSignChanges, value);
        return out;
    }

    public static void removeDirt(double[][] field, double[][] out, int l, int maxNumOfSignChanges, double value) {
        int k;
        int kk;
        int count;
        int xSize = field.length;
        int ySize = field[0].length;
        for (int i = 0; i < xSize; ++i) {
            System.arraycopy(field[i], 0, out[i], 0, ySize);
        }
        int xSizeMinusL = xSize - l;
        int ySizeMinusL = ySize - l;
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySizeMinusL; ++j) {
                count = 0;
                kk = 1;
                k = j + 1;
                while (kk < l) {
                    if ((field[i][k - 1] - value) * (field[i][k] - value) < 0.0) {
                        ++count;
                    }
                    ++kk;
                    ++k;
                }
                if (count <= maxNumOfSignChanges) continue;
                MarchingSquares.removeDirt(out, i, j, 1, l, value);
            }
        }
        for (int j = 0; j < ySize; ++j) {
            for (int i = 0; i < xSizeMinusL; ++i) {
                count = 0;
                kk = 1;
                k = i + 1;
                while (kk < l) {
                    if (field[k - 1][j] * field[k][j] < 0.0) {
                        ++count;
                    }
                    ++kk;
                    ++k;
                }
                if (count <= maxNumOfSignChanges) continue;
                MarchingSquares.removeDirt(out, i, j, l, 1, value);
            }
        }
    }

    public static interface RealFunctionOnReal2 {
        public double valueAt(double var1, double var3);
    }

    static abstract class RealFunctionOnTupleIndex {
        int xSize;
        int ySize;

        RealFunctionOnTupleIndex() {
        }

        abstract double valueAt(int var1, int var2);
    }

    public static class IndexedLineSet {
        double[] points;
        int[] index;
        int[] length;

        IndexedLineSet(double[] points, int[] index, int[] length) {
            this.points = points;
            this.index = index;
            this.length = length;
        }

        public int[] getIndex() {
            return this.index;
        }

        public int[] getLength() {
            return this.length;
        }

        public double[] getPoints() {
            return this.points;
        }
    }
}

