/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.latticeReduction;

public class LLL {
    private static final double EPS = 1.0E-13;
    static int dim = 0;
    static double[][] A;
    static double[][] mu;
    static double[] a;

    private static void setDimension(int n) {
        if (n != dim) {
            dim = n;
            A = new double[dim][dim];
            mu = new double[dim][dim];
            a = new double[dim];
        }
    }

    private static void initLLL(double[][] B, int[][] U, double[][] U_, double[][] mu, double[] a) {
        int j;
        int i;
        int n = B.length;
        if (U != null) {
            for (i = 0; i < n; ++i) {
                for (j = 0; j < n; ++j) {
                    U[i][j] = i == j ? 1 : 0;
                }
            }
        }
        if (U_ != null) {
            for (i = 0; i < n; ++i) {
                for (j = 0; j < n; ++j) {
                    U_[i][j] = i == j ? 1.0 : 0.0;
                }
            }
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                LLL.A[i][j] = B[i][j];
            }
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < i; ++j) {
                double d = LLL.dot(B[i], A[j]) / a[j];
                mu[i][j] = d;
                double t = d;
                for (int k = 0; k < n; ++k) {
                    double[] dArray = A[i];
                    int n2 = k;
                    dArray[n2] = dArray[n2] - t * A[j][k];
                }
            }
            a[i] = LLL.dot(A[i], A[i]);
        }
    }

    public static void reduce(double[][] B) {
        LLL.reduce(B, null, null, 0.75);
    }

    public static void reduce(double[][] B, int[][] U) {
        LLL.reduce(B, U, null, 0.75);
    }

    public static void reduce(double[][] B, double[][] U) {
        LLL.reduce(B, null, U, 0.75);
    }

    public static void reduce(double[][] B, int[][] U, double[][] U_, double c) {
        if (c < 0.25 || c > 1.0) {
            throw new IllegalArgumentException("constant is not in [1/4,1]");
        }
        int n = B.length;
        LLL.setDimension(n);
        LLL.initLLL(B, U, U_, mu, a);
        if (n < 2) {
            return;
        }
        int k = 1;
        while (true) {
            LLL.transform(B, U, U_, mu, k, k - 1);
            if (a[k] + 1.0E-13 < (c - mu[k][k - 1] * mu[k][k - 1]) * a[k - 1]) {
                LLL.swap(B, U, U_, mu, a, k);
                if (k <= 1) continue;
                --k;
                continue;
            }
            for (int l = k - 2; l >= 0; --l) {
                LLL.transform(B, U, U_, mu, k, l);
            }
            if (++k == n) break;
        }
    }

    private static void swap(double[][] B, int[][] U, double[][] U_, double[][] mu, double[] a, int k) {
        int n = B.length;
        double MU = mu[k][k - 1];
        double tmp = a[k] + MU * MU * a[k - 1];
        double[] dArray = mu[k];
        int n2 = k - 1;
        dArray[n2] = dArray[n2] * (a[k - 1] / tmp);
        int n3 = k;
        a[n3] = a[n3] * (a[k - 1] / tmp);
        a[k - 1] = tmp;
        LLL.swap(B, k, k - 1);
        if (U != null) {
            LLL.swap(U, k, k - 1);
        }
        if (U_ != null) {
            LLL.swap(U_, k, k - 1);
        }
        for (int j = 0; j < k - 1; ++j) {
            tmp = mu[k - 1][j];
            mu[k - 1][j] = mu[k][j];
            mu[k][j] = tmp;
        }
        for (int i = k + 1; i < n; ++i) {
            double t1;
            double t2 = mu[i][k - 1] - MU * mu[i][k];
            mu[i][k - 1] = t1 = mu[i][k] + t2 * mu[k][k - 1];
            mu[i][k] = t2;
        }
    }

    private static void transform(double[][] B, int[][] U, double[][] U_, double[][] mu, int k, int l) {
        if (Math.abs(mu[k][l]) > 0.5) {
            int r = (int)Math.floor(mu[k][l] + 0.5);
            int n = B.length;
            for (int i = 0; i < n; ++i) {
                double[] dArray = B[k];
                int n2 = i;
                dArray[n2] = dArray[n2] - (double)r * B[l][i];
                if (U != null) {
                    int[] nArray = U[k];
                    int n3 = i;
                    nArray[n3] = nArray[n3] - r * U[l][i];
                }
                if (U_ == null) continue;
                double[] dArray2 = U_[k];
                int n4 = i;
                dArray2[n4] = dArray2[n4] - (double)r * U_[l][i];
            }
            for (int j = 0; j < l; ++j) {
                double[] dArray = mu[k];
                int n5 = j;
                dArray[n5] = dArray[n5] - (double)r * mu[l][j];
            }
            double[] dArray = mu[k];
            int n6 = l;
            dArray[n6] = dArray[n6] - (double)r;
        }
    }

    private static double dot(double[] a, double[] b) {
        double result = 0.0;
        for (int i = 0; i < a.length; ++i) {
            result += a[i] * b[i];
        }
        return result;
    }

    private static void swap(double[][] a, int k, int l) {
        double[] tmp = a[k];
        a[k] = a[l];
        a[l] = tmp;
    }

    private static void swap(int[][] a, int k, int l) {
        int[] tmp = a[k];
        a[k] = a[l];
        a[l] = tmp;
    }

    private static void print(double[] a, String name) {
        System.out.print(name);
        for (int i = 0; i < a.length; ++i) {
            System.out.print("  " + a[i]);
        }
        System.out.println("  ");
    }
}

