/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.meshGeneration.ruppert;

import de.jtem.numericalMethods.geometry.meshGeneration.ruppert.Initializer;
import de.jtem.numericalMethods.geometry.meshGeneration.ruppert.Ruppert;
import java.awt.Button;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;

public class DelaunayViewer
implements Serializable {
    private static final long serialVersionUID = 1L;
    double xmin;
    double xmax;
    double ymin;
    double ymax;
    int FX_SIZE = 500;
    int FY_SIZE = 500;
    int X_SIZE = 500;
    int Y_SIZE;
    double[] point;
    int[] face;
    int nof;
    int[] xx = new int[3];
    int[] yy = new int[3];

    public DelaunayViewer(Ruppert d) {
        this.setTriangle(d);
        this.init(d);
    }

    public DelaunayViewer(int size, Ruppert d) {
        this.X_SIZE = size;
        this.setTriangle(d);
        this.init(d);
    }

    public void setTriangle(Ruppert d) {
        this.point = d.getPoints();
        this.face = d.getIndices();
        this.nof = this.face.length / 3;
        int l = this.point.length;
        this.xmin = this.xmax = this.point[0];
        this.ymin = this.ymax = this.point[1];
        int i = 2;
        while (i < l) {
            int n = i++;
            double x = this.point[n];
            if (x < this.xmin) {
                this.xmin = x;
            }
            if (x > this.xmax) {
                this.xmax = x;
            }
            int n2 = i++;
            double y = this.point[n2];
            if (y < this.ymin) {
                this.ymin = y;
            }
            if (!(y > this.ymax)) continue;
            this.ymax = y;
        }
        this.Y_SIZE = (int)((double)this.X_SIZE * (this.ymax - this.ymin) / (this.xmax - this.xmin));
    }

    final void init(Ruppert d) {
        Frame f = new Frame("Triangulation");
        f.setSize(this.FX_SIZE, this.FY_SIZE);
        DrawingPanel p = new DrawingPanel();
        f.add(p);
        f.setVisible(true);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        Frame f2 = new Frame("Ruppertment constraints");
        DelaunayPanel p2 = new DelaunayPanel(d, this, p);
        f2.add(p2);
        f2.setSize(this.X_SIZE, this.X_SIZE / 3);
        f2.setVisible(true);
    }

    public static void main(String[] arg) {
        double[] h = new double[]{-2.0, 0.0, 1.0, 2.0, 0.0, 1.0};
        int[] ref = new int[]{20, 20};
        new DelaunayViewer(Initializer.init(-4.0, -2.0, 4.0, 2.0, 2, 2, h, ref));
    }

    class DelaunayPanel
    extends Panel {
        int area;
        int angle;
        Scrollbar angleS;
        Scrollbar areaS;
        TextField angleT;
        TextField areaT;
        Button quitB;
        Button refineB;

        DelaunayPanel(final Ruppert d, final DelaunayViewer dv, final DrawingPanel dp) {
            this.angle = (int)d.getAngleConstraint();
            this.area = (int)(100.0 * d.getAreaConstraint());
            this.setLayout(new GridLayout(3, 3));
            this.angleS = new Scrollbar(0, 0, 1, 0, 35);
            this.angleS.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    DelaunayPanel.this.angle = e.getValue();
                    DelaunayPanel.this.repaint();
                }
            });
            this.angleT = new TextField();
            this.angleT.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DelaunayPanel.this.angle = Integer.valueOf(DelaunayPanel.this.angleT.getText());
                    DelaunayPanel.this.repaint();
                }
            });
            this.areaS = new Scrollbar(0, 0, 10, 0, 1000);
            this.areaS.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    DelaunayPanel.this.area = 1 + e.getValue();
                    DelaunayPanel.this.repaint();
                }
            });
            this.areaT = new TextField();
            this.areaT.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DelaunayPanel.this.area = (int)(100.0 * Double.valueOf(DelaunayPanel.this.areaT.getText()));
                    DelaunayPanel.this.repaint();
                }
            });
            this.quitB = new Button("quit");
            this.quitB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
            this.refineB = new Button("refine");
            this.refineB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    d.setAngleConstraint(DelaunayPanel.this.angle);
                    d.setAreaConstraint(0.01 * (double)DelaunayPanel.this.area);
                    d.refine();
                    dv.setTriangle(d);
                    dp.repaint();
                }
            });
            this.add(new Label("angle"));
            this.add(this.angleS);
            this.add(this.angleT);
            this.add(new Label("area "));
            this.add(this.areaS);
            this.add(this.areaT);
            this.add(new Label(""));
            this.add(this.quitB);
            this.add(this.refineB);
        }

        @Override
        public void paint(Graphics g) {
            if (this.angle < 0) {
                this.angle = 0;
            }
            if (this.angle > 34) {
                this.angle = 34;
            }
            if (this.area < 1) {
                this.area = 1;
            }
            if (this.area > 1000) {
                this.area = 1000;
            }
            this.angleT.setText(Integer.toString(this.angle));
            this.angleS.setValue(this.angle);
            this.areaT.setText(Double.toString(0.01 * (double)this.area));
            this.areaS.setValue(this.area - 1);
        }
    }

    class DrawingPanel
    extends Panel {
        DrawingPanel() {
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(Color.lightGray);
            g.fillRect(0, 0, DelaunayViewer.this.X_SIZE, DelaunayViewer.this.Y_SIZE);
            double xdif = (double)(4 * DelaunayViewer.this.X_SIZE) / (5.0 * (DelaunayViewer.this.xmax - DelaunayViewer.this.xmin));
            double ydif = (double)(4 * DelaunayViewer.this.Y_SIZE) / (5.0 * (DelaunayViewer.this.ymax - DelaunayViewer.this.ymin));
            int x_border = DelaunayViewer.this.X_SIZE / 10;
            int y_border = DelaunayViewer.this.Y_SIZE / 10;
            int fp = 0;
            for (int i = 0; i < DelaunayViewer.this.nof; ++i) {
                int j = 0;
                while (j < 3) {
                    DelaunayViewer.this.xx[j] = x_border + (int)((DelaunayViewer.this.point[2 * DelaunayViewer.this.face[fp]] - DelaunayViewer.this.xmin) * xdif);
                    DelaunayViewer.this.yy[j] = DelaunayViewer.this.Y_SIZE - y_border - (int)((DelaunayViewer.this.point[2 * DelaunayViewer.this.face[fp] + 1] - DelaunayViewer.this.ymin) * ydif);
                    ++j;
                    ++fp;
                }
                g.setColor(Color.green);
                g.fillPolygon(DelaunayViewer.this.xx, DelaunayViewer.this.yy, 3);
                g.setColor(Color.blue);
                g.drawPolygon(DelaunayViewer.this.xx, DelaunayViewer.this.yy, 3);
            }
        }
    }
}

